
-- This script is isolated from all other scripts
-- If you need to include other scripts you should do it manually below


_OpenScript( "functions_vector.lua" );



-- These variables are passed by the engine

MyIndex		=	0; -- Weapon's entity index.
Owner			= 	0; -- The player that owns this weapon
CurrentTime		=	0; -- The current game time


-- Called when the weapon is created.
	
	function onInit( )
		
		_SWEPSetSound( MyIndex, "single_shot", "Weapon_MAC10.Single" )
		
	end

	
-- Called every frame

	function onThink( )
			
	end
	
	
	function onPrimaryAttack( )
					
		end
		
	function onSecondaryAttack( )		
		
		if ( _PlayerInfo( Owner, "alive" ) == false ) then return; end

				local entityTraced
				local vecpos = _PlayerGetShootPos( Owner )
				local plyang = _PlayerGetShootAng( Owner )
				_TraceLine( vecpos, plyang, 4096, Owner )
				if ( _TraceHit() == true )  then 
					if _TraceHitNonWorld() then
						entityTraced = _TraceGetEnt()
						_PlayerFreeze(entityTraced, true)
						_EntFire(entityTraced, "color", "340 258 0", 0) 
					end
				end
	
		
		_SWEPUseAmmo( MyIndex, 1, 1 );

	      end

-- Weapon settings.
-- These are only accessed once when setting the weapon up
	
	function getWeaponSwapHands()
		return false;	
	end
	
	function getWeaponFOV()
		return 80;	
	end
	
	function getWeaponSlot()
		return 5;	
	end
	
	function getWeaponSlotPos()
		return 5;	
	end
	
	function getFiresUnderwater()
		return true;
	end
	
	function getReloadsSingly()
		return false;
	end
	
	function getDamage()
		return 200;
	end
	
	function getPrimaryShotDelay()
		return 0.2;
	end
	
	function getSecondaryShotDelay()
		return 0.2;
	end
	
	function getPrimaryIsAutomatic()
		return false;
	end
	
	function getSecondaryIsAutomatic()
		return false;
	end
	
	function getSecondaryIsAutomatic()
		return false;
	end
	
	function getBulletSpread()
		return vector3( 0.001, 0.001, 0.001 );
	end
	
	function getViewKick()
		return vector3( 0, 0.0, 0.0);
	end
	
	function getViewKickRandom()
		return vector3( 0.02, 0.01, 0.01 );
	end

	function getViewModel( )
		return "models/weapons/v_smg_ump45.mdl";
	end
	
	function getWorldModel( )
		return "models/weapons/w_smg_ump45.mdl";
	end
	
	function getClassName()
		return "weapon_tranquilizer";
	end

	function getPrimaryAmmoType()
		return "357";
	end
		
	function getSecondaryAmmoType()
		return "357";
	end
	
	-- return -1 if it doesn't use clips
	function getMaxClipPrimary()
		return 1;
	end
	
	function getMaxClipSecondary()
		return -1;
	end
	
	-- ammo in gun by default
	function getDefClipPrimary()
		return 25;
	end
	
	function getDefClipSecondary()
		return -1;
	end

	-- pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade
	function getAnimPrefix()
		return "pistol";
	end

	function getPrintName()
		return "Slim's Tranquilizer";
	end
	
	
	-- 0 = Don't override, shoot bullets, make sound and flash
	-- 1 = Don't shoot bullets but do make flash/sounds
	-- 2 = Only play animations
	-- 3 = Don't do anything
	
	function getPrimaryScriptOverride()
		return 0;
	end

	function getSecondaryScriptOverride()
		return 0;
	end

