-- Leeroy Jenkins gamemode
-- By JetBoom

-- Server Options
MAXSCORE = 10
MUSIC = true -- Leeroy Remix :D

--------------------------------------------------------------
REMOTESPAWNPOINTS = {}
_ServerCommand("gm_sv_allowspawning 0\n")
_ServerCommand("gm_sv_allownpc 0\n")
_ServerCommand("gm_sv_allweapons 0\n")
_ServerCommand("gm_sv_teamplay 1\n")
_ServerCommand("gm_sv_allowmultigun 0\n")
_ServerCommand("gm_sv_allowphysgun 0\n")
_ServerCommand("gm_sv_teamdamage 1\n")
_ServerCommand("gm_sv_playerdamage 1\n")
_ServerCommand("gm_sv_setrules\n")
_EntPrecacheModel("models/player/eli.mdl")
if MUSIC then _PlaySound("leeroyremix.mp3") end
for i=1, _MaxPlayers() do
	if _PlayerInfo(i, "connected") then
		_PlayerRemoveAllWeapons(i)
		eventPlayerActive(_PlayerInfo(i, "name"), i, _PlayerInfo(i, "networkid"))
		_PlayerChangeTeam(i, TEAM_RED)
		_PlayerKill(i)
		_PlayerSetScore(i, 0)
		_PlayerAddDeath(i, _PlayerInfo(i, "deaths")*-1)
	end
end
for i=_MaxPlayers()+1, 4000 do
	if string.find(_EntGetType(i), "vehicle") ~= nil or string.find(_EntGetType(i), "weapon") ~= nil or string.find(_EntGetType(i), "item") ~= nil then
		_EntFire(i, "kill", "", 0.1)
	end
end

function AddSpawnPoint(userid)
	table.insert(REMOTESPAWNPOINTS, _EntGetPos(userid))
end

function gamerulesThink()
end

function PlayerSpawnChooseModel(playerid)
	_PlayerSetModel(playerid, "models/Player/eli.mdl")
end

function DisplayWinner(userid)
	_GModText_Start( "ImpactMassive" )
	 _GModText_SetPos( -1, -1 )
	 _GModText_SetColor( 255, 255, 255, 255 )
	 _GModText_SetTime( 4, 0, 0 )
	 _GModText_SetText( _PlayerInfo(userid, "name").." has won!!\nRestarting...")
	_GModText_Send( 0, 5151 )
	for i=1, _MaxPlayers() do
		if _PlayerInfo(i, "connected") then
			local ent = _EntCreate("env_explosion")
			if ent > 0 then
				_EntSetPos(ent, _EntGetPos(i))
				_EntSetKeyValue(ent, "iMagnitute", 400)
				_EntSpawn(ent)
				_EntFire(ent, "explode", "", math.random(1, 100)*0.01)
				_EntFire(ent, "kill", "", 1.1)
			end
			_PlayerKill(i)
			_PlayerSetScore(i, 0)
			_PlayerAddDeath(i, _PlayerInfo(i, "deaths")*-1)
		end
	end
end

function DamagelessExplosion(targ, tim)
	local ent = _EntCreate("env_explosion")
	if ent > 0 then
		_EntSetPos(ent, _EntGetPos(targ))
		_EntSetKeyValue(ent, "spawnflags", "65")
		_EntSpawn(ent)
		_EntFire(ent, "explode", "", tim)
		_EntFire(ent, "kill", "", 2.0)
	end
end

function CreateResFileString()
	local str = [["resources"
	{
	"sound/stfu.wav" "file"
	"sound/banned.wav" "file"
	"sound/leeroyjenkins.wav" "file"
	"sound/leeroyremix.mp3" "file"
	}
	]]
	return str
end

function CreateResFile()
	_file.Write("maps/".._GetCurrentMap()..".res", CreateResFileString())
end

function DoMusic()
	if MUSIC then
		_PlaySound("leeroyremix.mp3")
	end
end

function gamerulesStartMap()
	_TeamSetName(TEAM_RED, "LEEROY JENKINS")
	CreateResFile()
	AddTimer(101.0, 999, DoMusic)
end
gamerulesStartMap()

function IsInRadius(a, b, dist)
	return math.abs(vecLength(vecSub(_EntGetPos(a),_EntGetPos(b)))) <= dist
end

function PickDefaultSpawnTeam(userid)
	_PlayerChangeTeam(userid, TEAM_RED)
	return true
end

function eventPlayerSpawn(userid)
	_player.ShouldDropWeapon(userid, false)
	if table.getn(REMOTESPAWNPOINTS) > 1 and math.random(1, 7) > 1 then
		_EntSetPos(userid, REMOTESPAWNPOINTS[math.random(1, table.getn(REMOTESPAWNPOINTS))])
	end
end

function eventPlayerKilled(killed, attacker, weapon)
	if killed ~= attacker then
		if attacker <= _MaxPlayers() and attacker > 0 then
			_PlayerAddScore(attacker, 1)
			_PlayerAddDeath(killed, 1)
			if _PlayerInfo(attacker, "kills") >= MAXSCORE then
				DisplayWinner(attacker)
			end
		end
	end
end

function onShowTeam(userid)
end

function onShowHelp(userid)
	_GModRect_Start("gmod/white")
	 _GModRect_SetPos(0.0, 0.14, 1.0, 0.24)
	 _GModRect_SetColor(0, 0, 0, 175)
	 _GModRect_SetTime(10, 0.2, 1)
	_GModRect_Send(userid, 49)
	_GModText_Start("Trebuchet24")
	 _GModText_SetPos(-1, 0.16)
	 _GModText_SetColor(255, 255, 255, 255)
	 _GModText_SetTime(10, 0.2, 1.25)
	 _GModText_SetText("Leeroy Jenkins\n a gamemode by JetBoom")
	_GModText_Send(userid, 50)
	_GModText_Start("Default")
	 _GModText_SetPos(-1, 0.3)
	 _GModText_SetColor(90, 90, 255, 240)
	 _GModText_SetTime(10, 0.2, 1.25)
	 _GModText_SetText( "Suicide bomb people to get kills.\nFirst Leeroyer to get "..MAXSCORE.." kills wins the round!!" )
	_GModText_Send( userid, 51 )
end

function eventPlayerActive(name, userid, steamid)
	AddTimer(4.0, 1, onShowHelp, userid)
end

function GiveDefaultItems(userid)
	_PlayerGiveSWEP(userid, "weapons/weapon_leeroy")
end
