-- The Stalker Weapon: Kabar Knife
-- Based roughly off of the zombie knife from ZS
-- <3 JetBoom

-- Rambo_6

-- Corpse eating by JetBoom

CORPSEEATHP = 15

	function onInit( )
	end

	function onThink( )
		if _PlayerIsKeyDown(Owner, IN_ATTACK2) then
			local tracedEntity
			_TraceLine( _PlayerGetShootPos( Owner ), _PlayerGetShootAng( Owner ), 50, Owner )
			if _TraceHitWorld() or _TraceHitNonWorld() then
				tracedVictim = _TraceGetEnt()
				if tracedVictim <= _MaxPlayers() and tracedVictim > 0 then return end
				if _TraceGetTexture() == "toolssky"
					or _TraceGetTexture() == "toolsskybox"
					or _TraceGetTexture() == "toolsnodraw"
					or _TraceGetTexture() == "toolsclip"
						or _TraceGetTexture() == "toolsplayerclip" then return end
				_EntSetVelocity(Owner, vector3(0, 0, 5))
			end
		end
	end

	function onDrop()
	_EntEmitSound(Owner,"npc/stalker/breathing3.wav")
	end
	
	function onPrimaryAttack( )
		if not _PlayerInfo( Owner, "alive" ) then return end
		local tracedVictim
		_TraceLine( _PlayerGetShootPos( Owner ), _PlayerGetShootAng( Owner ), 65, Owner )
		_RunString("CheckCorpseExplode(".._TraceEndPos().x..", ".._TraceEndPos().y..", ".._TraceEndPos().z..")")
		_PlayerViewModelSequence(Owner, 171)
		if _TraceHitNonWorld() then
			tracedVictim = _TraceGetEnt()
			--_MakeDecal(math.random(46, 51))
			_EntEmitSound(tracedVictim, "weapons/knife/knife_hit"..math.random( 1, 4 )..".wav")
			_TraceAttack( tracedVictim, Owner, Owner, getDamage())
			_phys.ApplyForceCenter(tracedVictim, vecMul(_PlayerGetShootAng(Owner), vector3(23000, 23000, 58000)))
			_EntitySetPhysicsAttacker(tracedVictim, Owner)
		elseif _TraceHitWorld() then
			_MakeDecal(math.random(72, 74))
			_EntEmitSound(Owner, "weapons/knife/knife_hitwall1.wav")
		else
			_EntEmitSound(Owner, "weapons/knife/knife_slash"..math.random( 1, 2 )..".wav")
		end
	end

	function onSecondaryAttack( )
	end

	

	function onReload( )
		return false
	end

	function getWeaponSwapHands()
		return false	
	end

	function getWeaponFOV()
		return 53
	end

	function getWeaponSlot()
		return 1	
	end

	function getWeaponSlotPos()
		return 1;	
	end

	function getFiresUnderwater()
		return true;
	end

	function getReloadsSingly()
		return false;
	end

	function getDamage()
		return 40;
	end

	function getPrimaryShotDelay()
		return 0.8;
	end
	
	function getPrimaryIsAutomatic()
		return true;
	end
		
	function getBulletSpread()
		return vector3( 0.00, 0.00, 0.00 );
	end

	function getViewKick()
		return vector3( 0.0, 0.0, 0.0);
	end

	function getViewKickRandom()
		return vector3( 0.0, 8.0, 0.0 );
	end
	
	function getNumShotsPrimary()
		return 1;
	end

	function getPrimaryAmmoType()
		return "none";
	end

	function getDamageSecondary()
		return 10;
	end

	function getSecondaryShotDelay()
		return 0.3
	end

	function getSecondaryIsAutomatic()
		return true;
	end

	function getBulletSpreadSecondary()
		return vector3( 0.001, 0.001, 0.001 )
	end

	function getViewKickSecondary()
		return vector3( 0.0, 0.0, 0.0)
	end

	function getViewKickRandomSecondary()
		return vector3( 0.0, 0.0, 0.0 )
	end

	function getNumShotsSecondary()
		return 1;
	end

	function getSecondaryAmmoType()
		return "none";
	end

	function getViewModel( )
		return "models/weapons/v_knife_t.mdl";
	end

	function getWorldModel( )
		return "models/weapons/shell.mdl"
	end

	function getClassName() 
		return "weapon_stalker";
	end

	function getMaxClipPrimary()
		return 1;
	end

	function getMaxClipSecondary()
		return -1;
	end

	function getDefClipPrimary() -- ammo in gun by default
		return 1;
	end

	function getDefClipSecondary()
		return 0;
	end

	function getAnimPrefix() -- How the player holds the weapon: pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade
		return "phys";
	end

	function getPrintName()
		return "Knife";
	end

	function getPrimaryScriptOverride()
		return 2;
	end

	function getSecondaryScriptOverride()
		return 2;
	end

	function getDeathIcon( )
		return "d_knife"
end
