-- Stalker Weapon: Frag Grenade
-- Rambo_6

_OpenScript( "includes/vector3.lua" );
MyIndex = 0; -- Weapon's entity index.
Owner = 0; -- The player that owns this weapon
CurrentTime = 0; -- The current game time

NadesLeft = 3 -- Amount of grenades you have (default 3)

--Change these settings if need be.

NadeTimer = 2
KillTimer = 2.1
Zoomed = false;
-- This is called when the weapon is given to player 
function onInit( )
_SWEPSetSound( MyIndex, "single_shot", "" )
_EntPrecacheModel( "models/weapons/w_eq_fraggrenade.mdl" )
end

-- This is called every frame
function onThink( )
	end


-- This is called when the player presses his primary fire button. 
function onPrimaryAttack( ) 
if ( _PlayerInfo( Owner, "alive" ) == false ) then return; end
local vecpos = _PlayerGetShootPos( Owner );
local plyang = _PlayerGetShootAng( Owner );
_TraceLine( vecpos, plyang, 90000, Owner );
local hitpos = _TraceEndPos();

local Fnade = _EntCreate( "prop_physics" );
local vVelocity = vecMul( plyang, vector3(4000, 4000, 4000) ); 
if (Fnade > 0) then
_EntSetModel( Fnade, "models/weapons/w_eq_fraggrenade.mdl")
_EntSetPos( Fnade,_PlayerGetShootPos( Owner ) );
_EntSetAng( Fnade, _PlayerGetShootAng( Owner ) );
_EntSetOwner(Fnade, Owner );
_EntSetAng(Fnade, _PlayerGetShootAng( Owner ))
_EntSpawn( Fnade );
_PhysApplyForce( Fnade, vVelocity );
local Nadepos = _EntGetPos( Fnade )
local NadeExplode = _EntCreate( "env_explosion" )
_EntSetKeyValue( NadeExplode, "iMagnitude", 81 )
_EntSpawn( NadeExplode )
_EntSetPos( NadeExplode, Nadepos )
_EntSetParent( NadeExplode, Fnade )
_EntSetOwner(NadeExplode, Owner ); 
_EntFire( NadeExplode, "Explode", "", NadeTimer )
_EntFire(Fnade, "kill", "", KillTimer)
_SWEPUseAmmo(MyIndex, 0, 1);

NadesLeft = NadesLeft - 1

_EntEmitSound(Owner, "npc/zombie/claw_miss"..math.random( 1, 2 )..".wav")
_PlayerViewModelSequence(Owner, ACT_HANDGRENADE_THROW1);
end
end 



-- Same as above
function onSecondaryAttack( ) 
	
end



-- Return true if you want it to reload successfully
function onReload( )
return false;
end
-- Set this to true if you want the gun on the right side of your view.
-- False if you want it on the left.
function getWeaponSwapHands()
return true 
end
-- Sets the player's Field of View while using this weapon.
function getWeaponFOV()
if NadesLeft == 0 then
	return 2
	else
return 80; 
end
end

-- Slot number for the new weapon
-- 0 = crowbar/grav gun
-- 1 = pistol/357
-- 2 = smg/pulse rifle
-- 3 = shotgun/crossbow
-- 4 = genade/rpg
-- 5 = bugbait
function getWeaponSlot()
return 1; 
end
-- Position of weapon in the slot. If it is in the same slot 
-- position of another gun it will not show up.
function getWeaponSlotPos()
return 3; 
end
-- Just guess what this does.
function getFiresUnderwater()
return true;
end
-- Reload after every shot? (like the crossbow)
function getReloadsSingly()
return false;
end
-- how much damage the bullet does
function getDamage()
return 1;
end
-- Delay between shots (in seconds)
function getPrimaryShotDelay()
return 1.6;
end
-- Delay between shots for secondary fire (in seconds)
function getSecondaryShotDelay()
return 1.5;
end
-- Automatic weapon
function getPrimaryIsAutomatic()
return false;
end
-- Automatic weapon for secondary fire
function getSecondaryIsAutomatic()
return false;
end
-- Ammo type for primary fire
function getPrimaryAmmoType()
return "AR2AltFire";
end
-- Ammo type for secondary fire
function getSecondaryAmmoType()
return "AR2AltFire";
end
-- Max Clip size. -1 if no clip
function getMaxClipPrimary()
return 4;
end
-- Max Clip size for secondary fire. -1 if no clip
function getMaxClipSecondary()
return 0;
end
-- Primary Ammo given to player when given the gun
function getDefClipPrimary()
return 3;
end
-- Secondary Ammo given to player when given the gun
function getDefClipSecondary()
return 0;
end
-- 0 = Don't override, shoot bullets, make sound and flash
-- 1 = Don't shoot bullets but do make flash/sounds
-- 2 = Only play animations
-- 3 = Don't do anything
function getPrimaryScriptOverride()
return 2;
end
-- see above
function getSecondaryScriptOverride()
return 1;
end
-- Higher the # the bigger the spread
function getBulletSpread()
return vector3( -2.0, 1.0, 1.0 );
end
-- amount of view kick
function getViewKick()
return vector3( -1.0, 0.0, 0.0);
end
-- same as above only random values (set to 0.0 , 0.0, 0.0 for no random kick)
function getViewKickRandom()
return vector3( -3.0, 1.0, 1.0 );
end
-- Defines the first person model
function getViewModel( )
return "models/weapons/v_eq_fraggrenade.mdl";
end
-- Defines what it looks like from 3rd person view
function getWorldModel( )
return "models/weapons/w_eq_fraggrenade.mdl";
end
-- Classname of wep. So you can use "give" for this
function getClassName()
return "weapon_fragnade";
end
-- getAnimPrefix - the animation prefix. one of the following: 
-- pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade
function getAnimPrefix()
return "grenade";
end
-- Text you see when choosing the weapon
function getPrintName()
return "Frag Grenade";
end 
