	lMsg("[ECS]: e_admins.lua loaded");
	eLogEvent(0, "e_admins.lua loaded", ECS_LOG_LEVELTWO, true);
	
	--[[
	|====================================================================================================|
	|	Entity Command Suite
	|	Ryan "Joudoki" Lewellen
	|	
	|	Version history:
	|		12/26/2005 - v1
	|		1/26/2006 - v3b
	|		2/25/2006 - v5 Development (MAJOR CHANGES, LIKE MODULE SYSTEM)
	|		4/2/2006 - v5.0 Released
	|		4/11/2006 - v5.1 Released
	|		4/21/2006 - v5.2 Developement resumed after a break
	|	
	|	Contact Info:
	|		Email:	ryanlewellen@comcast.net or Joudoki@gmail.com
	|		AIM: 	Joudoki
	|		MSN: 	Joudoki@hotmail.com1
	|		Y!: 		Joudoki
	|		Google: 	Joudoki@gmail.com
	|	
	|	PLEASE DO NOT MODIFY THIS SCRIPT WITHOUT FIRST CONTACTING ME.	
	|	IF YOU NEED TO COPY / REUSE A PORTION OF THIS SCRIPT, THEN PLEASE
	|	ASK PERMISSION FIRST
	|	Copyright 2005-2006 Ryan Lewellen
	|====================================================================================================|
	--]]
	
	eAdmins = {};
	eAdmins["unknown"] = {ECS_ADMIN_SUPER, "UNKNOWN"}; -- The listen server host owns all.
	eAdmins["steam_0:1:81572"] = {ECS_ADMIN_SUPER, "Joudoki"}; -- Joudoki ( that would be the developer of Entity Command Suite, in case you didn't know :))
	
	-- If you didn't know, I'm going to find where you live and shank you.
	
	-- Admin Levels:
	-- 0: Restricted
	-- 1: Everyone
	-- 2: Basic
	-- 3: Admin
	-- 4: Superadmin
	
	function eAdminImportMani()
		if _file.Exists("cfg/mani_admin_plugin/adminlist.txt") then
			local maniPath = "cfg/mani_admin_plugin/adminlist.txt";
			local maniFile = _file.Read(maniPath); -- "lua/maniadmins.txt" - My test file.
			--STEAM_0:%d:[%d]*[\n]
			local lines = {};
			lines = explode("\n", maniFile);
			local newlines = {};
			
			dMsg("Mani File Parse Begin")
			for i=1, table.getn(lines) do 
				string.gsub(lines[i], "[\n]", "");
				
				local st, en = string.find(lines[i], "//");
				if (st == nil or en == nil) then 
					st = 0; 
					en = 0;
				end
				if (st == 1) then
					--dMsg("Comment on this line (" .. st .. ", " .. en ..")");						
				else
					dMsg("Valid line");
					dMsg("Line " .. i .. ": " .. lines[i] .. " : " .. string.len(lines[i]));
					
					if (string.len(lines[i]) > 1) then
						table.insert(newlines, lines[i]);
					end
				end
			end
			dMsg("Mani File Parse End")
			
			dMsg("Checking newlines list");
			
			local newNewLines = {};
			
			for i=1, table.getn(newlines) do
				dMsg(newlines[i]);
				--_Msg(newlines[i] .. "\n");
				local st, en = string.find(newlines[i], "STEAM_0:%d:[%d]*"); --%:[%d]*%:[%d]*
				if st then 
					local steamid = string.sub( newlines[i], st, en );
					dMsg("We have a steamid. " .. st .. " (" .. steamid .. ") " .. en .. "");
					eAddUser(steamid, ECS_ADMIN_SUPERADMIN, "Unknown");
				end
			end
			
			dMsg("Done checking newlines list")				
		end
	end
	function eAdminImportULX()
		dMsg("Importing Admins from ULX");
		if (gUsers) then
			dMsg("gUsers exists and is opened");
			for k,v in gUsers do
				dMsg("Entry: " .. k .. " : " .. v);
				if (string.find(v, ECS_ADMINS_ULX_REQACCESS_S) ~= nil) then
					dMsg("ULX User has Superadmin flag, adding as super admin")
					if (eAddUser(k, ECS_ADMIN_SUPER, "Unknown") ~= true) then dMsg("Failed to add steamid " .. k .. " to the admins list from ULX") end
				elseif (string.find(v, ECS_ADMINS_ULX_REQACCESS_A) ~= nil) then
					dMsg("ULX User has Admin flag, adding as admin")
					if (eAddUser(k, ECS_ADMIN_ADMIN, "Unknown") ~= true) then dMsg("Failed to add steamid " .. k .. " to the admins list from ULX") end
				elseif (string.find(v, ECS_ADMINS_ULX_REQACCESS_B) ~= nil) then
					dMsg("ULX User has Basic Admin flag, adding as basic admin")
					if (eAddUser(k, ECS_ADMIN_BASIC, "Unknown") ~= true) then dMsg("Failed to add steamid " .. k .. " to the admins list from ULX") end
				end
			end
			dMsg("Done importing admins from ULX");
		end
	end
	
	function eAddUser(iSteam, iLevel, iName)
		if (iName == nil) then iName = "Unknown" end
		dMsg("eAddUser called with steamid " .. iSteam .. ", level " .. tostring(iLevel) .. ", name " .. iName)
		if (eAdmins[string.lower(iSteam)]) then 
			dMsg("Steam ID " .. iSteam .. " is already in eAdmins")
			return false;
		end		
		
		eAdmins[string.lower(iSteam)] = {iLevel, iName};
		
		--eSaveAdminFile();
		
		return true;
	end
	
	function eCommandAllowed(iPlayer, iLevel)
		dMsg("eCommandAllowed called for player " .. iPlayer .. " for command of level " .. iLevel);
		
		if (_MaxPlayers() == 1) then 
			dMsg("Server is a single player server, returning");
			return true;
		end
		
		if ((ECS_ENABLED == false) and (iLevel < ECS_ADMIN_SUPER)) then
			dMsg("Entity Command Suite is currently disabled");
			eShowMessage(iPlayer, ECS_DISABLED_MESSAGE);
			return false;
		end
		
		local iPlayerAccess = eGetUserAccess(iPlayer);
		
		if (iPlayerAccess < 1) then
			-- The user has been BAYNED from ECS!
			eShowMessage(iPlayer, "Sorry, but your steamid is on the ECS blacklist. Contact an admin to resolve the issue.")
			return false;
		end
		
		if (iPlayerAccess == nil) then
			dMsg("Warning: iPlayerAccess is nil. Setting to 1..");
			iPlayerAccess = 1;
		end
		
		if (iLevel == nil) then 
			dMsg("Warning: iLevel is nil. Returning.");
			return false;
		end
				
		if (tonumber(iPlayerAccess) >= tonumber(iLevel)) then
			-- The user has to have the same access level as the command or greater to use it.
			return true;
		else
			-- The user is just some noob trying to access a level too high above his head.
			eUserDenyAccess(iPlayer, iLevel, iPlayerAccess);
			return false;
		end
		
		eUserDenyAccess(iPlayer, iLevel, iPlayerAccess);
		return false; -- If we haven't gotten a "yes" yet for whatever reason, then just say no.
	end
	function eUserDenyAccess(iPlayer, iReqLevel, iUserLevel)
		eShowMessage(iPlayer, _PlayerInfo(iPlayer, "name") .. ", the command you are trying to use is a level " .. iReqLevel .. " command, and you're only level " .. iUserLevel .. ".");
	end
	function eGetUserAccess(iPlayer)
		dMsg("Getting user access for steamid " .. iPlayer);
		
		local steamid = string.lower(eGetSteamId(iPlayer));
		
		for k,v in eAdmins do
			dMsg("Is " .. steamid .. " == " .. k .. " ? ");
			if (string.lower(k) == steamid) then
				dMsg("Yes");
				dMsg("User is in table with access '" .. v[1] .. "'.");
				return v[1];
			end
		end
		dMsg("No")
		
		if (eAdmins[steamid]) then 
			dMsg("User is in table with access '" .. eAdmins[steamid][1] .. "'.");
			return eAdmins[steamid][1];
		else 
			dMsg("User is not in user table; returning the default value (" .. tostring(ECS_ADMIN_EVERYONE) .. ").")
			return ECS_ADMIN_EVERYONE;
		end
	end
	
	function eLoadAdminFile()
		dMsg("Loading admins from ECS file")
		if _file.Exists("lua/e_commands/admins.ini") then
			dMsg("Found File")
			local adminsFile = _file.Read("lua/e_commands/admins.ini");
			local lines = {};
			lines = explode("\n", adminsFile);
			
			dMsg("Going through lines\n")
			
			local entries = {};
			local entryNum = 0;
			
			local stage = 1;
			
			local iSteamT = nil;
			local iNameT = nil;
			local iLevelT = nil;
			
			-- 1 Looking for name
			-- 2 Looking for steamid
			-- 3 looking for access
			
			for i=1, table.getn(lines) do
				if (string.find(lines[i], "{")) then
					dMsg("Starting a new entry");
					entryNum = entryNum + 1;
				elseif (string.find(lines[i], "}")) then					
					eAddUser(iSteamT, iLevelT, iNameT);
					
					stage = 1;
					iSteamT = nil;
					iNameT = nil;
					iLevelT = nil;
					
					dMsg("Entry End\n");
				else
					local s,e = string.find(lines[i], "\'[^\']*\'"); -- A quote followed by anything not a quote followd by a quote
					local str = string.sub(lines[i],  s + 1, e - 1 );
					
					if (stage == 1) then
						-- Name						
						iNameT = str;
						dMsg("Name: " .. iNameT);
						stage = 2;
					elseif (stage == 2) then
						-- Steamid
						iSteamT = str;
						dMsg("Steamid: " .. iSteamT);
						stage = 3;
					elseif (stage == 3) then
						-- Access
						iLevelT = str;
						dMsg("Level: " .. iLevelT);
					end
				end
			end
			dMsg("Done getting admins from file")
		end
		dMsg("Finished")
	end
	function eSaveAdminFile()
		if _file.Exists("lua/e_commands/admins.ini") then
			local lines = {};
			
			local curLine = 1;
			
			for k,v in eAdmins do
				lines[curLine] = "{";
				lines[curLine + 1] = "	'" .. v[2] .. "'";
				lines[curLine + 2] = "	'" .. k .. "'";
				lines[curLine + 3] = "	'" .. v[1] .. "'";
				lines[curLine + 4] = "}";
				
				curLine = curLine + 5;
			end
			
			local fileToWrite = implode("\n", lines);
			_file.Write("lua/e_commands/admins.ini", fileToWrite);
		end
	end