	--[[
	|====================================================================================================|
	|	Entity Command Suite
	|	Ryan "Joudoki" Lewellen
	|	
	|	Version history:
	|		12/26/2005 - v1
	|		1/26/2006 - v3b
	|		2/25/2006 - v5 Development (MAJOR CHANGES, LIKE MODULE SYSTEM)
	|		4/2/2006 - v5.0 Released
	|		4/11/2006 - v5.1 Released
	|		4/21/2006 - v5.2 Developement resumed after a break
	|	
	|	Contact Info:
	|		Email:	ryanlewellen@comcast.net or Joudoki@gmail.com
	|		AIM: 	Joudoki
	|		MSN: 	Joudoki@hotmail.com
	|		Y!: 		Joudoki
	|		Google: 	Joudoki@gmail.com
	|	
	|	PLEASE DO NOT MODIFY THIS SCRIPT WITHOUT FIRST CONTACTING ME.	
	|	IF YOU NEED TO COPY / REUSE A PORTION OF THIS SCRIPT, THEN PLEASE
	|	ASK PERMISSION FIRST
	|	Copyright 2005-2006 Ryan Lewellen
	|====================================================================================================|
	--]]
	
	ECS_DEBUG = false;
	
	-- Player Related
	function ePlayerTraceEnt(iPlayer)
		_TraceLine(_PlayerGetShootPos(iPlayer),_PlayerGetShootAng(iPlayer), 32768, iPlayer);
		local iEnt = _TraceGetEnt();
		if (iEnt) then
			return iEnt;
		else
			return nil;
		end
	end
	function eGetName(iPlayer)
		if(_PlayerInfo(iPlayer, "connected")) then
			return _PlayerInfo(iPlayer, "name");
		end		
		return iPlayer;
	end
	function eGetSteamId(iPlayer)
		if(_PlayerInfo(iPlayer, "connected")) then
			return _PlayerInfo(iPlayer, "networkid");
		end
		return iPlayer;
	end
	function ePlayerInfo(iPlayer)
		if(_PlayerInfo(iPlayer, "connected")) then
			local iName = eGetName(iPlayer);
			local iSteam = eGetSteamId(iPlayer);
			
			local iString = string.format("%s (%s : %s)", iName, iPlayer, iSteam);
		end
		-- He's (she's?)  not connected? WTF?
		return iPlayer;
	end
	
	-- Input Functions
	function eGetArgs( iMsg, iCommand )
		local output = "";
		
		dMsg("eGetArgs called with input " .. iMsg .. ", taking off name");
		
		output = string.gsub(iMsg, "([^%:]*)%:[%s]*", "", 1);
		
		dMsg("Output is " .. output .. ", taking off " .. iCommand);
		
		output = string.gsub(output, iCommand .. "[%s]*", "", 1);
		
		dMsg("Output is " .. output);
		
		return output;
	end
	
	-- Output Functions
	function eShowMessage ( iPlayer, iMsg, iType )
		dMsg("eShowMessage called by player " .. iPlayer .. " with message " .. iMsg)
		_PrintMessage(iPlayer, 3, iMsg);
	end
	function lMsg ( msg ) 
	
		_PrintMessageAll( HUD_PRINTCONSOLE, msg .. " \n" );
	
	end
	
	-- Vectors
	function vecEqual(v1, v2)
		if (v1.x == v2.x and v1.y == v2.y and v1.z == v2.z) then return true end
		return false;
	end
	function vecDiv(v1, v2)
		return vector3(v1.x / v2.x, v1.y / v2.y, v1.z / v2.z);
	end
	function vecDivConst(v1, mult)
		return vector3(v1.x / mult, v1.y / mult, v1.z / mult);
	end
	
	-- Utility Functions
	function eSetDefaultSettings( iSettings, iNumber, iSpecial )
		for i=1, iNumber do
			if (iSettings[i] == nil or iSettings[i] == "" or iSettings[i] == " ") then 
				iSettings[i] = 0; -- Everything Else
				if (iSpecial) then
					if (iSpecial[i]) then
						iSettings[i] = iSpecial[i];
						dMsg("Settings number " .. i .. " has special value " .. iSpecial[i])
					end
				end
			end
			dMsg("iSettings[" .. i .. "] is " .. iSettings[i]);
		end
		
		return iSettings;
	end
	
	-- String Functions
	function explode( d, p ) -- grabbed this nifty little function from http://lua-users.org/wiki/LuaRecipes
		p = string.lower(p);
		t={}
		ll=0
		while true do
			l=string.find(p,d,ll+1,true) -- find the next d in the string
			if l~=nil then -- if "not not" found then..
				if (l ~= " " and l ~= "") then
					table.insert(t, string.sub(p,ll,l-1)) -- Save it in our array.
					ll=l+1 -- save just after where we found it for searching next time.
				end
			else
				if (l ~= " " and l ~= "") then
					table.insert(t, string.sub(p,ll)) -- Save what's left in our array.
					break -- Break at end, as it should be, according to the lua manual.
				end
			end		
		end
		
		for i=1, table.getn(t) do -- From here
			dMsg(i .. " : " .. t[i])
		end -- To here is my code in this function.
		
		return t
	end
	function implode( d, t ) -- and i grabbed this nifty little function from http://lua-users.org/wiki/LuaRecipes
		ss=""
		for a, v in pairs(t) do ss = ss .. v .. d end  -- foreach value, add it to ss and add the delimiter
		ss=string.sub(ss,0,string.len(ss)-string.len(d)) -- Remove the bogus ending delimiter.s
		return ss
	end
	function isEmpty( var )
		if (var == nil or var == "" or var == " ") then return true else return false end
	end
	
	-- Debug
	if (not(GMOD_DEBUG)) then -- I have my own file for debugging. If you don't have my file, you shouldn't try to use commands from it.
		
		function dMsg ( msg )
			
			if ECS_DEBUG == true then
			
				_PrintMessageAll( HUD_PRINTCONSOLE, "[Debug]: " .. msg .. " \n" );
				
			end
			
		end
		
	end
	-- If you do have my file, I will shoot you.
	
	lMsg("[ECS]: e_common.lua loaded")
	eLogEvent(0, "e_common.lua loaded", ECS_LOG_LEVELTWO, true);