	lMsg("[ECS]: e_help.lua loaded")
	eLogEvent(0, "e_help.lua loaded", ECS_LOG_LEVELTWO, true);
	
	--[[
	|====================================================================================================|
	|	Entity Command Suite
	|	Ryan "Joudoki" Lewellen
	|	
	|	Version history:
	|		12/26/2005 - v1
	|		1/26/2006 - v3b
	|		2/25/2006 - v5 Development (MAJOR CHANGES, LIKE MODULE SYSTEM)
	|		4/2/2006 - v5.0 Released
	|		4/11/2006 - v5.1 Released
	|		4/21/2006 - v5.2 Developement resumed after a break
	|	
	|	Contact Info:
	|		Email:	ryanlewellen@comcast.net or Joudoki@gmail.com
	|		AIM: 	Joudoki
	|		MSN: 	Joudoki@hotmail.com
	|		Y!: 		Joudoki
	|		Google: 	Joudoki@gmail.com
	|	
	|	PLEASE DO NOT MODIFY THIS SCRIPT WITHOUT FIRST CONTACTING ME.	
	|	IF YOU NEED TO COPY / REUSE A PORTION OF THIS SCRIPT, THEN PLEASE
	|	ASK PERMISSION FIRST
	|	Copyright 2005-2006 Ryan Lewellen
	|====================================================================================================|
	--]]
	
	-- I didn't make these few functions
	-- http://lua-users.org/wiki/OrderedTable

	function __genOrderedIndex( t )
	    local orderedIndex = {}
	    for key in t do
	        table.insert( orderedIndex, key )
	    end
	    table.sort( orderedIndex )
	    return orderedIndex
	end
	function orderedNext(t, state)
	    -- Equivalent of the next function, but returns the keys in the alphabetic
	    -- order. We use a temporary ordered key table that is stored in the
	    -- table being iterated.

	    --print("orderedNext: state = "..tostring(state) )
	    if state == nil then
	        -- the first time, generate the index
	        t.__orderedIndex = __genOrderedIndex( t )
	        key = t.__orderedIndex[1]
	        return key, t[key]
	    end
	    -- fetch the next value
	    key = nil
	    for i = 1,table.getn(t.__orderedIndex) do
	        if t.__orderedIndex[i] == state then
	            key = t.__orderedIndex[i+1]
	        end
	    end

	    if key then
	        return key, t[key]
	    end

	    -- no more value to return, cleanup
	    t.__orderedIndex = nil
	    return
	end
	function orderedPairs(t)
	    -- Equivalent of the pairs() function on tables. Allows to iterate
	    -- in order
	    return orderedNext, t, nil
	end
	t = {};
	function sortTable(tSort)
		t = tSort;
		local rTable = {};
		for key, val in orderedPairs(t) do
			dMsg(key.." : "..val)
			rTable[key] = val;
		end
		
		for key, val in rTable do
			dMsg(key.." : "..val)
		end
		
		return rTable;
	end
	-- End functions not made by me
	
	-- eHelpWindows -- definitions of each window
	local eHelpWindows = {};
	--local ePriorityHelpWindows = {};
	local eDebug = false; -- don't change this unless you want everyone's console full of spam. (Useful spam if you're a developer :) )
	charactersPerLine = "100";
	usedRects = {};
	local eTopOfPage = 0.26;
	
	-- Ignore these
	local eTitleFont = "";
	local eNormalFont = "";
	local eNormalFontLineSize = 0.018;
	local eBoldFont = "";
	local eBoldFontLineSize = 0.018;
	-- /end ignore
	
	function eAddHelpPage(iPageName, iPageData)
		if (iPageName == nil or iPageName == "" or iPageName == " ") then 
			-- No page title means no index. no index means no accessibility.
			return;
		end
		
		if (iPageData.title == nil or iPageData.title == "" or iPageData.title == " ") then
			-- We gotta have a title!
			return;
		end
		
		--[[
		if (iPageData.next == nil or iPageData.next == "" or iPageData.next == " ") then
			iPageData.next = "main";
		end
		
		if (iPageData.prev == nil or iPageData.prev == "" or iPageData.prev == " ") then
			iPageData.prev = "main";
		end
		--]]
		
		iPageName = string.lower(iPageName);
		eHelpWindows[iPageName] = iPageData;
	end
	
	local aboutEntry = {};
	aboutEntry.title = "About";
	aboutEntry.text = "About / Contact Notes: \n Ryan 'Exitus' / 'Joudoki' Lewellen \n Steam: STEAM_0:1:81572 \n AIM: Joudoki \n MSN: Joudoki@hotmail.com \n Y!: Joudoki \n Google: Joudoki@gmail.com \n Use this to email / google talk me.";
	eAddHelpPage("2about", aboutEntry);	-- Use this to add to the help menu.
	
	local startedEntry = {};
	startedEntry.title = "Getting Started";
	startedEntry.text = "Getting Started \n Entity Command Sutie may be a little overwhelming for a beginner, but you'll find that as you get more and more familiar with it, you will become more at ease with it. $p First thing to know, is that any command can be entered in either chat or the console. For example, if the command is e_undo, you would type -e_undo in chat, or e_undo in the console. Basically, the chat version of a command just has a - in front of it. $p Entity Command Suite also has a built-in admin system. There are four levels of admins: \n 1: Everyone \n 2: Basic Admins (Or advanced users) \n 3: Admins (Lower Level admin commands) \n 4: Super Admins (Everything). $p Depending on what server you're on, you may or may not be able to access certain groups of commands. $p Also, there are some Swep tools available for your use. Type e_swep #list to see a list of available swep tools in your console. $p Good luck, and happy building!";
	eAddHelpPage("1started", startedEntry);
	
	-- Current Page Info
	eCurrentPage = {};
	
	-- eCurrentPage
		-- [iPlayer]
			-- open
			-- selected
			-- page
			-- Limit
			-- [ Links ]
			-- next
			-- prev
		-- end
	-- end
	
	function eShowHelp(iPlayer)
		if (eCurrentPage[iPlayer] == nil) then
			eCurrentPage[iPlayer] = {};
			eCurrentPage[iPlayer].open = true;
			eCurrentPage[iPlayer].selected = 0;
			eCurrentPage[iPlayer].page = "main"
			eCurrentPage[iPlayer].limit = 0;
			eCurrentPage[iPlayer].links = {};
			eCurrentPage[iPlayer].next = "none";
			eCurrentPage[iPlayer].prev = "none";
		end
	
		_PlayerLockInPlace(iPlayer, true);
	
		_GModRect_Start("gmod/white")
		_GModRect_SetPos(0.1, 0.05, 0.8, 0.9)
		_GModRect_SetColor(64, 64, 64, 100)
		_GModRect_SetTime(9999, 0.5, 0.5)
		_GModRect_Send(iPlayer, 0)
		
		_GModText_Start("ClientTitleFont")
		_GModText_SetPos(0.2, 0.05)
		_GModText_SetTime(9999, 0.5, 0.5)
		_GModText_SetText("Entity Commands Suite " .. ECS_VERSION_NUMBER .. "\n		By Exitus / Joudoki")
		_GModText_SetColor(255, 255, 255, 200)
		_GModText_Send(iPlayer, 0)
		
		_GModText_Start("DefaultShadow")
		_GModText_SetPos(0.2, 0.21)
		_GModText_SetTime(9999, 0.5, 0.5)
		_GModText_SetText("Press forward to move the selection up, press back to move it down. Shoot to select.");
		_GModText_SetColor(255, 255, 255, 200)
		_GModText_Send(iPlayer, 4984) -- My brother's birthday.
		
		eShowMenu(iPlayer);
	end
	function eHideHelp(iPlayer)	
		_PlayerLockInPlace(iPlayer, false);
		
		_GModRect_Hide(iPlayer, 0, 0.5, 0.1);
		_GModRect_Hide(iPlayer, 1, 0.5, 0.1);
		
		_GModText_Hide(iPlayer, 0, 0.5, 0.1);
		_GModText_Hide(iPlayer, 1, 0.5, 0.1);
		_GModText_Hide(iPlayer, 4984, 0.5, 0.1);
		
		for i=1, table.getn(usedRects) do
			_GModText_Hide(iPlayer, usedRects[i], 0.5, 0.1);
			_GModRect_Hide(iPlayer, usedRects[i], 0.5, 0.1);
		end
		
		eCurrentPage[iPlayer].open = false;
		eCurrentPage[iPlayer].page = "none";
		eCurrentPage[iPlayer].selected = 0;
	end
	
	function eShowMenu(iPlayer)
		eCurrentPage[iPlayer].links = {};
		dMsg(" ----- ShowMenu called -----")
		
		for i=1, table.getn(usedRects) do
			_GModText_Hide(iPlayer, usedRects[i], 0.5, 0.1);
			_GModRect_Hide(iPlayer, usedRects[i], 0.5, 0.1);
		end
		
		local lineNumber = 1;
		local lines = {};
		
		local tempTable = {};
		
		for k, v in eHelpWindows do
			tempTable[k] = "Oh look! a muffin.";
		end
		
		dMsg("Getting sorted version of table...")
		
		local sortedTable = sortTable(tempTable);
		
		dMsg("Got it.")
		
		for k, v in sortedTable do
			dMsg(k .. " : " .. v)
		end
		
		--for k,v in sortedTable do
		for k, v in orderedPairs(eHelpWindows) do
			v = eHelpWindows[k];
			if (v.type == HELPTYPE_PAGE or v.type == nil and v.type ~= 2) then
				if (eDebug == true) then 
					lines[lineNumber] = "[" .. k .. "]"; 
					lines[lineNumber] = lines[lineNumber] .. v.title;
				else
					lines[lineNumber] = v.title;
				end
				
				dMsg("Link " .. lineNumber .. " is " .. k);
				eCurrentPage[iPlayer].links[lineNumber] = k;
				lineNumber = lineNumber + 1;
			end
		end
		
		lines[lineNumber] = "Next";
		eCurrentPage[iPlayer].links[lineNumber] = "next";
		dMsg("Link " .. lineNumber .. " is next");
		lineNumber = lineNumber + 1;
		
		
		lines[lineNumber] = "Previous";
		eCurrentPage[iPlayer].links[lineNumber] = "prev";
		dMsg("Link " .. lineNumber .. " is prev");
		lineNumber = lineNumber + 1;
		
		lines[lineNumber] = "Close";
		eCurrentPage[iPlayer].links[lineNumber] = "close";
		dMsg("Link " .. lineNumber .. " is close");
		lineNumber = lineNumber + 1;
		
		local totalLines = 0;
			
		for i=1, table.getn(lines) do
			dMsg("Displaying line " .. i)
			local posY = eTopOfPage + (totalLines * 0.018);
			
			_GModText_Start("Default");
			_GModText_SetPos(0.2, posY);
			_GModText_SetTime(9999, 0.5, 0.5);
			_GModText_SetText(i .. ") " .. lines[i]);
			_GModText_SetColor(255, 255, 255, 200);
			_GModText_Send(iPlayer, i+1000);
			table.insert(usedRects, i+1000);
					
			totalLines = totalLines + 1;
		end
		
		-- The bar
		_GModRect_Start("gmod/white");
		_GModRect_SetPos(0.2, eTopOfPage, 0.5, 0.02);
		_GModRect_SetColor(255, 192, 96, 128);
		_GModRect_SetTime(9999, 0.5, 0.5);
		_GModRect_Send(iPlayer, 1);		

		eCurrentPage[iPlayer].open = true;
		eCurrentPage[iPlayer].selected = 0;
		eCurrentPage[iPlayer].page = "main"
		eCurrentPage[iPlayer].limit = lineNumber - 2;
		eCurrentPage[iPlayer].next = "none";
		eCurrentPage[iPlayer].prev = "none";
	end
	function eShowPage(iPlayer, iPage)
		if (eHelpWindows[iPage] == nil) then
			if (iPage == nil) then 
				lMsg("[Warning]: nil passed to eShowPage! Closing helpmenu.");
			else
				lMsg("[Warning]: iPage " .. iPage .. " not found! Closing helpmenu.");
			end
			eHideHelp(iPlayer);
		elseif string.find(iPage, "main", 1, true) then
			eShowMenu(iPlayer);
		else
			for i=1, table.getn(usedRects) do
				_GModText_Hide(iPlayer, usedRects[i], 0.5, 0.1);
				_GModRect_Hide(iPlayer, usedRects[i], 0.5, 0.1);
			end
			local iPageData = eHelpWindows[iPage];
			dMsg("Showing Page '" .. iPage .. "'");
			--_GModText_Hide(iPlayer,1);
			
			-- Get all the paragraphs
			
			local paragraphs = explode(" $p ", iPageData.text);
			local paragraphWords = {};
			
			for i=1, table.getn(paragraphs) do 
				paragraphWords[i] = explode(" ", paragraphs[i]);
			end
			
			-- Get all the lines
			
			local paragraphLines = {};
			
			local lines = {};

			local currentLineTotal = 0;
			local currentLine = 1;
			local currentLineText = "";
			
			local inPic = false;
		
			--GMOD_DEBUG = false;
			
			for i=1, table.getn(paragraphWords) do
				-- Per whole thing
				paragraphLines[i] = {};
				local iWords = paragraphWords[i];
				dMsg("	-----	Paragraph " .. i .. "	-----	")
				for k=1, table.getn(iWords) do
					local eLine = string.find(iWords[k], "\n", 1, true);
					local ePgh = string.find(iWords[k], "$p", 1, true);
					local eImgStart = string.find(iWords[k], "$img", 1, true);
					local eImgEnd = string.find(iWords[k], "img$", 1, true);
					
					if not(ePgh) then
						-- Per paragraph
						dMsg("[" .. currentLineTotal .. "][" .. string.len(iWords[k]) .. "]" .. iWords[k]);						
						
						if (eLine) then dMsg("Found a developer-placed line break") end
						
						if ((tonumber(currentLineTotal) + tonumber(string.len(iWords[k])) < tonumber(charactersPerLine)) and (not(eLine)) and (not(eImgStart)) and (not(eImgEnd))) then
							-- We have room on current line
							currentLineTotal = currentLineTotal + string.len(iWords[k]) + 1;
							currentLineText = currentLineText .. iWords[k] .. " ";
						else
							if (eLine) then
								-- If there was a developer line, then we need to add it on BEFORE we go to the next line
								dMsg("Finished a line [" .. currentLine .. "] due to line break: " .. currentLineText )
								currentLineTotal = currentLineTotal + string.len(iWords[k]) + 1;
								currentLineText = currentLineText .. iWords[k] .. " ";
								lines[currentLine] = currentLineText;
								currentLine = currentLine + 1;
								currentLineTotal = 0;
								currentLineText = "";
							elseif (eImgStart) then
								-- Record the last line
								dMsg("Finished a line due to image start: [" .. currentLine .. "]: " .. currentLineText)
								lines[currentLine] = currentLineText;
								
								-- Clear the buffer
								currentLine = currentLine + 1;
								currentLineTotal = 0;
								currentLineText = "";
								
								-- Add a line before the picture
								lines[currentLine] = currentLineText;
								currentLine = currentLine + 1;
								
								-- Start a new line
								currentLineTotal = currentLineTotal + string.len(iWords[k]) + 1;
								currentLineText = currentLineText .. iWords[k] .. " ";
							elseif (eImgEnd) then
								dMsg("Finished a line [" .. currentLine .. "] due to image end: " .. currentLineText )
								currentLineTotal = currentLineTotal + string.len(iWords[k]) + 1;
								currentLineText = currentLineText .. iWords[k] .. " ";
								lines[currentLine] = currentLineText;
								currentLine = currentLine + 1;
								currentLineTotal = 0;
								currentLineText = "";
								
								-- Add a line after the picture
								lines[currentLine] = currentLineText;
								currentLine = currentLine + 1;
							else
								-- Otherwise, we need to add the new word to the next line.
								dMsg("Finished a line [" .. currentLine .. "]: " .. currentLineText)
								lines[currentLine] = currentLineText;
								--lines[currentLine].type = 1; -- It's a special type; It's a picture.
								currentLine = currentLine + 1;
								currentLineTotal = 0;
								currentLineText = "";
								currentLineTotal = currentLineTotal + string.len(iWords[k]) + 1;
								currentLineText = currentLineText .. iWords[k] .. " ";
							end
						end
					end
				end
				dMsg("Finished a line [" .. currentLine .. "]: " .. currentLineText)
				lines[currentLine] = currentLineText;
				currentLine = currentLine + 1;
				lines[currentLine] = ""; -- Add a line in between paragraphs
				currentLine = currentLine + 1;
				currentLineTotal = 0;
				currentLineText = "";
			end
			
			dMsg("Finished with stuff, now get the final paragraph lines.")
			
			-- Get the final lines with the \n per line
			
			--[[
			local paragraphsFinal = {};
			local linesPerParagraph = {};
			
			for i=1, table.getn(paragraphLines) do
				dMsg("Paragraph " .. i .. " out of " .. table.getn(paragraphLines))
				local lineTable = paragraphLines[i];
				linesPerParagraph[i] = table.getn(lineTable);
				paragraphsFinal[i] = implode("\n", lineTable);
				dMsg("Final Paragraph # " .. i .. " \n" .. paragraphsFinal[i])
			end
			
			--]]
			
			eCurrentPage[iPlayer].links = {};
			
			local curNum = 1;
			local navText = "";
			
			if not(isEmpty(iPageData.next)) then
				if (eDebug == true) then navText = navText .. "[" .. iPageData.next .. "]"; end
				navText = navText .. "1) Next \n";
				eCurrentPage[iPlayer].next = tostring(iPageData.next);
				eCurrentPage[iPlayer].links[curNum] = "next";
				curNum = curNum + 1;
			end
			if not(isEmpty(iPageData.prev)) then
				if (eDebug == true) then navText = navText .. "[" .. iPageData.prev .. "]"; end
				navText = navText .. curNum .. ") Previous \n";
				eCurrentPage[iPlayer].prev = tostring(iPageData.prev);
				eCurrentPage[iPlayer].links[curNum] = "prev";
				curNum = curNum + 1;
			end
			
			navText = navText .. curNum .. ") Main \n";
			eCurrentPage[iPlayer].links[curNum] = "main";
			curNum = curNum + 1;
			navText = navText .. curNum .. ") Close";
			eCurrentPage[iPlayer].links[curNum] = "close";
			
			eCurrentPage[iPlayer].selected = 0;
			eCurrentPage[iPlayer].limit = curNum - 1;
			
			_GModText_Start("Default");
			_GModText_SetPos(0.2, eTopOfPage);
			_GModText_SetTime(9999, 0.5, 0.5);
			_GModText_SetText(navText);
			_GModText_SetColor(255, 255, 255, 200);
			_GModText_Send(iPlayer, 41006); -- Today (4/10/06)
			
			table.insert(usedRects, 41006);
			
			_GModRect_Start("gmod/white");			
			_GModRect_SetPos(0.2, eTopOfPage, 0.5, 0.02);
			_GModRect_SetColor(255, 192, 96, 128);
			_GModRect_SetTime(9999, 0.5, 0.5);
			_GModRect_SendAnimate(iPlayer, 1, 0.25, 0.5);
			
			local totalLines = curNum + 1;
			
			--GMOD_DEBUG = true;
			
			for i=1, table.getn(lines) do
				dMsg("Displaying line " .. i)
				local posY = eTopOfPage + .65;
				posY = eTopOfPage + (totalLines * 0.018);
				
				local eImgStart, 	eImgStartEnd 	= string.find(lines[i], "$img", 1, true);
				local eImgEnd, 		eImgEndEnd 		= string.find(lines[i], "img$", 1, true);
				
				if (eImgStart) then
					-- It's a picture :O
					local line = lines[i];
					dMsg("Got a picture. Lets get the properties. Sub out " .. eImgStart .. " - " .. eImgStartEnd .. " and " .. eImgEnd .. " - " .. eImgEndEnd)
					dMsg(line);
					line = string.sub(line, eImgStartEnd + 2, eImgEnd - 2);
					dMsg(line);
					
					-- Lets get all the keyvalues.
					local keyvalues = explode(" ", line);
					
					local eKeyStart, eKeyEnd = string.find(keyvalues[1], "path='", 1, true);
					local imgPath = string.sub(keyvalues[1], eKeyEnd + 1, -2);					
					dMsg("imgPath = " .. imgPath);
					
					eKeyStart, eKeyEnd = string.find(keyvalues[2], "ratio='", 1, true);
					local imgRatio = string.sub(keyvalues[2], eKeyEnd + 1, -2);
					dMsg("imgRatio = " .. imgRatio);
					
					eKeyStart, eKeyEnd = string.find(keyvalues[3], "height='", 1, true);
					local imgHeight = string.sub(keyvalues[3], eKeyEnd + 1, -2);
					dMsg("imgHeight = " .. imgHeight);
					
					local lenX = (imgHeight * 0.018) * imgRatio * (3/4); -- X is the Height times the line length constant times the image ratio where x is over y and multiplied by 4 over 3, the aspect ratio of most resolutions
					local lenY = imgHeight * 0.018;
					local posX = (1.0 - lenX) / 2;
					
					_GModRect_Start(imgPath);
					_GModRect_SetPos(posX, posY, lenX, lenY);
					_GModRect_SetTime(9999, 0.5, 0.5);
					_GModRect_SetColor(255, 255, 255, 200);
					_GModRect_Send(iPlayer, i+800);
					table.insert(usedRects, i+800);
					
					totalLines = totalLines + imgHeight;
				else
					_GModText_Start("Default");
					_GModText_SetPos(0.2, posY);
					_GModText_SetTime(9999, 0.5, 0.5);
					_GModText_SetText(lines[i]);
					_GModText_SetColor(255, 255, 255, 200);
					_GModText_Send(iPlayer, i+600);
					table.insert(usedRects, i+600);
					
					totalLines = totalLines + 1;
				end
			end
			
			dMsg("Done displaying page.");
		end
	end
	
	function eMoveSelect(iPlayer, iDir)
		if (iDir == 1 and eCurrentPage[iPlayer].selected == eCurrentPage[iPlayer].limit) then return end
		if (iDir == -1 and eCurrentPage[iPlayer].selected == 0) then return end
		
		local newY = eTopOfPage + (eCurrentPage[iPlayer].selected + iDir) * 0.018;
		dMsg(newY);
	
		_GModRect_Start("gmod/white")
		_GModRect_SetPos(0.2, newY, 0.5, 0.02)
		_GModRect_SetColor(255, 192, 96, 128)
		_GModRect_SetTime(9999, 0.5, 0.5)
		_GModRect_SendAnimate(iPlayer, 1, 0.25, 0.5)
		
		eCurrentPage[iPlayer].selected = eCurrentPage[iPlayer].selected + iDir;
	end
	function eHelpSelect(iPlayer)
		dMsg("Player has made a selection.")
		if ( eCurrentPage[iPlayer].links[ eCurrentPage[iPlayer].selected + 1 ] == "close" ) then
			-- Close
			eHideHelp(iPlayer);
			
		elseif ( eCurrentPage[iPlayer].links[ eCurrentPage[iPlayer].selected + 1 ] == "next") then
			-- Next
			eShowPage(iPlayer, eCurrentPage[iPlayer].next);
			
		elseif ( eCurrentPage[iPlayer].links[ eCurrentPage[iPlayer].selected + 1 ] == "prev") then
			-- Prev
			eShowPage(iPlayer, eCurrentPage[iPlayer].prev);
			
		elseif ( eCurrentPage[iPlayer].links[ eCurrentPage[iPlayer].selected + 1 ] == "main") then
			-- Menu
			eShowMenu(iPlayer);
			
		else
			dMsg("Showing page at location " .. eCurrentPage[iPlayer].selected);
			eShowPage( iPlayer, eCurrentPage[iPlayer].links[ eCurrentPage[iPlayer].selected + 1 ] );
			
		end
	end
	
	function eHelpKeyPress(iPlayer, iKey)
		if (eCurrentPage[iPlayer] == nil) then return end
		if (eCurrentPage[iPlayer].open == true) then
			-- Just make sure that menu is open first.
			dMsg("Player " .. iPlayer .. " has pressed key " .. iKey)
			if (iKey == 8) then
				dMsg("Key is forward. Move selection up.");
				eMoveSelect(iPlayer, -1);
			elseif (iKey == 16) then
				dMsg("Key is back. Move selection down.");
				eMoveSelect(iPlayer, 1);
			elseif (iKey == 1) then
				dMsg("Key is attack. Select the selection.");
				eHelpSelect(iPlayer)
			end
		end
	end
	HookEvent("eventKeyReleased", eHelpKeyPress);