	-- Ent Module
	-- -e_keyvalue, -e_classname, -e_add
	
	-- Module Name
	eLastLoadedModule = "Advanced Ent 2.0 by Joudoki";
	
	-- Player Specific / Global  Variables
	eNewClasses = {}; -- The new classes that will be applied to ents when they are copied	
	
	-- Functions	
	function eRender(iPlayer, iEnts, iSettings)
		dMsg("eRender called")
		for i=1, 6 do
			if (iSettings[i] == nil) then iSettings[i] = -1 end
		end
		
		dMsg("Render Mode: " .. iSettings[1]);
		dMsg("Render Amount: " .. iSettings[2]);
		dMsg("Render FX: " .. iSettings[3]);
		dMsg("Red: " .. iSettings[4]);
		dMsg("Green: " .. iSettings[5]);
		dMsg("Blue: " .. iSettings[6]);
		
		local keyvalues = {};
		keyvalues[1] = "rendermode";
		keyvalues[2] = "renderamt";
		keyvalues[3] = "renderfx";
		
		dMsg("Starting to render")

		for k = 1, table.getn(iEnts) do
			dMsg("Multiple Entities")
			local iEnt = iEnts[k];
			for i=1, 3 do
				dMsg("Setting " .. keyvalues[i] .. " to " .. tostring(iSettings[i]))
				if (iSettings[i] ~= -1) then _EntSetKeyValue(iEnt, keyvalues[i], iSettings[i]) end
			end
				if ((iSettings[4] ~= "-1") or (iSettings[5] ~= "-1") or (iSettings[6] ~= "-1")) then
				dMsg("Coloring, too")
				_EntFire(iEnt, "color", iSettings[4] .. " " .. iSettings[5] .. " " .. iSettings[6], 0)
				--_EntSetKeyValue( iEnt, "color", settings[4] .. " " .. settings[5] .. " " .. settings[6] )
			end
		end	
		eShowMessage(iPlayer, "Prop rendering changed to " .. iSettings[1] .. "mode, " .. iSettings[2] .. "amt, " .. iSettings[3] .. "fx, " .. iSettings[4] .. "red, " .. iSettings[5] .. "green, " .. iSettings[6] .. "blue.");
		eLogEvent(iPlayer, "changed the render properties on a prop.", ECS_LOG_LEVELTWO);
		dMsg("eRender Finished")
	end
	function eKeyValue(iPlayer, iEnts, iSettings) -- -e_keyvalue <key> <value>
		dMsg("Key: " .. iSettings[1] .. "\nValue: " .. iSettings[2])
		for k = 1, table.getn(iEnts) do
			local iEnt = iEnts[k];
			_EntSetKeyValue(iEnt, tostring(iSettings[1]), tostring(iSettings[2]));
		end
		dMsg("Done setting keyvalue")
		eShowMessage(iPlayer, "Key " .. iSettings[1] .. " set to " .. iSettings[2], 0);
		eLogEvent(iPlayer, "set the key '" .. iSettings[1] .. "' to '" .. iSettings[2] .. "'.", ECS_LOG_LEVELFOUR);
	end
	function eOutput(iPlayer, iEnts, iSettings) -- -e_output <Output> <Ent to Fire> <Input> <delay> <value>
		-- <output name>
		-- <targetname>
		-- <inputname>
		-- <parameter>
		-- <delay>
		--<max times to fire (-1 == infinite)>
		
		dMsg("Output name is " .. iSettings[1])
		dMsg("Target name is " .. iSettings[2])
		dMsg("Input name is " .. iSettings[3])
		dMsg("Parameter is " .. iSettings[4])
		dMsg("Delay name is " .. iSettings[5])
		dMsg("Max times to fire is " .. iSettings[6])
		
		for k = 1, table.getn(iEnts) do
			local iEnt = iEnts[k];
			dMsg("addoutput " .. "\"" .. iSettings[1] .. " " .. iSettings[2] .. "," .. iSettings[3] .. "," .. iSettings[4] .. "," .. iSettings[5] .. "," .. iSettings[6] .. "\"");
			local iParameters = iSettings[1] .. " " .. iSettings[2] .. "," .. iSettings[3] .. "," .. iSettings[4] .. "," .. iSettings[5] .. "," .. iSettings[6];
			
			_EntFire(iEnt, "addoutput", iParameters, 0);
			
			dMsg(string.format('_EntFire(%s, "addoutput", "%s", 0);', iEnt, iParameters));
		end
		
		--object addoutput "condition target,command,variable,delay,timestobeused"
		eShowMessage(iPlayer, "Added output " .. iSettings[1] .. " " .. iSettings[2] .. "," .. iSettings[3] .. "," .. iSettings[4] .. "," .. iSettings[5] .. "," .. iSettings[6]);
		eLogEvent(iPlayer, "added an output to an entity (" .. iSettings[1] .. " " .. iSettings[2] .. "," .. iSettings[3] .. "," .. iSettings[4] .. "," .. iSettings[5] .. "," .. iSettings[6] .. ").", ECS_LOG_LEVELFOUR);
	end
	function eAdd(iPlayer, iSettings) -- -e_add <classname>:<key>:<value> or -e_add <classname> <key> <value> <key> <value>
		dMsg("Classname: " .. iSettings[1]);
		
		--keyvalues[0] = "classname";
		
		local vOrigin = vector3(0,0,0);		-- The origin variable
		local vOriginT = false;				-- Do we have an origin yet?
		
		local vClass = iSettings[1];			-- The classname
		
		local vSpawnFrozen = false;		-- Try to freeze creation?
		local vSelect = false;				-- Select the creation?
		
		local vKeyVals = {};				-- What are the keyvalues?
		
		for i=1, table.getn(ECS_DISALLOWED_CLASSNAMES) do
			if (vClass == ECS_DISALLOWED_CLASSNAMES[i].class) then
				local iReason = "";
				if(ECS_DISALLOWED_CLASSNAMES[i].reason) then 
					iReason = ECS_DISALLOWED_CLASSNAMES[i].reason;
				else
					iReason = ECS_DISALLOWED_CLASSNAMES_DEFMESSAGE;
				end
				eShowMessage(iPlayer, "Sorry, you're not allowed to create a " .. vClass .. ". Reason: " .. iReason);
				return false;
			end
		end
		
		-- go through the key values and check to make sure that the keyvalues aren't empty
		for i=1, table.getn(iSettings) do
			if (iSettings[i] == nil or iSettings == "" or iSettings == " ") then 
				if (iSettings[i] == "" or iSettings[i] == nil) then iSettings[i] = "nil" end
				dMsg("Found an empty keyvalue at " .. i .. ": " .. iSettings[i])
				table.remove(iSettings, i);
			else
				dMsg("Keyvalue at " .. i .. ": " .. iSettings[i] .. " isn't empty");
			end
		end
		
		dMsg("Starting the keyvalues loop");
		
		-- Iterate through the setttings table and organize the keyvals into a table
		for i=1, table.getn(iSettings) do
			if(i / 2 == math.floor(i/2)) then
				dMsg("Key: " .. iSettings[i]); 
			else
				dMsg("Value: " .. iSettings[i]);
				
				-- check for special values
				if (iSettings[i-1] == "origin" and string.lower(iSettings[i]) == "%here%") then
					-- Origin: %HERE%:
					vOrigin = _EntGetPos(iPlayer);
					vOriginT = true;
					
				elseif (iSettings[i-1] == "origin" and string.lower(iSettings[i]) == "%picker%") then
					-- Origin: %PICKER%
					_TraceLine(_PlayerGetShootPos(iPlayer),_PlayerGetShootAng(iPlayer), 32768, iPlayer);
					vOrigin = _TraceEndPos();
					vOriginT = true;
				else
					-- This isn't a special key/value pair, so just store it
					vKeyVals[tostring(iSettings[i-1])] = iSettings[i];
				end
			end
		end
		
		dMsg("Finished getting keyvalues")
		
		if (vOriginT == false) then
			dMsg("The origin has not been set, getting picker")
			_TraceLine(_PlayerGetShootPos(iPlayer),_PlayerGetShootAng(iPlayer), 32768, iPlayer);
			vOrigin = _TraceEndPos();
			dMsg("Origin is " .. vecString(vOrigin));
			vOriginT = true;
		end
		
		local reportString = "Created a " .. iSettings[1] .. " at origin " .. vecString(vOrigin) .. " with keyvalues(";
		
		dMsg("Creating a " .. tostring(vClass) .. ".");
		
		local iProp = _EntCreate(tostring(iSettings[1]));
		
		dMsg("Setting origin to " .. vecString(vOrigin));
		_EntSetPos(iProp, vOrigin);
		
		if(iProp == 0) then
			-- Make sure that the entity created isn't illegal
			-- Thanks, "blubber23"
            eShowMessage(iPlayer, "Entity creation failed for non-existant classname: " .. tostring(vClass));
            return;
        end
		
		for k,v in vKeyVals do
			if k ~= "nil" then
				dMsg(k .. ": " .. v)
				_EntSetKeyValue(iProp, tostring(k), tostring(v));
				reportString = reportString .. " " .. k .. ": " .. v;
			end
		end
		dMsg("Done setting keyvalues");
		_EntSpawn(iProp);
		dMsg("Finished spawning prop");
		eShowMessage(iPlayer, reportString .. ")!");
		eLogEvent(iPlayer, reportString, ECS_LOG_LEVELFOUR);
	end
	
	function eClassName(iPlayer, iEnts, iSettings)
		for i=1, table.getn(iEnts) do
			iEnt = iEnts[i];
			eNewClasses[iEnt] = iSettings[1];
		end
		
		eShowMessage(iPlayer, "Set the classname of the object(s) to " .. iSettings[1]);
		eLogEvent(iPlayer, reportString, ECS_LOG_LEVELFOUR);
	end
	function eClassThink()
		for k,v in eNewClasses do
			if (_EntExists(k) ~= true) then
				eNewClasses[k] = nil;
				lMsg("Warning: Entity " .. k .. " doesn't exist, removing classname change entry");
			end
		end
	end
	eAddThink(eClassThink, 0.5, false);
	
	-- Calls
	function eRenderCall(iPlayer, iArgs)
		local iSettings = explode(" ", iArgs);
		local iEnts = eGetProps(iPlayer);
		eRender(iPlayer, iEnts, iSettings);
	end
	function eKeyValueCall(iPlayer, iArgs)
		local iSettings = explode(" ", iArgs);
		local iEnts = eGetProps(iPlayer);
		eKeyValue(iPlayer, iEnts, iSettings);
	end
	function eOutputCall(iPlayer, iArgs)
		local iSettings = explode(" ", iArgs);
		local iEnts = eGetProps(iPlayer);
		eOutput(iPlayer, iEnts, iSettings);
	end
	function eClassnameCall(iPlayer, iArgs)
		local iSettings = explode(" ", iArgs);
		local iEnts = eGetProps(iPlayer);
		eClassname(iPlayer, iEnts, iSettings);
	end
	function eAddCall(iPlayer, iArgs)
		local iSettings = explode(":", iArgs);
		eAdd(iPlayer, iSettings);
	end
	
	-- Add functions to function list
	-- eAddCommand(<command name>, <function to call>)
	eAddCommand("e_render", 		eRenderCall,		"Syntax: -e_render <rendermode> <renderamt> <renderfx> <red> <green> <blue>\nSets the rendermode of objects. <renderamt> is also the alpha of the object.", ECS_ADMIN_BASIC);
	eAddCommand("e_keyvalue", 		eKeyValueCall,		"Syntax: -e_keyvalue <key> <value>\nSets the <key> on an entity to the <value> specified.", ECS_ADMIN_BASIC);
	eAddCommand("e_output", 		eOutputCall,		"Syntax: -e_output <targetname> <inputname> <parameter> <delay> <max times to fire (-1 == infinite)>\nAdds an output to an entity.", ECS_ADMIN_BASIC);
	eAddCommand("e_class", 			eClassnameCall,	"Syntax: -e_class <classname>\nSets the classname of an entity, so the next time it's copied, it becomes this classtype.", ECS_ADMIN_BASIC);
	eAddCommand("e_add", 			eAddCall,			"Syntax: -e_add <classname>:origin:<[position or %HERE% or %PICKER%]>:<key1>:<value1>:<key2>:<value2>:...\nCreates a <classname> at an origin, where you can specify a position (not recommended), you can use %HERE% for where you are standing, or you can use %PICKER% for where you are aiming. Each <key> <value> pair is applied to the entity. Don't use this unless you know what you're doing.", ECS_ADMIN_BASIC);
	
	local addEntEntry = {};
	addEntEntry.title = "Advanced Entity Creation";
	addEntEntry.text = "Syntax: e_add <entity name>:origin:[%HERE% or %PICKER%]:<key1>:<value1>:<key2>:<value2>: \n e_add is a very advanced command for those familiar with entities and their key/value pairs. In order to create an entity, you must specify a classname (such as npc_combine_s, for a combine solder) and an origin to create it at (%HERE% for where you're standing, %PICKER% for where you're aiming.) $p Examples: \n e_add npc_combine_s:origin:%PICKER%:squad:squad1:targetname:soldiers:additionalequipment:weapon_ar2: \n e_add env_explosion:origin:%HERE%:targetname:exploder:spawnflags:2:";
	eAddHelpPage("advent_eadd", addEntEntry);
	
	local outputEntry = {};
	outputEntry.title = "Adding Outputs";
	outputEntry.text = "Syntax: e_output <targetname> <inputname> <parameter> <delay> <max times to fire (-1 == infinite)> \n You can use e_output to add an output to any entity. For example if you wanted to make a button out of a prop that causes an explosion, you could do the following: $p e_keyvalue spawnflags 256 (This makes an entity a button) $p e_add env_explosion:origin:%HERE%:targetname:explosion:spawnflags:1: (This makes the explosive. The spawnflags 1 is so you can do it over and over again). $p Lastly, you do e_output onplayeruse explosion explode 0 0 -1. (The onplayeruse is when the player uses it, explosion is the explosive we just created, explode is the input, 0/0 is the parameter/delay (unimportant in this case) and -1 means allow this output to be fired an infinite amount of times.";
	eAddHelpPage("advent_output", outputEntry);
	
	local keyValueEntry = {};
	keyValueEntry.title = "Changing Keyvalues";
	keyValueEntry.text = "Syntax: e_keyvalue <key> <value> - Sets a key / value pair for an entity. $p Example: e_keyvalue targetname test \n -This sets the name of an entity \n e_keyvalue model models/antlion.mdl \n -This sets the model of something to an antlion. \n Warning: Setting a model with this command is not recommended. Always check file paths before using them, as you run a risk of crashing the server.";
	eAddHelpPage("advent_keyvalue", keyValueEntry);
	
	local renderEntry = {};
	renderEntry.title = "Rendering";
	renderEntry.text = "Syntax: e_render <rendermode> <renderamt> <renderfx> <r> <g> <b> \n This command will render an entity. $p <rendermode> can be one of the following: $p 0: Normal \n 1: Color \n 2: Texture \n 3: Glow \n 4: Solid \n 5: Additive \n 7: Additive Fractional Frame \n 9: World Space Glow \n 10: Dont Render $p For <renderamt>, this is generally the alpha of an entity. $p <renderfx> can be one of the following: \n 0: Normal \n 1: Slow Pulse \n 2: Fast Pulse \n 3: Slow Wide Pulse \n 4: Fast Wide Pulse \n 5: Slow Fade Away \n 6: Fast Fade Away \n 7: Slow Become Solid \n 8: Fast Become Solid \n 9: Slow Strobe \n 10: Fast Strobe \n 11: Faster Strobe \n 12: Slow Flicker \n 13: Fast Flicker \n 14: Constant Glow \n 15: Distort \n 16: Hologram (Distort + fade) \n 23: Cull By Distance (TEST) \n 24: Spotlight FX \n 26: Fade Near. $p <r> <g> and <b> represent the red, green, and blue values of the render.";
	eAddHelpPage("advent_render", renderEntry);
	
	local classEntry = {};
	classEntry.title = "Changing Classnames";
	classEntry.text = "Syntax: e_class <classname> \n This command is used to change the classname of an entity; for example, if you wanted to change a func_brush to a trigger_multiple, then you would do e_class trigger_multiple. $p The classname isn't actually changed until you copy the entity (Recommended: e_replace)";
	eAddHelpPage("advent_class", classEntry);