	-- Module Name
	eLastLoadedModule = "Circle Stack 1.2 by Joudoki";
	
	-- Player - specific variables
	
	function eCircleStack(iPlayer, iEnts, iSettings)
		if (iEnts == nil) then
			eShowMessage(iPlayer, "Nothing to stack!");
			return;
		end
		
		-- I need:
		-- Number Copies [1]
		-- Radius [2]
		-- Degrees between copies [3]
		-- Z Offset [4]
		-- Rotate Copies [5]
			-- 1: Rotate to face
			-- 2: Rotate to face, but keep facing same up direction
		-- Select Copies [6]
		-- Spawn Frozen [7]
		-- Rotation offset
		
		if (iSettings[3] == "auto" and iSettings[1] == "auto") then
			dMsg("User specified auto for both Number and degrees. Returning.")
			eShowMessage(iPlayer, "You must specify either Number of copies or Degree offset!");
			return false
		elseif (iSettings[1] == "auto" and iSettings[3] ~= "auto") then
			dMsg("User specified auto for the number of copies.")
			iSettings[1] = 360/iSettings[3];		
			dMsg("Number of copies is " .. iSettings[1])
		elseif (iSettings[3] == "auto" and iSettings[1] ~= "auto") then
			dMsg("User specified auto for the degrees offset.")
			iSettings[3] = 360/iSettings[1];
			dMsg("Degree rotation is " .. iSettings[3])
		end		
		
		local numberStacksTotal = table.getn(iEnts) * iSettings[1];
		
		if (tonumber(numberStacksTotal) > tonumber(ECS_MAX_STACK)) then 
			dMsg("ECS_MAX_STACK(" .. ECS_MAX_STACK .. ") exceeded for player id " .. iPlayer .. " with value " .. numberStacksTotal);
			eShowMessage(iPlayer, "You can't spawn that many props! Server max is " .. ECS_MAX_STACK .. " and you tried to make " .. numberStacksTotal .. "!");
			return false;
		elseif (numberStacksTotal < 1) then
			eShowMessage(iPlayer, "Nothing to stack!");
			return false;
		else
			dMsg("Max Stack not exceeding, continuing");
		end
		
		iSettings[7] = eSpawnFrozen[iPlayer];
		
		iSettings = eSetDefaultSettings(iSettings, 7, {[7] = 1});
		
		dMsg ("Number of Copies: " 	.. 	iSettings[1]);
		dMsg ("Radius: " 			.. 	iSettings[2]);
		dMsg ("Degree offset: " 	..	iSettings[3]);
		dMsg ("Z Offset: " 			.. 	iSettings[4]);
		dMsg ("Rotate Copies: " 	.. 	iSettings[5]);
		dMsg ("Select Copies: " 	.. 	iSettings[6]);
		dMsg ("Spawn Frozen: " 		.. 	iSettings[7]);	
		
		local iStackedEnts = {};
		
		for i=1, table.getn(iEnts) do
			local iEnt = iEnts[i];
			
			local vClass = _EntGetType(iEnt);
			if (eNewClasses[iEnt]) then vClass = eNewClasses[iEnt] end
			eNewClasses[iEnt] = nil;
			
			local vModel = _EntGetModel(iEnt);
			local vPos = _EntGetPos(iEnt);
			local vAng = _EntGetAngAngle(iEnt);
			
			for k = 1, iSettings[1] do
				local iRadDegrees = math.rad(iSettings[3] * k);
				
				-- Z Plane ( x / y )
				iPosX = math.cos( iRadDegrees ) * iSettings[2] + vPos.x;
				iPosY = math.sin( iRadDegrees ) * iSettings[2] + vPos.y;
				iPosZ = vPos.z + ( iSettings[4] * k );
					
				local cProp = _EntCreate(vClass); -- Create a new prop
				local cPos 	= vector3(iPosX, iPosY, iPosZ);
				
				_EntPrecacheModel(vModel); -- Make sure that the model is ready to be used by the engine
				_EntSetKeyValue(cProp, "model", vModel); -- Set the model on the copy
				
				_EntSetPos(cProp, cPos);
				
				if iSettings[5] == "1" then -- Rotate
					dMsg("Rotating copy " .. cProp .. " to face " .. iEnt);
					_util.PointAtEntity(cProp, iEnt);
				elseif iSettings[5] == "2" then
					dMsg("Rotating copy " .. cProp .. " to face " .. iEnt .. ", but preserving x axis rotation");
					_util.PointAtEntity(cProp, iEnt);
					local vAng2 = _EntGetAngAngle(cProp);
					vAng2.x = vAng.x;
					_EntSetAngAngle(cProp, vAng2);
				else
					_EntSetAngAngle(cProp, vAng);
				end
				
				_EntSpawn(cProp);
				
				if iSettings[6] == "1" then -- Select
					dMsg("Selecting copy " .. cProp)
					eSelect(iPlayer, cProp);
				end
				if iSettings[7] == 1 then -- Freeze
					dMsg("Freezing copy " .. cProp)
					_PhysEnableMotion(cProp, false); -- If we said we wanted it to be spawned frozen, we freeze it here
				end
				
				table.insert(iStackedEnts, cProp);
			end
		end
		
		if (not(eLastStacks[iPlayer])) then eLastStacks[iPlayer] = {} end
		table.insert(eLastStacks[iPlayer], iStackedEnts);
		
		eShowMessage(iPlayer, eGetNSelected(iPlayer) .. " circle stacked " .. iSettings[1] .. " time(s) with radius " .. iSettings[2] .. ", degree offset " .. iSettings[3] .. ", z offset " .. iSettings[4] .. ".");
		eLogEvent(iPlayer, "stacked " .. eGetNSelected(iPlayer) .. " in a circle.", ECS_LOG_LEVELTHREE);
	end
	
	function eCircleStackCall(iPlayer, iArgs)		
		local iSettings = explode(" ", iArgs);
		local iEnts = eGetProps(iPlayer);
		eCircleStack(iPlayer, iEnts, iSettings);
	end
	
	eAddCommand("e_cstack",		eCircleStackCall,		"Syntax: e_cstack <number> <radius> <degree offset> <z offset> <rotate copies> <select copies>. Stacks a prop in a circle, using the prop as the center.", ECS_ADMIN_EVERYONE);