	-- LABox Module
	-- e_laboxon, e_laboxoff
	
	-- Module Name
	eLastLoadedModule = "Looking At Box 2.0 by Joudoki";
	
	-- Player - specific variables	
	eLABox = {}; -- eLABox is the little box that displays when you are looking at an entity. 
	
	-- Functions	
	function eCreateLAB(iPlayer)
		_GModRect_Start("gmod/white")
		_GModRect_SetPos(0.1, 0.025, 0.8, 0.3)
		_GModRect_SetColor(64, 64, 64, 200)
		_GModRect_SetTime(9999, 0, 0)
		_GModRect_Send(iPlayer, 512+iPlayer)
		
		_GModText_Start("Trebuchet24");
		_GModText_SetPos(0.11, 0.035);
		_GModText_SetTime(9999, 0, 0);
		_GModText_SetText("Entity ID: 1337\nEntity Name: 1337\nEntity Class: ent_1337");
		_GModText_SetColor(255, 255, 255, 200);
		_GModText_Send(iPlayer, 512+iPlayer);
		
		_GModText_Start("Trebuchet24");
		_GModText_SetPos(0.11, 0.129);
		_GModText_SetTime(9999, 0, 0);
		_GModText_SetText("Entity Health: 1337\nEntity Mass: 1337 \nEntity Movetype: MOVETYPE_1337");
		_GModText_SetColor(255, 255, 255, 200);
		_GModText_Send(iPlayer, 768+iPlayer);
		
		_GModText_Start("Trebuchet24");
		_GModText_SetPos(0.11, 0.223);
		_GModText_SetTime(9999, 0, 0);
		_GModText_SetText("Entity Position: 1 33 7\nEntity Angles: 13 3 7\nEntity Model: 1337.mdl");
		_GModText_SetColor(255, 255, 255, 200);
		_GModText_Send(iPlayer, 1024+iPlayer);
		
		eLABox[iPlayer] = 1;
		eShowMessage(iPlayer, "Looking-At-Box turned on!");
		eLogEvent(iPlayer, "turned on the looking at box.", ECS_LOG_LEVELTWO);
	end
	function eDestroyLAB(iPlayer)
		_GModText_Hide(iPlayer, 512 + iPlayer, 0.5, 0.1);
		_GModText_Hide(iPlayer, 768 + iPlayer, 0.5, 0.1);
		_GModText_Hide(iPlayer, 1024 + iPlayer, 0.5, 0.1);
		_GModRect_Hide(iPlayer, 512+iPlayer, 0.5, 0.1);
		eLABox[iPlayer] = 0;
		eShowMessage(iPlayer, "Looking-At-Box turned off!");
		eLogEvent(iPlayer, "turned off the looking at box.", ECS_LOG_LEVELTWO);
	end
	
	function eUpdateLAB(iPlayer, entInfo)
		_GModText_Start("Trebuchet24");
		_GModText_SetPos(0.11, 0.035);
		_GModText_SetTime(9999, 0, 0);
		_GModText_SetText("Entity ID: " .. entInfo[0] .. "\nEntity Name: " .. entInfo[1] .. "\nEntity Class: " .. entInfo[2]);
		_GModText_SetColor(255, 255, 255, 200);
		_GModText_Send(iPlayer, 512+iPlayer);
		
		_GModText_Start("Trebuchet24");
		_GModText_SetPos(0.11, 0.129);
		_GModText_SetTime(9999, 0, 0);
		_GModText_SetText("Entity Health: " .. entInfo[6] .. "\nEntity Mass: " .. entInfo[7] .. "\nEntity Movetype: " .. entInfo[8]);
		_GModText_SetColor(255, 255, 255, 200);
		_GModText_Send(iPlayer, 768+iPlayer);		
		
		_GModText_Start("Trebuchet24");
		_GModText_SetPos(0.11, 0.223);
		_GModText_SetTime(9999, 0, 0);
		_GModText_SetText("Entity Position: " .. vecString(entInfo[3]) .. "\nEntity Angles: " .. vecString(entInfo[4]) .. "\nEntity Model: " .. entInfo[5]);
		_GModText_SetColor(255, 255, 255, 200);
		_GModText_Send(iPlayer, 1024+iPlayer);
	end
	function eLABThink(iPlayer)
		if (eLABox[iPlayer] == 0 or eLABox[iPlayer] == nil) then return end
		local entInfo = {0,0,0,0,0,0,0};
		local moveTypes = { "UNKNOWN", "MOVETYPE_NONE", "MOVETYPE_ISOMETRIC", "MOVETYPE_WALK", "MOVETYPE_STEP", "MOVETYPE_FLY", "MOVETYPE_FLYGRAVITY", "MOVETYPE_VPHYSICS", "MOVETYPE_PUSH", "MOVETYPE_NOCLIP", "MOVETYPE_LADDER", "MOVETYPE_OBSERVER", "MOVETYPE_ISOMETRIC"}
		
		_TraceLine(_PlayerGetShootPos(iPlayer),_PlayerGetShootAng(iPlayer), 32768, iPlayer);
		if _TraceHitNonWorld() then
			local iEnt = _TraceGetEnt();
			entInfo[0] = iEnt; -- id
			entInfo[1] = _EntGetName(iEnt); -- Name
			entInfo[2] = _EntGetType(iEnt); -- Class
			
			entInfo[3] = _EntGetPos(iEnt); -- Pos
			entInfo[4] = _EntGetAngAngle(iEnt); -- vector3 angle
			entInfo[5] = _EntGetModel(iEnt); -- Model
			
			entInfo[6] = _EntGetMaxHealth(iEnt); -- Maxhealth
			entInfo[7] = _phys.GetMass(iEnt); -- Mass
			entInfo[8] = _EntGetMoveType(iEnt); -- Movetype
		else
			entInfo[0] = "<Worldspawn>";
			entInfo[1] = "<None>"; -- Name
			entInfo[2] = "<None>"; -- Class
			
			entInfo[3] = _TraceEndPos(); -- Pos
			entInfo[4] = vector3(0, 0, 0); -- vector3 angle
			entInfo[5] = "<None>"; -- Model
			
			entInfo[6] = "<None>"; -- MaxHealth
			entInfo[7] = "<None>"; -- Mass
			entInfo[8] = -1; -- Movetype
		end
		for i = 0, 8 do
			if ((entInfo[i] == nil) or (entInfo[i] == "")) then
				entInfo[i] = "<None>";
			end
		end
		
		entInfo[8] = moveTypes[entInfo[8] + 2];
		
		--dMsg("Entity ID: " .. entInfo[0]);
		--dMsg("Entity Name: " .. entInfo[1]);
		--dMsg("Entity Class: " .. entInfo[2]);
		--dMsg("Entity Position: " .. vecString(entInfo[3]));
		--dMsg("Entity Angles: " .. vecString(entInfo[4]));
		--dMsg("Entity Health: " .. entInfo[5]);
		--dMsg("Entity Mass: " .. entInfo[6]);
				
		eUpdateLAB(iPlayer, entInfo);
	end
	
	-- Calls
	function eLaBoxOnCall(iPlayer, iArgs)
		eCreateLAB(iPlayer);
	end	
	function eLaBoxOffCall(iPlayer, iArgs)
		eDestroyLAB(iPlayer);
	end
	
	-- Add functions to function list
	-- eAddCommand(<command name>, <function to call>)
	eAddCommand("e_laboxon", 	eLaBoxOnCall,		"Turns the looking-at box on.", ECS_ADMIN_EVERYONE);
	eAddCommand("e_laboxoff", 	eLaBoxOffCall,		"Turns the looking-at box off.", ECS_ADMIN_EVERYONE);
	
	-- Add Player-Specific think functions
	-- eAddThink(<think function with arg iPlayer>)
	eAddThink(eLABThink, 0.25, true);
	 
	local laboxEntry = {};
	laboxEntry.title = "Looking At Box";
	laboxEntry.text = "Commands: \n e_laboxon and e_laboxoff $p These two commands will show information regarding the entity (or position) that you are looking it. If you see an entity, it will tell you its name, type, id, etc, and if you don't aim at an entity, it will tell you where you're looking at. (Hence, \"Looking At Box\" ;)";
	eAddHelpPage("labox", laboxEntry);