	-- Entity Command Suite
	-- weapon_select
	-- 3/25/2006

	_OpenScript( "includes/vector3.lua" );
	_OpenScript( "e_commands/e_common.lua" );

	MyIndex		=	0; -- Weapon's entity index.
	Owner		= 	0; -- The player that owns this weapon
	CurrentTime	=	0; -- The current game time

	function onInit()
		_SWEPSetSound(MyIndex, "single_shot", "Weapon_PhysCannon.OpenClaws")
		dMsg(("Select Gun ID: " .. MyIndex) .. ", Player ID ".._EntGetParent(MyIndex).."\n"); -- For debugging
	end
	function onPrimaryAttack()
		dMsg("Primary Fire Called");		
		-- Select the entity
		_RunString("eSelectGun_Select(" .. Owner .. ")");
		dMsg("Primary Fire Call End");
	end
	function onSecondaryAttack()
		dMsg("Secondary Fire Called");
		-- Deselect the entity
		_RunString("eSelectGun_Deselect(" .. Owner .. ")");
		dMsg("Secondary Fire Call End");
	end
	function onReload()
		dMsg("Reload Called");
		-- Deselect all
		_RunString("eSelectGun_DeselectAll(" .. Owner .. ")");
		dMsg("Reload End");
		return false;
	end
	
	function Holster() end
	function onDrop() end

	-- General
	function getWeaponSwapHands() 			return false;								end
	function getWeaponFOV() 				return 70; 									end
	function getWeaponSlot()				return 5; 									end
	function getWeaponSlotPos() 			return 1; 									end
	function getFiresUnderwater()			return true; 								end
	function getReloadsSingly() 			return false; 								end
	-- Primary Attack
	function getDamage() 					return 0; 									end
	function getPrimaryShotDelay() 			return 0.3; 								end
	function getPrimaryIsAutomatic() 		return true; 								end
	function getBulletSpread() 				return vector3( 0.0, 0.0, 0.0 ); 			end
	function getViewKick() 					return vector3( 0.0, 0.0, 0.0 ); 			end
	function getViewKickRandom() 			return vector3( 0, 0, 0 ); 					end
	function getNumShotsPrimary()			return 1;									end
	function getPrimaryAmmoType()			return "pistol";							end
	function getMaxClipPrimary()			return 1;									end
	function getDefClipPrimary()			return 1;									end
	function getPrimaryScriptOverride()		return 1;									end
	-- Secondary attack	
	function getDamageSecondary() 			return 0;									end
	function getSecondaryShotDelay()		return 0.1;									end
	function getSecondaryIsAutomatic() 		return true; 								end
	function getBulletSpreadSecondary() 	return vector3( 0.0, 0.0, 0.0 ); 			end
	function getViewKickSecondary() 		return vector3( 0.0, 0.0, 0.0 );			end
	function getViewKickRandomSecondary() 	return vector3( 0, 0, 0 );					end
	function getNumShotsSecondary() 		return 1;									end
	function getSecondaryAmmoType() 		return "none";								end
	function getDefClipSecondary()			return 1;									end
	function getMaxClipSecondary()			return 1;									end
	function getSecondaryScriptOverride()	return 1;									end
	-- General
	function getViewModel() 				return "models/weapons/v_crossbow.mdl"; 	end
	function getWorldModel()				return "models/weapons/w_crossbow.mdl"; 	end
	function getClassName() 				return "ecs_select";						end
	function getHUDMaterial()				return "e_commands/swep_selectgun";			end	
	function getAnimPrefix() 				return "crossbow";							end
	function getPrintName()					return "Select Gun";						end
	