	lMsg("[ECS]: e_main.lua loaded")
	eLogEvent(0, "e_main.lua loaded", ECS_LOG_LEVELTWO, true);
	
	--[[
	|====================================================================================================|
	|	Entity Command Suite
	|	Ryan "Joudoki" Lewellen
	|	
	|	Version history:
	|		12/26/2005 - v1
	|		1/26/2006 - v3b
	|		2/25/2006 - v5 Development (MAJOR CHANGES, LIKE MODULE SYSTEM)
	|		4/2/2006 - v5.0 Released
	|		4/11/2006 - v5.1 Released
	|		4/21/2006 - v5.2 Developement resumed after a break
	|	
	|	Contact Info:
	|		Email:	ryanlewellen@comcast.net or Joudoki@gmail.com
	|		AIM: 	Joudoki
	|		MSN: 	Joudoki@hotmail.com
	|		Y!: 		Joudoki
	|		Google: 	Joudoki@gmail.com
	|	
	|	PLEASE DO NOT MODIFY THIS SCRIPT WITHOUT FIRST CONTACTING ME.	
	|	IF YOU NEED TO COPY / REUSE A PORTION OF THIS SCRIPT, THEN PLEASE
	|	ASK PERMISSION FIRST
	|	Copyright 2005-2006 Ryan Lewellen
	|====================================================================================================|
	--]]
	
	_OpenScript( "e_commands/e_config.lua" );
	_OpenScript( "e_commands/e_defines.lua" );
	
	-- Version Number
	ECS_VERSION_NUMBER = "v5.2"; -- Don't change this, or I'll murder you
	
	ECS_ENABLED = true; -- Is ECS currently enabled?
	
	-- Global commands table
	eCommandsTable = { };
	eThinkTable = { }; -- All of the think functions are added into this command, so that if we need to shut off the think commands, we can just disable the one think command.
	
	eModulesTable = { };
	
	eLastLoadedModule = "";
	eLastLoadedInclude = "";
	
	function eLoadModules( )
		fileList = _file.Find( "lua/e_commands/modules/*.lua" );
		
		lMsg("Loading ECS Modules ...\n")
		
		local eParentDir = "/";
		local eCurrentDir = "/";
		
		for k,v in fileList do
			lMsg("\nModule Loaded: " .. eLastLoadedModule);
			_OpenScript("e_commands/modules" .. eCurrentDir .. v)
						
			table.insert(eModulesTable, eLastLoadedModule);			
		end
		
		lMsg("Done loading ECS Modules!")
	end
	function eReloadModules( )
		eCommandsTable = { };
		eThinkTable = { };
		
		eLoadModules();
	end
	
	function eAddCommand( iCommand, iFunction, iDesc, iLevel)
		if (iCommand == nil or iFunction == nil) then
			dMsg("One or more of the arguments was not passed to eAddCommand!")
			return	false;
		end
		
		if (iLevel == nil) then iLevel = ECS_ADMIN_EVERYONE end
		
		--dMsg("Function: " .. iCommand);
		--dMsg("	- Chat Command: -" .. iCommand);
		--dMsg("	- Console Command: " .. iCommand);
		--dMsg("	- Function: " .. tostring(iFunction));
		--dMsg("	- Description: " .. iDesc);
		
		local newEntry = {};
		newEntry.name = iCommand;
		newEntry.func = iFunction;
		newEntry.desc = iDesc;
		newEntry.level = iLevel;
		
		table.insert(eCommandsTable, newEntry);
		local iCheckAccessFunc = function(iPlayer, iArgs)
			if (eCommandAllowed(iPlayer, iLevel)) then iFunction(iPlayer, iArgs); end -- Make sure the user can actually use this command
		end
		
		CONCOMMAND(iCommand, iCheckAccessFunc);
	end
	function eAddThink(iFunction, iFreq, iPlay)
		if (iFunction == nil) then
			dMsg("iFunction not passed to eAddThink!")
			return false;
		end
		
		if (iFreq == nil) then
			iFreq = 0.5; -- Every half second
		end
		
		if (iPlay == nil) then
			iPlay = false;
		end

		dMsg("EThink " .. tostring(iFunction) .. ". Frequency: " .. tostring(iFreq));
		_ServerCommand("echo [ECS] - EThink " .. tostring(iFunction) .. ". Frequency: " .. tostring(iFreq) .. "\n");
		
		local newEntry = { iFunction, iFreq, iPlay, _CurTime() + iFreq};
		
		table.insert(eThinkTable, newEntry);
	end
	
	-- Specified by developer
		-- 1: Function
		-- 2: Frequency
		-- 3: Player-specific Function
	
	-- Internal
		-- 4: Next call
	
	function eMainThink(debug)
		local curTime = _CurTime();
		
		for i=1, table.getn(eThinkTable) do
			local curThink = eThinkTable[i];
			
			if (debug ~= nil) then dMsg("eThinkTable Entry " .. i) end
			if (debug ~= nil) then dMsg(tostring(curThink[1]) .. " : " .. tostring(curThink[2]) .. " : " .. tostring(curThink[3]) .. " :: " .. tostring(curThink[4])) end
			
			if (curTime > curThink[4]) then
				if (debug ~= nil) then dMsg("Running eThinkTable Entry " .. i .. " (" .. tostring(curThink[1]) .. ")") end
				-- It's time to run it
				if (curThink[3] == true) then
					if (debug ~= nil) then dMsg("Running eThinkTable with the player argument") end
					for p=1, _MaxPlayers() do
						if (_PlayerInfo(p, "connected")) then
							curThink[1](p);
						end
					end
				else
					if (debug ~= nil) then dMsg("Running eThinkTable without the player argument") end
					curThink[1]();
				end
				
				if (debug ~= nil) then dMsg("Setting next run time") end
				curThink[4] = tonumber(curTime) + tonumber(curThink[2]);
			end
		end
		
		if (debug ~= nil) then dMsg("Finished firing think events") end
	end
	
	function ePlayerSay( iPlayer, iMsg, iTeam )
		local hide = nil;
		local commands = {};
		
		for i = 1, table.getn(eCommandsTable) do
			local eCmdName = "-" .. eCommandsTable[i].name;
			local eCmd = string.find(string.lower(iMsg), eCmdName, 1, true)
			if (eCmd) then
				dMsg("What a player said is recognized, calling the " .. eCommandsTable[i].name .. " function.")		
				commands[eCommandsTable[i].name] = {eCommandsTable[i].func, eCommandsTable[i].level};
				hide = true;
			end
		end
		
		if (hide == true) then -- We have 1 more more commands
			local commandToRun = "";
			local commandFunc = nil;
			local commandLevel = ECS_ADMIN_EVERYONE;
		
			for k,v in commands do
				if (string.len(k) > string.len(commandToRun)) then
					commandToRun = k;
					commandFunc = v[1];
					commandLevel = v[2];
				end
			end
			
			-- Pass the arguments to the _other_ machine
			local iMsgFinal = eGetArgs(iMsg, "-" .. commandToRun);
			
			if (eCommandAllowed(iPlayer, commandLevel)) then commandFunc(iPlayer, iMsgFinal); end -- Make sure the user can actually use this command
		end
		
		if (hide) then return "" else return iMsg end
	end
	function eShowRunning( iPlayer )
		_GModRect_Start("gmod/white")
		_GModRect_SetPos(0.025, 0.025, 0.65, 0.075)
		_GModRect_SetColor(128, 128, 128, 100)
		_GModRect_SetTime(ECS_SHOWRUNNING, 0.5, 0.5)
		_GModRect_Send(iPlayer, 3)
		
		_GModText_Start("Trebuchet24")
		_GModText_SetPos(0.04, 0.03)
		_GModText_SetTime((ECS_SHOWRUNNING - 0.25), 0.5, 0.5)
		_GModText_SetText("This server is running Entity Commands Suite " .. ECS_VERSION_NUMBER .. " by Exitus / Joudoki\nType -e_help into chat for more info.")
		_GModText_SetColor(255, 255, 255, 200)
		_GModText_Send(iPlayer, 6)
	end
	
	function eRunCommand ( iPlayer, iArgs )
	
	end
	
	AddThinkFunction(eMainThink); -- The main think function. It calls other think functons that have to do with the other indivual components
	HookEvent( "eventPlayerSay", ePlayerSay );
	HookEvent( "eventPlayerSpawn", eShowRunning );
	
	CONCOMMAND("e_reloadmodules", eReloadModules);