	lMsg("[ECS]: e_sweps.lua loaded");
	eLogEvent(0, "e_sweps.lua loaded", ECS_LOG_LEVELTWO, true);
	
	--[[
	|====================================================================================================|
	|	Entity Command Suite
	|	Ryan "Joudoki" Lewellen
	|	
	|	Version history:
	|		12/26/2005 - v1
	|		1/26/2006 - v3b
	|		2/25/2006 - v5 Development (MAJOR CHANGES, LIKE MODULE SYSTEM)
	|		4/2/2006 - v5.0 Released
	|		4/11/2006 - v5.1 Released
	|		4/21/2006 - v5.2 Developement resumed after a break
	|	
	|	Contact Info:
	|		Email:	ryanlewellen@comcast.net or Joudoki@gmail.com
	|		AIM: 	Joudoki
	|		MSN: 	Joudoki@hotmail.com
	|		Y!: 		Joudoki
	|		Google: 	Joudoki@gmail.com
	|	
	|	PLEASE DO NOT MODIFY THIS SCRIPT WITHOUT FIRST CONTACTING ME.	
	|	IF YOU NEED TO COPY / REUSE A PORTION OF THIS SCRIPT, THEN PLEASE
	|	ASK PERMISSION FIRST
	|	Copyright 2005-2006 Ryan Lewellen
	|====================================================================================================|
	--]]
	
	local eSwepTable = {};
	-- Indexed by entity name
		-- 1: Path
		-- 2: Level
		-- 3: Help
			-- 1: Author
			-- 2: Name / Version
			-- 3: Primary Fire
			-- 4: Secondary Fire
			-- 5: Reload
	
	function eAddSwep(iCommand, iEntName, iPath, iLevel, iHelp)
		local newEntry = {};
		
		if (isEmpty(iCommand)) then 
			-- We need a path
			lMsg("Fatal Error: Can't add SWEP without a command name");
			return false;
		end
		if (isEmpty(iPath)) then 
			-- We need a path
			lMsg("Fatal Error: Can't add SWEP without a path");
			return false;
		end
		if (isEmpty(iEntName)) then
			-- We need an entname
			lMsg("Fatal Error: Can't add SWEP without entity name");
			return false;
		end
		
		if (isEmpty(iLevel)) then 
			lMsg("Warning: No level specified for SWEP; Setting to 1");
			iLevel = 1;
		end
		
		if (isEmpty(iHelp)) then
			lMsg("Warning: No help specified for SWEP; Setting to default values");
			iHelp = {};
			iHelp[1] = "Unknown";
			iHelp[2] = "Unknown v?";
			
			iHelp[3] = "Unknown";
			iHelp[4] = "Unknown";
			iHelp[5] = "Unknown";
		end
		
		newEntry.entity = iEntName;
		newEntry.path = iPath;
		newEntry.level = iLevel;
		newEntry.help = iHelp;
		
		dMsg("eSwep: " .. tostring(iCommand) .. " (" .. iPath .. ")");
		_ServerCommand("echo [ECS] - eSwep: " .. tostring(iCommand) .. " (" .. iPath .. ")\n");
		
		eSwepTable[iCommand] = newEntry;
	end
	
	function eGiveSwep(iPlayer, iSwep)
		if (iSwep == "#list") then
			-- List all the available sweps
			local i = 1;
			lMsg("\nAvailable Sweps:")
			for k,v in eSwepTable do
				lMsg("Swep #" .. i .. " : " .. k)
				i = i + 1;
			end
			lMsg("End of List\n")
			
			eShowMessage ( iPlayer, "A list of available sweps has been printed to your console." )			
			eLogEvent(iPlayer, "Player " .. ePlayerInfo(iPlayer) .. " tried to get non-existant swep '" .. iSwep .. "'", true);
			
			return true;
		end
		local iSwepT = eSwepTable[iSwep]
		if (not(iSwepT)) then
			dMsg("Error: Could not find SWEP at address '" .. iSwep .. "'.")
			
			eShowMessage ( iPlayer, "Couldn't find the swep '" .. iSwep .. "', try doing e_swep #list to see a list of available sweps." );
			eLogEvent(iPlayer, "Player " .. ePlayerInfo(iPlayer) .. " tried to get non-existant swep '" .. iSwep .. "'", true);
			
			return false 
		end
		dMsg("Got an SWEP entry. The access key to check is '" .. tostring(iSwepT.level) .. "'.");
		if (eCommandAllowed(iPlayer, iSwepT.level) ~= true) then 
			eLogEvent(iPlayer, "Player " .. ePlayerInfo(iPlayer) .. " tried to get swep '" .. iSwep .. "'", true);
			return false;
		end
		
		if (_PlayerHasWeapon(iPlayer, iSwepT.entity) == true) then
			dMsg("User already has the swep, switching to that swep.")
			_PlayerSelectWeapon(iPlayer, iSwepT.entity);
		else
			dMsg("User doesn't have the swep, giving it to the user.")
			_PlayerGiveSWEP(iPlayer, iSwepT.path);
			-- Show help here
			
			dMsg("Showing the help.")
			eShowSwepHelp(iPlayer, iSwepT.help);
		end
		
		eLogEvent(iPlayer, "Gave " .. ePlayerInfo(iPlayer) .. " the swep '" .. iSwep .. "'");
		
		dMsg("Done giving user SWEP");
	end
	function eShowSwepHelp(iPlayer, iHelp)
		dMsg("Showing the textbox")
		_GModRect_Start("gmod/white")
		_GModRect_SetPos(0.21, 0.8, 0.4, 0.20)
		_GModRect_SetColor(64, 64, 64, 100)
		_GModRect_SetTime(ECS_SHOWSWEPHELP_TIME, 0.5, 0.5)
		_GModRect_Send(iPlayer, 42306) -- Today, April 23rd, 2006
		
		dMsg("Showing the text")
		_GModText_Start("Trebuchet24");
		_GModText_SetPos(0.22, 0.825)
		_GModText_SetTime(ECS_SHOWSWEPHELP_TIME, 0.5, 0.5)
		_GModText_SetText(string.format("%s\nBy: %s\n\nPrimary Fire: %s\nSecondary Fire: %s\nReload: %s", iHelp[2], iHelp[1], iHelp[3], iHelp[4], iHelp[5]))
		_GModText_SetColor(255, 255, 255, 200)
		_GModText_Send(iPlayer, 42406) -- Tomorrow is a school day :(
		
		dMsg("Done showing swep help")
	end
	
	function eReloadSweps()
	
	end
	
	eAddCommand( "e_swep", eGiveSwep, "Gives you a specified swep. Typing e_swep #list will display a list of available sweps.")