	-- Basic Module
	-- Stack, Rotate, Translate
	
	-- Module Name
	eLastLoadedModule = "Basic 3.0 by Joudoki";
	
	-- Player - specific variables
	eLastOffsets = {}; -- eLastOffsets is the table I will use for storing the offsets from the previously done command. Used for the -1 shortcut. Is 2-d
	eLastStacks = {}; -- When a stack is finished, the created entities are filed under this table with playerid, so that if the user does -e_undo, it undoes it.
	eSpawnFrozen = {}; -- spawn new props frozen?
	eMeasures = {}; -- e_measure 2-stage command data table
	eCopy = {}; -- The player-specific data for copying entities
	
	-- Stack
	function eStack(iPlayer, iEnts, iSettings) -- n,x,y,z,ay,ax,az,s,iPlayer
		if (iEnts == nil) then
			eShowMessage(iPlayer, "Nothing to stack!");
			return;
		end
		
		iSettings[9] = eSpawnFrozen[iPlayer];
		
		if (eLastOffsets[iPlayer] == nil) then eLastOffsets[iPlayer] = {} end
		
		dMsg ("Making sure that all variables have values")
		if (iSettings[1] == "-1") then
			dMsg ("Player used -1 shortcut")
			if (eLastOffsets[iPlayer][1] ~= nil) then iSettings[1] = eLastOffsets[iPlayer][1] end -- Num
			if (eLastOffsets[iPlayer][2] ~= nil) then iSettings[2] = eLastOffsets[iPlayer][2] end -- X
			if (eLastOffsets[iPlayer][3] ~= nil) then iSettings[3] = eLastOffsets[iPlayer][3] end -- Y
			if (eLastOffsets[iPlayer][4] ~= nil) then iSettings[4] = eLastOffsets[iPlayer][4] end -- Z
			if (eLastOffsets[iPlayer][5] ~= nil) then iSettings[5] = eLastOffsets[iPlayer][5] end -- AY
			if (eLastOffsets[iPlayer][6] ~= nil) then iSettings[6] = eLastOffsets[iPlayer][6] end -- AX
			if (eLastOffsets[iPlayer][7] ~= nil) then iSettings[7] = eLastOffsets[iPlayer][7] end -- AZ
			if (eLastOffsets[iPlayer][8] ~= nil) then iSettings[8] = eLastOffsets[iPlayer][8] end -- S
			dMsg ("Done");
		end
		
		iSettings = eSetDefaultSettings(iSettings, 9, {[9] = 1});
		
		dMsg ("Done.")
		
		dMsg ("Number of Copies: " .. 	iSettings[1]);
		dMsg ("X Offset: " .. 			iSettings[2]);
		dMsg ("Y Offset: " ..			iSettings[3]);
		dMsg ("Z Offset: " .. 			iSettings[4]);
		dMsg ("Y Angle Offset: " .. 		iSettings[5]);
		dMsg ("X Angle Offset: " .. 		iSettings[6]);
		dMsg ("Z Angle Offset: " .. 		iSettings[7]);
		dMsg ("Select Copies: " ..		iSettings[8]);
		dMsg ("Spawn Frozen: " .. 		iSettings[9]);
		
		local numberStacksTotal = table.getn(iEnts) * iSettings[1];
		
		if (tonumber(numberStacksTotal) > tonumber(ECS_MAX_STACK)) then 
			dMsg("ECS_MAX_STACK(" .. ECS_MAX_STACK .. ") exceeded for player id " .. iPlayer .. " with value " .. numberStacksTotal);
			eShowMessage(iPlayer, "You can't spawn that many props! Server max is " .. ECS_MAX_STACK .. " and you tried to make " .. numberStacksTotal .. "!");
			return false;
		elseif (numberStacksTotal < 1) then
			eShowMessage(iPlayer, "Nothing to stack!");
			return false;
		else
			dMsg("Max Stack not exceeding, continuing");
		end
		
		dMsg("Setting some values here and there");
		
		local iStackedEnts = {};
		
		for k = 1, table.getn(iEnts) do
			local iEnt = iEnts[k];
		
			local offSet 	= vector3(iSettings[2], iSettings[3], iSettings[4]);
			local offAcc 	= vector3(iSettings[2], iSettings[3], iSettings[4]);
			
			local className = _EntGetType(iEnt);
			if (eNewClasses[iEnt]) then className = eNewClasses[iEnt] end
			eNewClasses[iEnt] = nil;
			
			local modelName = _EntGetModel(iEnt);
			local vPos = _EntGetPos(iEnt);
			local vAngle = _EntGetAngAngle(iEnt);
			
			local curPos = vPos;
			
			for i = 1, iSettings[1] do
				-- first, we need to get the new offset, and then we need to set the new offset so that when we run the same loop for the nth time, it will know how much to add on
				dMsg("In the for loop for the " .. i .. "th time. ")
				local curPos = vecAdd(curPos,offAcc);
				dMsg("curPos set")
				
				local newProp = _EntCreate(className); -- Create a new prop
				local vNewPropPos = curPos;
				_EntPrecacheModel(modelName); -- Make sure that the model is ready to be used by the engine
				_EntSetKeyValue(newProp, "model", modelName); -- Set the model on the copy
				_EntSetPos(newProp, curPos);
				_EntSetAngAngle(newProp, eRotAng(vAngle, iSettings[6]*i, iSettings[5]*i, iSettings[7]*i)); -- rotate the object, if we elected to do so
				_EntSpawn(newProp); -- spawn the prp
				
				if iSettings[9] == 1 then
					_PhysEnableMotion(newProp, false); -- If we said we wanted it to be spawned frozen, we freeze it here
					dMsg("Frozen!")
				end
				if iSettings[8] == "1" then
					eSelect(iPlayer, newProp);
				end
				
				table.insert(iStackedEnts, newProp);
				
				dMsg("Updating offAcc")
				offAcc = vecAdd (offSet, offAcc)
				dMsg("Done!")
			end
		end
		
		
		
		if (not(eLastStacks[iPlayer])) then eLastStacks[iPlayer] = {} end
		table.insert(eLastStacks[iPlayer], iStackedEnts);
		
		eLastOffsets[iPlayer][1] = iSettings[1];
		eLastOffsets[iPlayer][2] = iSettings[2];
		eLastOffsets[iPlayer][3] = iSettings[3];
		eLastOffsets[iPlayer][4] = iSettings[4];
		eLastOffsets[iPlayer][5] = iSettings[5];
		eLastOffsets[iPlayer][6] = iSettings[6]
		eLastOffsets[iPlayer][7] = iSettings[7];
		eLastOffsets[iPlayer][8] = iSettings[8];
		
		dMsg("eLastOffsets table updated")
			
		dMsg ("LASTOFFSET: Number of Copies: " .. 	eLastOffsets[iPlayer][1])
		dMsg ("LASTOFFSET: X Offset: " .. 			eLastOffsets[iPlayer][2])
		dMsg ("LASTOFFSET: Y Offset: " .. 			eLastOffsets[iPlayer][3])
		dMsg ("LASTOFFSET: Z Offset: " .. 			eLastOffsets[iPlayer][4])
		dMsg ("LASTOFFSET: Angle Y Offset: " .. 		eLastOffsets[iPlayer][5])
		dMsg ("LASTOFFSET: Angle X Offset: " .. 		eLastOffsets[iPlayer][6])
		dMsg ("LASTOFFSET: Angle Z Offset: " .. 		eLastOffsets[iPlayer][7])
		dMsg ("LASTOFFSET: Select Spawned: " .. 		eLastOffsets[iPlayer][8])
		
		eShowMessage(iPlayer, eGetNSelected(iPlayer) .. " stacked " .. eLastOffsets[iPlayer][1] .. " time(s) with " .. eLastOffsets[iPlayer][2] .. "x " .. eLastOffsets[iPlayer][3] .. "y " .. eLastOffsets[iPlayer][4] .. "z " .. eLastOffsets[iPlayer][6] .. "ax " .. eLastOffsets[iPlayer][5] .. "ay " .. eLastOffsets[iPlayer][7] .. "az.");
		eLogEvent(iPlayer, "stacked " .. table.getn(iEnts) .. " prop(s) " .. iSettings[1] .. " time(s) each for a total " .. numberStacksTotal .. " time(s)", ECS_LOG_LEVELTHREE);
	end
	function eRotAng(vOrigAng, rotAmtX, rotAmtY, rotAmtZ)
		return vector3((vOrigAng.x + rotAmtX), (vOrigAng.y + rotAmtY), (vOrigAng.z + rotAmtZ));
	end
		
	function eUndo(iPlayer)
		dMsg("e_undo called with iPlayer " .. iPlayer)
		local iLastEnts = eLastStacks[iPlayer];
		local undoneStack = table.getn(iLastEnts);
		local iUndoEnts = iLastEnts[undoneStack];
		if (not(iUndoEnts)) then return false end
		for i=1, table.getn(iUndoEnts) do
			local iEnt = iUndoEnts[i];
			_EntRemove(iEnt);
		end
		table.remove(iLastEnts, undoneStack);
		eLastStacks[iPlayer] = iLastEnts;
		dMsg("e_undo finished");
		eShowMessage(iPlayer, "Undo Level " .. undoneStack .. " undone!");
		eLogEvent(iPlayer, "Undid his/her level " .. undoneStack .. " undo.", ECS_LOG_LEVELONE);
	end
	function eUndoThink(iPlayer)
		local iUndoLevels = eLastStacks[iPlayer];
		
		if (not(iUndoLevels)) then
			iUndoLevels = {};
			eLastStacks[iPlayer] = {};
		end
		
		for i=1, table.getn(iUndoLevels) do
			local iEnts = iUndoLevels[i];
			for k=1, table.getn(iEnts) do
				if (_EntExists(iEnts[k]) ~= true) then
					table.remove(iEnts, k);
					lMsg("Warning: Undo entity #" .. iEnts[k] .. " doesn't exist, removing from undo list...");
				end
			end
			iUndoLevels[i] = iEnts;
		end
		
		eLastStacks[iPlayer] = iUndoLevels;
	end
	
	function eFreezeChange(iPlayer, iValue)
		dMsg ("Setting eSpawnFrozen for iPlayer " .. iPlayer .. " to " .. iValue .. ". ")
		local iNewValue = "off";
		if (string.lower(iValue) == "on") then 
			eSpawnFrozen[iPlayer] = 1; 
			iNewValue = "on";
		else 
			eSpawnFrozen[iPlayer] = 0;
			iNewValue = "off";
		end
		
		eShowMessage(iPlayer, "Spawn Frozen mode turned " .. iNewValue .. "!");
		eLogEvent(iPlayer, "Turned his/her spawnfrozen " .. iNewValue, ECS_LOG_LEVELTWO);
	end
	
	-- Freeze
	function eFreeze(iPlayer, iEnts) -- A function to freeze  selected entities
		dMsg("Freezing player " .. iPlayer .. "'s entities");
		for i=1, table.getn(iEnts) do
			_PhysEnableMotion(iEnts[i], false); -- Freeze
			dMsg("Freezing entity " .. iEnts[i])
		end
		dMsg("Done freezing entities")
		eShowMessage(iPlayer, eGetNSelected(iPlayer) .. " have been frozen");
		eLogEvent(iPlayer, "froze " .. eGetNSelected(iPlayer), ECS_LOG_LEVELONE);
	end	
	function eUnFreeze(iPlayer, iEnts) -- A function to unfreeze selected entities
		dMsg("Freezing player " .. iPlayer .. "'s entities");
		for i=1, table.getn(iEnts) do
			_PhysEnableMotion(iEnts[i], true); -- Unfreeze
			dMsg("Unfreezing entity " .. iEnts[i])
		end
		dMsg("unfreezing entities")
		eShowMessage(iPlayer, eGetNSelected(iPlayer) .. " have been unfrozen");
		eLogEvent(iPlayer, "unfroze " .. eGetNSelected(iPlayer), ECS_LOG_LEVELONE);
	end
	
	-- Rotate
	function eSetRotation(iPlayer, iEnts, iSettings)		
		for i=1, 3 do
			if (iSettings[i] == nil or iSettings[i] == "" or iSettings[i] == " ") then 
				iSettings[i] = 0; -- Everything Else
			end
			dMsg("iSettings[" .. i .. "] is " .. iSettings[i]);
		end
		
		for k = 1, table.getn(iEnts) do
			local iEnt = iEnts[k];
			_EntSetAngAngle(iEnt, vector3(iSettings[1], iSettings[2], iSettings[3]));
		end
		
		eShowMessage(iPlayer, "Rotation set to " .. vecString(vector3(iSettings[1], iSettings[2], iSettings[3])) .. "!");
		eLogEvent(iPlayer, "set the rotation of a prop to " .. vecString(vector3(iSettings[1], iSettings[2], iSettings[3])), ECS_LOG_LEVELONE);
	end
	function eAddRotation(iPlayer, iEnts, iSettings)		
		for i=1, 3 do
			if (iSettings[i] == nil or iSettings[i] == "" or iSettings[i] == " ") then 
				iSettings[i] = 0; -- Everything Else
			end
			dMsg("iSettings[" .. i .. "] is " .. iSettings[i]);
		end
		
		
		for k = 1, table.getn(iEnts) do
			local iEnt = iEnts[k];
			vAngle = _EntGetAngAngle(iEnt);
			_EntSetAngAngle(iEnt, vecAdd(vAngle, vector3(iSettings[1],iSettings[2],iSettings[3])));
		end
		
		eShowMessage(iPlayer, "Rotation set to " .. vecString(vecAdd(vector3(iSettings[1],iSettings[2],iSettings[3]), vAngle)) .. "!");
		eLogEvent(iPlayer, "set the rotation of a prop to " .. vecString(vector3(iSettings[1], iSettings[2], iSettings[3])), ECS_LOG_LEVELONE);
	end
	
	-- Position
	function eTranslate(iPlayer, iEnts, iSettings)
		dMsg("Translate called by " .. eGetName(iPlayer) .. " with coords " .. vecString(vector3(iSettings[1], iSettings[2], iSettings[3])));
		
		for i=1, 3 do
			if (iSettings[i] == nil or iSettings[i] == "" or iSettings[i] == " ") then 
				iSettings[i] = 0; -- Everything Else
			end
			dMsg("iSettings[" .. i .. "] is " .. iSettings[i]);
		end
		
		local translateVector = vector3(iSettings[1], iSettings[2], iSettings[3]);
		
		for k = 1, table.getn(iEnts) do
			local iEnt = iEnts[k];
			local vPos = _EntGetPos(iEnt);
			local vNewPos = vecAdd(vPos, translateVector);
			_EntSetPos(iEnt, vNewPos);
		end
		
		eShowMessage(iPlayer, eGetNSelected(iPlayer) .. " translated " .. vecString(translateVector));
		eLogEvent(iPlayer, "translated a prop.", ECS_LOG_LEVELONE);
	end
	function eSetPos(iPlayer, iEnts, iSettings)
		dMsg("Set Position called by " .. eGetName(iPlayer) .. " with coords " .. iSettings[1] .. "," .. iSettings[2] .. "," .. iSettings[3] .. ".");
		for k = 1, table.getn(iEnts) do	
			local iEnt = iEnts[k];
			local vPos = _EntGetPos(iEnt);
			
			if ((isEmpty(iSettings[1])) or string.lower(iSettings[1]) == "%a") then iSettings[1] = vPos.x end
			if ((isEmpty(iSettings[2])) or string.lower(iSettings[2]) == "%a") then iSettings[2] = vPos.y end
			if ((isEmpty(iSettings[3])) or string.lower(iSettings[3]) == "%a") then iSettings[3] = vPos.z end
			
			local vNewPos = vector3(iSettings[1], iSettings[2], iSettings[3]);
			
			_EntSetPos(iEnt, vNewPos);
		end
		
		eShowMessage(iPlayer, eGetNSelected(iPlayer) .. " moved to " .. vecString(vNewPos), ECS_LOG_LEVELONE);
	end
	
	-- Measure
	function eMeasure(iPlayer, iLocation)
		if (eMeasures[iPlayer] == nil) then
			eMeasures[iPlayer] = {};
		end
		
		if eMeasures[iPlayer].Stage == 1 then
			-- Stage 2
			local vec1 = eMeasures[iPlayer].FirstPos;
			local vec2 = iLocation;
			local vecLen = vecLength(vecSub(vec2, vec1));
			local xDist = vec2.x - vec1.x;
			local yDist = vec2.y - vec1.y;
			local zDist = vec2.z - vec1.z;
			eMeasures[iPlayer].Stage = 0;
			
			eShowMessage(iPlayer, "The distance between [" .. vecString(vec1) .. "] and [" .. vecString(vec2) .. "] is " .. vecLen .. ".", 0);
			eShowMessage(iPlayer, "started a measure.", ECS_LOG_LEVELONE);
			
			local iMessage = "Measurements:\nPoint 1: " .. vecString(vec1) .. "\nPoint 2: " .. vecString(vec2);
			iMessage = iMessage .. "\nTotal Distance: " .. vecLen .. "\nX Distance: " .. xDist .. "\nY Distance: " .. yDist .. "\nZ Distance: " .. zDist;
			
			_GModText_Start("Trebuchet24");
			_GModText_SetPos(0.2, 0.05);
			_GModText_SetTime(15, 0.5, 0.5);
			_GModText_SetText(iMessage);
			_GModText_SetColor(255, 255, 255, 200);
			_GModText_Send(iPlayer, 21191); -- Easter bunny right there. That happens to be my birthday :)
			
			_EffectInit();
			_EffectSetOrigin(vec1);
			_EffectSetStart(vec2);
			_EffectSetScale(10);
			_EffectSetMagnitude(5);
			_EffectDispatch("FadingLineTeam");
		else
			-- Stage 1
			eMeasures[iPlayer].FirstPos = iLocation;
			eMeasures[iPlayer].Stage = 1;
			eShowMessage(iPlayer, "Got point one for measure (" .. vecString(iLocation) .. ")");
			eShowMessage(iPlayer, "finished a measure.", ECS_LOG_LEVELONE);
		end
	end
	
	-- Copy / Replace
	function eCopyEnt(iPlayer, iEnt)
		if (eCopy[iPlayer] ~= nil) then -- We need to turn off the move, we already copied
			eMoveOff(iPlayer);
			_EntSetOwner(eCopy[iPlayer], 0);
			_phys.EnableMotion(eCopy[iPlayer], true);
			eCopy[iPlayer] = nil;
		else -- We need to copy	
			if (not(iEnt)) then return end
			
			local cClass = _EntGetType(iEnt);
			if (eNewClasses[iEnt]) then cClass = eNewClasses[iEnt] end
			eNewClasses[iEnt] = nil;
			
			local cPos = _EntGetPos(iEnt);
			local cAng = _EntGetAngAngle(iEnt);
			local cModel = _EntGetModel(iEnt);
			
			local iCopyEnt = _EntCreate(cClass);
			_EntPrecacheModel	(cModel);
			_EntSetKeyValue	(iCopyEnt, "model", cModel);
			_EntSetPos			(iCopyEnt, cPos);
			_EntSetAngAngle	(iCopyEnt, cAng);
			_EntSpawn			(iCopyEnt);
			
			_EntSetOwner(iCopyEnt, iEnt);
			_phys.EnableMotion(iCopyEnt, false);
			
			eCopy[iPlayer] = iCopyEnt;
		
			eMoveOn(iPlayer, iCopyEnt, {255,0,255,200});
			eShowMessage(iPlayer, "copied an entity (" .. cClass .. ").", ECS_LOG_LEVELTWO);
		end
	end
	function eReplace(iPlayer, iEnt)
		local cClass = _EntGetType(iEnt);
		local cOrigClass = cClass;
		if (eNewClasses[iEnt]) then cClass = eNewClasses[iEnt] end
		eNewClasses[iEnt] = nil;
		
		local cPos = _EntGetPos(iEnt);
		local cAng = _EntGetAngAngle(iEnt);
		local cModel = _EntGetModel(iEnt);
		
		local iCopyEnt = _EntCreate(cClass);
		_EntPrecacheModel	(cModel);
		_EntSetKeyValue	(iCopyEnt, "model", cModel);
		_EntSetPos			(iCopyEnt, cPos);
		_EntSetAngAngle	(iCopyEnt, cAng);
		_EntSpawn			(iCopyEnt);
		
		if (eSpawnFrozen[iPlayer] == 1) then
			_PhysEnableMotion(newProp, false); -- If we said we wanted it to be spawned frozen, we freeze it here
			dMsg("Frozen!")
		end
		
		_EntRemove(iEnt);
		
		eShowMessage(iPlayer, "Replaced entity " .. iEnt .. " (" .. cOrigClass .. ") with a clone (" .. cClass .. ").");
		eShowMessage(iPlayer, "replaced an entity (" .. cClass .. ").", ECS_LOG_LEVELTWO);
	end
	
	-- Commands
	function eStackCall(iPlayer, iArgs)		
		local iSettings = explode(" ", iArgs);
		local iEnts = eGetProps(iPlayer);
		eStack(iPlayer, iEnts, iSettings);
	end
	function eUndoCall(iPlayer, iArgs)
		eUndo(iPlayer);
	end
	function eSpawnFrozenCall(iPlayer, iArgs)
		eFreezeChange(iPlayer, iArgs);
	end
	function eFreezeCall(iPlayer, iArgs)
		local iEnts = eGetProps(iPlayer);
		eFreeze(iPlayer, iEnts);
	end
	function eUnFreezeCall(iPlayer, iArgs)
		local iEnts = eGetProps(iPlayer);
		eUnFreeze(iPlayer, iEnts);
	end
	function eSetRotCall(iPlayer, iArgs)
		local iSettings = explode(" ", iArgs);
		local iEnts = eGetProps(iPlayer);
		eSetRotation(iPlayer, iEnts, iSettings);
	end
	function eAddRotCall(iPlayer, iArgs)
		local iSettings = explode(" ", iArgs);
		local iEnts = eGetProps(iPlayer);
		eAddRotation(iPlayer, iEnts, iSettings);
	end
	function eTranslateCall(iPlayer, iArgs)
		local iSettings = explode(" ", iArgs);
		local iEnts = eGetProps(iPlayer);
		eTranslate(iPlayer, iEnts, iSettings);
	end
	function eSetPosCall(iPlayer, iArgs)
		local iSettings = explode(" ", iArgs);
		local iEnts = eGetProps(iPlayer);
		eSetPos(iPlayer, iEnts, iSettings);
	end
	function eMeasureCall(iPlayer, iArgs)
		local iPos = nil;
		iArgs = string.lower(iArgs)
		if (iArgs == "%here%") then
			iPos = _PlayerGetShootPos(iPlayer);
		else
			_TraceLine(_PlayerGetShootPos(iPlayer),_PlayerGetShootAng(iPlayer), 32768, iPlayer);
			iPos = _TraceEndPos();
		end
		eMeasure(iPlayer, iPos);
	end
	function eCopyCall(iPlayer, iArgs)
		local iEnt = ePlayerTraceEnt(iPlayer);
		if ((iEnt) or (eCopy[iPlayer] == true)) then eCopyEnt(iPlayer, iEnt) end
	end
	function eReplaceCall(iPlayer, iArgs)
		local iEnt = ePlayerTraceEnt(iPlayer);
		if (iEnt) then eReplace(iPlayer, iEnt) end
	end
	
	-- Add functions to function list
	-- eAddCommand(<command name>, <function to call>, <string seperate method>, <type>)
	eAddCommand("e_stack", 		eStackCall,		"Syntax: e_stack <number> <x offset> <y offset> <z offset> <angular y offset> <angular x offset> <angular z offset> <select copies[1 or 0]>\nStacks (an) object(s) n times with an x/y/z offset (or any combination of the three) and with an angle offset of Pitch/Yaw/Roll. Selects copies if you use 1 for the last parameter. You don't need to type all the parameteres if they don't precede a non-zero parameter.", ECS_ADMIN_EVERYONE);
	eAddCommand("e_undo", 			eUndoCall,			"Undoes the last stack", ECS_ADMIN_EVERYONE);
	eAddCommand("e_spawnfrozen", eSpawnFrozenCall,	"Syntax: e_spawnfrozen [on / off]\nWhen you stack, determines if stacked copies are frozen or not", ECS_ADMIN_EVERYONE);
	eAddCommand("e_freeze", 		eFreezeCall,		"Freezes entities", ECS_ADMIN_EVERYONE);
	eAddCommand("e_unfreeze", 	eUnFreezeCall,		"Unfreezes entities", ECS_ADMIN_EVERYONE);
	eAddCommand("e_setrot", 		eSetRotCall,		"Syntax: e_setrot <Pitch> <Yaw> <Roll>\nSets the rotation of an object.", ECS_ADMIN_EVERYONE);
	eAddCommand("e_rotate", 		eAddRotCall,		"Syntax: e_rotate <Pitch> <Yaw> <Roll>\nAdds to the rotation of an object.", ECS_ADMIN_EVERYONE);
	eAddCommand("e_translate", 	eTranslateCall, 	"Syntax: e_translate <x> <y> <z>\nMoves (slides) an object along the axes with the amounts you specify.", ECS_ADMIN_EVERYONE);
	eAddCommand("e_setpos", 		eSetPosCall, 		"Syntax: e_setpos <x> <y> <z>\nMoves (slides) an object to the coordinates you specify. If you leave out a coordinate or set it to %A, it will use the current coordinates on that axis.", ECS_ADMIN_EVERYONE);
	eAddCommand("e_measure", 		eMeasureCall, 	"A command used to measure the distance between two points.", ECS_ADMIN_EVERYONE);
	eAddCommand("e_copy", 			eCopyCall,			"Copies the entity you're looking at and makes it follow you.", ECS_ADMIN_EVERYONE);
	eAddCommand("e_replace", 		eReplaceCall,		"Takes the prop you are looking at and respawns it.", ECS_ADMIN_EVERYONE);
	
	eAddThink(eUndoThink, 0.5, true);
	
	-- HELP MEH
	local stackHelp = {};
	stackHelp.title = "Stacking and related"; 	-- The title of the page. The name of the menu entry as well as the title shown at the top of the page.
	stackHelp.next = "basic_stack2"; 	-- The page to go to when the user selects the "next" option. Use "none" if there is no next page.
	stackHelp.type = HELPTYPE_PAGE;
	local stackHelp1 = "e_stack <n> <x> <y> <z> <ay> <ax> <az> <s> $p Definitions:\n"
	local stackHelp2 = "     <n>: Number of copies to stack\n";
	local stackHelp3 = "     <x>: The amount of units on the x axis to offset each copy\n";
	local stackHelp4 = "     <y>: The amount of units on the y axis to offset each copy\n";
	local stackHelp5 = "     <z>: The amount of units on the z axis to offset each copy\n";
	local stackHelp6 = "     <ay>: The number of degrees on the y axis to rotate each copy\n";
	local stackHelp7 = "     <ax>: The number of degrees on the x axis to rotate each copy\n";
	local stackHelp8 = "     <az>: The number of degrees on the z axis to rotate each copy\n";
	local stackHelp9 = "     <s>: Use 1 if you want to select your copies, 0 otherwise\n";
	local stackHelp10 = " $p Tips: \n - Before you even start stacking, do e_setrot 0 0 0 (or just e_setrot). This will snap the prop to 0 degrees on all axis so you can easily stack it. \n - You can also use e_spawnfrozen [on / off] to change if the stacked props are frozen.\n";
	local stackHelp11 = " - If you make a mistake, you can always do e_undo. \n - If you are doing the same stack over and over again, you just do e_stack -1, which will repeat the last stack.";
	local stackHelp12 = " $p Description: \n e_stack is a useful command when making objects where a certain prop has to tiled. For example, in fortwars, instead of tediously making each individual wall, you can just make one wall, and then stack it to the full length of the wall.";
	local stackHelp13 = " $p Go the next page for a tutorial.";
	stackHelp.text = stackHelp1 .. stackHelp2 .. stackHelp3 .. stackHelp4 .. stackHelp5 .. stackHelp6 .. stackHelp7 .. stackHelp8 .. stackHelp9 .. stackHelp10 .. stackHelp11 .. stackHelp12 .. stackHelp13;
								-- The text that is shown whent he page is shown.
	eAddHelpPage("basic_stack1", stackHelp);
								-- Use this to add to the help menu.
								
	local stackHelp2 = {};
	stackHelp2.title = "Stacking Page 2"; 	-- The title of the page. The name of the menu entry as well as the title shown at the top of the page.
	stackHelp2.next = "basic_stack3"; 	-- The page to go to when the user selects the "next" option. Use "none" if there is no next page.
	stackHelp2.prev = "basic_stack1"; 	-- The page to go to when the user selects the "previous" option. Use "main" if there is no previous page, so that the user can return to the menu
								-- If you set these to "main", they will take you to the main page.
	stackHelp2.type = HELPTYPE_HIDDEN;
	local stack2Help1 = "Stacking Tutorial: \n Step 1: Axis \n Determine the axis you want to stack on using the e_showa command. Each line is pointing in the positive direction of that axis. The red line is the positive x axis, the green the positive y axis, and the blue the positive z axis, which is always up. \n For an example, lets say I want to make a wall of small crates, so I choose the red (x) axis.";
	local stack2Help2 = " $p $img path='e_commands/stackTut1' ratio='1.0' height='16' img$";
	
	stackHelp2.text = stack2Help1 .. stack2Help2;
								-- The text that is shown whent he page is shown.
	eAddHelpPage("basic_stack2", stackHelp2);
								-- Use this to add to the help menu.
								
	local stackHelp3 = {};
	stackHelp3.title = "Stacking Page 3"; 	-- The title of the page. The name of the menu entry as well as the title shown at the top of the page.
	stackHelp3.next = "basic_stack4"; 	-- The page to go to when the user selects the "next" option. Use "none" if there is no next page.
	stackHelp3.prev = "basic_stack2"; 	-- The page to go to when the user selects the "previous" option. Use "main" if there is no previous page, so that the user can return to the menu
								-- If you set these to "main", they will take you to the main page.
	stackHelp3.type = HELPTYPE_HIDDEN
	local stack3Help1 = " $p Step 2: Offset \n After you have decided what axis to stack on, you need to find the dimension of the prop that is the axis that you will be stacking. For example, if I am stacking on the x axis, I need to find the length of the prop from the far positive x to the far negative x. To do this, you can use the e_measure command. \n Continuing my example, I have determined that my crate measures about 40x40x40.";
	local stack3Help2 = " $p $img path='e_commands/stackTut2' ratio='1.0' height='16' img$";
	
	stackHelp3.text = stack3Help1 .. stack3Help2;
								-- The text that is shown whent he page is shown.
	eAddHelpPage("basic_stack3", stackHelp3);
								-- Use this to add to the help menu.								
								
	local stackHelp4 = {};
	stackHelp4.title = "Stacking Page 4"; 	-- The title of the page. The name of the menu entry as well as the title shown at the top of the page.
	stackHelp4.prev = "basic_stack3"; 	-- The page to go to when the user selects the "previous" option. Use "main" if there is no previous page, so that the user can return to the menu
								-- If you set these to "main", they will take you to the main page.
	stackHelp4.type = HELPTYPE_HIDDEN;
	local stack4Help1 = " $p Step 3: Finalize \n When you are done determining the axis / offsets, you are ready to do the final command. Make sure you e_setrot 0 0 0 the prop first, or it will be difficult to stack correctly. Then, enter the stack command using the data you gathered from the previous two steps. If successful, a message should appear telling you what it has stacked. \n Finishing my example, I know that I want a wall of 4 crates on the red axis and each crate measures 40 units on the x axis, so I would do e_stack 4 40. It's that simple.";
	local stack4Help2 = " $p $img path='e_commands/stackTut3' ratio='2.0' height='16' img$";
	
	stackHelp4.text = stack4Help1 .. stack4Help2;
	eAddHelpPage("basic_stack4", stackHelp4);
								-- Use this to add to the help menu.
								
	local rotateHelp = {};
	rotateHelp.title = "Rotation"; 			-- The title of the page. The name of the menu entry as well as the title shown at the top of the page.
	rotateHelp.type = HELPTYPE_PAGE;
	rotateHelp.text = "e_setrot <pitch> <yaw> <roll> \n e_rotate <pitch> <yaw> <roll> $p These two commands will rotate entities. However, e_setrot SETS the rotation, whereas e_rotate ADDS to the rotation.";
	eAddHelpPage("basic_rotate", rotateHelp);	-- Use this to add to the help menu.
	
	local translateHelp = {};
	translateHelp.title = "Translate"; 			-- The title of the page. The name of the menu entry as well as the title shown at the top of the page.
	translateHelp.type = HELPTYPE_PAGE;
	translateHelp.text = "e_translate <x> <y> <z> $p The e_translate command will move a prop x/y/z amount of units on the specified axis.";
	eAddHelpPage("basic_translate", translateHelp);	-- Use this to add to the help menu.
	
	local copyHelp = {};
	copyHelp.title = "Copying Entities";
	copyHelp.type = HELPTYPE_PAGE;
	copyHelp.text = "You can copy entities using the e_copy command. You can also set it up so that when you press and hold a key, it copies and moves the entity for you by doing the following in your console: \n alias +e_copy e_copy; alias -e_copy e_copy; bind <key> +e_copy;";
	eAddHelpPage("basic_copy", copyHelp);