	-- Mass Move Module
	-- -e_massmove_on, -e_massmove_off
	
	-- Module Name
	eLastLoadedModule = "Move 1.2 by Joudoki";
	
	-- Player Specific / Global  Variables
	eMassMove = {}; 
	-- Indexed by playerid.
	--[1] is the on/off.
	--[2] is the original position of the player.. 
	--[3] is the entity list.
	--[4] is the vector list.
	
	eMove = {};
	-- Indexed by playerid.
	--[1] is the on/off.
	--[2] is the original position of the player.. 
	--[3] is the entity.
	--[4] is the vector.
	
	local iMassMoveColor = {255,0,0,200};
	
	-- Functions	
	function eMassMoveOn(iPlayer)
		local iPlayerPos = _PlayerGetShootPos(iPlayer); 	-- Get the player position for offsets
		local iEnts = eGetSelections(iPlayer); 		-- Get the entities for the player
		local iVecs = {};							-- Create a vector table
		for i=1, table.getn(iEnts) do
			iVecs[i] = _EntGetPos(iEnts[i]);		-- Assign the entities position for each entity
		end
		
		local iEntry = {};		
		iEntry[1] = true;
		iEntry[2] = iPlayerPos;
		iEntry[3] = iEnts;
		iEntry[4] = iVecs;
		
		eMassMove[iPlayer] = iEntry;
		
		for i=1, table.getn (iEnts) do
			local iEnt = iEnts[i];
			
			_EntFire(iEnt, "color", string.format("%s%s+%s", iMassMoveColor[1], iMassMoveColor[2], iMassMoveColor[3]), 0);
			_EntSetKeyValue(iEnt, "rendermode", "1");
			_EntSetKeyValue(iEnt, "renderamt", tostring(iMassMoveColor[4]));
		end
		
		eShowMessage(iPlayer, "Massmove Mode On");
		eLogEvent(iPlayer, "turned on massmove", ECS_LOG_LEVELONE);
	end
	function eMassMoveOff(iPlayer)
		local iEntry = {};		
		iEntry[1] = false;
		iEntry[2] = nil;
		iEntry[3] = nil;
		iEntry[4] = nil;
		eMassMove[iPlayer] = iEntry;
		
		for i=1, table.getn (iEnts) do
			local iEnt = iEnts[i];
			
			_EntFire(iEnt, "color", "255+255+255", 0);
			_EntSetKeyValue(iEnt, "rendermode", "0");
			_EntSetKeyValue(iEnt, "renderamt", "255");
		end
		
		eShowMessage(iPlayer, "Massmove Mode Off");
		eLogEvent(iPlayer, "turned off massmove", ECS_LOG_LEVELONE);
	end
	function eMassMoveThink(iPlayer)
		local iEntry = eMassMove[iPlayer];
		if (iEntry == nil) then return end
		if (iEntry[1] == true) then
			local iPlayerPos = _PlayerGetShootPos(iPlayer);
			local iOffset = vecSub(iPlayerPos, iEntry[2]);
			local iEnts = iEntry[3];
			local iVecs = iEntry[4];
			for i=1, table.getn(iEnts) do
				local iPos = vecAdd(iVecs[i], iOffset);
				_EntSetPos(iEnts[i], iPos);
			end
		end
	end
	
	function eMoveOn(iPlayer, iEnt, iRender)
		local iPlayerPos = _PlayerGetShootPos(iPlayer); 	-- Get the player position for offsets
		local iPos = _EntGetPos(iEnt);
		
		_EntFire(iEnt, "color", string.format("%s+%s+%s", iRender[1], iRender[2], iRender[3]), 0);
		_EntSetKeyValue(iEnt, "rendermode", "1");
		_EntSetKeyValue(iEnt, "renderamt", tostring(iRender[4]));
		
		local iEntry = {};		
		iEntry[1] = true;
		iEntry[2] = iPlayerPos;
		iEntry[3] = iEnt;
		iEntry[4] = iPos;
		eMove[iPlayer] = iEntry;
		
		return true;
		
		--eShowMessage(iPlayer, "Moving Entity " .. iEnt);
	end
	function eMoveOff(iPlayer)
		local iEntry = eMove[iPlayer];
		local iEnt = iEntry[3];
	
		_EntFire(iEnt, "color", "255+255+255", 0);
		_EntSetKeyValue(iEnt, "rendermode", "0");
		_EntSetKeyValue(iEnt, "renderamt", "255");
		
		iEntry[1] = false;
		iEntry[2] = nil;
		iEntry[3] = nil;
		iEntry[4] = nil;
		eMove[iPlayer] = iEntry;
		
		return true;
		
		--eShowMessage(iPlayer, "Moving Entity " .. iEnt);
	end
	function eMoveThink(iPlayer, debug)
		if (debug) then dMsg("eMoveThink called for player" .. iPlayer) end
		local iEntry = eMove[iPlayer];
		if (iEntry == nil) then 
			if (debug) then dMsg("iEntry is nil!") end
			return;
		end
		if (iEntry[1] == true) then
			local iPlayerPos = _PlayerGetShootPos(iPlayer);
			local iOffset = vecSub(iPlayerPos, iEntry[2]);
			local iEnt = iEntry[3];
			local iPos = iEntry[4];
			
			local vPos = vecAdd(iPos, iOffset);
			_EntSetPos(iEnt, vPos);
		end
		if (debug) then dMsg("eMoveThink finished for player " .. iPlayer) end
	end
	
	-- Calls
	function eMassMoveOnCall(iPlayer, iArgs)
		eMassMoveOn(iPlayer);
	end
	function eMassMoveOffCall(iPlayer, iArgs)
		eMassMoveOff(iPlayer);
	end
	function eMoveOnCall(iPlayer, iArgs)
		local iEnt = ePlayerTraceEnt(iPlayer);
		if (iEnt) then 
			eMoveOn(iPlayer, iEnt, {"128", "255", "0", "200"});
			eLogEvent(iPlayer, "started moving entity number" .. iEnt, ECS_LOG_LEVELONE);
		end
	end
	function eMoveOffCall(iPlayer, iArgs)
		eMoveOff(iPlayer);
		eLogEvent(iPlayer, "turned off the mover.", ECS_LOG_LEVELONE);
	end
	
	-- Add functions to function list
	-- eAddCommand(<command name>, <function to call>)
	eAddCommand("e_mmove_on", 		eMassMoveOnCall, 		"Takes the entities you have selected and makes them move with you.", ECS_ADMIN_EVERYONE);
	eAddCommand("e_mmove_off", 	eMassMoveOffCall, 	"Makes your selected entities stop following you.", ECS_ADMIN_EVERYONE);
	
	eAddCommand("e_move_on", 		eMoveOnCall, 		"Makes an entity follow you.", ECS_ADMIN_EVERYONE);
	eAddCommand("e_move_off", 		eMoveOffCall, 		"Makes an entity stop following you.", ECS_ADMIN_EVERYONE);
	
	-- Add Player-Specific think functions
	-- eAddThink(<think function with arg iPlayer>)
	eAddThink(eMassMoveThink, 0.25, true);
	eAddThink(eMoveThink, 0.25, true);
	
	-- Misc
	local massMoveEntry = {};
	massMoveEntry.title = "Mass Move"; 			-- The title of the page. The name of the menu entry as well as the title shown at the top of the page.
	massMoveEntry.text = "Commands: \n e_mmove_on - Turns on massmove. \n e_mmove_off - Turns off massmove. $p Massmove is useful when you need to move a bunch of objects somewhere - you select all the entities you want to move, and then you turn on mass move and they will all follow you. Be sure to remember to turn it off when you're done.";
	eAddHelpPage("move_mmove", massMoveEntry);	-- Use this to add to the help menu.
	
	local moveEntry = {};
	moveEntry.title = "Mass Move"; 			-- The title of the page. The name of the menu entry as well as the title shown at the top of the page.
	moveEntry.text = "Commands: \n e_move_on - Makes the entity you are looking at follow you. \n e_move_off - Makes the entity you selected with e_move_on stop following you. $p Hint: Try doing the following in your console to make this easier: \n Step 1: alias +e_move e_move_on; alias -e_move e_move_off; \n Step 2: bind <key> +e_move $p Voila, you can now move a prop by holding a key.";
	eAddHelpPage("move_1move", moveEntry);	-- Use this to add to the help menu.