	-- Teleport Module
	-- -e_standon, -e_destandon, -e_telestart, -e_teleend, -e_teledelete
	
	-- Module Name
	eLastLoadedModule = "Teleport 2.0 by Joudoki";
	
	-- Global Tables
	eStandOn = {}; -- Used for the teleports
	eStandOff = {}; -- Used for the teleports
	eTeleEnts = {}; -- Should be 2d. Index is iTele, [0] says if it's ready or not. [1] says what the first sprite is. [2] says what the second sprite is.	

	-- Functions
	function eTeleStart(iPlayer, iTele)
		dMsg("Telestart called with params " .. iPlayer .. ", " .. iTele .. ".");
		
		local vPos = _PlayerGetShootPos(iPlayer);
		vPos.z = vPos.z - 24;
		
		local vSpriteName = ("tele" .. iTele .. "_start");
		
		dMsg("Creating TeleStart at " .. vPos.x .. ", " .. vPos.y .. ", " .. vPos.z .. ".");
		
		-- Create Sprite
		dMsg("Creating the end sprite (env_sprite)");
		local Sprite = _EntCreate("env_sprite");
		_EntSetPos(Sprite, vPos);
		_EntSetName(Sprite, vSpriteName);
		_EntSetKeyValue(Sprite, "spawnflags", "1");
		_EntSetKeyValue(Sprite, "model", "sprites/blueglow1.vmt");
		_EntSetKeyValue(Sprite, "scale", "1.0");
		_EntSetKeyValue(Sprite, "rendermode", "5");
		_EntSetKeyValue(Beam, "rendercolor", "255 128 64");
		_EntSpawn(Sprite);
		
		dMsg("Sprite Finished Spawning with ID " .. Sprite .. ", checking table add")
		
		if (eTeleEnts[iTele] ~= nil) then -- We already have at least one of the two ends
			dMsg("We already have one of the two ends. End 2 is " .. eTeleEnts[iTele][3]);
			dMsg("Teleport ID: " .. iTele .. " : [" .. Sprite .. "] [" .. eTeleEnts[iTele][3] .. "]")
			eTeleEnts[iTele] = {2, Sprite, eTeleEnts[iTele][3]};
			dMsg("Finished Seting");
			
			eShowMessage(iPlayer, "Teleporter completed at address " .. iTele .. " with entities " .. eTeleEnts[iTele][2] .. " and " .. eTeleEnts[iTele][3]);
		else
			dMsg("We don't have an end just yet, lets set a new index and set the first end")
			eTeleEnts[iTele] = {1, Sprite, nil}; -- Create an index to work with
			dMsg("Teleport ID: " .. iTele .. " : [" .. Sprite .. "] [ ? ]")
			dMsg("Finished Seting")
			eShowMessage(iPlayer, "Teleport id " .. iTele .. " created with start " .. Sprite);
			eLogEvent(iPlayer, "made a teleporter at address " .. iTele, ECS_LOG_LEVELTHREE);
		end
		dMsg("Done")
	end
	function eTeleEnd(iPlayer, iTele)
		dMsg("Teleend called with params " .. iPlayer .. ", " .. iTele .. ".");
		
		local vPos = _PlayerGetShootPos(iPlayer);
		vPos.z = vPos.z - 24;
		
		local vSpriteName = ("tele" .. iTele .. "_end");
		
		dMsg("Creating TeleEnd at " .. vPos.x .. ", " .. vPos.y .. ", " .. vPos.z .. ".");
		
		-- Create Sprite
		dMsg("Creating the end sprite (env_sprite)");
		local Sprite = _EntCreate("env_sprite");
		_EntSetPos(Sprite, vPos);
		_EntSetName(Sprite, vSpriteName);
		_EntSetKeyValue(Sprite, "spawnflags", "1");
		_EntSetKeyValue(Sprite, "model", "sprites/blueglow1.vmt");
		_EntSetKeyValue(Sprite, "scale", "1.0");
		_EntSetKeyValue(Sprite, "rendermode", "5");
		_EntSetKeyValue(Beam, "rendercolor", "255 128 128");
		_EntSpawn(Sprite);
		
		if (eTeleEnts[iTele] ~= nil) then -- We already have at least one of the two ends
			eTeleEnts[iTele] = {2, eTeleEnts[iTele][2], Sprite}; -- Create an index to work with
			dMsg("Teleport ID: " .. iTele .. " : [" .. eTeleEnts[iTele][2] .. "] [" .. Sprite .. "]");
			eShowMessage(iPlayer, "Teleporter completed at address " .. iTele .. " with entities " .. eTeleEnts[iTele][2] .. " and " .. eTeleEnts[iTele][3]);
			eLogEvent(iPlayer, "ended the teleporter at address " .. iTele, ECS_LOG_LEVELTHREE);
		else
			eTeleEnts[iTele] = {1, nil, Sprite}; -- Create an index to work with
			eShowMessage(iPlayer, "Teleport id " .. iTele .. " created with end " .. Sprite);
			dMsg("Teleport ID: " .. iTele .. " : [ ? ] [" .. Sprite .. "]");
		end
		dMsg("Done")
	end
	function eTeleDelete(iPlayer, iTele)
		if (eTeleEnts[iTele]) then
			_EntRemove(eTeleEnts[iTele][2]);
			_EntRemove(eTeleEnts[iTele][3]);
			
			eTeleEnts[iTele] = nil;
			
			eShowMessage(iPlayer, "Teleporter at address " .. iTele .. " Deleted")
			eLogEvent(iPlayer, "deleted the teleporter at address " .. iTele, ECS_LOG_LEVELTHREE);
		else
			eShowMessage(iPlayer, "No teleporter exists at address " .. iTele .. "!")
		end
	end
	function eTeleCheck()
		for k,v in eTeleEnts do -- Go through the table of tele id ents
			if (v[1] == 2) then -- Make sure that the teleporter associated with that id is ready
				iEnts = _EntitiesFindInSphere(_EntGetPos(v[2]), 64); -- Get entities for teleport
				for k = 1, table.getn(iEnts) do -- Go through that list of entities for teleport
					if (iEnts[k] ~= v[2] and iEnts[k] ~= v[3]) then -- Make sure it's not one of the sprites
						_EntSetPos(iEnts[k], _EntGetPos(v[3])); -- Teleport
					end
				end
			end
		end
	end
	
	function eCreateStandOn(iPlayer, iEnts, iSettings)
		if (iSettings[1] ~= nil and iSettings[1] ~= "" and iSettings[1] ~= " ") then
			-- We have an id
			if (eStandOn[iSettings[1]] or eStandOn[iSettings[2]]) then
				-- ID already taken
				eShowMessage(iPlayer, "That ID is already taken. Choose another one.", 0);
				return;
			end			
			eStandOn[iSettings[1]] = iEnts[1];
			eStandOff[iSettings[1]] = iEnts[2];
		else
			--Generate an id
			iSettings[1] = table.getn(eStandOn) + 1;
			eStandOn[iSettings[1]] = iEnts[1];
			eStandOff[iSettings[1]] = iEnts[2];
		end
		
		eStandOn[iSettings[1]] = iEnts[1];
		eStandOff[iSettings[1]] = iEnts[2];
		
		eColor(iEnts[1]);
		eColor(iEnts[2]);
		
		dMsg("iEnt " .. iEnts[1] .. " and " .. iEnts[2] .. " added to eStandOn/Off at index " .. iSettings[1]);
		eShowMessage(iPlayer, "Standon Teleport made with ents " .. iEnts[1] .. " and " .. iEnts[2] .. " at index " .. iSettings[1], 0);
		eLogEvent(iPlayer, "made a standing on teleport at address " .. iSettings[1], ECS_LOG_LEVELTHREE);
	end
	function eDestroyStandOn(iPlayer, iSettings)
		if (eStandOn[iSettings[1]]) then
			eUnColor(eStandOn[iSettings[1]]);
			eUnColor(eStandOff[iSettings[1]]);
		
			eStandOn[iSettings[1]] = nil;
			eStandOff[iSettings[1]] = nil;
			
			eShowMessage(iPlayer, "Standon teleportat address " .. iSettings[1] .. " removed!", 0);
			eLogEvent(iPlayer, "deleted the standing on teleport at address " .. iSettings[1], ECS_LOG_LEVELTHREE);
		else
			eShowMessage(iPlayer, "No standon teleport exists at address " .. iSettings[1], 0);
		end
	end	
	function eCheckStandingOn(iPlayer)
		for k,v in eStandOn do
			if ((_EntExists(eStandOn[k]) ~= true) or (_EntExists(eStandOff[k]) ~= true)) then eStandOn[k] = nil; eStandOff[k] = nil; end
			-- Thanks to blubber23 for spotting a stupid mistake right here
			if (_EntGetGroundEntity(iPlayer) == eStandOn[k]) then
				dMsg("Playerid " .. iPlayer .. " is standing on ent " .. eStandOn[k])
				_EntSetPos(iPlayer, (vecAdd(_EntGetPos(eStandOff[k]), vector3(0,0,32))));
			end
		end
	end
	
	-- Calls	
	function eTeleStartCall(iPlayer, iArgs)
		local iSettings = explode(" ", iArgs);
		eTeleStart(iPlayer, iSettings[1]);
	end	
	function eTeleEndCall(iPlayer, iArgs)
		local iSettings = explode(" ", iArgs);
		eTeleEnd(iPlayer, iSettings[1]);
	end	
	function eTeleDelCall(iPlayer, iArgs)
		local iSettings = explode(" ", iArgs);
		eTeleDelete(iPlayer, iSettings[1]);
	end
	function eStandOnCall(iPlayer, iArgs)
		local iSettings = explode(" ", iArgs);
		local iEnts = eGetProps(iPlayer);
		
		if ( table.getn(iSettings) > 2 ) then
			-- User inputted two ents
			iEnts[1] = iSettings[2];
			iEnts[2] = iSettings[3];
			eCreateStandOn(iPlayer, iEnts, iSettings)
		elseif (table.getn(iEnts) > 1) then
			-- Get user selection
			eCreateStandOn(iPlayer, iEnts, iSettings)
		else
			-- We don't have anything to make a standon teleport with
			return;
		end
	end
	function eDestroyStandOnCall(iPlayer, iArgs)
		local iSettings = explode(" ", iArgs);
		eDestroyStandOn(iPlayer, iSettings);
	end
	
	-- Add functions to function list
	-- eAddCommand(<command name>, <function to call>)
	eAddCommand("e_telestart", 	eTeleStartCall,		"Syntax: -e_telestart <teleid>\nCreates a teleport start at address <teleid>.", ECS_ADMIN_BASIC);
	eAddCommand("e_teleend", 		eTeleEndCall,			"Syntax: -e_teleend <teleid>\nSets the endpoint of the teleport at address <teleid>.", ECS_ADMIN_BASIC);
	eAddCommand("e_teledel", 		eTeleDelCall,			"Syntax: -e_teledelete <teleid>\nDeleted the teleporter at address <teleid>.", ECS_ADMIN_BASIC);	
	eAddCommand("e_standon", 		eStandOnCall,			"Syntax: -e_standon (address) (entid 1) (entid 2)\nMakes a stand-on teleport at address (address) with entid 1 and 2. You can also select 2 entities with -e_select, where the first one you select is the teleporter, and the second is the destination. If you don't specify an address, one will be generated.", ECS_ADMIN_EVERYONE);
	eAddCommand("e_destandon", 	eDestroyStandOnCall,	"Syntax: -e_destandon <address>", ECS_ADMIN_EVERYONE);
	
	-- Add Player-Specific think functions
	-- eAddThink(<think function with arg iPlayer>)
	eAddThink(eCheckStandingOn, 1.0, true);
	eAddThink(eTeleCheck, 0.75, false);
	
	local standonEntry = {};
	standonEntry.title = "Standing On Teleports";
	standonEntry.text = "Commands / Syntax: \n e_standon [id] and e_destandon <id> \n Standing on teleports are teleports where when a player stands on the entity that is used as a teleport, it will teleport him to the entity designated as a the end. Sawblades generally work very well for this. To create a standing on teleport, you first need to make sure you have deselected everything (e_deselectall). Then, use e_select on the entity to be the teleporter, and then e_select the entity to be the destination. The order matters. Then, do the e_standon [id] command, where id is a unique address that you can use (if you don't input one, it will be generated.) When you need to destroy a standon teleport, just delete on eof the ends or do e_destandon [id].";
	eAddHelpPage("tele_standon", standonEntry);
	
	local telenEntry = {};
	telenEntry.title = "Static Teleports";
	telenEntry.text = "Commands / Syntax: \n e_telestart [id], e_teleend [id], e_teledel [id] \n Static teleporters are similar to standon teleports, but instead of being something you stand on, they are something that you can just walk into. They can also teleport any and all entities. For a teleporter start and end to be linked, they must have the same id. To remove a teleporter, use the delete command on that same id.";
	eAddHelpPage("tele_static", telenEntry);