	-- Admin Module
	-- e_maxstack, e_adduser
	
	-- Module Name
	eLastLoadedModule = "Admin 2.0 by Joudoki";
	
	-- Player Specific / Global  Variables
	
	-- Functions	
	function eChangeMaxStack(iPlayer, iValue)
		ECS_MAX_STACK = iValue;
		eShowMessage(iPlayer, "ECS_MAX_STACK set to " .. iValue);
		eLogEvent(iPlayer, "changed the maximum stack number to " .. iValue, ECS_LOG_LEVELFOUR);
	end
	function ePlayerAddUser(iPlayer, iSettings)
		local iTargetName = eFindPlayer(iSettings[1]);
		if (iTargetName ~= false) then
			local iTargetID = _util.PlayerByName(iTargetName);
			local iAdded = eAddUser(_PlayerInfo(iTargetID, "networkid"), iSettings[2], iTargetName);
			if(iAdded) then
				eShowMessage(iPlayer, "Player \"" .. iTargetName .. "\" (" .. iTargetID .. "] has been added to the admins list with access " .. iSettings[2] .. ".");
				eShowMessage(iTargetID, "Player \"" .. _PlayerInfo(iPlayer, "name") .. "\" has added you to the ECS admin list with access ");
				return true;
			elseif(iAdded == false) then
				eShowMessage(iPlayer, "User " .. iTargetName .. " is already an admin.");
				return false;
			end
		end
		eShowMessage(iPlayer, "Couldn't find a player from the name \"" .. iSettings[1] .. "\" to add to the admins list.");
		eLogEvent(iPlayer, "tried to add a non-existant user from a partial name \"" .. iSettings[1] .. "\".", ECS_LOG_LEVELFOUR);
	end
	function eFindPlayer(iPartial)
		dMsg("Looking for player with partial name " .. iPartial)
		for i=1, _MaxPlayers() do
			if (_PlayerInfo(i, "connected")) then
				if (string.find(string.lower(_PlayerInfo(i, "name")), string.lower(iPartial))) then
					dMsg("Found player " .. _PlayerInfo(i, "name") .. " from partial name " .. iPartial);
					return _PlayerInfo(i, "name");
				end
			end
		end
		dMsg("Couldn't find a player from partial " .. iPartial);
		return false;
	end
	function eWho(iPlayer)
		for k,v in eAdmins do
			---if (_util.PlayerByUserId(eAdmins[i])) then
			--	_PrintMessageAll(HUD_PRINTCONSOLE, "Admin " .. i .. " : " .. eAdmins[i] .. " - ONLINE NOW (" .. _PlayerInfo(_util.PlayerByUserId(eAdmins[i]), "name") .. ")");
			--else
				_PrintMessageAll(HUD_PRINTCONSOLE, string.format("%s : %s (%s)", v[2], k, v[1]));
			--end
		end
		eShowMessage(iPlayer, "The current admins list has been printed to your console.");
	end
	function eEnableECS(iPlayer, iState)
		ECS_ENABLED = iState;
		local state = "disabled";
		if (iState == true) then state = "enabled" end
		eShowMessage(iPlayer, "ECS has been " .. state);
		eLogEvent(iPlayer, state .. " all of the ECS commands.", ECS_LOG_LEVELFOUR);
	end
	
	-- Calls
	function eMaxStackCall(iPlayer, iArgs)
		eChangeMaxStack(iPlayer, iArgs);
	end
	function eAddUserCall(iPlayer, iArgs)
		local iSettings = explode(" ", iArgs);
		ePlayerAddUser(iPlayer, iSettings);
	end	
	function eWhoCall(iPlayer, iArgs)
		eWho(iPlayer);
	end
	function eEnableCall(iPlayer, iArgs)
		eEnableECS(iPlayer, true);
	end
	function eDisableCall(iPlayer, iArgs)
		eEnableECS(iPlayer, false);
	end
	
	-- Add functions to function list
	-- eAddCommand(<command name>, <function to call>, <description>)
	eAddCommand("e_maxstack", eMaxStackCall, "Admin Only. Changes the maximum amount of props to be made in one stack.", ECS_ADMIN_ADMIN);
	eAddCommand("e_adduser", eAddUserCall, "Admin Only. Adds a user as an admin.", ECS_ADMIN_SUPER);
	eAddCommand("e_who", eWhoCall, "Displays the admin list.", ECS_ADMIN_EVERYONE);
	eAddCommand("e_enable", eEnableCall, "Enables the Entity Command Suite commands.", ECS_ADMIN_SUPER);
	eAddCommand("e_disable", eDisableCall, "Disables the Entity Command Suite commands.", ECS_ADMIN_SUPER);
	
	-- Add Player-Specific think functions
	-- eAddThink(<think function with arg iPlayer>)	
	
	-- Misc
	local adminEntry = {};
	adminEntry.title = "Admin-Only Commands";
	adminEntry.text = "Commands: \n e_maxstack - Changes the ECS_MAX_STACK variable. The max stack is the amount of props that can be made from one stack. \n e_adduser - Adds a user. Paste the full name. \n e_enable and e_disable - Enables or disables the Entity Command Suite commands.";
	eAddHelpPage("admin", adminEntry);