	-- Keepup Module
	-- -e_keepup, -e_unkeepup
	
	-- Module Name
	eLastLoadedModule = "Keepup 1.0";
	
	-- Player - specific variables
	eKeepUps = {}; -- Table of keepuprights and their associated entities
	
	function eAddKeepUp(iEnt, iPower)
		-- I don't think players need a keepupright
		dMsg("eAddKeepUp called with iEnt " .. iEnt .. " and iPower " .. iPower)
		if (IsPlayer(iEnt)) then return false end
	
		local vPos = _EntGetPos(iEnt);
		
		-- What to do with the original entity
	    _EntSetName(iEnt, tostring(iEnt));
	    
		-- What to do with the keepupright
		iKeepUp = _EntCreate("phys_keepupright")						-- Create the entity
		_EntSetKeyValue(iKeepUp, "targetname", tostring(iKeepUp) .. "_ku");	-- Set the name
		_EntSetKeyValue(iKeepUp, "attach1", tostring(iEnt));		-- Set the entity to keep upright
		_EntSetKeyValue(iKeepUp, "angularlimit", tostring(iPower));	-- Set the angular limit (how much power it has)
		
		_EntSetKeyValue(iKeepUp, "angles", "0 0 0");
		_EntSetPos(iKeepUp, vPos);
		
		_EntSpawn(iKeepUp);			-- Spawn the entity
	   _EntActivate(iKeepUp);		-- Activate it (turn it on)
		
		dMsg("Finished creating keepup ent " .. iKeepUp);
		return iKeepUp; -- Success!
	end
	
	-- Functions	
	function eKeepUp(iPlayer, iEnts, iSettings) -- -e_keepupright <power>
		dMsg("eKeepUp called by " .. iPlayer .. " with power " .. iSettings[1]);
		for i = 1, table.getn(iEnts) do
			dMsg("Performing keepupright on selection ent " .. i);
			local iEnt = iEnts[i];
			if(eKeepUps[iEnt]) then
				-- Return, we don't want to have one where we already have a keepup on it.
				dMsg("entity already has keepupright applied");
				eShowMessage(iPlayer, "Entity " .. iEnt .. " already has a keepup! Changing power to " .. iSettings[1]);
			else
				dMsg("Creating new keepupright");
				
				local kEnt = eAddKeepUp(iEnt, iSettings[1]);
				
				if (kEnt ~= false) then
					-- Success!
					dMsg("Done creating, setting ku into keepups table");
					eKeepUps[iEnt] = kEnt;
					dMsg("keepupright(" .. kEnt .. ") added to table at adress " .. iEnt);
					eShowMessage(iPlayer, "Keep upright (" .. kEnt .. ") applied to entity " .. iEnt .. " with power " .. iSettings[1]);
					eLogEvent(iPlayer, "added a keepupright to entity " .. iEnt .. " with power " .. iSettings[1], ECS_LOG_LEVELTWO);
				else
					-- Failure! :(
					dMsg("Unable to create keepupright for entity " .. iEnt);
				end
			end
		end

		dMsg("Apply Keepupright Finished");
	end
	function eRemoveKeepUp(iPlayer, iEnts) -- -e_removeku
		for i=1, table.getn(iEnts) do
			local iEnt = iEnts[i];
			if(eKeepUps[iEnt]) then
				dMsg("Entity " .. iEnt .. " has a keepup, deleting.")
				
				eShowMessage(iPlayer, "Keep upright (" .. iEnt .. ") on entity " .. eKeepUps[iEnt] .. " has been deleted.");
				eLogEvent(iPlayer, "removed the keepupright from " .. iEnt, ECS_LOG_LEVELTWO);
				
				_EntRemove(eKeepUps[iEnt]);
				eKeepUps[iEnt] = nil;
			else
				eShowMessage(iPlayer, "No keepup exists on entity " .. iEnt);
			end
		end
	end
	
	-- Calls
	function eKeepUpCall(iPlayer, iArgs)
		local iSettings = explode(" ", iArgs);
		local iEnts = eGetProps(iPlayer);
		eKeepUp(iPlayer, iEnts, iSettings);
	end
	function eUnKeepUpCall(iPlayer, iArgs)
		local iEnts = eGetProps(iPlayer);
		eRemoveKeepUp(iPlayer, iEnts);
	end
	
	-- Add functions to function list
	-- eAddCommand(<command name>, <function to call>)
	eAddCommand("e_addku", 		eKeepUpCall,		"Syntax: -e_keepup <power>\nCreates a phys_keepup entity on the entities specified with power <power>.", ECS_ADMIN_EVERYONE)
	eAddCommand("e_removeku", 	eUnKeepUpCall,		"Aim at an entity with a keepup on it, and then this will remove its keepup.", ECS_ADMIN_EVERYONE)
	
	-- Add Player-Specific think functions
	-- eAddThink(<think function with arg iPlayer>)
	
	
	-- Misc
	local kuHelp = {};
	kuHelp.title = "Keep Uprights";
	kuHelp.text = "Have you ever needed to ensure that an entity needs to stay upright? Well, you can use e_addku <power [ 1 - 360 ]> to create a phys_keepupright entity. The higher the power, the faster/harder the entity will work to keep that entity upright. You can also use e_removeku on a prop to remove a keepupright. (Sorry folks, but only keepuprights added by e_addku can be removed.)";
	eAddHelpPage("keepup", kuHelp);
	