	-- Misc Module
	-- -e_mass, -e_health, -e_static, e_nonstatic
	
	-- Module Name
	eLastLoadedModule = "Misc Commands 2.0 by Joudoki";	
	
	-- Functions	
	function eMass(iPlayer, iEnts, iMass)
		if (iMass < "1") then iMass = 1; end
		dMsg("eMass called with iMass " .. iMass)
		for k = 1, table.getn(iEnts) do
			local iEnt = iEnts[k];
			_phys.SetMass(iEnt, iMass);
		end
		eShowMessage(iPlayer, "Mass of " .. eGetNSelected(iPlayer) .. " set to " .. iMass .. ".");
		eLogEvent(iPlayer, "changed the mass of " .. eGetNSelected(iPlayer) .. " to " .. iMass, ECS_LOG_LEVELTWO);
	end
	function eHealth(iPlayer, iEnts, iHealth)
		dMsg("eHealth called with iHealth " .. iHealth)
		for k = 1, table.getn(iEnts) do
			local iEnt = iEnts[k];
			_EntSetMaxHealth(iEnt, iHealth);
		end
		dMsg("eHealth finished")
		eShowMessage(iPlayer, "Max Health of " .. eGetNSelected(iPlayer) .. " changed to " .. iHealth .. ".");
		eLogEvent(iPlayer, "changed the max health of " .. eGetNSelected(iPlayer) .. " to " .. iHealth, ECS_LOG_LEVELTWO);
	end	
	-- Make static
	function eMakeStatic(iPlayer, iEnts)
		dMsg("eMakeStatic Called");
		for k = 1, table.getn(iEnts) do
			local iEnt = iEnts[k];				
			dMsg("Got a prop " .. iEnt);			
			_EntSetMoveType(iEnt, MOVETYPE_NONE);			
		end
		eShowMessage(iPlayer, eGetNSelected(iPlayer) .. " have been made static.");
		eLogEvent(iPlayer, "made " .. eGetNSelected(iPlayer) .. " static.", ECS_LOG_LEVELTWO);
	end
	function eMakeNonStatic(iPlayer, iEnts)
		dMsg("eMakeStatic Called");
		for k = 1, table.getn(iEnts) do
			local iEnt = iEnts[k];				
			dMsg("Got a prop " .. iEnt);			
			_EntSetMoveType(iEnt, 6);				
		end
		eShowMessage(iPlayer, eGetNSelected(iPlayer) .. " have been made moveable.");
		eLogEvent(iPlayer, "made " .. eGetNSelected(iPlayer) .. " moveable.", ECS_LOG_LEVELTWO);
	end
	-- Kill
	function eKill(iPlayer, iEnts)
		dMsg("eKill Called");

		if (table.getn(iEnts) < 1) then
			eShowMessage(iPlayer, "No objects to kill");
			return;
		end
		
		for k = 1, table.getn(iEnts) do
			local iEnt = iEnts[k];
			
			if (not(iEnt) or iEnt == 0) then return false end
			
			if (_EntGetType() == "player") then 
				eShowMessage(iPlayer, "You can't delete players!");
			else
				_EffectInit();
					_EffectSetEnt( iPlayer );
					_EffectSetOrigin( _PlayerGetShootPos( iPlayer ) );
					_EffectSetStart( _EntGetPos( iEnt ) );
					_EffectSetScale( 5 );
					_EffectSetMagnitude( 3 );
				_EffectDispatch( "FadingLineTeam" );
				
				_EffectInit();
					_EffectSetOrigin( _EntGetPos( iEnt ) );
					_EffectSetScale( 0.5 );
					_EffectSetMagnitude( 2 );
					_EffectSetRadius( 1 );
				_EffectDispatch( "cball_explode" );
				
				_EntRemove(iEnt);
			end
		end
		eShowMessage(iPlayer, eGetNSelected(iPlayer) .. " have been killed");
		eLogEvent(iPlayer, "killed " .. eGetNSelected(iPlayer), ECS_LOG_LEVELTWO);
	end
	
	-- Calls
	function eHealthCall(iPlayer, iArgs)
		local iSettings = explode(" ", iArgs);
		local iEnts = eGetProps(iPlayer);
		eHealth(iPlayer, iEnts, iSettings[1]);
	end	
	function eMassCall(iPlayer, iArgs)
		local iSettings = explode(" ", iArgs);
		local iEnts = eGetProps(iPlayer);
		eMass(iPlayer, iEnts, iSettings[1]);
	end
	function eStaticCall(iPlayer, iArgs)
		local iEnts = eGetProps(iPlayer);
		eMakeStatic(iPlayer, iEnts);
	end
	function eNonStaticCall(iPlayer, iArgs)
		local iEnts = eGetProps(iPlayer);
		eMakeNonStatic(iPlayer, iEnts);
	end
	function eKillCall(iPlayer, iArgs)
		local iEnts = eGetProps(iPlayer);
		eKill(iPlayer, iEnts);
	end
	
	-- Add functions to function list
	-- eAddCommand(<command name>, <function to call>)
	eAddCommand("e_static", 	eStaticCall,		"Makes an object static.", ECS_ADMIN_EVERYONE);
	eAddCommand("e_nonstatic", eNonStaticCall,	"Makes an object non-static. (Opposite of -e_static)", ECS_ADMIN_EVERYONE);
	eAddCommand("e_health", 	eHealthCall,		"-e_health <health>\nSets the maximum health of an object.", ECS_ADMIN_EVERYONE);
	eAddCommand("e_mass", 		eMassCall,			"-e_mass <mass>\nSets the mass of an object.", ECS_ADMIN_EVERYONE);
	eAddCommand("e_kill", 		eKillCall,			"Kills all selected entities.", ECS_ADMIN_BASIC);
	
	-- Help
	local miscHelp = {};
	miscHelp.title = "Miscellaneous Commands"; 			-- The title of the page. The name of the menu entry as well as the title shown at the top of the page.
	miscHelp.type = HELPTYPE_PAGE;
	miscHelp.text = "Miscellaneous Commands: \n e_health <health> - Sets the health of an object \n e_mass <mass greater then 0> - Sets the mass of an entity \n e_static - Makes an entity static (unmovable) \n e_nonstatic - Makes an object moveable again \n e_kill - Kills (deletes) an entity";
	eAddHelpPage("misc", miscHelp);	-- Use this to add to the help menu.