	-- Select Module 2.0
	-- Select, Deselect, Deselectall, get selections, etc.
	-- I had to recode this because the old one was being gay
	
	-- Module Name
	eLastLoadedModule = "Select 2.3 by Joudoki";
	
	-- Player Specific / Global  Variables
	eEntities = {}; -- Player Selections table
	eShowSelect = {}; -- Does the player have the show-select system on?
	eBoxSelect = {}; -- Selects all ents in box
	
	-- Select Box Material
	eBoxSelectMat = "e_commands/selectbox";
	eBoxSelectTime = 5; -- Time to show the select box
	
	-- Global Functions
	function eCheckSelect(iPlayer, iEnt)
		local iEnts = eEntities[iPlayer];
		if (iEnts == nil) then 
			eEntities[iPlayer] = {};
			return nil; -- Nothing Selected, so no need to perform any kind of check
		end
		
		if (iEnt < 1) then return true end
		
		for i=1, table.getn(iEnts) do
			if (iEnts[i] == iEnt) then 
				eShowMessage(iPlayer, "Entity is Already Selected!");
				return true; -- Ent already selected
			end
		end
		
		return nil; -- If we haven't found one by now, we aren't going to; Return
	end
	function eGetProps(iPlayer)
		dMsg("eGetProps called")
		local iProps = eEntities[iPlayer];
		
		-- First, make sure that we have an iProps table to work with.
		if (iProps == nil) then 
			eEntities[iPlayer] = {};
			iProps = {};
			dMsg("Player's Selection Entry was nil")
		end
		
		if (table.getn(iProps) > 0) then
			-- If we do have ents to work with, then lets return those
			dMsg("Returning Player's Selections");
			return iProps;
		end
		
		if (ePlayerTraceEnt(iPlayer)) then
			-- We don't have any selections, so let's just trace one.
			local iEnt = ePlayerTraceEnt(iPlayer);
			if (IsPlayer(iEnt) == true) then return end
			dMsg("Returning Entity in Player's view");
			return {iEnt};
		end
		
		-- We have nothing to work with. Just return.
		dMsg("No selections to use :(");
		return nil;
	end
	function eGetSelections(iPlayer)
		return eEntities[iPlayer];
	end
	function eGetNSelected(iPlayer)
		dMsg("eGetNSelected for player " .. iPlayer)
		local iEnts = eGetSelections(iPlayer);
		local iCount = table.getn(iEnts);
		if (iCount == 1) then
			return "1 object";
		else
			return iCount .. " objects";
		end
	end
	
	function eColor(iEnt)
		_EntFire(iEnt, "color", "175+0+0", 0);
	end
	function eUnColor(iEnt)
		_EntFire(iEnt, "color", "255+255+255", 0);
	end
	
	function eSelect(iPlayer, iEnt)
		local iEnts = eEntities[iPlayer];
		if (iEnts == nil) then
			iEnts = {};
		end
		if (iEnt < 1) then return false end
		if (eCheckSelect(iPlayer, iEnt)) then 
			return false;
		end
		if (IsPlayer(iEnt) == true) then return end
		
		table.insert(iEnts, iEnt);
		eEntities[iPlayer] = iEnts;
		
		_EffectInit();
			_EffectSetEnt( iPlayer );
			_EffectSetOrigin( _PlayerGetShootPos( iPlayer ) );
			_EffectSetStart( _EntGetPos( iEnt ) );
			_EffectSetScale( 5 );
			_EffectSetMagnitude( 3 );
		_EffectDispatch( "FadingLineTeam" );
		
		eColor(iEnt);
	end
	function eSelectBox(iPlayer, iLocation)
			if (eBoxSelect[iPlayer] == nil) then
			eBoxSelect[iPlayer] = {};
		end
		
		if eBoxSelect[iPlayer].Stage == 1 then
			-- Done, get ents
			-- Ok, for whatever reason, util.entsinbox doesn't work, so I looked at RoboDonut's Barrier Script to see how he did it, and this is how he did it.
			-- I also snagged the box. keke.
			local vector1 = eBoxSelect[iPlayer].FirstPos;
			local vector2 = iLocation;
			local minVec  = vector3( math.min( vector1.x, vector2.x ), math.min( vector1.y, vector2.y ), math.min( vector1.z, vector2.z ) )
			local maxVec  = vector3( math.max( vector1.x, vector2.x ), math.max( vector1.y, vector2.y ), math.max( vector1.z, vector2.z ) )
			
			-- The two X-axis faces
			_GModQuad_Start( eBoxSelectMat )
			_GModQuad_SetVector( 0, vector3( minVec.x, minVec.y, minVec.z ) )
			_GModQuad_SetVector( 1, vector3( minVec.x, maxVec.y, minVec.z ) )
			_GModQuad_SetVector( 2, vector3( minVec.x, maxVec.y, maxVec.z ) )
			_GModQuad_SetVector( 3, vector3( minVec.x, minVec.y, maxVec.z ) )
			_GModQuad_SetTimings( 0, 0, eBoxSelectTime, 0 )
			_GModQuad_Send( 0, math.random(1, 4096) )
			
			_GModQuad_Start( eBoxSelectMat )
			_GModQuad_SetVector( 0, vector3( maxVec.x, minVec.y, minVec.z ) )
			_GModQuad_SetVector( 1, vector3( maxVec.x, maxVec.y, minVec.z ) )
			_GModQuad_SetVector( 2, vector3( maxVec.x, maxVec.y, maxVec.z ) )
			_GModQuad_SetVector( 3, vector3( maxVec.x, minVec.y, maxVec.z ) )
			_GModQuad_SetTimings( 0, 0, eBoxSelectTime, 0 )
			_GModQuad_Send( 0, math.random(1, 4096) )
			
			-- The two Y-axis faces 
			_GModQuad_Start( eBoxSelectMat )
			_GModQuad_SetVector( 0, vector3( minVec.x, minVec.y, minVec.z ) )
			_GModQuad_SetVector( 1, vector3( maxVec.x, minVec.y, minVec.z ) )
			_GModQuad_SetVector( 2, vector3( maxVec.x, minVec.y, maxVec.z ) )
			_GModQuad_SetVector( 3, vector3( minVec.x, minVec.y, maxVec.z ) )
			_GModQuad_SetTimings( 0, 0, eBoxSelectTime, 0 )
			_GModQuad_Send( 0, math.random(1, 4096) )
			
			_GModQuad_Start( eBoxSelectMat )
			_GModQuad_SetVector( 0, vector3( minVec.x, maxVec.y, minVec.z ) )
			_GModQuad_SetVector( 1, vector3( maxVec.x, maxVec.y, minVec.z ) )
			_GModQuad_SetVector( 2, vector3( maxVec.x, maxVec.y, maxVec.z ) )
			_GModQuad_SetVector( 3, vector3( minVec.x, maxVec.y, maxVec.z ) )
			_GModQuad_SetTimings( 0, 0, eBoxSelectTime, 0 )
			_GModQuad_Send( 0, math.random(1, 4096) )
			
			-- The two Z-axis faces 
			_GModQuad_Start( eBoxSelectMat )
			_GModQuad_SetVector( 0, vector3( minVec.x, minVec.y, minVec.z ) )
			_GModQuad_SetVector( 1, vector3( maxVec.x, minVec.y, minVec.z ) )
			_GModQuad_SetVector( 2, vector3( maxVec.x, maxVec.y, minVec.z ) )
			_GModQuad_SetVector( 3, vector3( minVec.x, maxVec.y, minVec.z ) )
			_GModQuad_SetTimings( 0, 0, eBoxSelectTime, 0 )
			_GModQuad_Send( 0, math.random(1, 4096) )
			
			_GModQuad_Start( eBoxSelectMat )
			_GModQuad_SetVector( 0, vector3( minVec.x, minVec.y, maxVec.z ) )
			_GModQuad_SetVector( 1, vector3( maxVec.x, minVec.y, maxVec.z ) )
			_GModQuad_SetVector( 2, vector3( maxVec.x, maxVec.y, maxVec.z ) )
			_GModQuad_SetVector( 3, vector3( minVec.x, maxVec.y, maxVec.z ) )
			_GModQuad_SetTimings( 0, 0, eBoxSelectTime, 0 )
			_GModQuad_Send( 0, math.random(1, 4096) )
		
			-- End RoboDonut's Barrier Script util.entsinbox fix (steal)
			-- Please don't shoot me
			
			eBoxSelect[iPlayer].Stage = 0;
			local iEnts = _util.EntsInBox( minVec, maxVec );
			--local iEnts = _util.EntsInBox( vector1, vector2 );
			eShowMessage(iPlayer, table.getn(iEnts) .. " object(s) in selectbox ([" .. vecString(eBoxSelect[iPlayer].FirstPos) .. "] and [" .. vecString(iLocation) .. "]) selected.");
			eLogEvent(iPlayer, "selected " .. table.getn(iEnts) .. " object(s) with a selectbox", ECS_LOG_LEVELTWO);
			
			for i=1, table.getn(iEnts) do
				if (iEnts[i] == iPlayer) then break end
				if (IsPlayer(iEnts[i]) == true) then break end
				eSelect(iPlayer, iEnts[i]);
			end
		else
			-- Get first pos and store it
			eShowMessage(iPlayer, "Got point one for selectbox (" .. vecString(iLocation) .. ")");
			eBoxSelect[iPlayer].Stage = 1;
			eBoxSelect[iPlayer].FirstPos = iLocation;
		end
	end
	function eDeselect(iPlayer, iEnt)
		local iEnts = eEntities[iPlayer];
		local bEntRemoved = false;
		
		for i=1, table.getn(iEnts) do
			if (iEnts[i] == iEnt) then
				table.remove(iEnts, i);
				eUnColor(iEnt);
				bEntRemoved = true;
			end
		end
		
		eEntities[iPlayer] = iEnts;
		return bEntRemoved;
	end
	function eDeselectAll(iPlayer)
		local iEnts = eEntities[iPlayer];
		local iNumEnts = table.getn(iEnts);
		
		for i=1, table.getn(iEnts) do
			eUnColor(iEnts[i]);
		end
		
		eEntities[iPlayer] = {};
		if (iNumEnts > 0) then
			eShowMessage(iPlayer, "Deselected " .. eGetNSelected(iPlayer));
			eLogEvent(iPlayer, "deselected all of his/her props.", ECS_LOG_LEVELONE);
		end
	end
	
	function eSelectThink(iPlayer)
		local iEnts = eEntities[iPlayer];
		
		if (iEnts == nil) then
			iEnts = {};
			eEntities[iPlayer] = {};
		end
		
		for i=1, table.getn(iEnts) do
			if (_EntExists(iEnts[i]) ~= true) then
				eDeselect(iPlayer, iEnts[i]);
			end
		end
	end
	
	-- Calls
	function eSelectCall(iPlayer, iArgs)
		if (ePlayerTraceEnt(iPlayer)) then
			-- We don't have any selections, so let's just trace one.
			local iEnt = ePlayerTraceEnt(iPlayer);
			if (eSelect(iPlayer, iEnt) ~= false) then
				eShowMessage ( iPlayer, "Selected entity " .. iEnt .. " (" .. _EntGetType(iEnt) .. ").");
				eLogEvent(iPlayer, "selected an entity.", ECS_LOG_LEVELTWO);
			end
		else
			eShowMessage(iPlayer, "No prop to select!", 0);
			return;
		end
	end
	function eSelectBoxCall(iPlayer, iArgs)
		local iPos = nil;
		iArgs = string.lower(iArgs)
		if (iArgs == "%here%") then
			iPos = _PlayerGetShootPos(iPlayer);
		else
			_TraceLine(_PlayerGetShootPos(iPlayer),_PlayerGetShootAng(iPlayer), 32768, iPlayer);
			iPos = _TraceEndPos();
		end
		eSelectBox(iPlayer, iPos);
	end
	function eDeselectCall(iPlayer, iArgs)
		if (ePlayerTraceEnt(iPlayer)) then
			-- We don't have any selections, so let's just trace one.
			local iEnt = ePlayerTraceEnt(iPlayer);
			eDeselect(iPlayer, iEnt);
			eShowMessage(iPlayer, "Deselected entity " .. iEnt .. " (" .. _EntGetType(iEnt) .. ").");
			eLogEvent(iPlayer, "deselected an entity.", ECS_LOG_LEVELTWO);
		else
			eShowMessage(iPlayer, "No prop to deselect!", 0);
			return;
		end
	end
	function eDeselectAllCall(iPlayer, iArgs)
		eDeselectAll(iPlayer);
	end
	
	-- SWEP Calls
	function eSelectGun_Select(iPlayer)
		if (ePlayerTraceEnt(iPlayer)) then
			local iEnt = ePlayerTraceEnt(iPlayer);
			if (eSelect(iPlayer, iEnt) ~= false) then
				eShowMessage ( iPlayer, "Selected entity " .. iEnt .. " (" .. _EntGetType(iEnt) .. ")." )
			end
		end
	end
	function eSelectGun_Deselect(iPlayer)
		if (ePlayerTraceEnt(iPlayer)) then
			local iEnt = ePlayerTraceEnt(iPlayer);
			if (eDeselect(iPlayer, iEnt) ~= false) then
				eShowMessage( iPlayer, "Deselected entity " .. iEnt .. " (" .. _EntGetType(iEnt) .. ").");
			end
		end
	end
	function eSelectGun_DeselectAll(iPlayer)
		eDeselectAll(iPlayer);
	end
	
	-- Add functions to function list
	-- eAddCommand(<command name>, <function to call>, <description>)
	eAddCommand("e_select", 		eSelectCall, 		"Selects the entity you're looking at.", 		ECS_ADMIN_EVERYONE);
	eAddCommand("e_selectbox", 	eSelectBoxCall, 	"Selects all the entities in a player-defined box.", ECS_ADMIN_EVERYONE);
	eAddCommand("e_deselect", 		eDeselectCall, 	"Deselects the entity you're looking at.", 	ECS_ADMIN_EVERYONE);
	eAddCommand("e_deselectall", 	eDeselectAllCall, "Deselects all of your entities", 				ECS_ADMIN_EVERYONE);
	eAddSwep("selectgun", "ecs_select", "e_commands/sweps/weapon_select.lua", ECS_ADMIN_EVERYONE, {"Joudoki", "Select Gun v1.0", "Select", "Deselect", "Deselect All"});
	
	-- Add Player-Specific think functions
	-- eAddThink(<think function with arg iPlayer>)
	eAddThink(eSelectThink, 0.5, true);
	
	-- Miscs
	function eDumpSelections()
		lMsg("Dumping Player Selections:");
		for i = 1, table.getn(eEntities) do
		lMsg("Player " .. i .. "'s selections:");
			local iEnts = eEntities[i];
			for k = 1, table.getn(iEnts) do
				lMsg("Selection " .. k .. ": " .. eEntities[i][k] .. " : " .. _EntGetType(eEntities[i][k]));
			end
		end
		lMsg("Finished dumping player selections.");
	end
	CONCOMMAND("e_dumpselect", eDumpSelections, "Dumps the selections of all players");
	
	-- Help
	local selectHelp = {};
	selectHelp.title = "Selectings"; 			-- The title of the page. The name of the menu entry as well as the title shown at the top of the page.
	selectHelp.type = HELPTYPE_PAGE;
	selectHelp.text = "Knowing how to use the selection system is essential to your use of Entity Command Suite; The following commands are used: $p e_select - Selects the entity you're looking at \n e_selectbox (%HERE%) - Selects all of the entities in a box between two points. Unless you say %HERE%, it will use the vertice of where you are pointing at. \n e_deselect - Selects the prop you're looking at. \n e_deselectall - Deselects all of your props.";
	eAddHelpPage("select", selectHelp);	-- Use this to add to the help menu.
	