	-- Show Module
	-- Showx, Showy, Showz, Showa, Showp
	
	-- Module Name
	eLastLoadedModule = "Show 2.0 by Joudoki";
	
	-- Functions	
	function eShowX(iPlayer, iTime)
		if (isEmpty(iTime)) then iTime = 5 end
		vStart = _PlayerGetShootPos(iPlayer);
		vStart.z = vStart.z - 40;
		
		xCorner1 = vector3(vStart.x + 4, vStart.y + 2, vStart.z);
		xCorner2 = vector3(vStart.x + 4, vStart.y - 2, vStart.z);
		xCorner3 = vector3(vStart.x + 64, vStart.y + 2, vStart.z);
		xCorner4 = vector3(vStart.x + 64, vStart.y - 2, vStart.z);
		
		_GModQuad_Start( "e_commands/showx" );
	
			_GModQuad_SetVector( 0, xCorner1 );
			_GModQuad_SetVector( 1, xCorner2 );
			_GModQuad_SetVector( 2, xCorner3 ); 
			_GModQuad_SetVector( 3, xCorner4 );
	
		_GModQuad_SetTimings( 1, 1.0, iTime, 1.0 );
	
		_GModQuad_Send( 0, math.random(0, 4096) );
		eLogEvent(iPlayer, "showed the x axis for " .. iTime .. " seconds.", ECS_LOG_LEVELONE);
	end
	function eShowY(iPlayer, iTime)
		if (isEmpty(iTime)) then iTime = 5 end
		vStart = _PlayerGetShootPos(iPlayer);
		vStart.z = vStart.z - 40;
		
		yCorner1 = vector3(vStart.x + 2, vStart.y + 4, vStart.z);
		yCorner2 = vector3(vStart.x - 2, vStart.y + 4, vStart.z);
		yCorner3 = vector3(vStart.x + 2, vStart.y + 64, vStart.z);
		yCorner4 = vector3(vStart.x - 2, vStart.y + 64, vStart.z);
		
		_GModQuad_Start( "e_commands/showy" );
	
			_GModQuad_SetVector( 0, yCorner1 );
			_GModQuad_SetVector( 1, yCorner2 );
			_GModQuad_SetVector( 2, yCorner3 ); 
			_GModQuad_SetVector( 3, yCorner4 );
	
		_GModQuad_SetTimings( 1, 1.0, iTime, 1.0 );
	
		_GModQuad_Send( 0, math.random(0, 4096) );
		eLogEvent(iPlayer, "showed the y axis for " .. iTime .. " seconds.", ECS_LOG_LEVELONE);
	end
	function eShowZ(iPlayer, iTime)
		if (isEmpty(iTime)) then iTime = 5 end
		vStart = _PlayerGetShootPos(iPlayer);
		vStart.z = vStart.z - 40;
		
		zCorner1 = vector3(vStart.x + 1, vStart.y - 1, vStart.z + 4);
		zCorner2 = vector3(vStart.x - 1, vStart.y + 1, vStart.z + 4);
		zCorner3 = vector3(vStart.x + 1, vStart.y - 1, vStart.z + 64);
		zCorner4 = vector3(vStart.x - 1, vStart.y + 1, vStart.z + 64);
		
		_GModQuad_Start( "e_commands/showz" );
	
			_GModQuad_SetVector( 0, zCorner1 );
			_GModQuad_SetVector( 1, zCorner2 );
			_GModQuad_SetVector( 2, zCorner3 ); 
			_GModQuad_SetVector( 3, zCorner4 );
	
		_GModQuad_SetTimings( 1, 1.0, iTime, 1.0 );
	
		_GModQuad_Send( 0, math.random(0, 4096) );
		eLogEvent(iPlayer, "showed the z axis for " .. iTime .. " seconds.", ECS_LOG_LEVELONE);
	end
	
	function eShowP(iPlayer, iRadius, iTime)	
		if (isEmpty(iTime)) then iTime = 5 end
		vStart = _PlayerGetShootPos(iPlayer);
		vStart.z = vStart.z - 40;
		
		dMsg("Protractor called. iRadius is " .. iRadius);
		iRadius = tonumber(iRadius);
		
		pCorner1 = vector3(vStart.x + iRadius, vStart.y + iRadius, vStart.z);
		pCorner2 = vector3(vStart.x + iRadius, vStart.y - iRadius, vStart.z);
		pCorner3 = vector3(vStart.x - iRadius, vStart.y - iRadius, vStart.z);
		pCorner4 = vector3(vStart.x - iRadius, vStart.y + iRadius, vStart.z);
		
		_GModQuad_Start( "e_commands/protractor" );
	
			_GModQuad_SetVector( 0, pCorner1 );
			_GModQuad_SetVector( 1, pCorner2 );
			_GModQuad_SetVector( 2, pCorner3 ); 
			_GModQuad_SetVector( 3, pCorner4 );
	
		_GModQuad_SetTimings( 1, 1.0, iTime, 1.0 );
	
		_GModQuad_Send( 0, math.random(0, 4096) );
		eLogEvent(iPlayer, "showed the protractor for " .. iTime .. " seconds with radius " .. iRadius, ECS_LOG_LEVELONE);
		
		dMsg("Done showing protractor")
	end
	
	-- Calls
	function eShowXCall(iPlayer, iArgs)
		eShowX(iPlayer, iArgs);
	end
	function eShowYCall(iPlayer, iArgs)
		eShowY(iPlayer, iArgs);
	end
	function eShowZCall(iPlayer, iArgs)
		eShowZ(iPlayer, iArgs);
	end
	function eShowACall(iPlayer, iArgs)
		eShowX(iPlayer);
		eShowY(iPlayer);
		eShowZ(iPlayer);
	end
	function eShowPCall(iPlayer, iArgs)
		local iSettings = explode(" ", iArgs);
		eShowP(iPlayer, iSettings[1], iSettings[2]);
	end
	
	-- Add functions to function list
	-- eAddCommand(<command name>, <function to call>, <string seperate method>, <type>)
	eAddCommand("e_showx", 		eShowXCall,			"Shows the positive X Axis", ECS_ADMIN_EVERYONE);
	eAddCommand("e_showy", 		eShowYCall,			"Shows the positive Y Axis", ECS_ADMIN_EVERYONE);
	eAddCommand("e_showz", 		eShowZCall,			"Shows the positive Z Axis", ECS_ADMIN_EVERYONE);
	eAddCommand("e_showa", 		eShowACall,			"Shows the positive X,Y,Z Axis", ECS_ADMIN_EVERYONE);
	eAddCommand("e_showp", 		eShowPCall,			"Shows the protractor", ECS_ADMIN_EVERYONE);
	
	-- Add Player-Specific think functions
	
	-- Misc
	
	-- Help
	local showAHelp = {};
	showAHelp.title = "Axis Help"; 			-- The title of the page. The name of the menu entry as well as the title shown at the top of the page.
	showAHelp.type = HELPTYPE_PAGE;
	showAHelp.text = "When working with Entity Command Suite, it will at times be necessary to determine an axis to use. For this purpose, you can use any of the following commands: $p e_showa <time in seconds> - Shows all 3 axis \n e_showx <time in seconds> - Shows the positive x axis \n e_showy <time in seconds> - Shows the positive y axis \n e_showz <time in seconds> - Shows the positive z axis (always up). You can also use e_showp <r> <t>, which shows a protractor with radius r and time t (in seconds).";
	eAddHelpPage("showa", showAHelp);	-- Use this to add to the help menu.