	-- Entity Command Suite
	-- weapon_entmover
	-- 2/1/2006

	_OpenScript( "includes/vector3.lua" );
	_OpenScript( "e_commands/e_common.lua" );

	MyIndex			=	0; -- Weapon's entity index.
	Owner			= 	0; -- The player that owns this weapon
	CurrentTime		=	0; -- The current game time
	
	local emEnt = {0, 0, vector3(0,0,0)}; -- Ent, Distance, hitpoint
	
	local explodeSounds = {};
	explodeSounds[0] = "weapons/explode3a.wav";
	explodeSounds[1] = "weapons/explode3b.wav";
	explodeSounds[2] = "weapons/explode3c.wav";
	explodeSounds[3] = "weapons/explode3d.wav";

	function onInit( )
		_SWEPSetSound(MyIndex, "single_shot", "Weapon_PhysCannon.OpenClaws")
		dMsg(("Entmover ID: " .. MyIndex) .. ", Player ID ".._EntGetParent(MyIndex).."\n"); -- For debugging
	end
	
	function checkVecEqual(v1, v2)
		if (v1.x == v2.x and v1.y == v2.y and v1.z == v2.z) then return true end
		return false;
	end

	function onThink( )
		if (_PlayerIsKeyDown(Owner, IN_ATTACK)) then
			--dMsg("emEnt is " .. emEnt[0] .. " at dist " .. emEnt[1])
			if (emEnt[0] ~= nil) then
				_TraceSetMask(MASK_PLAYERSOLID);
				_TraceLine(_PlayerGetShootPos(Owner),_PlayerGetShootAng(Owner), emEnt[1], emEnt[0]);
				
				_EntSetPos(emEnt[0], vecAdd(_TraceEndPos(), emEnt[2]));
			end
		else
			unGrabEnt();
		end
	end
	
	function grabEnt(iEnt, iOffset, iEndVec)
		emEnt[0] = iEnt;
		emEnt[1] = vecLength(vecSub(_PlayerGetShootPos(Owner), iEndVec));
		emEnt[2] = iOffset;
		eShowMessage ( Owner, "Grabbed entity " .. iEnt .. " (" .. _EntGetType(iEnt) .. ")." )
	end
	function unGrabEnt()
		emEnt[0] = nil;
		emEnt[1] = nil;
		emEnt[2] = nil;
	end

	function onPrimaryAttack( )
		dMsg("Primary Fire Called");
		
		_TraceLine(_PlayerGetShootPos(Owner),_PlayerGetShootAng(Owner), 32768, Owner);
		if _TraceHitNonWorld() then
			local iEnt = _TraceGetEnt(); -- If we hit an entity, lets grab that
			dMsg("Grabbing ent " .. iEnt);
			local iHitPos = _TraceEndPos();
			local iEntPos = _EntGetPos(iEnt);
			local iOffset = vecSub(iEntPos, iHitPos);
			grabEnt(iEnt, iOffset, iHitPos);
			dMsg("Offset is " .. vecString(iOffset));
		else
			local iPos = _TraceEndPos(); -- Otherwise, lets get the position
			dMsg("Couldn't find ent, hit position " .. vecString(iPos));
			local iEnts = _EntitiesFindInSphere(iPos, 128);
			
			local iEnt = nil;
			local iEntDist = 128;
			
			-- Lets get the closest entities.
			for i=1, table.getn(iEnts) do
				if (iEnts[i] == Owner) then break end
				local iEntPos = _EntGetPos(iEnts[i]);
				local iDistance = vecLength(vecSub(iPos, iEntPos));
				if (iDistance < iEntDist) then
					iEnt = iEnts[i];
					iEntDist = iDistance;
				end
			end
			
			local iEntPos = _EntGetPos(iEnt);
			local iOffset = vecSub(iEntPos, iPos);
			
			grabEnt(iEnt, iOffset, iPos);			
		end
		
		dMsg("Primary Fire Call End");
	end
	function onSecondaryAttack( )
		dMsg("Secondary Fire Called");
		
		if (emEnt[0] ~= nil) then -- If we have an ent in our grasp, lets just kill it instead.
			_EffectInit();
				_EffectSetEnt( Owner );
				_EffectSetOrigin( _PlayerGetShootPos( Owner ) );
				_EffectSetStart( _EntGetPos(emEnt[0]) );
				_EffectSetScale( 15 );
				_EffectSetMagnitude( 3 );
			_EffectDispatch( "FadingLineTeam" );
				
			_RunString("eCheckProtected(" .. emEnt[0] .. ", " .. MyIndex .. ")");
			return true
		end
		
		dMsg("Tracing Line")		
		_TraceLine(_PlayerGetShootPos(Owner),_PlayerGetShootAng(Owner), 32768, Owner);
		if _TraceHitNonWorld() then
		
			local iEnt = _TraceGetEnt(); -- If we hit an entity, lets grab that
			dMsg("Hit non-world entitity " .. iEnt)
			
			dMsg("Checking if entity is protected")
			
			_EffectInit();
				_EffectSetEnt( Owner );
				_EffectSetOrigin( _PlayerGetShootPos( Owner ) );
				_EffectSetStart( _TraceEndPos( ) );
				_EffectSetScale( 15 );
				_EffectSetMagnitude( 3 );
			_EffectDispatch( "FadingLineTeam" );
				
			_RunString("eCheckProtected(" .. iEnt .. ", " .. MyIndex .. ")");
			
		else
		
			_EffectInit();
				_EffectSetEnt( Owner );
				_EffectSetOrigin( _PlayerGetShootPos( Owner ) );
				_EffectSetStart( _TraceEndPos( ) );
				_EffectSetScale( 15 );
				_EffectSetMagnitude( 3 );
			_EffectDispatch( "FadingLineTeam" );
		
		end
		
		dMsg("Secondary Fire Call End");
	end		
	
	function blowEntity(iEnt)		
		_EffectInit();
			_EffectSetOrigin( _EntGetPos( iEnt ) );
			_EffectSetScale( 0.5 );
			_EffectSetMagnitude( 0.5 );
		_EffectDispatch( "Explosion" );
		_EntRemove(iEnt);
	end
	
	-- abcdefghijklmnopqrstuvwxyz
	-- zyxwvutsrqponmlkjihgfedcba

	function onReload( )
		return false;
	end
	function Holster()
	end
	function onDrop( )
		dMsg("Entmover ID: " .. MyIndex .. " removed.")
		_EntRemove(MyIndex);
	end
	
	function getWeaponSwapHands() 			return false;							end
	function getWeaponFOV() 				return 70; 								end
	function getWeaponSlot()				return 5; 								end
	function getWeaponSlotPos() 			return 2; 								end
	function getFiresUnderwater()			return true; 							end
	function getReloadsSingly() 			return false; 							end
	-- Primary Attack
	function getDamage() 					return 0; 								end
	function getPrimaryShotDelay() 			return 0.2; 							end
	function getPrimaryIsAutomatic() 		return false; 							end
	function getBulletSpread() 				return vector3( 0.01, 0.01, 0.01 ); 	end
	function getViewKick() 					return vector3( 0.0, 0.0, 0.0); 		end
	function getViewKickRandom() 			return vector3( 0, 0, 0 ); 				end
	function getNumShotsPrimary()			return 1;								end
	function getPrimaryAmmoType()			return "none";							end
	-- Secondary attack
	function getDamageSecondary() 			return 0;								end
	function getSecondaryShotDelay()		return 0.2;								end
	function getSecondaryIsAutomatic() 		return false; 							end
	function getBulletSpreadSecondary() 	return vector3( 0.0, 0.0, 0.0 ); 		end
	function getViewKickSecondary() 		return vector3( 0.0, 0.0, 0.0); 		end
	function getViewKickRandomSecondary() 	return vector3( 0, 0, 0 );				end
	function getNumShotsSecondary() 		return 1;								end
	function getSecondaryAmmoType() 		return "none";							end
	-- General
	function getViewModel() 				return "models/weapons/v_crossbow.mdl"; end
	function getWorldModel()				return "models/weapons/w_crossbow.mdl"; end
	function getClassName() 				return "ecs_entmover";					end
	function getHUDMaterial()				return "e_commands/swep_entmover";		end
	function getMaxClipPrimary()			return 1;								end
	function getMaxClipSecondary()			return 1;								end
	function getDefClipPrimary()			return 1;								end
	function getDefClipSecondary()			return 1;								end
	function getAnimPrefix() 				return "crossbow";						end
	function getPrintName()					return "Entmover";						end
	function getPrimaryScriptOverride()		return 2;								end
	function getSecondaryScriptOverride()	return 2;								end