--[[
UBowl v1.0
by Brett "Megiddo" Smith
Part of the Spirit of UGM collection.

This script spawns a lane of bowling pins.

Requirements:
This script requires ULib version 1 or higher. You can download ULib from ulyssesmod.net

Usage:
Use the command "makelane" to create a bowling lane, use "cleanlanes" to clean up previous lanes.

Changelog: 
v1.0 *(09/12/06)*
	* Initial version.
]]

assert( _file.Exists( "lua/ULib/init.lua" ), "UBowl needs ULib to run!" )
_OpenScript( "ULib/init.lua" )
assert( ULib.ULIB_VERSION >= 1, "UBowl requires ULib version 1 or higher to run!" )

local pin = "models/mixerman3d/bowling/bowling_pin.mdl"
local ball = "models/mixerman3d/bowling/bowling_ball.mdl"
local spacing = 25
local rows = 4 -- Standard pin setup has 4 rows

local ents = {}

local function cc_makeLane( userid )
	ents[ userid ] = ents[ userid ] or {}
	PlayerLookTrace( userid, 4096 )
	if not _TraceHit() then
		ULib.tsay( userid, "Please look at where you want to spawn the lane!" )
		return
	end

	local start = _TraceEndPos()

	local back = _EntGetForwardVector( userid )
	local right = _EntGetRightVector( userid )

	back.z = 0 -- We don't care about the third dimension
	right.z = 0

	local ang = vector3( 0, 90, 0 ) -- Used for angles

	for y=1, rows do
		local odd = (math.mod( y, 2 ) ~= 0)
		offy = vecMul( back, spacing * (y-1) )

		for x=1, y do
			local offx
			if x == 1 and odd then -- We just go straight back
				offx = vector3( 0, 0, 0 )
				--ULib.print( "easy way out" )
				--ULib.print( "x =", x, "y =", y, "offx =", offx, "offy =", offy )
			else
				local direction = math.mod( x, 2 ) * 2 - 1 -- Go right on odd numbers, left on even, timesing by two makes it 1 or -1
				local offnum
				if not odd then -- We need to add one to account for the middle pin
					offnum = x + 1 - math.mod( x + 1, 2 ) -- This rounds down to the nearest multiple of 2
				else
					offnum = x - math.mod( x, 2 ) -- This rounds down to the nearest multiple of 2
				end
				offnum = offnum / 2 -- And this gives us the number we want
				if not odd then offnum = offnum - 0.5 end -- For those odd rows!

				offx = vecMul( right, spacing * offnum * direction )
				--ULib.print( "x =", x, "y =", y, "offx =", offx, "offy =", offy )
				--ULib.print( "odd =", odd, "direction =", direction, "offnum =", offnum )
			end

			local pos = vecAdd( start, vecAdd( offx, offy ) )
			table.insert( ents[ userid ], ULib.makeProp( pin, pos, ang ) )
			--ULib.print( pos, "\n\n\n" )
		end
	end
end
ULib.CONCOMMAND( "makelane", cc_makeLane )

local function cc_cleanLanes( userid )
	if not ents[ userid ] then return end -- Nothing to do
	for _, entid in ipairs( ents[ userid ] ) do
		if _EntExists( entid ) and (_EntGetModel( entid ) == pin or _EntGetModel( entid ) == ball) then -- No exploiting here!
			_EntRemove( entid )
		end
	end
end
ULib.CONCOMMAND( "cleanlanes", cc_cleanLanes )