RoleplayData.MenuIndex = 1337
RoleplayData.MenuIndex2 = 1338
RoleplayData.MenuIndex3 = 1339
RoleplayData.MenuIndex4 = 1340

function RoleplayData.isAdmin(userid)
	for k,v in RoleplayData.Admins do
		local Steamid = _PlayerInfo(userid, "networkid")
		if Steamid == v then
		return true
		end
	end
	return false
end
function RoleplayData.AdminUnlock(userid,entid)
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 1000, userid)
	if RoleplayData.isAdmin(userid) then
			local Ent = _TraceGetEnt()
			local Type = _EntGetType(Ent)
			if string.find(Type, "door") then
				_EntFire(Ent, "unlock", "",0)
				return "";
			end
	else
		_PrintMessage(userid, 3, "Access Denied.")
		_PrintMessage(userid, 1, "Access Denied.")
	end
end
CONCOMMAND("rp_unlock", RoleplayData.AdminUnlock)

function RoleplayData.AdminLock(userid,entid)
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 1000, userid)
	if RoleplayData.isAdmin(userid) then
			local Ent = _TraceGetEnt()
			local Type = _EntGetType(Ent)
			if string.find(Type, "door") or string.find(Type, "vehicle") then
				_EntFire(Ent, "lock", "",0)
				return "";
			end
	else
		_PrintMessage(userid, 3, "Access Denied.")
		_PrintMessage(userid, 1, "Access Denied.")
	end
end
CONCOMMAND("rp_lock", RoleplayData.AdminLock)

function RoleplayData.ShowAdminMenu(userid)
	if RoleplayData.isAdmin(userid) then
		_GModRect_Start("gmod/white")
		_GModRect_SetPos(0, 0.3, 0.2, 0.24)
		_GModRect_SetColor(0, 0, 0, 100)
		_GModRect_SetTime(9999, 0.5, 0.5)
		_GModRect_Send(userid, RoleplayData.MenuIndex)

		_GModText_Start("Default")
		_GModText_SetPos(0, 0.32)
		_GModText_SetTime(99999, 1, 0.5)
		_GModText_SetText("(!) = Aiming At\n\n1. Silent Kill (!)\n2. Noclip\n3. Unown Door/Vehicle (!)\n4. Unlock\n5. Lock\n6. Next Page\n\n\n0. Close")
	 	_GModText_SetColor(255, 255, 255, 255)
		_GModText_Send(userid, RoleplayData.MenuIndex2)

		_PlayerOption(userid, "AdminMenuChoose", 99999)
	end
end
function AdminMenuChoose(playerid, num, seconds)
	_GModText_Hide(playerid, RoleplayData.MenuIndex2, 0.5, 0)
	
	_GModRect_Hide(playerid, RoleplayData.MenuIndex, 0.5, 0)

	if (num == 1) then 
		RoleplayData.AdminSilentKill(playerid)
	end

	if (num == 2) then
		RoleplayData.AdminNoclip(playerid)
	end

	if (num == 3) then
		RoleplayData.AdminUnownDoor(playerid)
	end

	if (num == 4) then
		RoleplayData.AdminUnlock(playerid)
	end

	if (num == 5) then
		RoleplayData.AdminLock(playerid)
	end
	if (num == 6) then
		RoleplayData.ShowAdminMenu2(playerid)
	end

end
function RoleplayData.ShowAdminMenu2(userid)
	if RoleplayData.isAdmin(userid) then
		_GModRect_Start("gmod/white")
		_GModRect_SetPos(0, 0.3, 0.2, 0.24)
		_GModRect_SetColor(0, 0, 0, 100)
		_GModRect_SetTime(9999, 0.5, 0.5)
		_GModRect_Send(userid, RoleplayData.MenuIndex3)

		_GModText_Start("Default")
		_GModText_SetPos(0, 0.32)
		_GModText_SetTime(99999, 1, 0.5)
		_GModText_SetText("(!) = Aiming At\n\n1. Kick (!)\n2. Ban - 5 Minutes (!)\n3. Ban - 30 Minutes (!)\n4. Ban - 2 Hours (!)\n5. Ban - Permanently(!)\n6. Previous Page\n\n\n0. Close")
	 	_GModText_SetColor(255, 255, 255, 255)
		_GModText_Send(userid, RoleplayData.MenuIndex4)

		_PlayerOption(userid, "AdminMenuChoose2", 99999)
	end
end
function AdminMenuChoose2(playerid, num, seconds)
	_GModText_Hide(playerid, RoleplayData.MenuIndex4, 0.5, 0)
	
	_GModRect_Hide(playerid, RoleplayData.MenuIndex3, 0.5, 0)

	if (num == 1) then 
		RoleplayData.AdminKick(playerid)
	end

	if (num == 2) then
		RoleplayData.AdminBan(playerid,5)
	end

	if (num == 3) then
		RoleplayData.AdminBan(playerid,30)
	end

	if (num == 4) then
		RoleplayData.AdminBan(playerid,120)
	end

	if (num == 5) then
		RoleplayData.AdminBan(playerid,0)
	end

	if (num == 6) then
		RoleplayData.ShowAdminMenu(playerid)
	end

end
function RoleplayData.AdminSilentKill(userid)
	if RoleplayData.isAdmin(userid) then
		_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 1000, userid)
		local Ent = _TraceGetEnt()
		local Type = _EntGetType(Ent)
			if Type == "player" then
				_PlayerSilentKill(Ent, 1, true)
			end
	end
end
function RoleplayData.AdminNoclip(userid)
	if RoleplayData.isAdmin(userid) then
		if not RoleplayData[userid].IsNoclip then
		_EntSetMoveType(userid, 8)
		RoleplayData[userid].IsNoclip = true
		elseif RoleplayData[userid].IsNoclip then
		_EntSetMoveType(userid, 2)
		RoleplayData[userid].IsNoclip = false
		else
		_Msg("Error!: RoleplayData[" .. userid .. "].IsNoclip is INVALID")
		end
	end
end
function RoleplayData.AdminUnownDoor(userid)
	if RoleplayData.isAdmin(userid) then
		_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 1000, userid)
	
		if _TraceHitNonWorld() then
		local Ent = _TraceGetEnt()
		local Type = _EntGetType(Ent)
			if string.find(Type, "door") or string.find(Type, "vehicle") then
				local ElseGotIt = false
				local ElseGotItID = 0
				for i = 1, _MaxPlayers() do
					for k,v in RoleplayData[i].Property do
						if v == Ent then
							ElseGotIt = true
							ElseGotItID = i
						end
					end
				end
				if ElseGotIt then
					for k,v in RoleplayData[ElseGotItID].Property do
						table.remove(RoleplayData[ElseGotItID].Property,k)
					end
				end
			end
		end
	end
end
CONCOMMAND("rp_unown", RoleplayData.AdminUnownDoor)

function RoleplayData.AdminKick(userid)
	if RoleplayData.isAdmin(userid) then
		_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 1000, userid)
	
		if _TraceHitNonWorld() then
		local Ent = _TraceGetEnt()
		local Type = _EntGetType(Ent)
			if Type == "player" then
					kickername = _PlayerInfo(userid, "name")
					victimsteamid = _PlayerInfo(Ent, "networkid")
					_PlayerSilentKill(victimsteamid, 30, true)
					_ServerCommand("kickid " .. victimsteamid .. " \"Kicked By " .. kickername .. "\"\n")
			end
		end
	end
end

function RoleplayData.AdminBan(userid,minutes)
	if RoleplayData.isAdmin(userid) then
		_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), 1000, userid)
	
		if _TraceHitNonWorld() then
		local Ent = _TraceGetEnt()
		local Type = _EntGetType(Ent)
			if Type == "player" then
				bannername = _PlayerInfo(userid, "name")
				victimsteamid = _PlayerInfo(Ent, "networkid")
				_PlayerSilentKill(victimsteamid, 30, true)
				_ServerCommand("banid " .. minutes .. " " .. victimsteamid .. "\n")
				_ServerCommand("kickid " .. victimsteamid .. " \"Banned By " .. bannername .. "\"\n")
			end
		end
	end
end 