function _Explode(str,seperator,limit)
	local t={}
	local lim=-1
	local reps=0
	local ll=0
	while true do
		local l=string.find(str,seperator,ll+1,true)
		if l~=nil then
		table.insert(t,string.sub(str,ll,l-1))
		ll=l+1
		reps=reps+1
		else
		table.insert(t,string.sub(str,ll))
		reps=reps+1
		break
		end

		if reps>=lim and lim~=-1 then
		table.insert(t,string.sub(str,ll))
		break
		end
	end
	return t
end

function math.round(real,digits) -- Thanks a lot Grumbely!
local remainder = math.mod(real,digits)
	if remainder/digits < 0.5 then
	return real-remainder
	else
	return real-remainder+(digits)
	end
end


function RoleplayData.GiveDefaultItems(userid)
	_PlayerGiveSWEP(userid, "UCRPM/rp_keys")
	_PlayerGiveItem(userid, "weapon_physcannon")
	_PlayerGiveItem(userid, "weapon_physgun")
	
	if RoleplayData[userid].Team == TEAM_BLUE then
	_PlayerGiveSWEP(userid, "UCRPM/rp_cop_m4a1")
	_PlayerGiveSWEP(userid, "UCRPM/rp_cop_usp")
	_PlayerGiveSWEP(userid, "UCRPM/rp_cop_arrest")
	_PlayerGiveSWEP(userid, "UCRPM/rp_cop_tranquilizer")
		if RoleplayData.AllowBatteringRam then
		_PlayerGiveSWEP(userid, "UCRPM/rp_cop_battering ram")
		end
	end
	
	if ( _GetRule( "AllowMultigun" ) ) then
	_PlayerGiveItem(userid, "weapon_tool")
	_PlayerGiveAmmo(userid, 1, "XBowBolt", false) -- Needed for the toolgun to work.
	end
end

function RoleplayData.AddMoney(userid, money)
	RoleplayData[userid].Cash = (RoleplayData[userid].Cash + money)
	RoleplayData[userid].Cash = math.round(RoleplayData[userid].Cash, 0.01)
	RoleplayData.ShowGUI(userid) -- Update the GUI
end

function RoleplayData.TakeMoney(userid, money)
	RoleplayData[userid].Cash = (RoleplayData[userid].Cash - money)
	RoleplayData[userid].Cash = math.round(RoleplayData[userid].Cash, 0.01)
	RoleplayData.ShowGUI(userid) -- Update the GUI
end

function RoleplayData.SetAspectRatio(userid)
	_GModRect_Start("gmod/white")
	_GModRect_SetPos(0, 0.3, 0.2, 0.2)
	_GModRect_SetColor(0, 0, 0, 100)
	_GModRect_SetTime(9999, 0.5, 0.5)
	_GModRect_Send(userid, RoleplayData.IndexGUI - 1)
	
	_GModText_Start("Default")
	_GModText_SetPos(0, 0.32)
	_GModText_SetTime(99999, 1, 0.5)
	_GModText_SetText("Select Aspect Ratio:\n\n1. CRT (5/4)\n\n3. LCD (4/3)\n\n5. Widescreen (16/9)")
 	_GModText_SetColor(255, 255, 255, 255)
	_GModText_Send(userid, RoleplayData.IndexGUI - 1)

	_PlayerOption(userid, "SetAspectRatio", 99999)
end

function SetAspectRatio(userid, num, seconds)
	if num == 1 then
	RoleplayData[userid].inventory.aspectratio = 5/4
	_GModRect_Hide(userid, RoleplayData.IndexGUI - 1, 0.5)
	_GModText_Hide(userid, RoleplayData.IndexGUI - 1, 0.5)
	_PrintMessage(userid, 3, 'You can set it manually with "rp_aspectratio #/#" in console.')
	elseif num == 3 then
	RoleplayData[userid].inventory.aspectratio = 4/3
	_GModRect_Hide(userid, RoleplayData.IndexGUI - 1, 0.5)
	_GModText_Hide(userid, RoleplayData.IndexGUI - 1, 0.5)
	_PrintMessage(userid, 3, 'You can set it manually with "rp_aspectratio #/#" in console.')
	elseif num == 5 then
	RoleplayData[userid].inventory.aspectratio = 16/9
	_GModRect_Hide(userid, RoleplayData.IndexGUI - 1, 0.5)
	_GModText_Hide(userid, RoleplayData.IndexGUI - 1, 0.5)
	_PrintMessage(userid, 3, 'You can set it manually with "rp_aspectratio #/#" in console.')
	else
	_PlayerOption(userid, "SetAspectRatio", 99999)
	end
end

function RoleplayData.SetAspectRatioCC(userid, args)
	local str = _Explode(args, "/", 2)
	if (tonumber(str[1]) == nil) or (tonumber(str[2]) == nil) then return _PrintMessage(userid, 1, "Wrong input! Ex. rp_aspectratio 5/4") end
	RoleplayData[userid].inventory.aspectratio = str[1] / str[2]
end
CONCOMMAND("rp_aspectratio", RoleplayData.SetAspectRatioCC)

function RoleplayData.SetJob(userid, strText)
	local Name = _PlayerInfo(userid, "name") -- Find the name of the player
	NoNameTxt1 = string.gsub( Name, "([%[%]%(%)%%%+%-%*%?%^%$%.])", "%%%1" ) -- Lets get rid of the special chars.
	NoNameTxt = string.gsub(strText, NoNameTxt1..":", "") -- Remove the name

	Text = _Explode(NoNameTxt, " ", 0)
	if string.lower(Text[2]) == string.lower("/setjob") or string.lower(Text[2]) == string.lower("/job") then -- Check if the player typed "/setjob" or "/job"
		if not RoleplayData[userid].ChangeJob then
		_PrintMessage(userid, 3, "You have to wait " .. RoleplayData.JobChangeTime .. " minutes untill you can change job again!")
		return true
		end
		
		if string.find(string.lower(RoleplayData[userid].Job), "chef") or string.find(string.lower(RoleplayData[userid].Job), "cook") then
		RoleplayData.NrChefs = RoleplayData.NrChefs -1
		RoleplayData[userid].isChef = false
		end
		
		local String = ""
		for i = 3, table.getn(Text) do
		String = String .. Text[i] .. " "
		end
		if string.find(string.lower(String), "chef") or string.find(string.lower(String), "cook") then
			if RoleplayData.NrChefs >= RoleplayData.MaxChefs then
			_PrintMessage(userid, 3, "Max jobs as Chefs reached.")
			return true
			else
			RoleplayData[userid].isChef = true
			RoleplayData.NrChefs = RoleplayData.NrChefs + 1
			end
		end
		
		_PrintMessageAll(3, Name .. " changed his job to: " .. String)
		_PrintMessageAll(1, Name .. " changed his job to: " .. String)
		RoleplayData[userid].Job = String
		RoleplayData.ShowGUI(userid) -- Update the GUI
		RoleplayData[userid].ChangeJob = false
		AddTimer((RoleplayData.JobChangeTime * 60), 1, RoleplayData.ChangeJobTrue, userid)
		return true
	end
end
function RoleplayData.ChangeJobTrue(userid)
	RoleplayData[userid].ChangeJob = true
end

function RoleplayData.Whisper(userid, strText)
	local Name = _PlayerInfo(userid, "name") -- Find the name of the player
	NoNameTxt1 = string.gsub( Name, "([%[%]%(%)%%%+%-%*%?%^%$%.])", "%%%1" ) -- Lets get rid of the special chars.
	NoNameTxt = string.gsub(strText, NoNameTxt1..":", "") -- Remove the name

	Text = _Explode(NoNameTxt, " ", 0)
	if string.lower(Text[2]) == string.lower("/w") then -- Check if the player typed "/w"
		local String = ""
		for i = 3, table.getn(Text) do
		String = String .. Text[i] .. " "
		end
		local Area = _EntitiesFindInSphere(_PlayerGetShootPos(userid), RoleplayData.WhisperArea)
			for k,v in Area do
				if (_EntGetType(v) == "player") then
				_PrintMessage(v, 3, Name .. " [WHISPER]: " .. String)
				_PrintMessage(v, 1, Name .. " [WHISPER]: " .. String)
				end
			end
		return true
	end
end

function RoleplayData.OutOfCharacter(userid, strText)
	local Name = _PlayerInfo(userid, "name") -- Find the name of the player
	NoNameTxt1 = string.gsub( Name, "([%[%]%(%)%%%+%-%*%?%^%$%.])", "%%%1" ) -- Lets get rid of the special chars.
	NoNameTxt = string.gsub(strText, NoNameTxt1..":", "") -- Remove the name

	Text = _Explode(NoNameTxt, " ", 0)
	if string.lower(Text[2]) == string.lower("ooc") then -- Check if the player typed "ooc"
		local String = ""
		for i = 3, table.getn(Text) do
		String = String .. Text[i] .. " "
		end
		_PrintMessageAll(3, Name .. ": (( " .. String .. " ))")
		_PrintMessageAll(1, Name .. ": (( " .. String .. " ))")
		return true
	end
end

function RoleplayData.MeText(userid, strText)
	local Name = _PlayerInfo(userid, "name") -- Find the name of the player
	NoNameTxt1 = string.gsub( Name, "([%[%]%(%)%%%+%-%*%?%^%$%.])", "%%%1" ) -- Lets get rid of the special chars.
	NoNameTxt = string.gsub(strText, NoNameTxt1..":", "") -- Remove the name

	Text = _Explode(NoNameTxt, " ", 0)
	if string.lower(Text[2]) == string.lower("/me") then -- Check if the player typed "/me"
		local String = ""
		for i = 3, table.getn(Text) do
		String = String .. Text[i] .. " "
		end
		_PrintMessageAll(3, "* " .. Name .. " " .. String)
		_PrintMessageAll(1, "* " .. Name .. " " .. String)
		return true
	end
end

function RoleplayData.PrivateMessage(userid, strText)
	local From = _PlayerInfo(userid, "name") -- Find the name of the player
	NoNameTxt1 = string.gsub( From, "([%[%]%(%)%%%+%-%*%?%^%$%.])", "%%%1" ) -- Lets get rid of the special chars.
	NoNameTxt = string.gsub(strText, NoNameTxt1..":", "") -- Remove the name

	Text = _Explode(NoNameTxt, " ", 0)
	if string.lower(Text[2]) == string.lower("/pm") then -- Check if the player typed "/pm"
		for i = 1, _MaxPlayers() do
		if not _PlayerInfo(i, "connected") then return end
		local Names = _PlayerInfo(i, "name")
			
			if string.find(string.lower(Names), string.lower(Text[3])) then
				local String = ""
				for i = 4, table.getn(Text) do
				String = String .. Text[i] .. " "
				end
				_PrintMessage(i, 3, "" .. From .. " [PRIVATE]: " .. String)
				_PrintMessage(i, 1, "" .. From .. " [PRIVATE]: " .. String)
				_PrintMessage(userid, 3, "[PRIVATE TO " .. Names .. "]: " .. String)
				_PrintMessage(userid, 1, "[PRIVATE TO " .. Names .. "]: " .. String)
				return true
			end
		end
	end
end

function RoleplayData.SetModels(userid)
	if RoleplayData[userid].ModelName ~= nil then 
	_PlayerSetModel(userid, RoleplayData[userid].ModelName)
	return RoleplayData[userid].ModelName
	end
	
	-- Set model
	for i = 1, _MaxPlayers() do
		local Num = table.getn(RoleplayData.Models)
		local RandomModel = RoleplayData.Models[math.random(1, Num)]
		_PlayerSetModel(userid, RandomModel)
		RoleplayData[userid].ModelName = RandomModel
	end
	
	-- Check for gender
	local Model = _PlayerInfo(userid, "model")
	if string.find(Model, "female") then
	local ModelNumber = string.gsub(Model, "models/player/female_", "")
	local ModelNumber = string.gsub(ModelNumber, ".mdl", "")
	RoleplayData[userid].Gender = "Female"
	RoleplayData[userid].Model = tostring(ModelNumber)
	RoleplayData.ShowGUI(userid)
	elseif string.find(Model, "male") then
	local ModelNumber = string.gsub(Model, "models/player/male_", "")
	local ModelNumber = string.gsub(ModelNumber, ".mdl", "")
	RoleplayData[userid].Gender = "Male"
	RoleplayData[userid].Model = tostring(ModelNumber)
	RoleplayData.ShowGUI(userid)
	else
	RoleplayData[userid].Gender = "Unknown"
	RoleplayData.ShowGUI(userid)
	end
end

function RoleplayData.ChangeModel(userid, strText)
	local Name = _PlayerInfo(userid, "name") -- Find the name of the player
	NoNameTxt1 = string.gsub( Name, "([%[%]%(%)%%%+%-%*%?%^%$%.])", "%%%1" ) -- Lets get rid of the special chars.
	NoNameTxt = string.gsub(strText, NoNameTxt1..":", "") -- Remove the name

	Text = _Explode(NoNameTxt, " ", 3)
	if string.lower(Text[2]) == string.lower("/models") or string.lower(Text[2]) == string.lower("/model") then -- Check if the player typed "/model" or "/models"
		--[[if RoleplayData[userid].Team == TEAM_BLUE then
		_PrintMessage(userid, 3, "You can't change model/gender!")
		return true
		end]]
		
		if RoleplayData[userid].IsSleeping then
		_PrintMessage(userid, 3, "You can't change model while sleeping!")
		return true
		end
	
		_GModRect_Start("gmod/white")
		_GModRect_SetPos(0, 0.3, 0.2, 0.2)
		_GModRect_SetColor(0, 0, 0, 100)
		_GModRect_SetTime(9999, 0.5, 0.5)
		_GModRect_Send(userid, (RoleplayData.IndexGUI + 200))
		
		if RoleplayData[userid].Team == TEAM_BLUE then
		_GModText_Start("Default")
		_GModText_SetPos(0, 0.32)
		_GModText_SetTime(99999, 1, 0.5)
		_GModText_SetText("1. Combine Soldier\n2. Combine Prisonguard\n3. Combine Elite\n4. Police (Metrocop)\n\n8. Gender: Male\n9. Gender: Female\n\n0. Close")
	 	_GModText_SetColor(255, 255, 255, 255)
		_GModText_Send(userid, (RoleplayData.IndexGUI + 200))
		else
		_GModText_Start("Default")
		_GModText_SetPos(0, 0.32)
		_GModText_SetTime(99999, 1, 0.5)
		_GModText_SetText("1. Female 04\n2. Female 06\n3. Female 07\n4. Male 02\n5. Male 03\n6. Male 08\n\n\n0. Close")
	 	_GModText_SetColor(255, 255, 255, 255)
		_GModText_Send(userid, (RoleplayData.IndexGUI + 200))
		end
		
		_PlayerOption(userid, "ChangeModelMenu", 99999)
		
		return true
	end
end

function ChangeModelMenu(playerid, num, seconds)
	_GModText_Hide(playerid, (RoleplayData.IndexGUI + 200), 0.5, 0)
	_GModRect_Hide(playerid, (RoleplayData.IndexGUI + 200), 0.5, 0)
	
	if RoleplayData[playerid].IsSleeping then
		_PrintMessage(playerid, 3, "You can't change model while sleeping!")
		return true
	end
		
	local HasChosen = false
		if RoleplayData[playerid].Team == TEAM_BLUE then
			if (num == 1) then 
			RoleplayData[playerid].ModelName = "models/player/combine_soldier.mdl"
			RoleplayData[playerid].Model = "Combine Soldier"
			_PrintMessage(playerid, 3, "You changed model to: Combine Soldier")
			_PrintMessage(playerid, 1, "You changed model to: Combine Soldier")
			HasChosen = true
			elseif (num == 2) then
			RoleplayData[playerid].ModelName = "models/player/combine_soldier_prisonguard.mdl"
			RoleplayData[playerid].Model = "Combine Prisonguard"
			_PrintMessage(playerid, 3, "You changed model to: Combine Prisonguard")
			_PrintMessage(playerid, 1, "You changed model to: Combine Prisonguard")
			HasChosen = true
			elseif (num == 3) then
			RoleplayData[playerid].ModelName = "models/player/combine_super_soldier.mdl"
			RoleplayData[playerid].Model = "Combine Elite"
			_PrintMessage(playerid, 3, "You changed model to: Combine Elite")
			_PrintMessage(playerid, 1, "You changed model to: Combine Elite")
			HasChosen = true
			elseif (num == 4) then
			RoleplayData[playerid].ModelName = "models/player/police.mdl"
			RoleplayData[playerid].Model = "Police (Metrocop)"
			_PrintMessage(playerid, 3, "You changed model to: Police (Metrocop)")
			_PrintMessage(playerid, 1, "You changed model to: Police (Metrocop)")
			HasChosen = true
			elseif (num == 8) then
			RoleplayData[playerid].Gender = "Male"
			_PrintMessage(playerid, 3, "You changed gender to: Male")
			_PrintMessage(playerid, 1, "You changed gender to: Male")
			RoleplayData.ShowGUI(playerid)
			elseif (num == 9) then
			RoleplayData[playerid].Gender = "Female"
			_PrintMessage(playerid, 3, "You changed gender to: Female")
			_PrintMessage(playerid, 1, "You changed gender to: Female")
			RoleplayData.ShowGUI(playerid)
			end
		else
			if (num == 1) then 
			RoleplayData[playerid].ModelName = "models/player/female_04.mdl"
			RoleplayData[playerid].Gender = "Female"
			RoleplayData[playerid].Model = "04"
			_PrintMessage(playerid, 3, "You changed model to: Female 04")
			_PrintMessage(playerid, 1, "You changed model to: Female 04")
			HasChosen = true
			elseif (num == 2) then
			RoleplayData[playerid].ModelName = "models/player/female_06.mdl"
			RoleplayData[playerid].Gender = "Female"
			RoleplayData[playerid].Model = "06"
			_PrintMessage(playerid, 3, "You changed model to: Female 06")
			_PrintMessage(playerid, 1, "You changed model to: Female 06")
			HasChosen = true
			elseif (num == 3) then
			RoleplayData[playerid].ModelName = "models/player/female_07.mdl"
			RoleplayData[playerid].Gender = "Female"
			RoleplayData[playerid].Model = "07"
			_PrintMessage(playerid, 3, "You changed model to: Female 07")
			_PrintMessage(playerid, 1, "You changed model to: Female 07")
			HasChosen = true
			elseif (num == 4) then
			RoleplayData[playerid].ModelName = "models/player/male_02.mdl"
			RoleplayData[playerid].Gender = "Male"
			RoleplayData[playerid].Model = "02"
			_PrintMessage(playerid, 3, "You changed model to: Male 02")
			_PrintMessage(playerid, 1, "You changed model to: Male 02")
			HasChosen = true
			elseif (num == 5) then
			RoleplayData[playerid].ModelName = "models/player/male_03.mdl"
			RoleplayData[playerid].Gender = "Male"
			RoleplayData[playerid].Model = "03"
			_PrintMessage(playerid, 3, "You changed model to: Male 03")
			_PrintMessage(playerid, 1, "You changed model to: Male 03")
			HasChosen = true
			elseif (num == 6) then
			RoleplayData[playerid].ModelName = "models/player/male_08.mdl"
			RoleplayData[playerid].Gender = "Male"
			RoleplayData[playerid].Model = "08"
			_PrintMessage(playerid, 3, "You changed model to: Male 08")
			_PrintMessage(playerid, 1, "You changed model to: Male 08")
			HasChosen = true
			end
		end
	
	if HasChosen then
	RoleplayData[playerid].Position = _EntGetPos(playerid) -- Get position
	RoleplayData[playerid].Angle = _PlayerGetShootAng(playerid) -- Get the angle
	RoleplayData.ShowGUI(playerid) -- Update GUI
	local Health = _PlayerInfo(playerid, "health")
	_PlayerRespawn(playerid) -- Respawn the player
	_PlayerSetHealth(playerid, Health)
	AddTimer(0.05, 1, _EntSetPos, playerid, RoleplayData[playerid].Position) -- Move them back
	AddTimer(0.05, 1, _EntSetAng, playerid, RoleplayData[playerid].Angle) -- Set angle back
	end
end

function RoleplayData.SetTeam(userid)
	_PlayerChangeTeam(userid, RoleplayData[userid].Team)
end

function RoleplayData.Arrest(userid, arrest)
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), RoleplayData.UseRange, userid)
	if _TraceHitNonWorld() then
	local Player = _TraceGetEnt()
	local Type = _EntGetType(Player)
	local PlayerName = _PlayerInfo(Player, "name")
		if Type == "player" then
			if RoleplayData[Player].Team == TEAM_BLUE then
			_PrintMessage(userid, 4, "You can't arrest a cop!")
			return
			end
			
			if arrest == 1 then
			RoleplayData[Player].Arrested = true
			_PlayerSetMaxSpeed(Player, RoleplayData.ArrestedSpeed)
			_PlayerSetSprint(Player, false)
			_PlayerDisableAttack(Player, true)
			_PrintMessage(Player, 4, "You are arrested\nPlease follow the police")
			_PrintMessage(userid, 4, "You arrested " .. PlayerName)
			elseif arrest == 2 then
			RoleplayData[Player].Arrested = false
			_PlayerSetMaxSpeed(Player, 190) -- 190 is default
			_PlayerSetSprint(Player, true)
			_PlayerDisableAttack(Player, false)
			_PrintMessage(Player, 4, "You are no longer arrested")
			_PrintMessage(userid, 4, "You unarrested " .. PlayerName)
				if RoleplayData[Player].NoWeapons then
				RoleplayData.GiveDefaultItems(Player)
				end
			elseif arrest == 3 then
				if RoleplayData[Player].Arrested then
				_PlayerRemoveAllWeapons(Player)
				RoleplayData[Player].NoWeapons = true
				_PrintMessage(Player, 4, "The police took your weapons!")
				_PrintMessage(userid, 4, "You took " .. PlayerName .. "'s weapons")
				end
			end
		end
	end
end

function RoleplayData.SetAge(userid, strText)
	local Name = _PlayerInfo(userid, "name")
	NoNameTxt1 = string.gsub( Name, "([%[%]%(%)%%%+%-%*%?%^%$%.])", "%%%1" ) -- Lets get rid of the special chars.
	NoNameTxt = string.gsub(strText, NoNameTxt1..":", "") -- Remove the name

	Text = _Explode(NoNameTxt, " ", 0)
	if string.lower(Text[2]) == string.lower("/age") then
		if tonumber(Text[3]) ~= nil then 
			if tonumber(Text[3]) >= RoleplayData.AgeMin then
				if tonumber(Text[3]) <= RoleplayData.AgeMax then
				_PrintMessage(userid, 3,"You are now " .. math.ceil(Text[3]) .. " years old.")
				RoleplayData[userid].Age = math.ceil(Text[3])
				RoleplayData.ShowGUI(userid)
				else
				_PrintMessage(userid, 3, "That is over the max limit (" .. RoleplayData.AgeMax .. ") !")
				end
			else
			_PrintMessage(userid, 3, "That is under the min limit (" .. RoleplayData.AgeMin .. ") !")
			end
		else
		_PrintMessage(userid, 3, "That is not a valid age!")
		end
	return true
	end
end

function RoleplayData.BecomeCitizen(userid, strText)
	local Name = _PlayerInfo(userid, "name")
	NoNameTxt1 = string.gsub( Name, "([%[%]%(%)%%%+%-%*%?%^%$%.])", "%%%1" ) -- Lets get rid of the special chars.
	NoNameTxt = string.gsub(strText, NoNameTxt1..":", "") -- Remove the name

	Text = _Explode(NoNameTxt, " ", 0)
	if string.lower(Text[2]) == string.lower("/citizen") or string.lower(Text[2]) == string.lower("/becitizen") then
		if RoleplayData[userid].Team ~= TEAM_BLUE then
		_PrintMessage(userid, 3, "You have to be a cop!")
		return true
		end
		_PrintMessageAll( 3, Name .. " has now become a citizen!")
		RoleplayData[userid].Team = TEAM_GREEN
		_PlayerRespawn(userid)
		RoleplayData[userid].ModelName = nil
		RoleplayData[userid].Job = "Unemployed"
		RoleplayData.SetModels(userid)
		RoleplayData.ShowGUI(userid)
		return true
	end
end

function RoleplayData.HelpText(userid, strText)
	local Name = _PlayerInfo(userid, "name")
	NoNameTxt1 = string.gsub( Name, "([%[%]%(%)%%%+%-%*%?%^%$%.])", "%%%1" ) -- Lets get rid of the special chars.
	NoNameTxt = string.gsub(strText, NoNameTxt1..":", "") -- Remove the name

	Text = _Explode(NoNameTxt, " ", 0)
	if string.lower(Text[2]) == string.lower("/help") then
		RoleplayData.ShowHelpMenu(userid)
		return true
	end
end

function RoleplayData.Sleep(userid, strText)
	local Name = _PlayerInfo(userid, "name")
	NoNameTxt1 = string.gsub( Name, "([%[%]%(%)%%%+%-%*%?%^%$%.])", "%%%1" ) -- Lets get rid of the special chars.
	NoNameTxt = string.gsub(strText, NoNameTxt1..":", "") -- Remove the name

	Text = _Explode(NoNameTxt, " ", 0)
	if string.lower(Text[2]) == string.lower("/sleep") then
		if not RoleplayData[userid].CanSleep then
		_PrintMessage(userid, 3, "You have to wait " .. RoleplayData.SleepDelayTime .. " seconds until you are able to wake up!")
		return true
		end
		--[[if RoleplayData[userid].Arrested then
		_PrintMessage(userid, 3, "You can't sleep while arrested!")
		return true
		end]]
		if RoleplayData[userid].Tranquilized  then
		_PrintMessage(userid, 3, "You can't sleep while tranquilized!")
		return true
		end
		
		if not _PlayerInfo(userid, "alive") then return true end
		if not RoleplayData[userid].IsSleeping then
		local Ragdoll = _EntCreate( "prop_ragdoll" )
		_EntPrecacheModel( _PlayerInfo(userid, "model") )
		_EntSetModel( Ragdoll, _PlayerInfo(userid, "model") )
		local vector = _EntGetPos(userid)
		local angle = _EntGetAngAngle(userid)
		_EntSetKeyValue(Ragdoll, "angles", angle.x .. " " .. angle.y .. " " .. angle.z) 
		_EntSetKeyValue(Ragdoll, "origin", vector.x .. " " .. vector.y .. " " .. vector.z)
		_EntSpawn(Ragdoll)
		_phys.ApplyForceCenter(Ragdoll, vecMul(_EntGetAng(userid), -1000))
		RoleplayData[userid].Health = _PlayerInfo(userid, "health")
		
		_PlayerSpectatorStart( userid, OBS_MODE_CHASE )
		_PlayerSpectatorTarget( userid, Ragdoll )
		_PlayerRemoveAllWeapons(userid)
		
		_GModRect_Start("gmod/white")
		_GModRect_SetColor(0, 0, 0, RoleplayData.SleepAlpha)
		_GModRect_SetPos(0.0, 0.0, 1, 1)
		_GModRect_SetTime(9999, 3, 0)
		_GModRect_Send(userid, RoleplayData.IndexGUI + 700)
		
		RoleplayData[userid].IsSleeping = true
		RoleplayData[userid].RagdollID = Ragdoll
		RoleplayData[userid].CanSleep = false
		RoleplayData[userid].SleepTimer = AddTimer(1, 0, RoleplayData.SleepRegainHP, userid)
		AddTimer(RoleplayData.SleepDelayTime, 1, RoleplayData.ChangeSleepTrue, userid)
		else
		_PlayerSpectatorEnd(userid)
		_PlayerRespawn(userid)
		if _EntExists(RoleplayData[userid].RagdollID) then
		local Pos = _EntGetPos(RoleplayData[userid].RagdollID)
		_EntSetPos(userid, vecAdd(Pos, vector3(0,0,10)))
		_EntRemove(RoleplayData[userid].RagdollID)
		end
		_PlayerSetHealth(userid, RoleplayData[userid].Health)
		
		_GModRect_Hide(userid, RoleplayData.IndexGUI + 700, 3, 0)
		
		RoleplayData[userid].IsSleeping = false
		RoleplayData[userid].RagdollID = nil
		HaltTimer(RoleplayData[userid].SleepTimer)
		RoleplayData.CheckHealth(userid, RoleplayData[userid].Health, 0)
		end
	return true
	end
end
function RoleplayData.ChangeSleepTrue(userid)
	RoleplayData[userid].CanSleep = true
end
function RoleplayData.CheckSleep(userid)
	if RoleplayData[userid].IsSleeping or RoleplayData[userid].Tranquilized  then
	_PlayerSpectatorStart(userid, OBS_MODE_CHASE )
	_PlayerSpectatorTarget(userid, RoleplayData[userid].RagdollID )
	_PlayerRemoveAllWeapons(userid)
	end
end
function RoleplayData.SleepRegainHP(userid)
	if RoleplayData[userid].Health + RoleplayData.SleepHP <= 100 then
	RoleplayData[userid].Health = RoleplayData[userid].Health + RoleplayData.SleepHP
	else
	RoleplayData[userid].Health = 100
	end
end

function RoleplayData.ShowUserInfo(userid)
	_TraceLine(_PlayerGetShootPos(userid), _PlayerGetShootAng(userid), RoleplayData.UseRange, userid)
	if _TraceHitNonWorld() then
		if _EntGetType(_TraceGetEnt()) == "player" then
		RoleplayData.ShowUserInfoGUI(userid, _TraceGetEnt())
		end
	end
end 

function RoleplayData.RespawnArrested(userid, getpos)
	if RoleplayData[userid].Arrested then
		if getpos then
		RoleplayData[userid].Position = _EntGetPos(userid)
		RoleplayData[userid].Angle = _PlayerGetShootAng(userid)
		else
		AddTimer(0.1, 1, _EntSetPos, userid, RoleplayData[userid].Position)
		AddTimer(0.1, 1, _EntSetAng, userid, RoleplayData[userid].Angle)
		AddTimer(0.1, 1, _PlayerSetMaxSpeed, userid, RoleplayData.ArrestedSpeed)
		AddTimer(0.1, 1, _PlayerDisableAttack, userid, true)
		AddTimer(0.1, 1, _PlayerSetSprint, userid, false)
			if RoleplayData[userid].NoWeapons then
			AddTimer(0.1, 1, _PlayerRemoveAllWeapons, userid)
			end
		end
	end
end 

function RoleplayData.Tranquilize(userid, wake)
	--if RoleplayData[userid].Tranquilized then return end
	if not RoleplayData[userid].IsSleeping then
		if not wake then
		local Ragdoll = _EntCreate( "prop_ragdoll" )
		_EntPrecacheModel( _PlayerInfo(userid, "model") )
		_EntSetModel( Ragdoll, _PlayerInfo(userid, "model") )
		local vector = _EntGetPos(userid)
		local angle = _EntGetAngAngle(userid)
		_EntSetKeyValue(Ragdoll, "angles", angle.x .. " " .. angle.y .. " " .. angle.z) 
		_EntSetKeyValue(Ragdoll, "origin", vector.x .. " " .. vector.y .. " " .. vector.z)
		_EntSpawn(Ragdoll)
		_phys.ApplyForceCenter(Ragdoll, vecMul(_EntGetAng(userid), 10000))
		RoleplayData[userid].Health = _PlayerInfo(userid, "health")
		
		_PlayerSpectatorStart( userid, OBS_MODE_CHASE )
		_PlayerSpectatorTarget( userid, Ragdoll )
		_PlayerRemoveAllWeapons(userid)
		RoleplayData[userid].RagdollID = Ragdoll
		else
		_PlayerSpectatorEnd(userid)
		_PlayerRespawn(userid)
			if _EntExists(RoleplayData[userid].RagdollID) then
			local Pos = _EntGetPos(RoleplayData[userid].RagdollID)
			_EntSetPos(userid, vecAdd(Pos, vector3(0,0,10)))
			_EntRemove(RoleplayData[userid].RagdollID)
			end
		_PlayerSetHealth(userid, RoleplayData[userid].Health)
		RoleplayData.CheckHealth(userid, RoleplayData[userid].Health, 0)
		RoleplayData[userid].RagdollID = nil
		RoleplayData[userid].Tranquilized = false
		end
	end
end

function TranquilizerThink()
	local darts = _EntitiesFindByName("tranquilizer_dart")
	for _,dart in darts do
	_TraceLine(_EntGetPos(dart), _EntGetAng(dart), 20, dart)
	if _TraceHit() then
	_phys.EnableGravity(dart, true)
	end
	local ent = _TraceGetEnt()
		if _EntGetType(ent) == "player" then
			if not RoleplayData[ent].Tranquilized then
			_GModRect_Start("gmod/white")
			_GModRect_SetColor(255, 255, 255, 255)
			_GModRect_SetPos(0.0, 0.0, 1, 1)
			_GModRect_SetTime(0.2, 0.1, 0.1)
			_GModRect_Send(ent, RoleplayData.IndexGUI + 701)
			
			_GModRect_Start("gmod/white")
			_GModRect_SetColor(0, 0, 0, 255)
			_GModRect_SetPos(0.0, 0.0, 1, 1)
			_GModRect_SetTime((RoleplayData.TranquilizerLength - RoleplayData.TranquilizerDelay), (RoleplayData.TranquilizerDelay - 0.5), 2)
			_GModRect_Send(ent, RoleplayData.IndexGUI + 700)
			
			--AddTimer(0.1, 190, RoleplayData.DrainSpeedOverTime, ent, 1)
			AddTimer(RoleplayData.TranquilizerDelay, 1, RoleplayData.Tranquilize, ent, false)
			AddTimer(RoleplayData.TranquilizerLength, 1, RoleplayData.Tranquilize, ent, true)
			RoleplayData[ent].Tranquilized = true
			end
		_EntRemove(dart)
		end
	end
end
AddThinkFunction(TranquilizerThink)

--[[function RoleplayData.DrainSpeedOverTime(userid, amount)
	RoleplayData[userid].Speed = RoleplayData[userid].Speed - amount
	_PlayerSetMaxSpeed(useird, RoleplayData[userid].Speed)
end]]

function RoleplayData.OnRemove(userid, entity)
	if not RoleplayData.DoorRemoveBlock then return true end
	if string.find(_EntGetType(entity), "door") then
		if RoleplayData.isAdmin(userid) then
		return true
		else
		_PrintMessage(userid, 4, "Only admins can remove doors!")
		return false
		end
	end
	
	return true
end

function RoleplayData.SetCustomPayment(userid, args)
	if not RoleplayData.isAdmin(userid) then return _PrintMessage(userid, 1, "Access Denied!") end
	local P = _Explode(args, " ", 3)
	
	for i = 1, _MaxPlayers() do
	if not _PlayerInfo(i, "connected") then return end
	local Names = _PlayerInfo(i, "name")
		if string.find(string.lower(Names), string.lower(P[1])) then
		if (tonumber(P[2]) == 0) or (tonumber(P[3]) == 0) then 
		RoleplayData[i].CustomPay = false 
		_PrintMessage(userid, 1, Names .. " now have a default payment.")
		return
		end
		if (tonumber(P[2]) == nil) or (tonumber(P[3]) == nil) then return _PrintMessage(userid, 1, "ERROR: Wrong Input!\nExample: rp_setpay killer 20 60") end
		if not (tonumber(P[2]) < tonumber(P[3])) then return _PrintMessage(userid, 1, "ERROR: Min is more than max.") end 
		if (tonumber(P[2]) > 10000) or (tonumber(P[3]) > 10000) then return _PrintMessage(userid, 1, "ERROR: Too high payment.") end 
		RoleplayData[i].CustomPay = true
		RoleplayData[i].CustomPayMin = P[2]
		RoleplayData[i].CustomPayMax = P[3]
		_PrintMessage(userid, 1, Names .. " now have min " .. RoleplayData.CashPrefix .. P[2] .. " and max " .. RoleplayData.CashPrefix .. P[3] .. " payment.")
		_PrintMessage(i, 3, "You now have min " .. RoleplayData.CashPrefix .. P[2] .. " and max " .. RoleplayData.CashPrefix .. P[3] .. " payment.")
		end
	end
end
CONCOMMAND("rp_setpay", RoleplayData.SetCustomPayment)

for i = 1, _MaxPlayers() do
	if _PlayerInfo(i, "connected") then
	RoleplayData.ShowGUI(i)
	RoleplayData.SetAspectRatio(i)
	_PlayerChangeTeam(i, RoleplayData[i].Team)
	AddTimer(0.5, 1, _PlayerRespawn, i)
	end
end 