--[[
	Title: AI Helpers
]]


--[[
	Function: playScene

	Plays a scripted scene through a npc

	Parameters:

		npc - The npc entity
		scene - The scene to play

]]
function ULib.playScene ( npc, scene )
	_EntFire( npc, "setexpressionoverride", scene, 0 )
end


--[[
	Function: stopScene

	Stops an npc playing a scene

	Parameters:

		npc - The npc entity

]]
function ULib.stopScene ( npc )
	_EntFire( npc, "setexpressionoverride", "shush", 0 )
end


--[[
	Function: runToPosition

	Forces a npc to run to a position

	Parameters:

		npc - The npc entity
		position - The position

	Revisions:

		v1- Initial
]]
function ULib.runToPosition ( npc, pos )
	_npc.SetLastPosition( npc, pos )
	_npc.SetSchedule( npc, SCHED_FORCED_GO_RUN )
end


--[[
	Function: walkToPosition

	Forces a npc to walk to a position

	Parameters:

		npc - The npc entity
		position - The position

	Revisions:

		v1- Initial
]]
function ULib.walkToPosition ( npc, pos )
	_npc.SetLastPosition( npc, pos )
	_npc.SetSchedule( npc, SCHED_FORCED_GO )
end


--[[
	Function: followEnt

	Forces a npc to follow another entity ( ie, a player ).

	Parameters:

		npc - The npc entity.
		targetent - The ent to follow.

	Note:
	
		This seems to be a bit buggy, but should work okay if you're careful. Should work especially well on maps with nodes.
]]
local gNpcs = {}
local gTimerid

function ULib.followEnt ( npc, targetent )
	if not gTimerid then gTimerid = ULib.addTimer( 2, 0, npcUpdate ) end -- Only add the timer when required.
	gNpcs[ npc ] = targetent
end


--[[
	Function: npcUpdate
	
	*This function is for internal use only*. It updates entity movement to support <followEnt()>
]]
local function npcUpdate()
	for k, v in pairs( gNpcs ) do
		local look = _EntGetAng( v )
		look.z = 0
		look = vecNormalize( look )
		local pos = vecSub( _EntGetPos( v ), vecMul( look, 100 ) ) -- Put the NPC behind the ent so it doesn't collide with it.
		ULib.goToPosition( k, pos )
	end
end


--[[
	Function: addRelationship
	
	Adds a relationship between two npcs and/or players

	Parameters:

		target - First NPC.
		target2 - Second NPC or player.
		disposition - *(Optional, defaults to "D_HT")* A *STRING* of how the NPC feels about their target (see <http://gmwiki.garry.tv/index.php/Npc.AddRelationship>).
		priority - *(Optional, defaults to 99)* How important the feelings are. The relationship with the highest priority is the one which is applied .

	Revisions:

		v1 - Initial
]]
function ULib.addRelationship( target, target2, disposition, priority )
	disposition = disposition or "D_HT"
	priority = priority or 99
	if not ULib.checkParams( { target, target2, disposition, priority }, { "number", "number", "string", "number" } ) then return nil, ULib.ERR_ARGS end
	
	_EntFire( target, "setrelationship", generateEntName( target2 ) .. " " .. disposition .. " " .. tostring( priority ), 0 )
end


--[[
	Function: recipRelationship
	
	Sets a reciprocal relationship between two ents.

	Parameters:

		target - First NPC.
		target2 - Second NPC.
		disposition - *(Optional, defaults to D_HT)* How the NPC feels about their target (see <http://gmwiki.garry.tv/index.php/Npc.AddRelationship>).
		priority - *(Optional, defaults to 99)* How important the feelings are. The relationship with the highest priority is the one which is applied .

	Revisions:

		v1 - Initial
]]
function ULib.recipRelationship( target, target2, disposition, priority )
	disposition = disposition or D_HT
	priority = priority or 99
	if not ULib.checkParams( { target, target2, disposition, priority }, { "number", "number", "number", "number" } ) then return nil, ULib.ERR_ARGS end

	ULib.addRelationship( target, target2, disposition, priority )
	ULib.addRelationship( target2, target, disposition, priority )
end

