--[[
	Title: Default menu skin

	ULib's default menu skin.
	Also serves as an example to anyone wanting to make their own menu skin.
]]

--[[
	Section: API

	ULib requires the following functions and variables from a menu skin--

	Variables:
	prev - A string of the text to use for the previous page option. IE, "Previous".
	next - A string of the text to use for the next page option. IE, "Next".
	next - A string of the text to use for the exit option. IE, "Exit".
	max_options - The max # of options in the menu, can be between 4 and 10.
	bind_options - Bind the users numbers 0-9 on their keyboard.


	Function: showMenu

	This is called when a menu needs to be shown.

	Parameters:

		userid - The userid to show the menu to.
		title - The title of the menu.
		page_options - The options on the menu. We recommend using this as a table key to keep track of text and rect keys. The format of this table is -- { text=text, id=id, callback=callback, disabled=disabled }. Text is the option text, id the optionid, disabled is whether or not the user can select the option. You don't need to handle the callback.
		timeout - The max time to show the menu.
		page - The page # that's being shown.
		menu - The whole menu class in case you need more information. You can safely ignore this parameter if you don't need it.

	
	Function: hideMenu

	This is called when a menu needs to be hidden.

	Parameters:

		userid - The userid to hide the menu from.
		page_options - The options on the menu. We recommend using this as a table key to keep track of text and rect keys.
		page - The page # the user was on.
		menu - The whole menu class in case you need more information. You can safely ignore this parameter if you don't need it.


	Function: startVote

	This is called when a vote is started. If you don't want to handle votes with a special gui, specify these functions with nothing in them.

	Parameters:

		userid - The userid to show the gui to. This will be everyone (called multiple times) if the vote is shown to everyone.
		time - The max time for the vote.
		voteMenu - The whole menu class in case you need more information. You can safely ignore this parameter if you don't need it.


	Function: updateVote

	This is called when someone makes a vote. You'd use this function to show who voted for what, etc.

	Parameters:

		userid - The userid to show the gui to. This will be everyone (called multiple times) if the vote is shown to everyone.
		optionid - The optionid chosen, this is the optionid chosen by the menu in addOption.
		time - The time taken to choose.
		text - The text of the option, this may be easier to use than the optionid.
		voteMenu - The whole menu class in case you need more information. You can safely ignore this parameter if you don't need it.


	Function: endVote

	This is called when someone makes a vote. You'd use this function to show who voted for what, etc.

	Parameters:

		winning_id - The winning option id.
		winning_text - The winning option text.
		total_votes - How many votes were cast.
		total_voters - How many voters there were. This can be higher than total_votes if the voter did not vote or got timed out.
		voteMenu - The whole menu class in case you need more information. You can safely ignore this parameter if you don't need it.
]]

ULib.default_skin = {}
ULib.default_skin.prev = "Previous Page"
ULib.default_skin.next = "Next Page"
ULib.default_skin.exit = "Exit"
ULib.default_skin.max_options = 10
ULib.default_skin.bind_options = true

function ULib.default_skin.showMenu( userid, title, page_options, timeout, page, menu )
	local options = title .. "\n"
	for k, v in pairs( page_options ) do
		if v.disabled then
			options = options .. "\n"
		else
			options = options .. "  " .. math.mod( k, 10 ) .. ". " .. v.text .. "\n" -- Mod so 10 shows up as 0
		end
	end
	ULib.sendText( userid, 1, 0.08, 0.4, options, timeout )
end

function ULib.default_skin.hideMenu( userid, page_options, page, menu )
	_GModText_Hide( userid, 1 )
end

function ULib.default_skin.startVote( userid, time, voteMenu )
end

function ULib.default_skin.updateVote( userid, optionid, time, text, voteMenu )
end

function ULib.default_skin.endVote( winning_id, winning_text, total_votes, total_voters, voteMenu )
end