--[[
	Title: UCL-Public

	ULib's Access Control List. This file contains *public* functions, functions that developers should be
	most concerned with. They were moved here because the ucl.lua file is just too massive ;)
]]

--------------------------
--Users.ini backup stuff--
--------------------------
if _file.Exists( "lua/ULib/new_install.txt" ) and _file.Exists( "lua/ULib/users.bak" ) then
	_file.Write( "lua/ULib/users.ini", _file.Read( "lua/ULib/users.bak" ) ) -- If it's a new install and they have a backup, restore it.
	_file.Delete( "lua/ULib/new_install.txt" )
end

ULib.addTimer( 47, 1, function() _file.Write( "lua/ULib/users.bak", _file.Read( "lua/ULib/users.ini" ) ) end )
-- Put on timer because there's no sense in making the server load time longer... and this is rather unimportant.

-- End backup stuff

--[[
	Variable: mainUcl
	
	This holds the default user access list, from the file "lua/ULib/users.ini"
	
	Revisions:
	
		v1 - Changed from mainUcl to ULib.mainUcl
]]
ULib.mainUcl = ULib.ucl:newFromFile( ULib.DEFAULT_UCL_FILE )


--[[
	Function: obj:addAccessCallback

	Pass a function and it will be called when someone receives access. Parameters it passes to the function are the userid and access string.
	This function is useful for things like passing menus to users upon access. *This is also called when a user receives NO access*.
	
	Parameters:
		
		fn - The function to call.
		
	Revisions:
	
		v1.1 - Initial
]]
function ULib.ucl:addAccessCallback( fn )
	table.insert( self.callbacks, fn )
end

--[[
	Function: obj:getAccess

	Returns the access string of a user

	Parameters:

		userid - The userid to query.

	Returns:

		The access string if they have access, false if they don't, nil and error message otherwise.
	
	Revisions:
	
		v1 - Fixed this function
]]
function ULib.ucl:getAccess( userid )
	if not ULib.checkParam( userid, "number" ) or
	userid < 1 or userid > _MaxPlayers() then
		return nil, ULib.ERR_ARGS
	end

	if not self.authed[ userid ] then return false end

	if self.authed[ userid ].steamlogin == ULib.getSteamLogin( userid ) then -- We check steam login to be secure.
		return self.authed[ userid ].access_flags
	end

	return false
end


--[[
	Function: obj:query

	Queries the UCL to see if a user has access.

	Parameters:

		userid - The userid to query.
		access - The access to check if they have. IE, ACCESS_KICK.

	Returns:

		True if they have access, false if they don't, nil and error message otherwise.
]]
function ULib.ucl:query( userid, access )
	if access == ACCESS_ALL or userid == 0 then return true end
	if access == ACCESS_NONE then return false end

	if not ULib.checkParams( { userid, access }, { "number", "string" } ) or
	userid < 1 or userid > _MaxPlayers() or string.len( access ) > 1 then
		return nil, ULib.ERR_ARGS
	end

	if not self.authed[ userid ] then return false end

	if string.find( self.authed[ userid ].access_flags, access ) and self.authed[ userid ].steamlogin == ULib.getSteamLogin( userid ) then -- We check steam login to be secure.
		return true
	end

	return false
end