--[[
	Title: Compat

	Offers to backwards compatible functions for ULX v1 scripts. To disable this functionality, see the variable below.

	Everything in this file started in v1.1.
]]

--[[
	Variable: COMPAT_ENABLED
	
	If false, the compat.lua file will not load
]]
local COMPAT_ENABLED = true

if COMPAT_ENABLED then
gUsers = {}
local ucl = ULib.mainUcl -- change this if you're using a different UCL

function hasAccess( userid, access )
	return ucl:query( userid, access )
end

function hasAccessSteamid( steamid, access )
	local player
	for player = 1, _MaxPlayers() do
		if _PlayerInfo( userid, "networkid" ) == steamid then
			break
		end
	end
	
	if not player then return false end -- Not found
	return ucl:query( player, access )
end

function getAccess( userid )
	if ucl.authed[ userid ] then
		return ucl.authed[ userid ].access_flags
	end
	return nil -- Not connected
end

local function updateUsers( userid, access )
	if access ~= "" then
		gUsers[ _PlayerInfo( userid, "networkid" ) ] = access
	end
end
ucl:addAccessCallback( updateUsers )
end