--[[
	Title: Defines

	Defines some things needed by ULib
]]


--[[
	Variable: VERSION

	ULib version identifier. 
	This variable will always be a number value and will always increase with new releases.

	If you would like to make sure that a current version of ULib is being used, you could use this code --
	:assert( ULIB_VERSION >= 0.5, "You must be running ULib version 0.5 or higher to use this script!" )
	If your script executes and the first parameter of assert is false, it will stop executing and print the error in the second argument.
	Of course, you'd want to make your own error message and replace 0.5 with your version of choice.
	
	Revisions:
	
		v1 - Changed from ULIB_VERSION to VERSION
]]
ULib.VERSION = 1.2

ULib.ULIB_VERSION = ULib.VERSION -- To be compatible with v0.9


--[[
	Variable: LISTEN_ACCESS
	
	This declares the access of the listen server admin.
]]
ULib.LISTEN_ACCESS = "bcdefghijklmnopqrstuz"


--[[
	Variable: DEBUG_MODE

	Determines which debug and error messages to be shown. Recommended you keep this set to 1.

	Possible Values:
	0 - Off, no debug messages.
	1 - Only show errors.
	2 - Full debug mode.
]]
ULib.DEBUG_LEVEL = 1

ULib.ERR = 1
ULib.DEBUG = 2


--[[
	Variable: SPACE_METHOD
	
	The spacing method used in saving files, used to show structure.
	
	See Also:

		<serialize()>
]]
ULib.SPACE_METHOD = "\t"


--[[
	Variable: NEWLINE

	The format of newlines for ULib to use. Defaults to '\n' on linux and '\r\n' on windows.
]]
if _IsLinux() then
	ULib.NEWLINE = "\n"
else
	ULib.NEWLINE = "\r\n"
end


--[[
	Variable: LOG

	If false, ULib will not write anything to the log.
]]
ULib.LOG = true


--[[
	Variable: LOG_FILE

	The file to save log messages to.
]]
ULib.LOG_FILE = "lua/ULib/log.txt"


--[[
	Variable: ACCESS_FILE

	The file to save dynamic command access to.
]]
ULib.ACCESS_FILE = "lua/ULib/command_access.ini"


--[[
	Variable: DB_FILE

	The file to save database to.
]]
ULib.DB_FILE = "lua/ULib/ULib.db"


--[[
	Variable: ID_NEXT

	Used for the ULib menu, this signifies "next page"
]]
ULib.ID_NEXT = -1


--[[
	Variable: ID_PREV

	Used for the ULib menu, this signifies "previous page"
]]
ULib.ID_PREV = -2


--[[
	Variable: ID_EXIT

	Used for the ULib menu, this signifies "exit menu"
]]
ULib.ID_EXIT = 0

--[[
	Variable: ID_ALLPLAYERS

	Used for the ULib menu, this signifies "all players"
]]
ULib.ID_ALLPLAYERS = -3


--[[
	Variable: ERR_MULTIPLE

	An error message to use when you get multiple targets and you only want one.
]]
ULib.ERR_MULTIPLE = "Multiple targets found! Please try again."


--[[
	Variable: ERR_ARGS

	An error message to use when you get invalid arguments.
]]
ULib.ERR_ARGS = "Invalid parameters!"


--[[
	Variable: DEFAULT_UCL_FILE

	ULib's default UCL file.
	
	Revisions:
	
		v1.1 - Initial
]]
ULib.DEFAULT_UCL_FILE = "lua/ULib/users.ini"