-- DBloader
-- A script for saving/loading databases
--
-- You may use any part from this script, but please
-- give me (Anders1) credits. Thanks.
--
 
-- Here's the functions that you can use:
--
-- db = dbloader:New(db) - Creates a database object
-- db:Load()             - Loads the database from disk
-- db:Reload()           - Reloads the database from disk
-- db:Unload()           - Unloads the database from memory
-- db:Save()             - Saves the DB to the disk
-- db:Get(key)           - Same as GetString()
-- db:GetString(key)     - Returns a string (or nil)
-- db:GetNumber(key)     - Returns a number (or nil)
-- db:GetBool(key)       - Returns a boolean (or nil)
-- db:GetTable()         - Returns the entire database as a Lua table
-- db:Set(key, value)    - Sets a value in the database
-- db:SetDB(db)          - Changes the current database file
-- db:SetTable(table)    - Adds all the values from a table into the db
--                         NOTE: it will not save tables inside tables!
-- db:Unset(key)         - Removes a key from the database
-- db:GetKeys()          - Returns a table with all the keys set
 
-- From lua-users.org
function explode(d,p)
        t={}
        ll=0
        while true do
                l=string.find(p,d,ll+1,true) -- find the next d in the string
                if l~=nil then -- if "not not" found then..
                        table.insert(t, string.sub(p,ll,l-1)) -- Save it in our array.
                        ll=l+1 -- save just after where we found it for searching next time.
                else
                        table.insert(t, string.sub(p,ll)) -- Save what's left in our array.
                        break -- Break at end, as it should be, according to the lua manual.
                end
        end
        return t
end

if dbloader == nil then
  dbloader = {}
end

function dbloader:New (db)
  local obj = {}
  for k, v in dbloader do obj[k]=v end

  obj.dbname = db
  obj.db = {}

  --setmetatable(obj, self)
  --obj.__index = self
  --obj.dbname = db
  --obj.db = {}
  
  --_Msg("---- DEBUG:New() ----\n")
  --_Msg("obj: "..tostring(obj).."\n")
  --_Msg("obj.dbname: "..tostring(obj.dbname).."\n")
  --_Msg("obj.db: "..tostring(obj.db).."\n")
  --_Msg("self: "..tostring(self).."\n")
  --_Msg("---- DEBUG ----\n")

  return obj
end

-- Clean this up
function dbloader:GetKV (line)
  local buf = ""
  local keybuf = ""
  local ch
  local i = 0
  local bvalue = false

  for i=1, string.len(line) do
    ch = string.sub(line, i, i)
    if not bvalue then
      if ch == " " then
        bvalue = true
      else
        keybuf = keybuf..ch
      end
    else
      buf = buf..ch
    end
  end
  return {key=keybuf, value=buf}
end

function dbloader:Load ()
  local lines
  local kv

  --_Msg("---- DEBUG:Load() ----\n")
  --_Msg("self:        "..tostring(self).."\n")
  --_Msg("self.db:     "..tostring(self.db).."\n")
  --_Msg("self.dbname: "..tostring(self.dbname).."\n")

  if _file.Exists(self.dbname) then
    lines = explode("\n", _file.Read(self.dbname))
  else
    return
  end

  for key, value in lines do
    if value ~= "" then
      kv = self:GetKV(value)
      self.db[kv.key] = kv.value
      --_Msg("self.db["..tostring(kv.key).."] = "..tostring(kv.value).."\n")
    end
  end
  --_Msg("---- DEBUG ----\n")
end

-- Always returns a string (or nil)
function dbloader:Get (key)
  return self.db[key]
end

-- String
function dbloader:GetString (key)
  return self.db[key]
end

-- Numbers
function dbloader:GetNumber (key)
  if self.db[key] ~= nil then
    return tonumber(self.db[key])
  end
  return nil
end

-- Booleans
function dbloader:GetBool (key)
  if self.db[key] ~= nil then
    return self:StrToBool(self.db[key])
  end
  return nil
end

function dbloader:GetTable ()
  return self.db
end

function dbloader:Unload ()
  self.db = {}
end

function dbloader:Reload ()
  self.Load()
end

function dbloader:Save ()
  local buf = ""

  for key, value in self.db do
    buf = key.." "..value.."\n"..buf
  end

  --_Msg("---- DEBUG:Save() ----\n")
  --_Msg("self:        "..tostring(self).."\n")
  --_Msg("self.db:     "..tostring(self.db).."\n")
  --_Msg("self.dbname: "..tostring(self.dbname).."\n")
  --_Msg("buf:         "..tostring(buf).."\n")
  --_Msg("---- DEBUG:Save() ----\n")

  _file.Write(self.dbname, buf)
end

function dbloader:SetDB (db)
  self.dbname = db
end

function dbloader:Set (key, value)
  self.db[tostring(key)] = tostring(value)
end

function dbloader:SetTable (tbl)
  for k, v in tbl do
    self.db[tostring(k)] = tostring(v)
  end
end

function dbloader:StrToBool (bool)
  if bool == "true" then return true end
  if bool == "1" then return true end
  return false
end

function dbloader:Unset (key)
  self.db[tostring(key)] = nil
end

function dbloader:GetKeys ()
  local buf = {}
  for k, v in self.db do
    table.insert(buf, k)
  end
  return buf
end
