function gmx.message(players,message,title,where)
	if gmx.isValid(message,"string")==false then return gmx.error("gmx.message - Arguments invalid.") end
	
	local where=where or 0;
	local fullMessage=message.."\n";
	if gmx.isValid(title,"string") then
		fullMessage=title..": "..fullMessage;
	end
	if _IsDedicatedServer()==true and (players==0 or players==-1) then
		_Msg(fullMessage);
	end
	if player~=-1 then
		local dummyFunc=function(player)
							if where==0 or where==2 then
								_PrintMessage(player,HUD_PRINTCONSOLE,fullMessage)
							end
							if where==0 or where==1 then
								_PrintMessage(player,HUD_PRINTTALK,fullMessage)
							end
						end
		gmx.forPlayers(players,dummyFunc);
	end
end

function gmx.makeText(name,users,font,text,x,y,color,waitTime,fadeInTime,displayTime,fadeOutTime,offscreen)
	local n="number";
	if gmx.allValid({name,font,text,x,y,color},{"string","string","string",n,n,"table"})==false then return gmx.error("gmx.makeText - Arguments invalid.") end
	local wait=waitTime or 0;
	local display=displayTime or 9999999;
	local fadeIn=fadeInTime or 0;
	local fadeOut=fadeOutTime or 0;
	local offscreenState=offscreen or false;
	
	_GModText_Start(font);
	 _GModText_SetPos(x/gmx.screenWidth,y/gmx.screenHeight);
	 _GModText_AllowOffscreen(offscreenState);
	 _GModText_SetText(text);
	 _GModText_SetDelay(wait);
	 _GModText_SetTime(display,fadeIn,fadeOut);
	 _GModText_SetColor(color.red,color.green,color.blue,color.alpha);
	if users==0 then
		_GModText_Send(0,gmx.textNameToSlot(name));
	else
		local dummyFunc=function(player)
							_GModText_Send(player,gmx.textNameToSlot(name));
						end
		gmx.forPlayers(users,dummyFunc);
	end
end

function gmx.animText(name,users,x,y,color,animLength,easeFactor,waitTime,offscreen,offset)
	local n="number";
	if gmx.allValid({name,x,y,color},{"string",n,n,"table"})==false then return gmx.error("gmx.animText - Arguments invalid.") end
	if gmx.textNameExists(name)==false then return gmx.error("gmx.animText - Text by name \""..name.."\" doesn't exist.") end
	local wait=waitTime or 0;
	local ease=easeFactor or 0;
	local offscreenState=offscreen or false;
	_GModText_Start("Default");
	 _GModText_AllowOffscreen(offscreenState);
	 _GModText_SetPos(x/gmx.screenWidth,y/gmx.screenHeight);
	 _GModText_SetColor(color.red,color.green,color.blue,color.alpha);
	 _GModText_SetDelay(wait);
	if gmx.isValid(offset) then
	 _GModText_SetEntityOffset(offset);
	end
	if users==0 then
		_GModText_SendAnimate(0,gmx.textNameToSlot(name),animLength,ease);
	else
		local dummyFunc=function(player)
							_GModText_SendAnimate(player,gmx.textNameToSlot(name),animLength,ease);
						end
		gmx.forPlayers(users,dummyFunc);
	end
end

function gmx.makeRect(name,users,material,x,y,width,height,color,waitTime,fadeInTime,displayTime,fadeOutTime)
	local n="number";
	if gmx.allValid({name,material,x,y,width,height,color},{"string","string",n,n,n,n,"table"})==false then return gmx.error("gmx.makeRect - Arguments invalid.") end
	local wait=waitTime or 0;
	local display=displayTime or 9999999;
	local fadeIn=fadeInTime or 0;
	local fadeOut=fadeOutTime or 0;
	
	_GModRect_Start(material);
	 _GModRect_SetPos(x/gmx.screenWidth,y/gmx.screenHeight,width/gmx.screenWidth,height/gmx.screenHeight);
	 _GModRect_SetColor(color.red,color.green,color.blue,color.alpha);
	 _GModRect_SetTime(display,fadeIn,fadeOut);
	 _GModRect_SetDelay(wait);
	if users==0 then
		_GModRect_Send(0,gmx.rectNameToSlot(name));
	else
		local dummyFunc=function(player)
							_GModRect_Send(player,gmx.rectNameToSlot(name));
						end
		gmx.forPlayers(users,dummyFunc);
	end
end

function gmx.makeQuadBox(name,users,material,where,width,length,height,waitTime,fadeInTime,displayTime,fadeOutTime)
	local n="number";
	if gmx.allValid({name,material,where,mode,width,height},{"string","string","userdata",n,n,n})==false then return gmx.error("gmx.makeQuadBox - Arguments invalid.") end
	local wait=waitTime or 0;
	local display=displayTime or 9999999;
	local fadeIn=fadeInTime or 0;
	local fadeOut=fadeOutTime or 0;
	
	local v1=vecAdd(where,vector3(0,0-(width/2),(height/2)));   --Front Side  (Y,2)
	local v2=vecAdd(where,vector3(0,(width/2),(height/2)));     --Back Side   (Y,2)
	local v3=vecAdd(where,vector3(0-(length/2),0,(height/2)));  --Left Side   (X,1)
	local v4=vecAdd(where,vector3((length/2),0,(height/2)));    --Right Side  (X,1)
	local v5=vecAdd(where,vector3(0,0,height));                 --Top Base    (Z,0)
	local v6=where;                                             --Bottom Base (Z,0)
	
	gmx.makeQuadCentered(name.."_side1",users,material,v1,2,length,height,waitTime,fadeInTime,displayTime,fadeOutTime);
	gmx.makeQuadCentered(name.."_side2",users,material,v2,2,length,height,waitTime,fadeInTime,displayTime,fadeOutTime);
	gmx.makeQuadCentered(name.."_side3",users,material,v3,1,width,height,waitTime,fadeInTime,displayTime,fadeOutTime);
	gmx.makeQuadCentered(name.."_side4",users,material,v4,1,width,height,waitTime,fadeInTime,displayTime,fadeOutTime);
	gmx.makeQuadCentered(name.."_side5",users,material,v5,0,length,width,waitTime,fadeInTime,displayTime,fadeOutTime);
	gmx.makeQuadCentered(name.."_side6",users,material,v6,0,length,width,waitTime,fadeInTime,displayTime,fadeOutTime);
end

function gmx.makeQuadCentered(name,users,material,where,mode,width,height,waitTime,fadeInTime,displayTime,fadeOutTime)
	local n="number";
	if gmx.allValid({name,material,where,mode,width,height},{"string","string","userdata",n,n,n})==false then return gmx.error("gmx.makeQuadCentered - Arguments invalid.") end
	local wait=waitTime or 0;
	local display=displayTime or 9999999;
	local fadeIn=fadeInTime or 0;
	local fadeOut=fadeOutTime or 0;
	
	local v1=where;
	local v2=where;
	local v3=where;
	local v4=where;
	
	--Faces Z ([] Ground)
	if mode==0 then
		v1=vecAdd(where,vector3(0-(width/2),(height/2),0));
		v2=vecAdd(where,vector3((width/2),(height/2),0));
		v3=vecAdd(where,vector3((width/2),0-(height/2),0));
		v4=vecAdd(where,vector3(0-(width/2),0-(height/2),0));
	--Faces X (| Wall)
	elseif mode==1 then
		v1=vecAdd(where,vector3(0,0-(width/2),(height/2)));
		v2=vecAdd(where,vector3(0,(width/2),(height/2)));
		v3=vecAdd(where,vector3(0,(width/2),0-(height/2)));
		v4=vecAdd(where,vector3(0,0-(width/2),0-(height/2)));
	--Faces Y (-- Wall)
	elseif mode==2 then
		v1=vecAdd(where,vector3(0-(width/2),0,(height/2)));
		v2=vecAdd(where,vector3((width/2),0,(height/2)));
		v3=vecAdd(where,vector3((width/2),0,0-(height/2)));
		v4=vecAdd(where,vector3(0-(width/2),0,0-(height/2)));
	end
	
	gmx.makeQuad(name,users,material,v1,v2,v3,v4,wait,fadeIn,display,fadeOut);
end

function gmx.makeQuad(name,users,material,v1,v2,v3,v4,waitTime,fadeInTime,displayTime,fadeOutTime)
	local n="number";
	if gmx.allValid({name,material,v1,v2,v3,v4},{"string","string","userdata","userdata","userdata","userdata"})==false then return gmx.error("gmx.makeQuad - Arguments invalid.") end
	local wait=waitTime or 0;
	local display=displayTime or 9999999;
	local fadeIn=fadeInTime or 0;
	local fadeOut=fadeOutTime or 0;
	
	_GModQuad_Start(material);
	 _GModQuad_SetVector(0,v1);
	 _GModQuad_SetVector(1,v2);
	 _GModQuad_SetVector(2,v3);
	 _GModQuad_SetVector(3,v4);
	 _GModQuad_SetTimings(wait,fadeIn,display,fadeOut);
	 
	if users==0 then
		_GModQuad_Send(0,gmx.quadNameToSlot(name)); 
	else
		local dummyFunc=function(player)
							_GModQuad_Send(player,gmx.quadNameToSlot(name)); 
						end
		gmx.forPlayers(users,dummyFunc);
	end
end

function gmx.animRect(name,users,x,y,width,height,color,animLength,easeFactor,waitTime,offset)
	local n="number";
	if gmx.allValid({name,x,y,width,height,color},{"string",n,n,n,n,"table"})==false then return gmx.error("gmx.animRect - Arguments invalid.") end
	if gmx.rectNameExists(name)==false then return gmx.error("gmx.animRect - Rect by name \""..name.."\" doesn't exist.") end
	local wait=waitTime or 0;
	local ease=easeFactor or 0;
	
	_GModRect_Start("gmod/white");
	 _GModRect_SetPos(x/gmx.screenWidth,y/gmx.screenHeight,width/gmx.screenWidth,height/gmx.screenHeight);
	 _GModRect_SetColor(color.red,color.green,color.blue,color.alpha);
	 _GModRect_SetDelay(wait);
	if gmx.isValid(offset) then
	 _GModRect_SetEntityOffset(offset);
	end
	if users==0 then
		_GModRect_SendAnimate(0,gmx.rectNameToSlot(name),animLength,ease);
	else
		local dummyFunc=function(player)
							_GModRect_SendAnimate(player,gmx.rectNameToSlot(name),animLength,ease);
						end
		gmx.forPlayers(users,dummyFunc);
	end
end

function gmx.animQuadBox(name,users,where,width,length,height,animLength,easeFactor,waitTime)
	local n="number";
	if gmx.allValid({name,where,width,length,height,animLength},{"string","userdata",n,n,n,n})==false then return gmx.error("gmx.animQuadBox - Arguments invalid.") end
	local wait=waitTime or 0;
	local ease=easeFactor or 0;
	
	local v1=vecAdd(where,vector3(0,0-(width/2),(height/2)));   --Front Side  (Y,2)
	local v2=vecAdd(where,vector3(0,(width/2),(height/2)));     --Back Side   (Y,2)
	local v3=vecAdd(where,vector3(0-(length/2),0,(height/2)));  --Left Side   (X,1)
	local v4=vecAdd(where,vector3((length/2),0,(height/2)));    --Right Side  (X,1)
	local v5=vecAdd(where,vector3(0,0,height));                 --Top Base    (Z,0)
	local v6=where;                                             --Bottom Base (Z,0)
	
	gmx.animQuad(name.."_side1",users,material,v1,2,length,height,waitTime,fadeInTime,displayTime,fadeOutTime);
	gmx.animQuad(name.."_side2",users,material,v2,2,length,height,waitTime,fadeInTime,displayTime,fadeOutTime);
	gmx.animQuad(name.."_side3",users,material,v3,1,width,height,waitTime,fadeInTime,displayTime,fadeOutTime);
	gmx.animQuad(name.."_side4",users,material,v4,1,width,height,waitTime,fadeInTime,displayTime,fadeOutTime);
	gmx.animQuad(name.."_side5",users,material,v5,0,length,width,waitTime,fadeInTime,displayTime,fadeOutTime);
	gmx.animQuad(name.."_side6",users,material,v6,0,length,width,waitTime,fadeInTime,displayTime,fadeOutTime);
end

function gmx.animQuad(name,users,v1,v2,v3,v4,animLength,easeFactor,waitTime)
	local n="number";
	if gmx.allValid({name,where,mode,width,height},{"string","userdata","userdata","userdata","userdata"})==false then return gmx.error("gmx.animQuad - Arguments invalid.") end
	if gmx.quadNameExists(name)==false then return gmx.error("gmx.animQuad - Quad by name \""..name.."\" doesn't exist.") end
	local wait=waitTime or 0;
	local ease=easeFactor or 0;
	
	_GModQuad_Start("gmod/white");
	 _GModQuad_SetVector(0,v1);
	 _GModQuad_SetVector(1,v2);
	 _GModQuad_SetVector(2,v3);
	 _GModQuad_SetVector(3,v4);
	 _GModQuad_SetTimings(wait)
	 
	if users==0 then
		_GModQuad_SendAnimate(0,gmx.quadNameToSlot(name),animLength,ease); 
	else
		local dummyFunc=function(player)
							_GModQuad_SendAnimate(player,gmx.quadNameToSlot(name),animLength,ease);
						end
		gmx.forPlayers(users,dummyFunc);
	end
end

function gmx.animQuadCentered(name,users,where,mode,width,height,animLength,easeFactor,waitTime)
	local n="number";
	if gmx.allValid({name,where,mode,width,height},{"string","userdata",n,n,n})==false then return gmx.error("gmx.animQuadCentered - Arguments invalid.") end
	if gmx.quadNameExists(name)==false then return gmx.error("gmx.animQuadCentered - Quad by name \""..name.."\" doesn't exist.") end
	local wait=waitTime or 0;
	local ease=easeFactor or 0;
	
	local v1=where;
	local v2=where;
	local v3=where;
	local v4=where;
	
	--Faces Z ([] Ground)
	if mode==0 then
		v1=vecAdd(where,vector3(0-(width/2),(height/2),0));
		v2=vecAdd(where,vector3((width/2),(height/2),0));
		v3=vecAdd(where,vector3((width/2),0-(height/2),0));
		v4=vecAdd(where,vector3(0-(width/2),0-(height/2),0));
	--Faces X (| Wall)
	elseif mode==1 then
		v1=vecAdd(where,vector3(0,0-(width/2),(height/2)));
		v2=vecAdd(where,vector3(0,(width/2),(height/2)));
		v3=vecAdd(where,vector3(0,(width/2),0-(height/2)));
		v4=vecAdd(where,vector3(0,0-(width/2),0-(height/2)));
	--Faces Y (-- Wall)
	elseif mode==2 then
		v1=vecAdd(where,vector3(0-(width/2),0,(height/2)));
		v2=vecAdd(where,vector3((width/2),0,(height/2)));
		v3=vecAdd(where,vector3((width/2),0,0-(height/2)));
		v4=vecAdd(where,vector3(0-(width/2),0,0-(height/2)));
	end
	
	gmx.animQuad(name,users,v1,v2,v3,v4,animLength,ease,wait);
end

function gmx.overheadRect(name,users,material,ent,offset,x,y,width,height,color,waitTime,fadeInTime,displayTime,fadeOutTime)
	local n="number";
	if gmx.allValid({name,material,ent,offset,x,y,width,height,color},{"string","string",n,"userdata",n,n,n,n,"table"})==false then return gmx.error("gmx.overheadRect - Arguments invalid.") end
	local wait=waitTime or 0;
	local display=displayTime or 9999999;
	local fadeIn=fadeInTime or 0;
	local fadeOut=fadeOutTime or 0;
	
	_GModRect_Start(material);
	 _GModRect_SetPos(x,y,width/gmx.screenWidth,height/gmx.screenHeight);
	 _GModRect_SetEntity(ent);
	 _GModRect_SetEntityOffset(offset);
	 _GModRect_SetColor(color.red,color.green,color.blue,color.alpha);
	 _GModRect_SetTime(display,fadeIn,fadeOut);
	 _GModRect_SetDelay(wait);
	if users==0 then
		_GModRect_Send(0,gmx.rectNameToSlot(name));
	else
		local dummyFunc=function(player)
							_GModRect_Send(player,gmx.rectNameToSlot(name));
						end
		gmx.forPlayers(users,dummyFunc);
	end
end

function gmx.overheadText(name,users,font,text,ent,offset,x,y,color,waitTime,fadeInTime,displayTime,fadeOutTime,offscreen)
	local n="number";
	if gmx.allValid({name,font,text,ent,offset,x,y,color},{"string","string","string",n,"userdata",n,n,"table"})==false then return gmx.error("gmx.overheadText - Arguments invalid.") end
	local wait=waitTime or 0;
	local display=displayTime or 9999999;
	local fadeIn=fadeInTime or 0;
	local fadeOut=fadeOutTime or 0;
	local offscreenState=offscreen or false;
	
	_GModText_Start(font);
	 _GModText_AllowOffscreen(offscreenState);
	 _GModText_SetEntity(ent);
	 _GModText_SetEntityOffset(offset);
	 _GModText_SetPos(x/gmx.screenWidth,y/gmx.screenHeight);
	 _GModText_SetText(text);
	 _GModText_SetDelay(wait);
	 _GModText_SetTime(display,fadeIn,fadeOut);
	 _GModText_SetColor(color.red,color.green,color.blue,color.alpha);
	if users==0 then
		_GModText_Send(0,gmx.textNameToSlot(name));
	else
		local dummyFunc=function(player)
							_GModText_Send(player,gmx.textNameToSlot(name));
						end
		gmx.forPlayers(users,dummyFunc);
	end
end

function gmx.hideQuadBox(name,users,fadeTime,delay)
	if gmx.isValid(name,"string")==false then return gmx.error("gmx.hideQuadBox - Name invalid.") end
	
	gmx.hideQuad(name.."_side1",users,fadeTime,delay);
	gmx.hideQuad(name.."_side2",users,fadeTime,delay);
	gmx.hideQuad(name.."_side3",users,fadeTime,delay);
	gmx.hideQuad(name.."_side4",users,fadeTime,delay);
	gmx.hideQuad(name.."_side5",users,fadeTime,delay);
	gmx.hideQuad(name.."_side6",users,fadeTime,delay);
end

function gmx.hideQuad(name,users,fadeTime,delay)
	if gmx.isValid(name,"string")==false then return gmx.error("gmx.hideQuad - Name invalid.") end
	if gmx.quadNameExists(name)==false then return gmx.error("gmx.hideQuad - Quad by name \""..name.."\" doesn't exist.") end
	local fade=fadeTime or 0;
	local wait=delay or 0;
	if users==0 then
		_GModQuad_Hide(0,gmx.quadNameToSlot(name),fade,wait);
	else
		local dummyFunc=function(player)
							_GModQuad_Hide(player,gmx.quadNameToSlot(name),fade,wait);
						end
		gmx.forPlayers(users,dummyFunc);
	end
end

function gmx.hideRect(name,users,fadeTime,delay)
	if gmx.isValid(name,"string")==false then return gmx.error("gmx.hideRect - Name invalid.") end
	if gmx.rectNameExists(name)==false then return gmx.error("gmx.hideRect - Rect by name \""..name.."\" doesn't exist.") end
	local fade=fadeTime or 0;
	local wait=delay or 0;
	if users==0 then
		_GModRect_Hide(0,gmx.rectNameToSlot(name),fade,wait);
	else
		local dummyFunc=function(player)
							_GModRect_Hide(player,gmx.rectNameToSlot(name),fade,wait);
						end
		gmx.forPlayers(users,dummyFunc);
	end
end

function gmx.hideText(name,users,fadeTime,delay)
	if gmx.isValid(name,"string")==false then return gmx.error("gmx.hideText - Name invalid.") end
	if gmx.textNameExists(name)==false then return gmx.error("gmx.hideText - Text by name \""..name.."\" doesn't exist.") end
	local fade=fadeTime or 0;
	local wait=delay or 0;
	if users==0 then
		_GModText_Hide(0,gmx.textNameToSlot(name),fade,wait);
	else
		local dummyFunc=function(player)
							_GModText_Hide(player,gmx.textNameToSlot(name),fade,wait);
						end
		gmx.forPlayers(users,dummyFunc);
	end
	
end

function gmx.quadNameExists(name)
	if gmx.isValid(name,"string")==false then return gmx.error("gmx.quadNameExists - Name invalid.") end
	if gmx.quads[name]==nil then
		return false;
	else
		return true;
	end
end

function gmx.rectNameExists(name)
	if gmx.isValid(name,"string")==false then return gmx.error("gmx.rectNameExists - Name invalid.") end
	if gmx.rects[name]==nil then
		return false;
	else
		return true;
	end
end

function gmx.textNameExists(name)
	if gmx.isValid(name,"string")==false then return gmx.error("gmx.textNameExists- Name invalid.") end
	if gmx.text[name]==nil then
		return false;
	else
		return true;
	end
end

function gmx.quadNameToSlot(name)
	if gmx.isValid(name,"string")==false then return gmx.error("gmx.quadNameToSlot - Name invalid.") end
	local slot=gmx.quadCount;
	if gmx.quads[name]==nil then
		gmx.quadCount=gmx.quadCount+1;
		gmx.quads[name]=slot;
	end
	return gmx.quads[name];
end

function gmx.rectNameToSlot(name)
	if gmx.isValid(name,"string")==false then return gmx.error("gmx.rectNameToSlot - Name invalid.") end
	local slot=gmx.rectCount;
	if gmx.rects[name]==nil then
		gmx.rectCount=gmx.rectCount+1;
		gmx.rects[name]=slot;
	end
	return gmx.rects[name];
end

function gmx.textNameToSlot(name)
	if gmx.isValid(name,"string")==false then return gmx.error("gmx.textNameToSlot - Name invalid.") end
	local slot=gmx.textCount;
	if gmx.text[name]==nil then
		gmx.textCount=gmx.textCount+1;
		gmx.text[name]=slot;
	end
	return gmx.text[name];
end