-- This is the base SWEP (Scripted Weapon).

-- DO NOT change this file.

-- When making a new weapon you only need to override what you need.
_OpenScript("copygun_config.lua");
_OpenScript("lib/gmx/init.lua"); -- GMX is needed. I'm using v 1.31, but it should work even with 1.0
think_start = true;

local mode = 1;
local material_for_quad = "RD/BarrierGlow"; -- "RD/BarrierGlow"
local wire_framed = true; -- Creates a wireframe around the quad
local player_shoot_ang1 = vector3(0, 0, 0);
local player_shoot_ang2 = vector3(0, 0, 0);
local quad_pos = vector3(0,0,0.1); -- Anit flicker
local fin_pos = vector3(0,0,0);
local distance = 0.0;
local old_distance = 0.0;
local last_update = 0;
local minsize = 50;
-- ###################
-- ###################

_OpenScript("includes/backcompat.lua");
_OpenScript("includes/vector3.lua");

function getEntity(id)
	_TraceLine(_PlayerGetShootPos(id), _PlayerGetShootAng(id), 16384, id);
	return _TraceGetEnt();
end

	function onThink( )
		if(think_start == true) then
			getEntity(Owner)
			player_shoot_ang2 = _PlayerGetShootAng(Owner);
			player_shoot_ang1 = _PlayerGetShootAng(Owner);
			if(quad_pos ~= vector3(0,0,0)) then
				create_quad();
			end
			--Autogive the player the CopyGun, cause it is needed!
			if(_PlayerHasWeapon(Owner, "tool_lua_groupcopy") == false) then
				-- Auto give the CopyGun!
				_PlayerGiveSWEP(Owner,"weapons/Tools/CopyGun.lua");
			end
			updateHudText();
			_RunString("CallQuadStatus(".._EntGetParent(MyIndex)..",\""..fin_pos.x.." "..fin_pos.y.." "..fin_pos.z.."\",true)");
			think_start = false;
		end
		if(mode > 1 and quad_pos ~= vector3(0,0,0)) then
			if(last_update >= 4) then
			getEntity(Owner);
			player_shoot_ang2 = _PlayerGetShootAng(Owner);
			-- But dont affect the Z vector!
			distance = math.abs(math.acos(vecDotProduct(player_shoot_ang1,player_shoot_ang2)))*1000 + minsize/1.42;
			if(string.gsub(tostring(math.ceil(distance)),"[0-9]*","") ~= "") then
				distance = minsize/1.42;
			end
			if(distance ~= old_distance) then
				old_distance = distance;
				if(mode == 2) then
					fin_pos = vector3(distance,minsize/1.42,minsize/1.42);
				elseif(mode == 3) then
					fin_pos = vector3(fin_pos.x,distance,minsize/1.42);
				else
					fin_pos = vector3(fin_pos.x,fin_pos.y,distance);
				end
				create_quad()
			end
			last_update = 0;
			else
				last_update = last_update + 1;
			end
		end
	end

	function updateHudText()
		if(Owner ~= 0) then
			-- Tell ppl how to remove pattern
			_GModText_Start("CloseCaption_Bold");
			_GModText_SetPos(0, 1);
			_GModText_SetColor( 255, 255, 255, 255 );
			_GModText_SetTime( 99999, 0, 0 );
			_GModText_SetText( "Primary: Seize width/length/height" );
			_GModText_SetDelay( 0 );
			_GModText_Send( Owner, 200);
			_GModText_Start("CloseCaption_Bold");
			
			_GModText_SetPos(1, 1);
			_GModText_SetColor( 255, 255, 255, 255 );
			_GModText_SetTime( 99999, 0, 0 );
			_GModText_SetText( "Secondary: Select Props" );
			_GModText_SetDelay( 0 );
			_GModText_Send( Owner, 201);
			
			_GModText_Start("CloseCaption_Bold");
			_GModText_SetPos(0.1, 0.15);
			_GModText_SetColor( 0, 255, 0, 200 );
			_GModText_SetTime( 99999, 0, 0 );
			_GModText_SetText( "Press RELOAD to reset a Quad" );
			_GModText_SetDelay( 0 );
			_GModText_Send( Owner, 102);
		end
	end
	
	function clearHudText()
		_GModText_Hide( Owner, 102);
		_GModText_Hide( Owner, 200);
		_GModText_Hide( Owner, 201);
		_GModText_Hide(Owner, 303)
		_GModRect_Hide(Owner, 301)
	end

	function onDrop( playerid )
		delete_quad();
		clearHudText();
	    _EntRemove( MyIndex );
	end 


function onReload()
	mode = 1;
	player_shoot_ang1 = vector3(0, 0, 0);
	player_shoot_ang2 = vector3(0, 0, 0);
	quad_pos = vector3(0,0,0);
	distance = 0.0;
	delete_quad()
	_RunString("CallQuadStatus(".._EntGetParent(MyIndex)..",\""..fin_pos.x.." "..fin_pos.y.." "..fin_pos.z.."\")");
	return true;
end


function onInit()
	_SWEPSetSound(MyIndex, "single_shot", "Weapon_USP.SilencedShot")
	if(gmx == nil) then
		ErrorNoGmx(Owner);
		_EntRemove(MyIndex);
	end
end

function onPrimaryAttack()
	if (not _PlayerInfo(Owner, "alive")) then return; end

	local entityid = getEntity(Owner);

	if (entityid) then
		player_shoot_ang1 = _PlayerGetShootAng(Owner);
		player_shoot_ang2 = _PlayerGetShootAng(Owner);
		if (mode == 1) then
			quad_pos = _TraceEndPos();
			quad_pos.z = quad_pos.z + 0.1 -- FlickerBug
			fin_pos = vector3(minsize/1.42,minsize/1.42,minsize/1.42);
			mode = 2;
			create_quad()
		elseif (mode == 2) then
			mode = 3
		elseif(mode == 3) then
			mode = 4
		else
			mode = 1;
			-- Dont affect Z vector
			distance = vecLength(vecSub(player_shoot_ang1,player_shoot_ang2));
			create_quad()
			-- Not needed anymore - Just for debug actions!
			_GModText_Start("ImpactMassive");
			_GModText_SetPos(0.7, 0.15);
			_GModText_SetColor(255, 0, 0, 200);
			_GModText_SetTime(3, 0.5, 0.5);
			--_GModText_SetText("Radius: " ..math.ceil(distance));
			_GModText_SetText("Quad created!");
			_GModText_Send(Owner, Owner);
			--[[
			_EffectInit();
			_EffectSetEnt(Owner);
			_EffectSetStart(quad_pos);
			_EffectSetOrigin(vecAdd(vector3(fin_pos.x*0.75,fin_pos.y*0.75,fin_pos.z*2*0.75),quad_pos));
			_EffectSetScale(50);
			_EffectSetMagnitude(3);
			_EffectDispatch("FadingLineTeam");
			--]]
		end
		_RunString("CallQuadStatus(".._EntGetParent(MyIndex)..",\""..fin_pos.x.." "..fin_pos.y.." "..fin_pos.z.."\")");
	end
end

function create_quad()
	gmx.makeQuadBox("quad_box"..Owner,0,material_for_quad,quad_pos,fin_pos.y*1.42,fin_pos.x*1.42,fin_pos.z*1.42,0,0,99999,0)
	if(wire_framed == true) then
		-- Create additionally a wireframe around it
		gmx.makeQuadBox("quad_wireframe"..Owner,0,"gmod/Wireframe",quad_pos,fin_pos.y*1.42,fin_pos.x*1.42,fin_pos.z*1.42,0,0,99999,0)
	end
end

function delete_quad()
	gmx.hideQuadBox("quad_wireframe"..Owner,0)
	gmx.hideQuadBox("quad_box"..Owner,0)
end
function onSecondaryAttack()
	if(quad_pos ~= vector3(0,0,0)) then
		_RunString("CallSphereSelect(\"".. quad_pos.x .." ".. quad_pos.y .." ".. quad_pos.z .."\",\""..fin_pos.x.." "..fin_pos.y.." "..fin_pos.z.."\",".._EntGetParent(MyIndex)..",true)");
		_RunString("CallQuadStatus(".._EntGetParent(MyIndex)..",\""..fin_pos.x.." "..fin_pos.y.." "..fin_pos.z.."\")");
	end
end

	function clear_sphere_status()
		delete_quad()
		_GModText_Hide(Owner, 303)
		_GModRect_Hide(Owner, 301)
	end
	
	function Deploy( )
		_RunString("CallQuadStatus(".._EntGetParent(MyIndex)..",\""..fin_pos.x.." "..fin_pos.y.." "..fin_pos.z.."\",true)");
		updateHudText();
		think_start = true;
	end
	
	function Holster( )
		clear_sphere_status();
		clearHudText();
		think_start = true;
	end
	
-- ===========================================
-- 							Basic Weapon Settings
-- ===========================================

-- These are only accessed once when setting up the weapon
	function getWeaponSwapHands()
		return false;	
	end
	function getWeaponFOV()
		return 70;	
	end
	function getWeaponSlot()
		return 5;	
	end
	function getWeaponSlotPos()
		return 8;	
	end
	function getFiresUnderwater()
		return true;
	end
	function getReloadsSingly()
		return false;
	end
	-- Primary Attack
	function getDamage()
		return 10;
	end
	function getPrimaryShotDelay()
		return 0.1;
	end
	function getPrimaryIsAutomatic()
		return false;
	end
	function getBulletSpread()
		return vector3( 0.0, 0.0, 0.0 );
	end
	function getViewKick()
		return vector3( 0.0, 0.0, 0.0);
	end
	function getViewKickRandom()
		return vector3( 0, 0, 0 );
	end
	function getNumShotsPrimary()
		return 1;
	end
	function getPrimaryAmmoType()
		return "pistol";
	end
	-- Secondary attack
	function getDamageSecondary()
		return 10;
	end
	function getSecondaryShotDelay()
		return 0.2;
	end
	function getSecondaryIsAutomatic()
		return false;
	end
	function getBulletSpreadSecondary()
		return vector3( 0.0, 0.0, 0.0 );
	end
	function getViewKickSecondary()
		return vector3( 0.0, 0.0, 0.0);
	end
	function getViewKickRandomSecondary()
		return vector3( 0, 0, 0 );
	end
	function getNumShotsSecondary()
		return 1;
	end
	function getSecondaryAmmoType()
		return "pistol";
	end
	function getViewModel( )
		return "models/weapons/v_crossbow.mdl";
	end
	function getWorldModel( )
		return "models/weapons/w_crossbow.mdl";
	end
	function getClassName() 
		return "tool_lua_groupcopy_quadselector";
	end
	function getHUDMaterial( )
		return "gmod/SWEP/default";
	end
	function getMaxClipPrimary() -- return -1 if it doesn't use clips
		return 25;
	end
	function getMaxClipSecondary() -- return -1 if it doesn't use clips
		return -1;
	end
	function getDefClipPrimary() -- ammo in gun by default
		return 25;
	end
	function getDefClipSecondary()
		return 0;
	end
	function getAnimPrefix() -- How the player holds the weapon: pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade
		return "crossbow";
	end
	function getPrintName()
		return "~[Group Copy Quad Selector]~";
	end
	-- 0 = Don't override, shoot bullets, make sound and flash
	-- 1 = Don't shoot bullets but do make flash/sounds
	-- 2 = Only play animations
	-- 3 = Don't do anything
	function getPrimaryScriptOverride()
		return 1;
	end
	function getSecondaryScriptOverride()
		return 1;
	end
	