-- This is the base SWEP (Scripted Weapon).

-- DO NOT change this file.

-- When making a new weapon you only need to override what you need.

_OpenScript("copygun_config.lua");
_OpenScript("lib/gmx/init.lua"); -- GMX is needed. I'm using v 1.31, but it should work even with 1.0 (i think, gmx.explode was included there too. I just need the explode function)!

think_start = true;

local mode = 1;
local position1 = vector3(0, 0, 0);
local position2 = vector3(0, 0, 0);
local distance = 0.0;
-- ###################
-- ###################

_OpenScript("includes/backcompat.lua");
_OpenScript("includes/vector3.lua");

	function getEntity(id)
		_TraceLine(_PlayerGetShootPos(id), _PlayerGetShootAng(id), 16384, id);
		return _TraceGetEnt();
	end

	function onThink( )
		if(think_start == true) then
			if(distance ~= 0) then
				create_sphere();
			end
			--Autogive the player the CopyGun, cause it is needed!
			if(_PlayerHasWeapon(Owner, "tool_lua_groupcopy") == false) then
				-- Auto give the CopyGun!
				_PlayerGiveSWEP(Owner,"weapons/Tools/CopyGun.lua");
			end
			updateHudText();
			_RunString("CallSphereStatus(".._EntGetParent(MyIndex)..",".. distance ..",true)");
			think_start = false;
		end
	end

	function updateHudText()
		if(Owner ~= 0) then
			-- Tell ppl how to remove pattern
			_GModText_Start("CloseCaption_Bold");
			_GModText_SetPos(0, 1);
			_GModText_SetColor( 255, 255, 255, 255 );
			_GModText_SetTime( 99999, 0, 0 );
			_GModText_SetText( "Primary: Create Range" );
			_GModText_SetDelay( 0 );
			_GModText_Send( Owner, 200);
			_GModText_Start("CloseCaption_Bold");
			
			_GModText_SetPos(1, 1);
			_GModText_SetColor( 255, 255, 255, 255 );
			_GModText_SetTime( 99999, 0, 0 );
			_GModText_SetText( "Secondary: Select Props" );
			_GModText_SetDelay( 0 );
			_GModText_Send( Owner, 201);
			
			_GModText_Start("CloseCaption_Bold");
			_GModText_SetPos(0.1, 0.15);
			_GModText_SetColor( 0, 255, 0, 200 );
			_GModText_SetTime( 99999, 0, 0 );
			_GModText_SetText( "Press RELOAD to reset the SelectionRadius" );
			_GModText_SetDelay( 0 );
			_GModText_Send( Owner, 102);
		end
	end
	
	function clearHudText()
		_GModText_Hide( Owner, 102);
		_GModText_Hide( Owner, 200);
		_GModText_Hide( Owner, 201);
		_GModText_Hide(Owner, 303)
		_GModRect_Hide(Owner, 301)
	end

	




function onReload()
	mode = 1;
	position1 = vector3(0, 0, 0);
	position2 = vector3(0, 0, 0);
	distance = 0.0;
	delete_sphere()
	_RunString("CallSphereStatus(".._EntGetParent(MyIndex)..","..distance..")");
	return true;
end

function onInit()
	_SWEPSetSound(MyIndex, "single_shot", "Weapon_USP.SilencedShot")
	if(gmx == nil) then
		ErrorNoGmx(Owner);
		_EntRemove(MyIndex);
	end
end

function onPrimaryAttack()
	if (not _PlayerInfo(Owner, "alive")) then return; end

	local entityid = getEntity(Owner);

	if (entityid) then
		if (mode == 1) then
			delete_sphere()
			position1 = _TraceEndPos();
			mode = 2;
			_GModText_Start("ImpactMassive");
			_GModText_SetPos(0.7, 0.15);
			_GModText_SetColor(255, 0, 0, 200);
			_GModText_SetTime(3, 0.5, 0.5);
			_GModText_SetText("Sphere Middlepoint created");
			_GModText_Send(Owner, Owner);
		else
			position2 = _TraceEndPos();
			mode = 1;
			distance = vecLength(vecSub(position1,position2));

			_GModText_Start("ImpactMassive");
			_GModText_SetPos(0.7, 0.15);
			_GModText_SetColor(255, 0, 0, 200);
			_GModText_SetTime(3, 0.5, 0.5);
			_GModText_SetText("Radius: " ..math.ceil(distance));
			_GModText_Send(Owner, Owner);

			_EffectInit();
			_EffectSetEnt(Owner);
			_EffectSetStart(position1);
			_EffectSetOrigin(position2);
			_EffectSetScale(50);
			_EffectSetMagnitude(3);
			_EffectDispatch("FadingLineTeam");
			create_sphere()
			_RunString("CallSphereStatus(".._EntGetParent(MyIndex)..","..distance..")")
		end
	end
end

function create_sphere()
	Sprite = _EntCreate("env_sprite");
	_EntSetPos(Sprite, position1);
	_EntSetName(Sprite, "Sphere_Select");
	_EntSetKeyValue(Sprite, "spawnflags", "1");
	_EntSetKeyValue(Sprite, "model", "sprites/blueglow1.vmt");
	local newScale = math.ceil(distance/35)
	_EntSetKeyValue(Sprite, "scale", newScale);
	_EntSetKeyValue(Sprite, "rendermode", "5");
	_EntSetKeyValue(Sprite, "rendercolor", "0 0 255");
	_EntSpawn(Sprite);
end

function delete_sphere()
	if(_EntExists(Sprite) == true) then
		if(_EntGetName(Sprite) == "Sphere_Select") then
			_EntFire(Sprite,"kill","",0);
		end
	end
end
function onSecondaryAttack()
	if(distance > 0) then
		_RunString("CallSphereSelect(\"".. position1.x .." ".. position1.y .." ".. position1.z .."\","..distance..",".._EntGetParent(MyIndex)..")");
		_RunString("CallSphereStatus(".._EntGetParent(MyIndex)..","..distance..")");
		delete_sphere()
	end
end

	function clear_sphere_status()
		delete_sphere()
		_GModText_Hide(Owner, 303)
		_GModRect_Hide(Owner, 301)
	end
	
	function Deploy( )
		_RunString("CallSphereStatus(".._EntGetParent(MyIndex)..","..distance..")");
		updateHudText();
		think_start = true;
	end
	
	function Holster( )
		clear_sphere_status();
		clearHudText();
		think_start = true;
	end
	
	function onDrop( playerid )
		clear_sphere_status();
		clearHudText();
	    _EntRemove( MyIndex );
	end 
	
-- ===========================================
-- 							Basic Weapon Settings
-- ===========================================

-- These are only accessed once when setting up the weapon
	function getWeaponSwapHands()
		return false;	
	end
	function getWeaponFOV()
		return 70;	
	end
	function getWeaponSlot()
		return 5;	
	end
	function getWeaponSlotPos()
		return 10;	
	end
	function getFiresUnderwater()
		return true;
	end
	function getReloadsSingly()
		return false;
	end
	-- Primary Attack
	function getDamage()
		return 10;
	end
	function getPrimaryShotDelay()
		return 0.1;
	end
	function getPrimaryIsAutomatic()
		return false;
	end
	function getBulletSpread()
		return vector3( 0.0, 0.0, 0.0 );
	end
	function getViewKick()
		return vector3( 0.0, 0.0, 0.0);
	end
	function getViewKickRandom()
		return vector3( 0, 0, 0 );
	end
	function getNumShotsPrimary()
		return 1;
	end
	function getPrimaryAmmoType()
		return "pistol";
	end
	-- Secondary attack
	function getDamageSecondary()
		return 10;
	end
	function getSecondaryShotDelay()
		return 0.2;
	end
	function getSecondaryIsAutomatic()
		return false;
	end
	function getBulletSpreadSecondary()
		return vector3( 0.0, 0.0, 0.0 );
	end
	function getViewKickSecondary()
		return vector3( 0.0, 0.0, 0.0);
	end
	function getViewKickRandomSecondary()
		return vector3( 0, 0, 0 );
	end
	function getNumShotsSecondary()
		return 1;
	end
	function getSecondaryAmmoType()
		return "pistol";
	end
	function getViewModel( )
		return "models/weapons/v_crossbow.mdl";
	end
	function getWorldModel( )
		return "models/weapons/w_crossbow.mdl";
	end
	function getClassName() 
		return "tool_lua_groupcopy_sphereselector";
	end
	function getHUDMaterial( )
		return "gmod/SWEP/default";
	end
	function getMaxClipPrimary() -- return -1 if it doesn't use clips
		return 25;
	end
	function getMaxClipSecondary() -- return -1 if it doesn't use clips
		return -1;
	end
	function getDefClipPrimary() -- ammo in gun by default
		return 25;
	end
	function getDefClipSecondary()
		return 0;
	end
	function getAnimPrefix() -- How the player holds the weapon: pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade
		return "crossbow";
	end
	function getPrintName()
		return "~[Group Copy Sphere Selector]~";
	end
	-- 0 = Don't override, shoot bullets, make sound and flash
	-- 1 = Don't shoot bullets but do make flash/sounds
	-- 2 = Only play animations
	-- 3 = Don't do anything
	function getPrimaryScriptOverride()
		return 1;
	end
	function getSecondaryScriptOverride()
		return 1;
	end
	