-- This is the base SWEP (Scripted Weapon).

-- DO NOT change this file.

-- When making a new weapon you only need to override what you need.




_OpenScript( "includes/defines.lua" );
_OpenScript( "includes/vector3.lua" );
_OpenScript("copygun_config.lua");
_OpenScript("lib/gmx/init.lua"); -- GMX is needed. I'm using v 1.31, but it should work even with 1.0 (i think, gmx.explode was included there too. I just need the explode function)!




-- These variables are passed by the engine



MyIndex			=	0; -- Weapon's entity index.

Owner			= 	0; -- The player that owns this weapon

CurrentTime		=	0; -- The current game time
think_start = true;

iStage = 1;
select1 = nil;
select2 = nil;

rangechangetimerwait=20
rangechangetimer=0





-- Called when the weapon is created.

	function onInit( )
		--_SWEPSetSound(MyIndex, "single_shot", "Weapon_357.Single")
		_SWEPSetSound(MyIndex, "single_shot", "Weapon_USP.SilencedShot")
		if(gmx == nil) then
			ErrorNoGmx(Owner);
			_EntRemove(MyIndex);
		end
	end



	function onDrop( playerid )
		clearHudText()
		_EntRemove( MyIndex );
	end 

-- Called every frame

	function onThink( )
		if(think_start == true) then
			--Autogive the player the CopyGun, cause it is needed!
			if(_PlayerHasWeapon(Owner, "tool_lua_groupcopy") == false) then
				-- Auto give the CopyGun!
				_PlayerGiveSWEP(Owner,"weapons/Tools/CopyGun.lua");
			end
			updateHudText();
			_RunString("CallWelderStatus(".._EntGetParent(MyIndex)..",\"yes\")");
			think_start = false;
		end
	    if(rangechangetimer>0) then
		 	rangechangetimer=rangechangetimer-1
		end
	end

	function updateHudText()
		if(Owner ~= 0) then
			-- Tell ppl how to remove pattern
			_GModText_Start("CloseCaption_Bold");
			_GModText_SetPos(0, 1);
			_GModText_SetColor( 255, 255, 255, 255 );
			_GModText_SetTime( 99999, 0, 0 );
			_GModText_SetText( "Primary: Weld" );
			_GModText_SetDelay( 0 );
			_GModText_Send( Owner, 200);
			_GModText_Start("CloseCaption_Bold");
			
			_GModText_SetPos(1, 1);
			_GModText_SetColor( 255, 255, 255, 255 );
			_GModText_SetTime( 99999, 0, 0 );
			_GModText_SetText( "Secondary: SmartWeld" );
			_GModText_SetDelay( 0 );
			_GModText_Send( Owner, 201);
			
			_GModText_Start("CloseCaption_Bold");
			_GModText_SetPos(0.1, 0.15);
			_GModText_SetColor( 0, 255, 0, 200 );
			_GModText_SetTime( 99999, 0, 0 );
			_GModText_SetText( "Press RELOAD to change the SmartWeld radius" );
			_GModText_SetDelay( 0 );
			_GModText_Send( Owner, 102);
		end
	end
	
	function clearHudText()
		_GModText_Hide( Owner, 102);
		_GModText_Hide( Owner, 200);
		_GModText_Hide( Owner, 201);
		_GModText_Hide(Owner, 303)
		_GModRect_Hide(Owner, 301)
	end

	

-- When the player presses left mouse button

	function onPrimaryAttack( )	
		_TraceLine(_PlayerGetShootPos(Owner), _PlayerGetShootAng(Owner), 32768, Owner);
		if _TraceHitNonWorld() then
			local vHit = _TraceEndPos();
			--local vecpos = _PlayerGetShootPos( Owner );
			--[[
			_EffectInit();
			_EffectSetOrigin(vHit);
			_EffectSetRadius(2);
			_EffectDispatch("AirboatGunImpact");
			]]
			_EffectInit();
			_EffectSetEnt( Owner );
			_EffectSetOrigin( vHit );
			--_EffectSetStart( vecpos );
			_EffectSetScale( 200 );
			_EffectSetMagnitude( 500 );
			_EffectDispatch( "AR2Impact" );
			local selEnt = _TraceGetEnt();
			if iStage == 1 then
				select1 = selEnt;
				iStage = 2;
			elseif iStage == 2 then
				select2 = selEnt;
				iStage = 1;
				_RunString("CallAddWeld("..select1..", "..select2..", ".._EntGetParent(MyIndex)..")");
				--_Msg("Welder Gun dispatched "..select1.." "..select2.." ".._EntGetParent(MyIndex).."\n");
				select1 = nil;
				select2 = nil;
			end
		end
	end

	

-- When the player presses right mouse button

	function onSecondaryAttack( )
		_RunString("CallTotalWeld(".._EntGetParent(MyIndex)..")");
		_GModText_Start("CloseCaption_Bold")
		_GModText_SetPos(0.3, -1);
		_GModText_SetTime( 3, 0, 2 );
		_GModText_SetColor( 255, 255, 255, 255 );
		_GModText_SetText( "Smart Weld successfull" );
		_GModText_SetDelay( 0 );
		_GModText_Send( Owner, 400 );
		return true;
	end



	function Deploy( )
		updateHudText()
		think_start = true;
	end
	
	function Holster( )
		iStage = 1;
		select1 = nil;
		select2 = nil;
		clearHudText();
		think_start = true;
	end
	

-- When player presses reload. Returning false means DONT RELOAD. Although this will hitch on the client.

	function onReload( )

		if(rangechangetimer==0) then
		
        	_RunString("CallRangeChange(".._EntGetParent(MyIndex)..")");
			rangechangetimer=rangechangetimerwait
        end

		return true;

	end

	



-- These are only accessed once when setting up the weapon

	

	function getWeaponSwapHands()

		return false;	

	end

	

	function getWeaponFOV()

		return 70;	

	end

	

	function getWeaponSlot()

		return 5;	

	end

	

	function getWeaponSlotPos()

		return 9;	

	end

	

	function getFiresUnderwater()

		return true;

	end

	

	function getReloadsSingly()

		return false;

	end

	



	

	-- Primary Attack

	

	function getDamage()

		return 00;

	end

	

	function getPrimaryShotDelay()

		return 0.1;

	end

		

	function getPrimaryIsAutomatic()

		return true;

	end

			

	function getBulletSpread()

		return vector3( 0.0, 0.0, 0.0 );

	end

	

	function getViewKick()

		return vector3( 0, 0.0, 0.0);

	end

	

	function getViewKickRandom()

		return vector3( 0, 0, 0 );

	end

		

	function getNumShotsPrimary()

		return 1;

	end

	

	function getPrimaryAmmoType()

		return "pistol";

	end

	

	-- Secondary attack

	

	function getDamageSecondary()

		return 00;

	end

	

	function getSecondaryShotDelay()

		return 0.3;

	end

	

	function getSecondaryIsAutomatic()

		return false;

	end

	

	function getBulletSpreadSecondary()

		return vector3( 0.0, 0.0, 0.0 );

	end

	

	function getViewKickSecondary()

		return vector3( 0.0, 0.0, 0.0);

	end

	

	function getViewKickRandomSecondary()

		return vector3( 0.0, 0.0, 0.0 );

	end

	

	function getNumShotsSecondary()

		return 1;

	end

	

	function getSecondaryAmmoType()

		return "pistol";

	end

	

	



	function getViewModel( )

		return "models/weapons/v_crossbow.mdl";

	end

	

	function getWorldModel( )

		return "models/weapons/w_crossbow.mdl";

	end

	

	function getClassName() 

		return "tool_lua_groupcopy_welder";

	end



	function getHUDMaterial( )

		return "gmod/SWEP/default";

	end





		



	

	function getMaxClipPrimary() -- return -1 if it doesn't use clips

		return 25;

	end

	

	function getMaxClipSecondary() -- return -1 if it doesn't use clips

		return -1;

	end

	

	function getDefClipPrimary() -- ammo in gun by default

		return 25;

	end

	

	function getDefClipSecondary()

		return 0;

	end



	

	function getAnimPrefix() -- How the player holds the weapon: pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade

		return "crossbow";

	end



	function getPrintName()

		return "~[Group Copy Welder]~";

	end

	

	

	-- 0 = Don't override, shoot bullets, make sound and flash

	-- 1 = Don't shoot bullets but do make flash/sounds

	-- 2 = Only play animations

	-- 3 = Don't do anything

	

	function getPrimaryScriptOverride()

		return 1;

	end



	function getSecondaryScriptOverride()

		return 1;

	end



