if(dbloader == nil) then
	_Msg("[Enhanced CopyGun] ERROR: DBLoader not started yet!\n")
	_Msg("[Enhanced CopyGun] Trying to load gmod9/lua/dbloader.lua\n")
	_OpenScript("dbloader.lua")
end
if(dbloader ~= nil) then
	_OpenScript("copygun_config.lua");
	_Msg("[Enhanced CopyGun] Script loaded succesfully!\n")
	-- DB loader define
	patterns = dbloader:New("copygun_patterns.db")
	patterns:Load()
	users = dbloader:New("copygun_users.db")
	users:Load()
	delete = dbloader:New("copygun_delete.db")
	delete:Load()
	public = dbloader:New("copygun_public.db")
	public:Load()
	
	_OpenScript("includes/player.lua")
	_OpenScript("admins.txt")
	--_OpenScript("vip.txt")
	
	-- Forbidden chars, which aren't allowed because of Filesystem limitation and ftp transactions (synchronizing etc). Get replacec by emty space ""
	forbidden_chars = {"","","","$","&","/","?","`","\\","{","}","","#",":","|","<",">"}
	IDTable = {}
	CurGivePlayer = 1;
	del_pattern_user = {}
	
	function cgPlayerSay(PID, strText)
		local strCompare = string.lower(strText);
		local saveStart, saveEnd  = string.find(strCompare, "-cgsave ", 1, true);
		local loadStart, loadEnd  = string.find(strCompare, "-cgload ", 1, true);
		local rotStart, rotEnd  = string.find(strCompare, "-cgrot ", 1, true);
		local frozenStart, frozenEnd  = string.find(strCompare, "-cgfrozen ", 1, true);
		local dynafrozenStart, dynafrozenEnd  = string.find(strCompare, "-cgdynafrozen ", 1, true);
		local npcStart, npcEnd  = string.find(strCompare, "-cgnpcweapon ", 1, true);
		local previewStart, previewEnd  = string.find(strCompare, "-cgpreview ", 1, true);
		local user_names_check = {}
		if (saveEnd ~= nil) and _PlayerHasWeapon(PID, "tool_lua_groupcopy") then
			-- " " replace, because dbloader doesn't support spaces in keys.
			local fileName = string.gsub(string.sub(strText, saveEnd + 1)," ","_");
			-- Replace forbidden strings now
			for forbidden_charsk,forbidden_charsv in forbidden_chars do
				fileName = string.gsub(fileName,forbidden_charsv,"");
			end
			_Msg("[Enhanced CopyGun] Saved As \""..fileName..".cgs\" by player ID "..PID.."\n");
			local runstring = "doFileSave(\""..fileName.."\")";
			_SWEPRunString(GetWeapByPlayer(PID), runstring);
			-- Create new Index in the Pattern DB and Users DB - But just put this to their List, when th PublicDB isnt set to true
			user_names_check = users:GetTable();
			patterns:Load();
			-- Dont overtake stuff
			file_names = patterns:GetTable();
			file_names = table_all_lower(file_names);
			if(file_names[string.lower(fileName)] == nil) then
				patterns:Set(string.lower(fileName),string.lower(_PlayerInfo(PID,"networkid"))) -- Save the Steamid to the filename
				patterns:Save()
				--[[
				-- Check first, if the user ever saved as an VIP stuff to his list. If yes, save all To his list now instead of public!
				if(isAdmin(PID) == false and isVip(PID) == false and user_names_check[string.lower(_PlayerInfo(PID,"networkid"))] == nil) then
					-- Save the pattern to public list - so, make an entry into PublicDB - No pattern with PublicDB entry will be set to the list except its removed from the pub list (then, it will be on a players list!)
					-- Just save now the Username - The user was never a friend/vip/admin on the server - so, he isn't recognized
					public:Set(string.lower(fileName),string.lower(_PlayerInfo(PID,"networkid")).." ( ".._PlayerInfo(PID,"name").." )");
					public:Save();
				else
				--]]
					-- Player was an VIP/Friend/Admin on the server. Any new pattern from him will set to his list instead of Publist, even when he is just a guest
					users:Set(string.lower(_PlayerInfo(PID,"networkid")),_PlayerInfo(PID,"name")) -- Save the nickname to the steamid
					users:Save()
				--end
				RefreshSpawnMenu(PID) -- Juts update for the user to reduce lags
			end
			return strText;
		elseif (loadEnd ~= nil) then
			if(del_pattern_user[PID] == true) then
				fileName = string.sub(strText, loadEnd + 1);
				_GModText_Hide(PID, 97)
				_GModRect_Hide(PID, 405, 0, 0)
				
				_GModText_Start("CloseCaption_Bold")
				_GModText_SetPos(0.23, 0.40)
				_GModText_SetColor( 255, 255, 255, 200 )
				_GModText_SetTime( 3, 0, 0 )
				if(isAdmin(PID) == true) then
					-- Admins can delete all Patterns
					--patterns:Unset(string.lower(fileName)); -- Don't unset anymore, cause we have an "Optimise Database Engine"
					delete:Set(string.lower(fileName),_PlayerInfo(PID,"name").." "..string.upper(_PlayerInfo(PID,"networkid"))) -- Save the Steamid to the filename
					--public:Unset(string.lower(fileName));
					--public:Save();
					--patterns:Save();
					delete:Save();
					_GModText_SetText( "Pattern set to the deletion list");
					del_pattern_user[PID] = nil
				else
					--if(isVip(PID) == true) then
					-- VIP is the owner of the Pattern => Allow deletion
					file_names = patterns:GetTable();
					file_names = table_all_lower(file_names);
					if(file_names[string.lower(fileName)] == string.lower(_PlayerInfo(PID,"networkid"))) then
						--patterns:Unset(string.lower(fileName)); -- Don't unset anymore, cause we have an "Optimise Database Engine"
						--public:Unset(string.lower(fileName));
						delete:Set(string.lower(fileName),"Deleted by: ".._PlayerInfo(PID,"name").." "..string.upper(_PlayerInfo(PID,"networkid"))) -- Save the Steamid to the filename
						delete:Save();
						--patterns:Save();
						--public:Save();
						del_pattern_user[PID] = nil
						_GModText_SetText( "Pattern set to the deletion list - An admin will remove it permanently soon");
					else
						_GModText_SetText( "You can just delete your own patterns");
					end
					--end
				end
				_GModText_Send( PID, 99);
				cg_message_rect(PID,3)
				cc_refreshmenu(PID)
				return "";
			end
			if(_PlayerHasWeapon(PID, "tool_lua_groupcopy") == false) then
				-- Auto give the CopyGun!
				_PlayerGiveSWEP(PID,"weapons/Tools/CopyGun.lua");
			else
				local fileName = string.sub(strText, loadEnd + 1);
				--[[
					if(isAdmin(PID) == true or isVip(PID) == true) then
						_Msg("[Enhanced CopyGun] Loading \""..fileName..".cgs\" for player ID "..PID.."\n");
						local runstring = "doFileLoad(\""..fileName.."\")";
						_SWEPRunString(GetWeapByPlayer(PID), runstring);
						return strText;
					else
					-- No VIP, but a public pattern or their patterns, which they saves a Friend
					public_patterns = public:GetTable();
					public_patterns = table_all_lower(public_patterns);
					file_names = patterns:GetTable();
					file_names = table_all_lower(file_names);
					if(file_names[string.lower(fileName)] == nil or file_names[string.lower(fileName)] == string.lower(_PlayerInfo(PID,"networkid")) or public_patterns[string.lower(fileName)] ~= nil) then
					--]]
					_Msg("[Enhanced CopyGun] Loading \""..fileName..".cgs\" for player ID "..PID.."\n");
					local runstring = "doFileLoad(\""..fileName.."\")";
					_SWEPRunString(GetWeapByPlayer(PID), runstring);
					return strText;
					--[[
					else
						announce_is_no_vip(PID)
						return "";
					end
					
				end
				--]]
			end
		elseif (rotEnd ~= nil) and _PlayerHasWeapon(PID, "tool_lua_groupcopy") then
			local rotAng = string.sub(strText, rotEnd + 1);
			local runstring = "setRotAng("..rotAng..")";
			_SWEPRunString(GetWeapByPlayer(PID), runstring);
			return strText;
		elseif (frozenEnd ~= nil) and _PlayerHasWeapon(PID, "tool_lua_groupcopy") then
			local IsFrozen = string.sub(strText, frozenEnd + 1);
			local runstring = "setFrozen("..IsFrozen..")";
			_SWEPRunString(GetWeapByPlayer(PID), runstring);
			return strText;
		elseif (dynafrozenStart ~= nil) and _PlayerHasWeapon(PID, "tool_lua_groupcopy") then
			local IsDynaFrozen = string.sub(strText, dynafrozenEnd + 1);
			local runstring = "CallDynaFrozen("..IsDynaFrozen..")";
			_SWEPRunString(GetWeapByPlayer(PID), runstring);
			return strText;
		elseif (npcEnd ~= nil) then
			local NPCweapon = string.sub(strText, npcEnd + 1);
			local runstring = "CallNPCWeapon(\""..NPCweapon.."\")";
			_SWEPRunString(GetWeapByPlayer(PID), runstring);
			return strText;
		elseif (previewEnd ~= nil) and _PlayerHasWeapon(PID, "tool_lua_groupcopy") then
			local choice = string.sub(strText, previewEnd + 1);
			local runstring = "setPreview("..choice..")";
			_SWEPRunString(GetWeapByPlayer(PID), runstring);
			return strText;
		--else
		--	return strText;
		-- Don't do this, otherwise ULX wont work anymore.
		end
	end
	HookEvent("eventPlayerSay", cgPlayerSay);
	
	function CallAddWeld(ent1, ent2, PID)
		local runstring = "AddWeld(" .. ent1 .. ", " .. ent2 .. ")";
		_SWEPRunString(GetWeapByPlayer(PID), runstring);
	end
	
	function CallWelderStatus(PID,isThink)
		if(isThink == nil) then
			isThink = "\"\"";
		end
		local runstring = "show_copygunwelder_status("..isThink..")";
		_SWEPRunString(GetWeapByPlayer(PID), runstring);
	end
	
	function CallTotalWeld(PID)
		local runstring = "TotalWeld()";
		_SWEPRunString(GetWeapByPlayer(PID), runstring);
	end
	
	function CallSphereSelect(vecstring,radius,PID,isQuad)
		local add_string = "";
		if(isQuad == true) then
			add_string = "\""..radius.."\",true"; -- Calls the sphere select, so the CG knows, its now the Quad Select
		else
			add_string = radius;
		end
		local runstring = "SphereSelect(\""..vecstring.."\","..add_string..")";
		_SWEPRunString(GetWeapByPlayer(PID), runstring);
	end
	
	function CallQuadStatus(PID,seizes,isThink)
		if(isThink == nil) then
			isThink = false;
		end
		local runstring = "show_quad_status(\""..seizes.."\","..tostring(isThink)..")";
		_SWEPRunString(GetWeapByPlayer(PID), runstring);
	end
	
	function CallSphereStatus(PID,distance,isThink)
		if(isThink == nil) then
			isThink = false;
		end
		local runstring = "show_sphere_status("..distance..","..tostring(isThink)..")";
		_SWEPRunString(GetWeapByPlayer(PID), runstring);
	end
	
	function CallRangeChange(PID)
		local runstring = "RangeChange("..PID..")";
		_SWEPRunString(GetWeapByPlayer(PID), runstring);
	end
	
	function PollResponse(PID, WeapID) --called by SWEPs for polling
		IDTable[PID] = WeapID;
	end
	
	function ClearIDTable()
		IDTable = nil;
		IDTable = {};
		_Msg("ID Table Flushed! \n");
	end
	
	function GetWeapByPlayer(PID)
		if _EntExists(IDTable[PID]) == false then return 0 end;
		return IDTable[PID];
	end
	
	function cg_give_totarget()
		if IsPlayerOnline(CurGivePlayer) == false then return end;
		cggive(CurGivePlayer);
	end
	
	function cg_give_target(caller, PID)
		if caller ~= 1 then return end;
		if PID == nil then return end;
		local nPID = tonumber(PID);
		if IsPlayerOnline(nPID) == false then return false end;
		CurGivePlayer = nPID;
		return PID;
	end
	
	function cggive(PID)
		if IsPlayerOnline(PID) == false then return end;
		_PlayerGiveSWEP(PID,"weapons/Tools/CopyGunQuadSelect.lua");
		_PlayerGiveSWEP(PID,"weapons/Tools/CopyGunSphereSelect.lua");
		_PlayerGiveSWEP(PID,"weapons/Tools/CopyGunWelder.lua");
		_PlayerGiveSWEP(PID,"weapons/Tools/CopyGun.lua");
	end
	CONCOMMAND("cg_give_to_self", cggive);
	CONCOMMAND("cg_give_target", cg_give_target);
	--CONCOMMAND("cg_clearidtable", ClearIDTable); -- Not needed!

	function table_all_lower(tab)
		local new_tab = {};
		for tab_k,tab_v in tab do
			new_tab[string.lower(tab_k)] = string.lower(tab_v);
		end
		return new_tab;
	end
	
	function give_copygun(PID,arg)
		arg = tonumber(arg);
		if(arg == 1) then
			_PlayerGiveSWEP(PID,"weapons/Tools/CopyGun.lua");
		elseif(arg == 2) then
			_PlayerGiveSWEP(PID,"weapons/Tools/CopyGunWelder.lua");
		elseif(arg == 3) then
			_PlayerGiveSWEP(PID,"weapons/Tools/CopyGunQuadSelect.lua");
		elseif(arg == 4) then
			_PlayerGiveSWEP(PID,"weapons/Tools/CopyGunSphereSelect.lua");
		end
	end
	CONCOMMAND("cg_give_weapon",give_copygun)
	
	function RefreshSpawnMenu(PID)
		--[[
		if(PID ~= 0) then
			VIPplayer_team_number[PID] = 0; -- Starts an VIP menu reset of the CGs
			VIPcheck_user_changed_team(PID); -- Resend now the VIP menu
		end
		--]]
		fileList = _file.Find(DEFAULT_SAVE_PARTIALDIR.."*")
		_spawnmenu.RemoveCategory(PID, DEFAULT_CATEGORY)
		_spawnmenu.SetCategory(PID, DEFAULT_CATEGORY)
		
		_spawnmenu.AddItem(PID, DEFAULT_CATEGORY, "@CopyGun Tools", "title")
		_spawnmenu.AddItem(PID, DEFAULT_CATEGORY, "+CopyGun", "cg_give_weapon 1")
		_spawnmenu.AddItem(PID, DEFAULT_CATEGORY, "+CopyGun Welder", "cg_give_weapon 2")
		_spawnmenu.AddItem(PID, DEFAULT_CATEGORY, "+Quad Select", "cg_give_weapon 3")
		_spawnmenu.AddItem(PID, DEFAULT_CATEGORY, "+Sphere Select", "cg_give_weapon 4")
		
		--[[
		_spawnmenu.AddItem(PID, DEFAULT_CATEGORY, "@Non VIPs can just", "title")
		_spawnmenu.AddItem(PID, DEFAULT_CATEGORY, "@load public stuff!", "title")
		--]]
		
		patterns:Load() -- Reload the database
		users:Load() -- Reload the database
		delete:Load() -- Reload the database
		public:Load() -- Reload the database
		
		--write_string = ""; -- Debug
		local pub_patterns = public:GetTable();
		pub_patterns = table_all_lower(pub_patterns);
		local file_names = patterns:GetTable()
		file_names = table_all_lower(file_names);
		local user_names = users:GetTable()
		--user_names = table_all_lower(user_names);
		local deleted_patterns = delete:GetTable()
		deleted_patterns = table_all_lower(deleted_patterns);
		local fileList_table = {}
		
		local deleted_patterns_list = {}
		local user_files = {} -- Saves the filenames sorted by users
		for i=1, table.getn(fileList) do
			if(fileList[i] ~= nil and fileList[i] ~= "." and fileList[i] ~= "..") then
				local simple_name = string.gsub(fileList[i], ".cgs","")
				if(deleted_patterns[string.lower(simple_name)] == nil) then
					if(file_names[string.lower(simple_name)] ~= nil and pub_patterns[string.lower(simple_name)] == nil) then
						-- Using user_names[file_names[simple_name]] instead of the for method below produces an error. Bad Lua implementation! 
						--cur_username = "ROFL, its fucked up again"; -- Debug
						cur_username = "[ERROR] Contact the ECG Developer!"; -- This shouldnt really appear.. Only, when this fuckng Lua bug appears again (arrrrr!) :D
						--_Msg("\n") -- Debug
						for user_namesk,user_namesv in user_names do
							--_Msg(user_namesv.."\n"); -- Debug
							local lower_simple = string.lower(simple_name);
							-- Bla bla bla, i hate lua, bla bla bla! Buggy fucking shit!!! This is the SECOND wrgaround for this fuck! - When you do a file_names[simple_name] == user_namesk, it returns sometimes NOT true, even when the FUCKING string is identical! - so, i just used string.find for this gay shit! - GARRY, work on it! Dammed!
							if(string.find(file_names[lower_simple],string.lower(user_namesk)) ~= nil) then
								cur_username = user_namesv
								--_Msg(user_namesv.."\n"); -- Debug
								break;
							end
						end
						--_Msg("\n") -- Debug
						if(user_files[cur_username] == nil) then
							user_files[cur_username] = {}
						end
						--write_string = write_string.."\n"..cur_username.."||| "..simple_name; -- Debug
						user_files[cur_username][(table.getn(user_files[cur_username])+1)] = simple_name;
						fileList[i] = nil
					else
						fileList_table[i] = fileList[i]
					end
				else
					deleted_patterns_list[table.getn(deleted_patterns_list)+1] = string.lower(simple_name);
				end
			end
		end
		
		-- Public stuff
		_spawnmenu.AddItem(PID, DEFAULT_CATEGORY, "@Public Stuff", "title")
		local addstring = ""
		for fileList_table_key,fileList_table_value in fileList_table do
			local simpleName = string.gsub(fileList_table[fileList_table_key], ".cgs","")
			local runString = "cgload " .. simpleName
			--write_string = write_string.."\nPub| "..simpleName -- Debug
			_spawnmenu.AddItem(PID, DEFAULT_CATEGORY, "+"..simpleName, runString)
		end
		
		--User saved stuff
		for user_files_key, user_files_value in user_files do
			_spawnmenu.AddItem(PID, DEFAULT_CATEGORY, "@"..addstring, "title")
			_spawnmenu.AddItem(PID, DEFAULT_CATEGORY, "+Delete next pattern"..addstring, "cg_delpattern")
			addstring = " " .. addstring
			_spawnmenu.AddItem(PID, DEFAULT_CATEGORY, "@"..user_files_key, "title")
			for user_files_value_key,user_files_value_value in user_files_value do
				runString = "cgload " .. user_files_value_value
				--write_string = write_string.."\n"..user_files_key.."| "..user_files_value_value -- Debug
				_spawnmenu.AddItem(PID, DEFAULT_CATEGORY, "+"..user_files_value_value, runString)
			end
		end
		-- Deletion list
		_spawnmenu.AddItem(PID, DEFAULT_CATEGORY, "@"..addstring, "title")
		_spawnmenu.AddItem(PID, DEFAULT_CATEGORY, "@Deletion List", "title")
		for k,v in deleted_patterns_list do
			runString = "cgload " .. v;
			_spawnmenu.AddItem(PID, DEFAULT_CATEGORY, "+"..v, runString)
		end
		_spawnmenu.AddItem(PID, DEFAULT_CATEGORY, "@ "..addstring, "title")
		_spawnmenu.AddItem(PID, DEFAULT_CATEGORY, "+Clear Deletionlist", "cleardeletionlist")
		--_file.Write( "fuckup.log", write_string); -- Debug
	end
	
	function cc_refreshmenu(PID)
		RefreshSpawnMenu(PID);
	end
	
	--cc_refreshmenu(0)
	HookEvent("eventPlayerInitialSpawn", RefreshSpawnMenu)
	
	function optimise_database()
		local fileList = _file.Find(DEFAULT_SAVE_PARTIALDIR.."*")
		
		patterns:Load() -- Reload the database
		local file_names = patterns:GetTable();
		file_names = table_all_lower(file_names);
		
		public:Load() -- Reload the database
		local pub_file_names = public:GetTable();
		pub_file_names = table_all_lower(pub_file_names);
		
		delete:Load() -- Reload the database
		local del_file_names = delete:GetTable();
		del_file_names = table_all_lower(del_file_names);
		
		local new_database_table = {}
		local pub_new_database_table = {}
		local del_new_database_table = {}
		for i=1, table.getn(fileList) do
			if(fileList[i] ~= nil and fileList[i] ~= "." and fileList[i] ~= "..") then
				local simple_name = string.gsub(fileList[i], ".cgs","")
				-- Remove out of patternlist
				if(file_names[string.lower(simple_name)] ~= nil) then
					new_database_table[string.lower(simple_name)] = file_names[string.lower(simple_name)];
					--_Msg("Pattern list "..simple_name.."\n");
				end
				-- Remove out of pub list
				if(pub_file_names[string.lower(simple_name)] ~= nil) then
					pub_new_database_table[string.lower(simple_name)] = pub_file_names[string.lower(simple_name)];
					--_Msg("Pub lis t"..simple_name.."\n");
				end
				-- Remove out of deletion list
				if(del_file_names[string.lower(simple_name)] ~= nil) then
					del_new_database_table[string.lower(simple_name)] = del_file_names[string.lower(simple_name)];
					--_Msg("Del list "..simple_name.."\n");
				end
			end
		end
		patterns:Unload();
		patterns:SetTable(new_database_table);
		patterns:Save();
		
		public:Unload();
		public:SetTable(pub_new_database_table);
		public:Save();
		
		delete:Unload();
		delete:SetTable(del_new_database_table);
		delete:Save();
		
		_Msg("Optimised CopyGun Database\n");
	end
	
	optimise_database(); -- Done everytime, server starts!
	
	-- I need this file list so i can synchronisize my Server CGs with those stored on my local PC. You can use it anyway, but i dont help at any problems related to this script!
	function export_filelist()
		local fileList = _file.Find(DEFAULT_SAVE_PARTIALDIR.."*")
		local files = "<?php $files = array("; -- Generate PHP array
		for k,v in fileList do
			v = string.gsub(v,'\'','\\\'');
			files = files.."'"..v.."',\n";
		end
		files = files..");\n$src_dir = './cg_saves';\n$d = dir($src_dir);\nwhile($file = $d->read()){\n  if(!is_dir($src_dir.'/'.$file)){\n    if(array_search($file,$files) === false){\n      unlink($src_dir.'/'.$file);\n      echo 'Removed '.$file;\n    }\n  }\n} ?>";
		_file.Write('export_filelist.php',files);
	end
	
	function completely_delete_pattern(userid,arg)
		if(isAdmin(userid)) then
			local fileList = _file.Find(DEFAULT_SAVE_PARTIALDIR.."*")
			delete:Load() -- Reload the database
			local del_file_names = delete:GetTable();
			del_file_names = table_all_lower(del_file_names);
			
			for i=1, table.getn(fileList) do
				if(fileList[i] ~= nil and fileList[i] ~= "." and fileList[i] ~= "..") then
					local simple_name = string.gsub(fileList[i], ".cgs","")
					if(del_file_names[string.lower(simple_name)] ~= nil) then
						if(_file.Exists(DEFAULT_SAVE_PARTIALDIR.."/"..fileList[i])) then
							_file.Delete(DEFAULT_SAVE_PARTIALDIR.."/"..fileList[i]);
						end
					end
				end
			end
			cc_refreshmenu(userid)
		end
	end
	
	function cg_message_rect(userid,duration,rec_id,rx,ry)
		if(rec_id == nil) then
			rec_id = 404
		end
		if(rx == nil or ry == nil) then
			rx = 0.15
			ry = 0.365
		end
		_GModRect_Hide(userid, 404, 0 , 0)
		_GModRect_Start("gmod/white")
		_GModRect_SetPos(rx, ry, 0.7, 0.10)
		_GModRect_SetColor(0, 0, 0, 150)
		_GModRect_SetTime(duration - 0.5, 0, 0.5)
		_GModRect_Send(userid, rec_id)
	end
	
	function cc_delpattern(userid,arg)
		if(isAdmin(userid) == true or ALL_CAN_DELETE_THEIR_OWN_PATTERNS == true) then
			if(del_pattern_user[userid] == nil) then
				del_pattern_user[userid] = true
				_GModText_Start("CloseCaption_Bold")
				_GModText_SetPos(0.21, 0.25)
				_GModText_SetTime( 9999, 0, 0 )
				_GModText_SetColor( 255, 0, 0, 200 )
				_GModText_SetText( "The next CopyGun pattern you spawn will be set to the deletion list\nPress the button again, to disable this mode" )
				_GModText_SetDelay( 0 )
				_GModText_Send( userid, 97 )
				cg_message_rect( userid , 9999, 405, 0.15,0.236)
			else
				del_pattern_user[userid] = nil
				_GModText_Hide(userid, 97)
				_GModRect_Hide(userid, 405, 0, 0)
			end
		--else
		--	announce_is_no_vip(userid)
		end
	end
	
	-- ConCommands!
	function concommand_cg_load(userid,arg)
		cgPlayerSay(userid, _PlayerInfo(userid,"name")..": -cgload "..arg);
	end
	function concommand_cg_save(userid,arg)
		cgPlayerSay(userid, _PlayerInfo(userid,"name")..": -cgsave "..arg);
	end
	function concommand_cg_rot(userid,arg)
		cgPlayerSay(userid, _PlayerInfo(userid,"name")..": -cgrot "..arg);
	end
	function concommand_cg_frozen(userid,arg)
		cgPlayerSay(userid, _PlayerInfo(userid,"name")..": -cgfrozen "..arg);
	end
	function concommand_cg_dynafrozen(userid,arg)
		cgPlayerSay(userid, _PlayerInfo(userid,"name")..": -cgdynafrozen "..arg);
	end
	function concommand_cg_npcweapon(userid,arg)
		cgPlayerSay(userid, _PlayerInfo(userid,"name")..": -cgnpcweapon "..arg);
	end
	function concommand_cg_npcpreview(userid,arg)
		cgPlayerSay(userid, _PlayerInfo(userid,"name")..": -cgpreview "..arg);
	end
	CONCOMMAND("cgload",concommand_cg_load)
	CONCOMMAND("cgsave",concommand_cg_save)
	CONCOMMAND("cgrot",concommand_cg_rot)
	CONCOMMAND("cgfrozen",concommand_cg_frozen)
	CONCOMMAND("cgdynafrozen",concommand_cg_dynafrozen)
	CONCOMMAND("cgnpcweapon",concommand_cg_npcweapon)
	CONCOMMAND("cgpreview",concommand_cg_npcpreview)
	CONCOMMAND("cleardeletionlist",completely_delete_pattern)
	
	CONCOMMAND("cg_delpattern",cc_delpattern)
	CONCOMMAND("cg_refreshmenu", cc_refreshmenu)
else
	_Msg("[Enhanced CopyGun] ERROR: The CopyGun Menu can't work, when the \"dbloader.lua\" isn't in the \"gmod9/lua/\" folder or gets executed before the CopyGunIO.lua!\n");
end
