--[[
Enhanced CopyGun, based on ZeroPoint's CopyGun 1.04b
by aVoN aka System of a pWne!^

This version of the CG can save/load nearly anything - Magnetised, Dynamics,Emitters (not the emmittertype!), cars, doors,npcs,ragdolls (not their posing) and many more!
Additionally, it got enhanced in that way, that there aren't ANY SaveCorruption problems anymore! And the CopyGun Patternmenu is NickName sorted! (using dbloader from Anders1)

For the CG, you get a new interface, which tells you any needed informations you need! When you spawn NPCs, they will have the weapons you have either selected in the NPC Menu (default = crowbar) or the one which u have set in the CopyGun Menu.
or just use 
-cgnpcweapon ar2 smg1 pistol
to set one or more weapons for the NPCs

And, you can props dynafrozen (prop_dynamic_override!), so, it cant get accidently moved by physgun! Gmow3,vMod and cmod (carmod) are fully supported! Even basewars/doormod doors.
Button/Door arangements can get saved when you use the "DoorMod - Lua Edition" which i have coded. You can download it here: www.avon.fneuweiler.de/index2.php?action=artikel/article&artikel=1146336296

There are two more SWEPS (Sphere/Quad Select) in the package, which allows you to select MORE then one prop at one time! You can save a full base in just seconds!
And I added a possibility, to add/remove props from a CG save. E.g. you accidently selected a prop, you don't want to be selected: Just shoot it again, and it gets deselected!

And before i forget: All old Patterns of the official CopyGun are compatible with this Version of the CG and most Pattern of the ECG are compatible with the old one, but may produce crashes (e.g. on ragdolls!)

--]]
-- Original Header here now!
--[[
Group Copy Gun v1r4b
by ZeroPoint

Requires Gmod 9.0.4 or greater
You must run 'CopyGunIO.lua' first.

Usage:

Primary Fire selects props for copy, the targets turn green as you select them.
Secondary Fire spawns a duplicate of the 'pattern' at the selected location.

Saying '-cgsave <name>' ingame will save the gun's current pattern to file(s) in the gmod/cg_saves.
The save will cancel if there is a file with a duplicate name. (This prevents clients from overwriting your stuff)

Saying '-cgload <name>' will load a pattern from file.

Saying '-cgrot <angle>' will set the amount of rotation for subsequent paste operations. Rotation is measured counterclockwise, in degrees. 
Positive angles less than 360 and negative angles greater than -360 are permitted.

Reload will clear any pattern from the gun and remove the green marking from previously selected elements.


Tips/Known Bugs:

Try to select a prop at the bottom of your structure first. In order to record the structure's 'altitude' correctly, the target prop must have a clear 'view' of the ground. Otherwise, part of the arrangement may spawn underground 
when you attempt to paste a copy.
As of this version, it's a bad idea to try and copy the duplicate of a structure. As far as I can tell, there's some strange problem with data corruption in _EntGetModel; in certain cases it returns either an incomplete string, 
or an invalid string which causes an error that shuts down the server. Until this issue is resolved, stick to copying arrangements of props that have been spawned from the menu.

]]

_OpenScript( "admins.txt");
--_OpenScript( "vip.txt");
_OpenScript("lib/gmx/init.lua"); -- GMX is needed. I'm using v 1.31, but it should work even with 1.0 (i think, gmx.explode was included there too. I just need the explode function)!
_OpenScript( "includes/vector3.lua" );
_OpenScript("copygun_config.lua");
--_OpenScript( "includes/misc.lua" );


DEFAULT_SAVE_FOLDER = string.sub(DEFAULT_SAVE_PARTIALDIR, 1, -2);


-- These variables are passed by the engine



MyIndex			=	0; -- Weapon's entity index.

Owner			= 	0; -- The player that owns this weapon

CurrentTime		=	0; -- The current game time

think_start = true;

copygun_is_owner = true -- Saves, if the user is the owner of the prop or not (for propprotector)

current_fileName = nil;

last_spawn = 0; -- Time, the players spawned a prop

rotAng = 0;
spawnWelds = 1;
spawnFrozen = 1;
showPreview = 1;
npc_weapon = {}; -- Whats the standard wep of an NPC?

IsDeployed = false;
LastPoll = _CurTime();
firstPropAltitude = nil;
firstPropPos = nil;
copyBufferTable = {};
originalTable = {};
weldTable = {};
spawnTable = {};
previewTable = {};
last_time_entity_added = 0;
dynafrozen = 0;
baserange=16;
weldrange=16;
weldmaxrange=SMART_WELD_MAXRANGE;
weldmaxrange_vip=SMART_WELD_MAXRANGE;
weldmaxrange_standard = SMART_WELD_MAXRANGE_FOR_NON_ADMINS; -- For non VIPs!

-- All entity types, which aren't supported or do a crash on load
sphere_dont_save_list = {"func_combine_ball_spawner","phys_bone_follower","tool_lua_groupcopy","env_sprite","env_beam","info_player_start","env_laser"}

-- Door table. Saves DSoor, which needes min/max animationtime (DoorMod/BaseWars)
DYN_DOORS = {}
DYN_DOORS[1] = "combine_door01.mdl";
DYN_DOORS[2] = "combine_gate_Vehicle.mdl";
DYN_DOORS[3] = "combine_gate_citizen.mdl";

-- Saves DoorNames, thats all (for Door/Button saves!)
DOOR_TEMP_SAVE = {}

-- Allowed weapons for NPCs
NPC_ALLOWED_WEAPONS = {"weapon_crowbar","weapon_stunstick","weapon_pistol","weapon_357","weapon_smg1","weapon_ar2","weapon_shotgun","weapon_annabelle","weapon_alyxgun","weapon_crossbow","weapon_frag","weapon_rpg","weapon_citizenpackage","weapon_citizensuitcase"}

-- Vehicel save/load index for the right movement behaviour
VEHICLE_TABLE = {}
-- Gmow3
VEHICLE_TABLE["models/330m.mdl"] = "scripts/vehicles/330m_test.txt";
VEHICLE_TABLE["models/beetle.mdl"] = "scripts/vehicles/beetle_test.txt";
VEHICLE_TABLE["models/bmwm3.mdl"] = "scripts/vehicles/bmwm3_test.txt";
VEHICLE_TABLE["models/bus.mdl"] = "scripts/vehicles/bus_test.txt";
--VEHICLE_TABLE["models/busseat.mdl"] = "scripts/vehicles/prisoner_pod.txt"; -- Not needed, because it's prop_vehicle_prisoner_pod - working without the script!
VEHICLE_TABLE["models/cj7.mdl"] = "scripts/vehicles/cj7_test.txt";
VEHICLE_TABLE["models/ctruck.mdl"] = "scripts/vehicles/ctruck_test.txt";
VEHICLE_TABLE["models/d90.mdl"] = "scripts/vehicles/d90_test.txt";
VEHICLE_TABLE["models/datsun.mdl"] = "scripts/vehicles/datsun_test.txt";
VEHICLE_TABLE["models/enzo.mdl"] = "scripts/vehicles/enzo_test.txt";
VEHICLE_TABLE["models/f40.mdl"] = "scripts/vehicles/f40_test.txt";
VEHICLE_TABLE["models/f100.mdl"] = "scripts/vehicles/f100_test.txt";
VEHICLE_TABLE["models/forklift.mdl"] = "scripts/vehicles/forklift_test.txt";
VEHICLE_TABLE["models/freight.mdl"] = "scripts/vehicles/freight_test.txt";
VEHICLE_TABLE["models/hummer.mdl"] = "scripts/vehicles/hummer_test.txt";
VEHICLE_TABLE["models/komatsu.mdl"] = "scripts/vehicles/komatsu_test.txt";
VEHICLE_TABLE["models/mbeetle.mdl"] = "scripts/vehicles/mbeetle_test.txt";
VEHICLE_TABLE["models/mcf1.mdl"] = "scripts/vehicles/mcf1_test.txt";
VEHICLE_TABLE["models/mini.mdl"] = "scripts/vehicles/mini_test.txt";
VEHICLE_TABLE["models/mtcuda.mdl"] = "scripts/vehicles/mtcuda_test.txt";
VEHICLE_TABLE["models/myj.mdl"] = "scripts/vehicles/myj_test.txt";
VEHICLE_TABLE["models/ohummer.mdl"] = "scripts/vehicles/ohummer_test.txt";
VEHICLE_TABLE["models/path.mdl"] = "scripts/vehicles/path_test.txt";
VEHICLE_TABLE["models/pathm.mdl"] = "scripts/vehicles/pathm_test.txt";
VEHICLE_TABLE["models/rig.mdl"] = "scripts/vehicles/rig_test.txt";
VEHICLE_TABLE["models/rigm.mdl"] = "scripts/vehicles/rigm_test.txt";
VEHICLE_TABLE["models/towrig.mdl"] = "scripts/vehicles/towrig_test.txt";
VEHICLE_TABLE["models/volvo.mdl"] = "scripts/vehicles/volvo_test.txt";
-- CarMod (cmod) -gmow addon
VEHICLE_TABLE["models/hilux.mdl"] = "scripts/vehicles/hilux_test.txt";
VEHICLE_TABLE["models/rubicon.mdl"] = "scripts/vehicles/rubicon_test.txt";
VEHICLE_TABLE["models/sub.mdl"] = "scripts/vehicles/sub_test.txt";
VEHICLE_TABLE["models/veyron.mdl"] = "scripts/vehicles/veyron_test.txt";
--VMod
VEHICLE_TABLE["models/206/206.mdl"] = "scripts/vehicles/206.txt";
VEHICLE_TABLE["models/apc/apc.mdl"] = "scripts/vehicles/apc.txt";
VEHICLE_TABLE["models/carma1/carma1.mdl"] = "scripts/vehicles/carma1.txt";
VEHICLE_TABLE["models/cf_autos/cf_mech.mdl"] = "scripts/vehicles/cf_mech.txt";
VEHICLE_TABLE["models/combapc/combapc.mdl"] = "scripts/vehicles/combineapc.txt";
VEHICLE_TABLE["models/genlee/genlee.mdl"] = "scripts/vehicles/genlee.txt";
VEHICLE_TABLE["models/hl1truck/hl1truck.mdl"] = "scripts/vehicles/hl1truck.txt";
VEHICLE_TABLE["models/impreza/impreza.mdl"] = "scripts/vehicles/impreza.txt";
VEHICLE_TABLE["models/pcar/pcar.mdl"] = "scripts/vehicles/pcar.txt";
VEHICLE_TABLE["models/pirapc/pirapc.mdl"] = "scripts/vehicles/pirapc.txt";
VEHICLE_TABLE["models/van/van.mdl"] = "scripts/vehicles/van.txt";
VEHICLE_TABLE["models/viper/viper.mdl"] = "scripts/vehicles/viper.txt";
VEHICLE_TABLE["models/hoggm/hoggm2.mdl"] = "scripts/vehicles/Warthog.txt";
VEHICLE_TABLE["models/halo2hogv7/halo2hogv8.mdl"] = "scripts/vehicles/Warthog.txt";

	function CopyGunisOwnerOfThisProp(bool_val)
		if(bool_val == true) then
			copygun_is_owner = true
		else
			copygun_is_owner = false
		end
	end

	function setFrozen(iState)
		if (iState ~= 1) and (iState ~= 0) then
			if spawnFrozen == 1 then spawnFrozen = 0 end;
			if spawnFrozen == 0 then spawnFrozen = 1 end;
		else
			spawnFrozen = iState;
		end
		if spawnFrozen == 0 then
			DispMessage(8, "Unfrozen");
		end
		if spawnFrozen == 1 then
			DispMessage(8, "Frozen");
		end
		if(IsDeployed == true) then
			show_copygun_status();
		end
	end
	
	function indexByEnt(iEnt)
		for i = 1, table.getn(originalTable) do
			if originalTable[i] == iEnt then
				return i;
			end
		end
		return nil;
	end
	
	function CallDynaFrozen(iState)
		if (iState ~= 1) and (iState ~= 0) then
			if dynafrozen == 1 then dynafrozen = 0 end;
			if dynafrozen == 0 then dynafrozen = 1 end;
		else
			dynafrozen = iState;
		end
		if dynafrozen == 0 then
			DispMessage(11, "No");
		end
		if dynafrozen == 1 then
			DispMessage(11, "Yes");
		end
		if(IsDeployed == true) then
			show_copygun_status();
		end
	end
	
	function AddWeld(iEnt1, iEnt2,smartWeld) --an external 'welder' SWEP will select the two ents for welding. All major scripting is handled in this SWEP for ease of processing.
		if(table.getn(weldTable) < MAX_WELDS) then
			if iEnt1 == iEnt2 then return end;
			if (AlreadyCopied(iEnt1) == false) or (AlreadyCopied(iEnt2) == false) then return end;
			local newWeldInfo = {};
			if(smartWeld == nil) then
				_EntFire(iEnt1, "color", "255+0+0", 0); 
				_EntFire(iEnt2, "color", "255+0+0", 0); 
				_EntFire(iEnt1, "color", "0+255+0", 0.5); 
				_EntFire(iEnt2, "color", "0+255+0", 0.5);
			end
			newWeldInfo[1] = "phys_constraint"
			newWeldInfo[2] = indexByEnt(iEnt1)
			newWeldInfo[3] = indexByEnt(iEnt2)
			for weldTablek,weldTablev in weldTable do
				-- Dont add any welds twice!
				if((weldTablev[2] == newWeldInfo[2] and weldTablev[3] == newWeldInfo[3]) or (weldTablev[2] == newWeldInfo[3] and weldTablev[3] == newWeldInfo[2])) then
					return;
				end
			end
			-- Just do it now for smartweld
			if(smartWeld ~= nil) then
				_EntFire(iEnt1, "color", "255+0+0", 0); 
				_EntFire(iEnt2, "color", "255+0+0", 0); 
				_EntFire(iEnt1, "color", "0+255+0", 0.5); 
				_EntFire(iEnt2, "color", "0+255+0", 0.5);
			end
			local newWeld = NCWeldEntities(iEnt1, iEnt2)
			table.insert(weldTable, newWeldInfo)
			if(smartWeld == nil) then
				show_copygunwelder_status()
			end
		else
			if(smartWeld == nil) then
				DispMessage(12, MAX_WELDS)
			end
		end
	end
	
	function ispropintable(propid,wheretostart)
	    for i=wheretostart, table.getn(originalTable) do
	        if(originalTable[i]==propid) then
	            return true
			end
	    end
	    return false
	end
	
	function CallNPCWeapon(weapon)
		local done = false;
		weapon = string.gsub(string.gsub(string.lower(weapon),"[ ]+",";"),"[;]+",";");
		_Msg(weapon.."\n");
		if(weapon == "off" or weapon == "none" or weapon == "0") then
			npc_weapon = {}
			done = true;
		elseif (weapon == "random" and done ~= true) then -- Random weps!
			npc_weapon = NPC_ALLOWED_WEAPONS;
			done = true;
		elseif (tonumber(weapon) ~= nil and done ~= true and tonumber(weapon) ~= 357) then -- Exactly the wep out of the wepaons table defined at begginning of the file
			if(tonumber(weapon) <= table.getn(NPC_ALLOWED_WEAPONS) and tonumber(weapon) > 0) then
				npc_weapon = {NPC_ALLOWED_WEAPONS[tonumber(weapon)]}
			end
			done = true;
		elseif (done ~= true) then
			local npc_weapon_temp = gmx.explode(weapon,";")
			npc_weapon = {}
			for k,v in npc_weapon_temp do
				if(tonumber(v) == nil or tonumber(v) == 357) then
					for kk,vv in NPC_ALLOWED_WEAPONS do
						if(string.find(string.lower(vv),v) ~= nil) then
							npc_weapon[(table.getn(npc_weapon)+1)] = vv;
							break;
						end
					end
				else
					if(tonumber(v) <= table.getn(NPC_ALLOWED_WEAPONS) and tonumber(v) > 0) then
						npc_weapon[(table.getn(npc_weapon)+1)] = NPC_ALLOWED_WEAPONS[tonumber(v)]
					end
				end
			end
		end
		if(table.getn(npc_weapon) ~= table.getn(NPC_ALLOWED_WEAPONS)) then
			DispMessage(13, string.gsub(gmx.implode(npc_weapon,";"),"weapon_",""))
		else
			DispMessage(13, "random")
		end
		think_start = true;
		show_copygunwelder_status();
	end
	
	function RangeChange(userid)
		weldrange=weldrange*2
		if(weldrange>weldmaxrange) then
			weldrange=baserange
		end
		DispMessage(10, weldrange)
		show_copygunwelder_status();
	end
	
	-- Quad/Sphere select function
	function SphereSelect(position,fin_pos,isQuad)
		position = gmx.explode(position," ");
		position = vector3(position[1],position[2],position[3]);
		local sphere_select_radius = fin_pos;
		local vQuadPosToEntPos = vector3(0,0,0);
		if(isQuad == true) then
			-- You ask me why 0.75? Even i don't know. But after some minutes of try, it was the new factor to multiply the length Vector, to exactly fit from the quad middle to one upper corner.
			-- Maybe it has something to do with Pi and the sphere. But whatever, who cars? It's compared with my other code a kind of shit, but it works! ^^
			fin_pos = gmx.explode(fin_pos," ");
			fin_pos = vector3(tonumber(fin_pos[1])*0.75,tonumber(fin_pos[2])*0.75,tonumber(fin_pos[3])*0.75);
			sphere_select_radius = vecLength(vecSub(vecAdd(position,vector3(fin_pos.x,fin_pos.y,fin_pos.z*2)),position)); -- z = twice at high
		end
		local sphereradius = _EntitiesFindInSphere(position,sphere_select_radius)
		local do_save = true
		for k in sphereradius do
			do_save = true
			-- Ignore PlayerWeapons, which the players have in their inventory
			if(table.getn(copyBufferTable) < MAX_ENTITY_COPY or isAdmin(Owner) --[[or isVip(Owner)--]] or MAX_ENTITY_COPY == 0) then
				if(_EntGetParent(sphereradius[k]) == 0) then
					if(COPYGUN_USE_PROPPROTECTOR_SWEPWRAPPER == true and PLAYER_CAN_USE_COPYGUN_ON_ALL_PROPS == false) then
						_RunString("prop_protectionSWEPWrapper(".. Owner ..","..sphereradius[k]..",".. MyIndex ..",\"CopyGunisOwnerOfThisProp\")")
					else
						copygun_is_owner = true
					end
					for sphere_dont_save_list_k,sphere_dont_save_list_v in sphere_dont_save_list do
						if(_EntGetType(sphereradius[k]) == sphere_dont_save_list_v) then
							do_save = false;
							break;
						end
					end
					if(isQuad == true) then
						vQuadPosToEntPos = vecSub(_EntGetPos(sphereradius[k]),position); -- Check now, if its in the quad or not
						if(vQuadPosToEntPos.x > fin_pos.x or vQuadPosToEntPos.x < -fin_pos.x or vQuadPosToEntPos.y > fin_pos.y or vQuadPosToEntPos.y < -fin_pos.y or vQuadPosToEntPos.z > fin_pos.z*2 or vQuadPosToEntPos.z < -10) then
							do_save = false;
						end
					end
					if(do_save == true) then
						if(copygun_is_owner == true) then
							AddCopyItem(sphereradius[k],true);
						end
					end
				end
			else
				_GModText_Start("CloseCaption_Bold");
				_GModText_SetPos(0.23, 0.40);
				_GModText_SetColor( 255, 255, 255, 255 );
				_GModText_SetTime( 2, 0, 0 );
				_GModText_SetText( "You can only select " .. MAX_ENTITY_COPY .. " at one time for copy!" );
				_GModText_SetDelay( 0 );
				_GModText_Send( Owner, 99 );
				break;
			end
		end
	end
	
	function TotalWeld()
	    weldradius=weldrange
		local break_it = false;
	    for i=1, table.getn(originalTable) do
		    location=_EntGetPos(originalTable[i])
		    closeprops=_EntitiesFindInSphere(location,weldradius)
			for prop in closeprops do
				if(ispropintable(closeprops[prop],i+1)) then
					if(table.getn(weldTable) < MAX_WELDS) then
						AddWeld(originalTable[i],closeprops[prop],true)
					else
						break_it = true;
						break;
					end
				end
			end
			if(break_it == true) then
				DispMessage(12, MAX_WELDS);
				break;
			end
	    end
		show_copygunwelder_status()
	    --_ScreenText ( Owner, "Total Weld Successful", 0.3, -1, 255, 255, 255, 255, 0.1, 0.1, 2, 0, 2 )
	end
	
	function SpawnWeld(iIndex)
		local origIndex1 = weldTable[iIndex][2]
		local origIndex2 = weldTable[iIndex][3]
		--_Msg("SpawnWeld: "..origIndex1.." "..origIndex2.."\n")
		local newWeld = NCWeldEntities(spawnTable[tonumber(origIndex1)], spawnTable[tonumber(origIndex2)])
	end
	
	function NCWeldEntities( enta, entb )		--Don't panic, it's just a modification of Garry's helper routine.
		local iConstraint = _EntCreate( "phys_constraint" );

		_EntSetPos( iConstraint, _EntGetPos( enta ) );
		_EntSetKeyValue( iConstraint, "attachpoint", _EntGetPos( entb ) );
		_EntSetKeyValue( iConstraint, "spawnflags", "1" );
		_PhysConstraintSetEnts( iConstraint, enta, entb );	
		
		_EntSpawn( iConstraint );
		_EntActivate( iConstraint );

		return iConstraint;
	end
	
	function DispMessage(iSel, msg1)
--[[		0: Reset
		1: Saved Successfully 		
		2: Save Cancelled due to Overwrite
		3: Loaded Successfuly
		4: Load file could not be found.
		5: Angle set successfully
		6: Angle was invalid
		7: Preview On/Off
		8: Freeze On/Off
		9: Too many props
		10: Change weld range
		11: Switch of dynafrozen mode
		12: Too much weld warning
		13: NPC Weapons announce
]]		
		_GModText_Start("CloseCaption_Bold")
		_GModText_SetPos(0.3, -1);
		_GModText_SetTime( 3, 0, 2 );
		_GModText_SetColor( 255, 255, 255, 255 );
		if iSel == 0 then
			_GModText_SetText( "Pattern Cleared!" );
		elseif iSel == 1 then
			_GModText_SetText( "Pattern "..msg1.." saved successfully!" );
		elseif iSel == 2 then
			_GModText_SetText( "Pattern "..msg1.." already exists, try another name." );
		elseif iSel == 3 then
			_GModText_SetText( "Pattern "..msg1.." loaded successfully!" );
		elseif iSel == 4 then
			_GModText_SetText( "Pattern "..msg1.." could not be found." );
		elseif iSel == 5 then
			_GModText_SetText( "Angle set to "..msg1.." degrees." );
		elseif iSel == 6 then
			_GModText_SetText( "Angle is invalid." );
		elseif iSel == 7 then
			_GModText_SetText( "Ghost preview "..msg1 );
		elseif iSel == 8 then
			_GModText_SetText( "Patterns will spawn "..msg1 );
		elseif iSel == 9 then
			_GModText_SetText( "Too reduce lag, Preview is cut to "..msg1.." props" );
		elseif iSel == 10 then
			_GModText_SetText( "Smart Weld range changed to "..msg1 );
		elseif iSel == 11 then
			_GModText_SetText( "Props spawn DynaFrozen: "..msg1 );
		elseif iSel == 12 then
			_GModText_SetText( "You can't have more then "..msg1.." welds!");
		elseif iSel == 13 then
			_GModText_SetText( "NPC Weapons set to "..msg1.."!");
		end
		_GModText_SetDelay( 0 );
		_GModText_Send( Owner, 400 );
	end

	function setRotAng(ang)
		if (ang >= 0) and (ang < 360) then
			rotAng = ang;
			DispMessage(5, rotAng)
		elseif (ang < 0) and (ang > -360) then
			rotAng = 360 + ang;
			DispMessage(5, rotAng)
		else
			rotAng = 0;
			DispMessage(6)
		end
		PreviewChangeAngle();
		--respawnPreview();
		if(IsDeployed == true) then
			show_copygun_status();
		end
	end
	
	function doRotPos(iIndex, intendedPos, localOrigin)
		-- Some test stuff by aVoN. Doesnt rly work ^^ => Rotating a vectur around the zerovector
		--[[
		local vRefVec = vecSub(intendedPos, localOrigin);
		vRefVec.x = vRefVec.x*math.cos(math.rad(rotAng)) + vRefVec.y*math.sin(math.rad(rotAng));
		vRefVec.y = -vRefVec.x*math.sin(math.rad(rotAng)) + vRefVec.y*math.cos(math.rad(rotAng));
		local radius = math.sqrt(vRefVec.x^2 + vRefVec.y^2);
		vNewPos = vecMul(vRefVec, vector3(radius, radius , 1));
		vNewPos = vecAdd(localOrigin, vRefVec)
		return vNewPos;
		--]]
		local vRefVec = vecSub(intendedPos, localOrigin);
		local radius = math.sqrt(vRefVec.x^2 + vRefVec.y^2);
		local alpha_xy
		if (vRefVec.y == 0) and (vRefVec.x ~= 0) then
			--_Msg("Ref: X "..vRefVec.x.."- Y "..vRefVec.y.."- Z "..vRefVec.z.."\n");
			if(vRefVec.x < 0) then
				alpha_xy = 180; -- The method below was one of the reasons, why some copies spawned corrupt! Fix by aVoN
			else
				alpha_xy = 0;
			end
			--alpha_xy = vRefVec.x;         --this and the next two elseif statements prevent unnecessary trig functions and 'divide by zero' errors.
			--_Msg("y = 0\n");
		elseif (vRefVec.y ~= 0) and (vRefVec.x == 0) then
			--_Msg("Ref: X "..vRefVec.x.."- Y "..vRefVec.y.."- Z "..vRefVec.z);
			--Now, decide, if the ordinate of y is bigger or smaller then 0 => angel of 90 or -90. simpel mathematics
			if(vRefVec.y < 0) then
				--_Msg("Smaller\n");
				alpha_xy = -90; -- Someone really can't math. Fix by avon => why u returned an ordinate instead of the angel? Wird!
			else
				--_Msg("Bigger\n");
				alpha_xy = 90;
			end
			--alpha_xy = vRefVec.y -- The old way. Why setting an Vector ordinate as angel?
			--_Msg("X = 0\n");
		elseif (vRefVec.y == 0) and (vRefVec.x == 0) then
			--_Msg("x+y = 0\n");
			return intendedPos
		elseif (vRefVec.y < 0) and (vRefVec.x < 0) then
			alpha_xy = math.deg(math.atan(vRefVec.y/vRefVec.x)) + 180 --corrects angle for lower left quadrant
		elseif (vRefVec.y > 0) and (vRefVec.x < 0) then
			alpha_xy = math.deg(math.atan(vRefVec.y/vRefVec.x)) + 180; --corrects angle for upper left quadrant
		else
			alpha_xy = math.deg(math.atan(vRefVec.y/vRefVec.x));
		end
		alpha_xy = alpha_xy + rotAng;
		if alpha_xy > 360 then
			alpha_xy = alpha_xy - 360
		elseif alpha_xy < 0 then
			alpha_xy = alpha_xy + 360
		end
		local vNewVec = vector3(0, 0 , intendedPos.z);
		vNewVec.y = math.sin(math.rad(alpha_xy));
		vNewVec.x = math.cos(math.rad(alpha_xy));
		vNewVec = vecMul(vNewVec, vector3(radius, radius , 1));
		localOrigin = vector3(localOrigin.x,localOrigin.y,0);
		vNewPos = vecAdd(localOrigin, vNewVec)
		return vNewPos;
	end
	
	function doRotAng(vOrigAng)
		return vector3(vOrigAng.x, (vOrigAng.y + rotAng), vOrigAng.z);
	end
	
	function AlreadyCopied(iEnt)
		for i = 1, table.getn(originalTable) do
			if originalTable[i] == iEnt then
				return i;
			end
		end
		return false;
	end
	
	function RemoveOutOfSpawnIndex(key)
		local return_copyBufferTable = {};
		local iTableIndex = 1;
		for copyBufferTable_k,copyBufferTable_v in copyBufferTable do
			-- Add all values of the old table to the new, except the wished key
			if(copyBufferTable_k ~= key) then
				return_copyBufferTable[iTableIndex] = copyBufferTable_v;
				iTableIndex = iTableIndex + 1;
			end
		end
		--Same now for the originalTable
		local return_originalTable = {};
		local nTableIndex = 1;
		for originalTable_k,originalTable_v in originalTable do
			-- Add all values of the old table to the new, except the wished key
			if(originalTable_k ~= key) then
				return_originalTable[nTableIndex] = originalTable_v;
				nTableIndex = nTableIndex + 1;
			end
		end
		-- Now check. if the first prop got removed. So, the new first prop must be the one, which is the first in the table now!
		if(key == 1 and table.getn(return_copyBufferTable) > 0) then
			vPos = return_copyBufferTable[1][3];
			_TraceLine(vPos, vector3(0, 0, -1), 32768, return_copyBufferTable[1][5]);
			local altitude = vecLength(vecSub(vPos, _TraceEndPos()));
			-- There is a bug with vehicles altitude. They are sometimes near the traceline length. So, lets do a check!
			--_Msg("Orig Altitude: "..altitude.."\n")
			if(altitude > 32700) then
				altitude = 32768 - altitude;
			end
			firstPropAltitude = altitude;
			firstPropPos = vPos;
		end
		--After doing all, refresh the CopyBufferTable with the newly generated in here
		copyBufferTable = return_copyBufferTable;
		--Amd the same with the originaltable, which saves all EntIds
		originalTable = return_originalTable;
		
		-- And check now the WeldTable to.
		local weldTable_temp_final = {};
		local done = false
		for i=1,table.getn(weldTable) do
			-- Decrease the weldnumbers to fit to original weld
			done = false;
			if(weldTable[i][2] > key ) then
				weldTable[i][2] = weldTable[i][2] - 1;
				done = true;
			end
			if(weldTable[i][3] > key) then
				weldTable[i][3] = weldTable[i][3] - 1;
				done = true;
			end
			-- Remove old, welds here
			if(weldTable[i][2] == key or weldTable[i][3] == key and done == false) then
				weldTable[i] = nil; -- unset it, cause one of the ent doesnt exist anymore!
			end
		end
		local weldCounter = 1;
		for weldTable_k,weldTable_v in weldTable do
			--_Msg("Adding weld to new table\n");
			weldTable_temp_final[weldCounter] = weldTable_v;
			weldCounter = weldCounter +1;
		end
		weldTable = weldTable_temp_final;
	end
	
	function AddCopyItem(iEnt,noDeselect)
		-- The _Msg() parts were for debug modes only!
		local className = _EntGetType(iEnt);
		if(className == "prop_dynamic") then
			className = "prop_dynamic_override"; -- Make any dynamic props backwards compatible to ANY copygun!
		end
		local entName = _EntGetName(iEnt);
		--_Msg(className.."\n");
		for sphere_dont_save_list_k,sphere_dont_save_list_v in sphere_dont_save_list do
			if(className == sphere_dont_save_list_v) then
				return;
			end
		end
		-- Trying to save/load Ragdolls will crash the server. Every other stuff is save/loadable! Players can't be saved too, of course
		if (--[[string.find(className,"ragdoll") ~= nil or --]]className == "player" or className == "func_brush") then return end; -- It seems, brushes crash the server too. See if clause below too
		local modelName = _EntGetModel(iEnt);
		--_Msg(modelName.."\n");
		-- Dont save anything, which hasnt got a model (e.g. env_lasers with vmt as "model". Loading this would crash the game)
		if(string.find(modelName,"*") ~= nil or tostring(modelName) == "" or string.find(string.lower(tostring(modelName)),".mdl") == nil) then return end; -- Some props in maps (autoloaded with map and belong to the map) have modelnames with an * and a number in it. This crashs the game.
		local vPos = _EntGetPos(iEnt);
		--_Msg("Postion: "..vPos.x.."|"..vPos.y.."|"..vPos.z.."\n")
		local vAng = _EntGetAng(iEnt);
		--_Msg("Angle: "..vAng.x.."|"..vAng.y.."|"..vAng.z.."\n")
		local vAngAngle = _EntGetAngAngle(iEnt);
		--_Msg("Ang Angle: "..vAngAngle.x.."|"..vAngAngle.y.."|"..vAngAngle.z.."\n")
		local alreadyCopied_var = AlreadyCopied(iEnt);
		if (alreadyCopied_var ~= false) then
			-- Just remove now, if this ent wasnt the last which has been added in the last 1 secs
			if(last_time_entity_added < _CurTime()) then
				if(noDeselect ~= true) then
					RemoveOutOfSpawnIndex(alreadyCopied_var);
					_EntFire(iEnt, "color", "255+255+255", 0);
				end
			end
			return false;
		end
		last_time_entity_added = _CurTime() + 1;
		-- Prop isn't already copied! so, decrease the countdown now
		table.insert(originalTable, iEnt);
		_EntFire(iEnt, "color", "0+255+0", 0);
		_TraceLine(vPos, vector3(0, 0, -1), 32768, iEnt);
		local altitude = vecLength(vecSub(vPos, _TraceEndPos()));
		if(className == "prop_ragdoll") then
			if(altitude >= 36) then
				altitude = altitude - 38;
				vPos.z = vPos.z - 38;
			end
		end
		-- There is a bug with vehicles altitude. They are sometimes near the traceline length. So, lets do a check!
		--_Msg("Orig Altitude: "..altitude.."\n")
		if(altitude > 32700) then
			altitude = 32768 - altitude;
		end
		--_Msg("Altitude: "..altitude.."\n")
		if (table.getn(copyBufferTable) <= 0) then
			firstPropAltitude = altitude;
			firstPropPos = vPos;
		end
		local iTableIndex = table.getn(copyBufferTable) + 1;
		local entData = {};
		entData[1] = className;
		entData[2] = modelName;
		entData[3] = vPos;
		entData[4] = vAngAngle;
		if(entName ~= "" and entName ~= nil and entName ~= "dynafrozen") then
			entData[5] = entName;
		end
		copyBufferTable[iTableIndex] = entData;
	end
	
	function SpawnCopyItem(iBufferIndex, vPos) --spawns prop from copyBufferTable[iBufferIndex] with relative arrangement pos 'vPos'
		if (firstPropAltitude == nil) or (firstPropPos == nil) then return end;
		-- Airboat  copy crashs servers! dammed!
		local vOriginOffset = vecSub(vPos, firstPropPos);
		local prop_type = copyBufferTable[iBufferIndex][1];
		local door_tmp = nil;
		local name_exploded = "";
		if(dynafrozen == 1 and copyBufferTable[iBufferIndex][1] ~= "prop_vehicle_jeep" and copyBufferTable[iBufferIndex][1] ~= "prop_vehicle_airboat" and copyBufferTable[iBufferIndex][1] ~= "prop_vehicle_prisoner_pod" and string.find(string.lower(copyBufferTable[iBufferIndex][1]),"npc") == nil and prop_type ~= "prop_combine_ball" and string.find(tostring(copyBufferTable[iBufferIndex][5]),"button_") == nil) then
			-- Spawn the wished prop in DynaFrozenMode (unmovable), except NPCs and Vehicles
			prop_type = "prop_dynamic_override";
		end
		-- Prevent a bug, when a prop is "saved" as prop_dynamic, but i is a prop_physics, which just got prop_dynamic_override. Otherwise, it wont spawn!
		if(prop_type == "prop_dynamic") then
			prop_type = "prop_dynamic_override";
		end
		--Its a combine ball! - Make a ballspawner out of it! (otherwise, it would fuck up to be the smalles ball, you ever seen!)
		if(prop_type == "prop_combine_ball") then
			prop_type = "func_combine_ball_spawner";
		end
		local newProp = _EntCreate(prop_type);
		if(string.find(prop_type,"prop_dynamic") ~= nil) then
			_EntSetName(newProp,"dynafrozen")
			_EntSetKeyValue(newProp,"solid",6)
			-- Check now, if its a Door of DoorMod or Basewars
			for door_k,door_v in DYN_DOORS do
				if(string.find(string.lower(copyBufferTable[iBufferIndex][2]),string.lower(door_v))) then
					_EntSetKeyValue(newProp,"MinAnimTime","1")
					_EntSetKeyValue(newProp,"MaxAnimTime","5")
					break;
				end
			end
		end
		--Remember? Its a combine ball! But wee need a ballspawner, for not getting something like the smalles CombineBal ever (~ 0.1 cm otherwiese)
		if(prop_type == "func_combine_ball_spawner") then
			_EntSetKeyValue(newProp, "targetname", "balls")
			_EntSetKeyValue(newProp, "parentname", Owner )
			_EntSetKeyValue(newProp, "ballcount", 1 )
			_EntSetKeyValue(newProp, "minspeed", 0)
			_EntSetKeyValue(newProp, "maxspeed", 0)
			_EntSetKeyValue(newProp, "ballradius",90)
			_EntSetKeyValue(newProp, "balltype", 3)
			_EntSetKeyValue(newProp, "ballrespawntime", .01)
		end
		-- Rotating door of DoorMod/Basewars
		if(prop_type == "prop_door_rotating") then
			_EntSetKeyValue(newProp,"spawnflags","8192")
			_EntSetKeyValue(newProp,"distance","90")
			_EntSetKeyValue(newProp,"health","0")
			_EntSetKeyValue(newProp,"returndelay","-1")
		end
		spawnTable[table.getn(spawnTable) + 1] = newProp;
		local vNewPropPos = vecAdd(vOriginOffset, copyBufferTable[iBufferIndex][3])
		-- The jeep
		if(prop_type == "prop_vehicle_jeep") then
			_EntSetKeyValue(newProp,"solid","6")
			_EntSetKeyValue(newProp,"fademindist","-1")
			_EntSetKeyValue(newProp,"fadescale","1")
			if(VEHICLE_TABLE[copyBufferTable[iBufferIndex][2]] == nil) then
				_EntSetKeyValue(newProp,"vehiclescript","scripts/vehicles/jeep_test.txt")
			else
				_EntSetKeyValue(newProp,"vehiclescript",VEHICLE_TABLE[copyBufferTable[iBufferIndex][2]])
			end
			_EntSetKeyValue(newProp,"actionscale","1")
		end
		-- The airboat
		if(prop_type == "prop_vehicle_airboat") then
			_EntSetKeyValue(newProp,"solid","6")
			_EntSetKeyValue(newProp,"fademindist","-1")
			_EntSetKeyValue(newProp,"fadescale","1")
			_EntSetKeyValue(newProp,"vehiclescript","scripts/vehicles/airboat.txt")
			_EntSetKeyValue(newProp,"actionscale","1")
		end
		-- The Pod
		if(prop_type == "prop_vehicle_prisoner_pod") then
			_EntSetKeyValue(newProp,"solid","6")
			_EntSetKeyValue(newProp,"vehiclescript","scripts/vehicles/prisoner_pod.txt")
		end
		-- Magnetised stuff (otherwise it has infinite magnetise force) -reduce it to a very low level
		if(prop_type == "phys_magnet") then
			-- Set it very low.. - Magnetisesd stuff should just be saveable. Event its then a very less effective magnet
			_EntSetKeyValue(newProp,"torquelimit","3")
			_EntSetKeyValue(newProp,"forcelimit","3")
		end
		if(prop_type ~= "func_combine_ball_spawner") then
			_EntPrecacheModel(copyBufferTable[iBufferIndex][2])
			_EntSetKeyValue(newProp, "model", copyBufferTable[iBufferIndex][2])
		else
			--Whatever, Buildergun uses Alyx as model. Why not i too? (Otherwise, it wont spawn!)
			_EntPrecacheModel("models/alyx.mdl")
			_EntSetKeyValue(newProp, "model", "models/alyx.mdl")
			--_EntSetModel(newProp,"models/alyx.mdl")
		end
		--_EntSetModel(newProp, copyBufferTable[iBufferIndex][2]); --Maybe this line was the reason for string corruption?
		if(prop_type == "func_combine_ball_spawner") then
			--Correct spawn behaviour
			vNewPropPos.z = vNewPropPos.z - 86;
		end
		if(string.find(string.lower(prop_type),"npc_") ~= nil) then
			if(table.getn(npc_weapon) ~= 0) then
				-- Set a random wep for an NPC
				_EntSetKeyValue(newProp, "additionalequipment",npc_weapon[math.random(1,table.getn(npc_weapon))]);
			else
				-- Get the Swep, a player selected on NPC list spawnmenu
				_EntSetKeyValue(newProp, "additionalequipment",_GetClientConVar_String(Owner,"npc_create_equipment"));
			end
		end
		local newPropPos = doRotPos(iBufferIndex, vNewPropPos, vPos);
		local newPropAngAngle = doRotAng(copyBufferTable[iBufferIndex][4]);
		_EntSetKeyValue(newProp, "origin",newPropPos.x.." "..newPropPos.y.." "..newPropPos.z);
		_EntSetKeyValue(newProp, "angles",newPropAngAngle.x.." "..newPropAngAngle.y.." "..newPropAngAngle.z);
		_EntSpawn(newProp);
		_EntActivate(newProp); -- activate it.
		-- PropProtection - Cleanup
		if(copyBufferTable[iBufferIndex][5] ~= "" and copyBufferTable[iBufferIndex][5] ~= nil) then
			-- Set PropNames
			if(string.find(copyBufferTable[iBufferIndex][5],"button_") ~= nil or string.find(copyBufferTable[iBufferIndex][5],"door_") ~= nil) then
				-- Huh, its a door or a button
				if(string.find(copyBufferTable[iBufferIndex][5],"button_") ~= nil) then
					door_tmp = false; -- Huh, button
					copyBufferTable[iBufferIndex][5] = string.gsub(copyBufferTable[iBufferIndex][5],"button_",""); -- Strip button tags
				else
					door_tmp = true; -- Huh, door
					copyBufferTable[iBufferIndex][5] = string.gsub(copyBufferTable[iBufferIndex][5],"door_",""); -- Strip door tags
				end
				name_exploded = gmx.explode(string.gsub(copyBufferTable[iBufferIndex][5],"[\[][0-9]*[\]]",""),";"); -- Check, if its a multibutton.
				for k in name_exploded do
					if(DOOR_TEMP_SAVE[name_exploded[k]] == nil) then
						-- Generate random number, so many copys can be made, without a door/button bind conflict
						-- But just do this, if there is at least one entity with this name!
						if(_EntGetByName("door_"..name_exploded[k])  ~= 0) then
							-- Now, check, if an entity still exists, and just do a number up. But first check, if this door or whatever just contains out of a number.
							for i = 0,1000 do -- Much doors, huh?
								if(_EntGetByName("door_"..name_exploded[k].."["..i.."]") == 0) then
										DOOR_TEMP_SAVE[name_exploded[k]] = "["..i.."]";
									break;
								end
							end
						else
							DOOR_TEMP_SAVE[name_exploded[k]] = "";
						end
					end
					name_exploded[k] = name_exploded[k]..tostring(DOOR_TEMP_SAVE[name_exploded[k]]);
					if(door_tmp == true) then
						copyBufferTable[iBufferIndex][5] = "door_"..name_exploded[k];
						break; -- Huh, a door! If the door name (for what reason ever) has a ; in it, so break this for
					else
						_EntFire(newProp, "addoutput", "spawnflags 256" , 0);
						_EntFire(newProp, "addoutput", "onplayeruse door_"..name_exploded[k]..",setanimation,open" , 0);
						_EntFire(newProp, "addoutput", "onplayeruse door_"..name_exploded[k]..",setanimation,close,3" , 0);
						if(string.find(copyBufferTable[iBufferIndex][5],"button_") == nil) then
							copyBufferTable[iBufferIndex][5] = "button_"..name_exploded[k];
						else
							copyBufferTable[iBufferIndex][5] = copyBufferTable[iBufferIndex][5]..";"..name_exploded[k];
						end
					end
				end
			end
			_EntSetName(newProp,copyBufferTable[iBufferIndex][5])
		end
		if(COPYGUN_USE_PROPPROTECTOR == true) then
			_RunString("CopyGunProtectionMode(" .. newProp .. "," .. Owner .. ",".. iBufferIndex ..",".. table.getn(copyBufferTable) ..")");
		end
		if(prop_type ~= "prop_vehicle_jeep" and prop_type ~= "prop_combine_ball") then
			if spawnFrozen == 1 then
				_PhysEnableMotion(newProp, false);
			end
		end
		return newProp;
	end

	function unColorOriginals()
		for i = 1, table.getn(originalTable) do
			if _EntExists(originalTable[i]) then
				_EntFire(originalTable[i], "color", "255+255+255", 0); 
			end
		end
	end
	
	function colorOriginals()
		for i = 1, table.getn(originalTable) do
			if _EntExists(originalTable[i]) then
				_EntFire(originalTable[i], "color", "0+255+0", 0); 
			end
		end
	end
	
	function checkDefFolder()
		if _file.Exists(DEFAULT_SAVE_FOLDER) == false then
			_file.CreateDir(DEFAULT_SAVE_FOLDER);
		end
		return _file.Exists(DEFAULT_SAVE_FOLDER);
	end

	function doFileSave(fileName)
		if checkDefFolder() == false then 
			_Msg("Error: Could not create save folder!\n");
			return;
		end
		local saveDir = DEFAULT_SAVE_PARTIALDIR .. fileName .. ".cgs"; -- '.cgs' stands for Copy Gun Save. :p
		_Msg("Saving to: "..fileName.."\n")
		if _file.Exists(saveDir) then
			DispMessage(2, fileName);
			return;
		else 
			DispMessage(1, fileName);
		end
		current_fileName = fileName;
		think_start = true;
		SaveInfo(saveDir);
	end
	
	function doFileLoad(fileName)
		local loadDir
		if _file.Exists(DEFAULT_SAVE_FOLDER) == false then return end;
		if string.lower(string.sub(fileName, -4, -1)) ~= ".cgs" then
			loadDir = DEFAULT_SAVE_PARTIALDIR .. fileName .. ".cgs"
		else
			loadDir = DEFAULT_SAVE_PARTIALDIR .. fileName
		end
		if _file.Exists(loadDir) == false then 
			DispMessage(4 , fileName);
			return;
		end
		current_fileName = fileName;
		think_start = true;
		LoadInfo(loadDir,fileName);
	end
	
	function Poll()
		local parentNum = _EntGetParent(MyIndex)
		if parentNum == 0 then return end;
		--if _PlayerHasWeapon(parentNum, "tool_lua_groupcopy_welder") == false then
			--_PlayerGiveSWEP(parentNum, "weapons/CopyGun/CopyGunWelder.lua");
			--_PlayerSelectSWEP(1,"lua_tool_groupcopy");
		--end
		_RunString("PollResponse(" .. _EntGetParent(MyIndex) .. ", " .. MyIndex.. ")");
	end
	
	function onInit( )
		_SWEPSetSound(MyIndex, "single_shot", "Weapon_USP.SilencedShot")
		_Msg(("Copy Gun ID: " .. MyIndex) .. ", Player ID ".._EntGetParent(MyIndex).."\n"); --For debugging
		Poll();
		callGetPPVersion();
		if(gmx == nil) then
			ErrorNoGmx(Owner);
			_EntRemove(MyIndex);
		end
		firstPropAltitude = nil;
		firstPropPos = nil;
		copyBufferTable = {};
		originalTable = {};
	end
	
	function SaveInfo(fileDir)
		if (fileDir == nil) then return end;
		local saveStr = "";
		local tempStr = "";
		
		for i = 1, table.getn(copyBufferTable) do
			tempStr = ""
			for j = 1, table.getn(copyBufferTable[i]) do
				if (j == 3) or (j == 4) then
					tempStr = tempStr .. "#" .. vecString(copyBufferTable[i][j]) .. "@" .. "\t";
				elseif(j == 5) then
					-- Cut off the [number] etc for doors. So, just dont save these infos (autoregenerated!)
					tempStr = tempStr .. "#" .. string.gsub(copyBufferTable[i][j],"[\[][0-9]*[\]]","") .. "@" .. "\t";
				else
					tempStr = tempStr .. "#" .. copyBufferTable[i][j] .. "@" .. "\t";
				end
			end
			saveStr = saveStr .. "{" .. tempStr .. "}" .. "\n";
		end
		tempStr = ""
		for i = 1, table.getn(weldTable) do
			tempStr = tempStr .. "<#" .. weldTable[i][1] .. "@\t#" .. weldTable[i][2] .. "@\t#" .. weldTable[i][3] .. "@\t>\n"
		end
		saveStr = saveStr .. tempStr
		saveStr = saveStr .. "(" .. firstPropAltitude .. ")";
		_file.Write(fileDir, saveStr);
		-- To reduce lag, just update for this owner!
		_RunString("RefreshSpawnMenu(".. Owner ..")")
		if(IsDeployed == true) then
			show_copygun_status();
		end
	end
	
	function spawnPreview()
		clearPreview();
		if showPreview == 0 then return end;
		vPos = vector3(0, 0, 0)
		preview_counter = 0
		for i = 1, table.getn(copyBufferTable) do
			if(preview_counter < PREVIEW_MAX_PROP_AMMOUNT or PREVIEW_MAX_PROP_AMMOUNT == 0) then
				local iBufferIndex = i
				if (firstPropAltitude == nil) or (firstPropPos == nil) then return end;
				local vOriginOffset = vecSub(vPos, firstPropPos);
				local newProp = _EntCreate("prop_dynamic_override");
				previewTable[table.getn(previewTable) + 1] = newProp;
				local vNewPropPos = vecAdd(vOriginOffset, copyBufferTable[iBufferIndex][3])
				--local vNewPropPos = copyBufferTable[iBufferIndex][3];
				_EntPrecacheModel(copyBufferTable[iBufferIndex][2])
				_EntSetKeyValue(newProp, "model", copyBufferTable[iBufferIndex][2])
				--_EntSetModel(newProp, copyBufferTable[iBufferIndex][2]);
				_EntSetPos(newProp, doRotPos(iBufferIndex, vNewPropPos, vPos));
				_EntSetAngAngle(newProp, doRotAng(copyBufferTable[iBufferIndex][4]));
				_EntSetSolid(newProp, 0);
				_EntSetMoveType(newProp, 0)
				_EntSetCollisionGroup(newProp, 0)
				_EntSetKeyValue(newProp, "targetname", "cg_preview");
				_EntSetKeyValue(newProp, "rendermode", "1");
				_EntSetKeyValue(newProp, "renderamt", "160");
				_EntSetKeyValue(newProp, "spawnflags", "527");
				_EntSpawn(newProp);
				preview_counter = preview_counter + 1
			else
				DispMessage(9, PREVIEW_MAX_PROP_AMMOUNT)
				break
			end
		end
	end
	
	function clearPreview()
		for i = 1, table.getn(previewTable) do
			_EntRemove(previewTable[i]);
		end
		previewTable = {};
	end
	
	function previewExists()
		if table.getn(previewTable) < 1 then
			return false;
		else
			return true;
		end
	end
	
	function movePreview(localOrigin2)
		if previewExists() == false then return end;
		local localOrigin1 = _EntGetPos(previewTable[1])
		if localOrigin1 == localOrigin2 then return end;
		local refVec = vecSub(localOrigin2, localOrigin1)
		for i = 1, table.getn(previewTable) do
			_EntSetPos(previewTable[i], vecAdd(_EntGetPos(previewTable[i]), refVec))
		end
	end
	
	function PreviewChangeAngle()
		vPos = previewPos;
		for i = 1, table.getn(previewTable) do
			local iBufferIndex = i;
			local vOriginOffset = vecSub(vPos, firstPropPos);
			local vNewPropPos = vecAdd(vOriginOffset, copyBufferTable[iBufferIndex][3])
			_EntSetPos(previewTable[iBufferIndex], doRotPos(iBufferIndex, vNewPropPos, vPos));
			_EntSetAngAngle(previewTable[iBufferIndex], doRotAng(copyBufferTable[iBufferIndex][4]));
		end
	end
	
	function respawnPreview()
		clearPreview();
		spawnPreview();
	end
	
	function setPreview(iChoice)
		if (iChoice ~= 0) and (iChoice ~= 1) then
			if setPreview == 1 then setPreview = 0 end;
			if setPreview == 0 then setPreview = 1 end;
		else
			showPreview = iChoice
		end	
		if showPreview == 0 then
			DispMessage(7, "OFF")
			clearPreview();
		elseif showPreview == 1 then
			DispMessage(7, "ON")
			respawnPreview();
		end
		if(IsDeployed == true) then
			show_copygun_status();
		end
	end
	
	function vecFromString(v1)
		local iCount = 0;
		local tempTable = {};
		for w in string.gfind(v1, "%-?%d+%.?%d*") do
			iCount = iCount + 1;
			tempTable[iCount] = w;
		end
		return vector3(tempTable[1], tempTable[2], tempTable[3]);
	end
	
	function LoadInfo(fileDir,fileName)
		local loadData = _file.Read(fileDir)
		_Msg("Load string length:" .. string.len(loadData) .. " chars\n")
		local tempTable = {};
		local iCount = 0;
		for w in string.gfind(loadData, "%b{}") do             
			iCount = iCount + 1;
			tempTable[iCount] = string.sub(w, 2, -2);
		end
		DispMessage(3, fileName.." ("..iCount.." props)");
		copyBufferTable = {};
		firstPropAltitude = 0;
		firstPropPos = vector3(0, 0, 0);
		
		for i = 1, table.getn(tempTable) do
			iCount = 0;
			copyBufferTable[i] = {};
			for w in string.gfind(tempTable[i], "%b#@") do
				iCount = iCount + 1;
				if (iCount == 3) or (iCount == 4) then
					copyBufferTable[i][iCount] = vecFromString(string.sub(w, 2, -2));
				else
					copyBufferTable[i][iCount] = string.sub(w, 2, -2);
				end
			end
		end
		
		tempTable = {};
		weldTable = nil;
		weldTable = {};
		
		iCount = 0;
		for w in string.gfind(loadData, "%b<>") do             
			iCount = iCount + 1;
			tempTable[iCount] = string.sub(w, 2, -2);
		end		
		_Msg(iCount .. " welds loaded \n")
		for i = 1, table.getn(tempTable) do
			iCount = 0;
			weldTable[i] = {};
			for w in string.gfind(tempTable[i], "%b#@") do
				iCount = iCount + 1;
				weldTable[i][iCount] = string.sub(w, 2, -2);
			end
		end		
		
		firstPropPos = copyBufferTable[1][3];
		for w in string.gfind(loadData, "%b()") do
			firstPropAltitude = string.sub(w, 2, -2);
		end
		
		if IsDeployed then respawnPreview() end;
		
		unColorOriginals();
		spawnFrozen = 1; -- And let the loaded stuff spawn frozen. Otherwise, someone might forgotten it to spawn 1000 props unfrozen = massive lag
		if(IsDeployed == true) then
			show_copygun_status();
		end
	end
	
	function updateHudText()
		if(Owner ~= 0) then
			-- How much copy left...
			if(isAdmin(Owner) == true --[[or isVip(Owner) == true --]]or MAX_ENTITY_COPY == 0) then
				_GModText_Start("CloseCaption_Bold");
				_GModText_SetPos(0, 1);
				_GModText_SetColor( 255, 255, 255, 255 );
				_GModText_SetTime( 99999, 0, 0 );
				_GModText_SetText( "Unlimited props left for CopyGun" );
				_GModText_SetDelay( 0 );
				_GModText_Send( Owner, 200);
			else
				_GModText_Start("CloseCaption_Bold");
				_GModText_SetPos(0, 1);
				_GModText_SetColor( 255, 255, 255, 255 );
				_GModText_SetTime( 99999, 0, 0 );
				_GModText_SetText( MAX_ENTITY_COPY - table.getn(copyBufferTable) .. " props left for CopyGun" );
				_GModText_SetDelay( 0 );
				_GModText_Send( Owner, 200);
			end
			
			-- Tell ppl how to remove pattern
			
			_GModText_Start("CloseCaption_Bold");
			_GModText_SetPos(0.1, 0.15);
			_GModText_SetColor( 0, 255, 0, 200 );
			_GModText_SetTime( 99999, 0, 0 );
			_GModText_SetText( "Press RELOAD to clear a CopyGun pattern" );
			_GModText_SetDelay( 0 );
			_GModText_Send( Owner, 102);
			show_copygun_status()
		end
	end
	
	function clearHudText()
		_GModText_Hide(Owner, 102);
		_GModText_Hide(Owner, 200);
		_GModText_Hide(Owner, 303)
		_GModRect_Hide(Owner, 301)
	end
	
	-- Called every frame
	previewPos = vector3(0,0,0);
	function onThink( )
		if(think_start == true) then
			if(isAdmin(Owner) == true --[[or isVip(Owner) == true--]]) then
				weldmaxrange=weldmaxrange_vip;
			else
				weldmaxrange=weldmaxrange_standard;
			end
			updateHudText()
			think_start = false;
		end
		if (LastPoll + POLL_INTERVAL) <= _CurTime() then 
			LastPoll = _CurTime()
			Poll();
			if(showPreview ~= 0) then
				-- Old Traceline was 32768
				_TraceLine(_PlayerGetShootPos(Owner),_PlayerGetShootAng(Owner), 4096, Owner);
				
				if _TraceHit() then --I think spawning in non-world hit locations would be nice...
					previewPos = _TraceEndPos();
					previewPos.z = previewPos.z + firstPropAltitude
					movePreview(previewPos);
				end
			end
		end
	end

	function show_copygun_status()
		if(Owner == nil or Owner == 0) then
			return;
		end
		local rect_high = 0.13;
		if(think_start == true) then
			_GModRect_Start("gmod/white")
			if(current_fileName ~= nil) then
				rect_high =  rect_high + 0.02;
			end
			if(table.getn(npc_weapon) ~= 0) then
				rect_high =  rect_high + 0.02;
			end
			_GModRect_SetPos(0.03, 0.4, 0.24, rect_high)
			_GModRect_SetColor(0, 0, 0, 150)
			_GModRect_SetTime(99999, 0, 0)
			_GModRect_Send(Owner, 301)
		end
		-- Text
		local loaded_file = "";
		if(current_fileName ~= nil) then
			loaded_file = "\nFile: "..current_fileName
		end
		local show_npc_weapons = "";
		if(table.getn(npc_weapon) ~= 0) then
			if(table.getn(npc_weapon) ~= table.getn(NPC_ALLOWED_WEAPONS)) then
				for k,v in npc_weapon do
					show_npc_weapons = show_npc_weapons..";"..v;
				end
				show_npc_weapons = string.sub(string.gsub(show_npc_weapons,"weapon_",""),2);
			else
				show_npc_weapons = "random";
			end
			show_npc_weapons = "\nNPC Weapons: "..show_npc_weapons;
		end
		local info_text = "Prop/Weld Ammount: ".. table.getn(copyBufferTable) .. "/".. table.getn(weldTable) .."\nPreview: ".. showPreview .."\nSpawn Frozen: "..spawnFrozen.."\nSpawn Dynafrozen: "..dynafrozen.."\nAngle: "..rotAng..show_npc_weapons..loaded_file;
		_GModText_Start("ChatFont")
		_GModText_SetPos(0.04, 0.415)
		_GModText_SetTime(99999, 0, 0)
		_GModText_SetText(info_text)
		_GModText_SetColor(255, 255, 255, 255)
		_GModText_Send(Owner, 303)
	end
	
	--Info for the copygun welder
	function show_copygunwelder_status(isThink)
		if(Owner == nil or Owner == 0) then
			return;
		end
		if(Owner ~= 0) then
			if(isThink ~= "") then
				_GModRect_Start("gmod/white")
				_GModRect_SetPos(0.03, 0.4, 0.24, 0.09)
				_GModRect_SetColor(0, 0, 0, 150)
				_GModRect_SetTime(99999, 0, 0)
				_GModRect_Send(Owner, 301)
			end
			-- Text
			local info_text = "Prop/Weld Ammount: ".. table.getn(copyBufferTable) .. "/".. table.getn(weldTable).."\nSmartWeld Radius: "..weldrange.."/"..weldmaxrange.."\nMaximum Welds: "..MAX_WELDS;
			_GModText_Start("ChatFont")
			_GModText_SetPos(0.04, 0.415)
			_GModText_SetTime(99999, 0, 0)
			_GModText_SetText(info_text)
			_GModText_SetColor(255, 255, 255, 255)
			_GModText_Send(Owner, 303)
		end
	end
	
	function show_sphere_status(distance,isThink)
		if(Owner == nil or Owner == 0) then
			return;
		end
		if(isThink == true) then
			_GModRect_Start("gmod/white")
			_GModRect_SetPos(0.03, 0.4, 0.24, 0.07)
			_GModRect_SetColor(0, 0, 0, 150)
			_GModRect_SetTime(99999, 0, 0)
			_GModRect_Send(Owner, 301)
		end
		-- Text
		local info_text = "Prop/Weld Ammount: ".. table.getn(copyBufferTable) .. "/".. table.getn(weldTable).."\nRadius: "..math.ceil(tonumber(distance));
		_GModText_Start("ChatFont")
		_GModText_SetPos(0.04, 0.415)
		_GModText_SetTime(99999, 0, 0)
		_GModText_SetText(info_text)
		_GModText_SetColor(255, 255, 255, 255)
		_GModText_Send(Owner, 303)
	end
	
	function show_quad_status(seizes,isThink)
		if(Owner == nil or Owner == 0) then
			return;
		end
		if(isThink == true) then
			_GModRect_Start("gmod/white")
			_GModRect_SetPos(0.03, 0.4, 0.24, 0.13)
			_GModRect_SetColor(0, 0, 0, 150)
			_GModRect_SetTime(99999, 0, 0)
			_GModRect_Send(Owner, 301)
		end
		-- Text
		seizes = gmx.explode(seizes," ");
		local info_text = "Prop/Weld Ammount: ".. table.getn(copyBufferTable) .. "/".. table.getn(weldTable).."\nQuadseizes:\n  Width: "..math.ceil(tonumber(seizes[1])*1.42).."\n  Length: "..math.ceil(tonumber(seizes[2])*1.42).."\n  Height: "..math.ceil(tonumber(seizes[3])*1.42);
		_GModText_Start("ChatFont")
		_GModText_SetPos(0.04, 0.415)
		_GModText_SetTime(99999, 0, 0)
		_GModText_SetText(info_text)
		_GModText_SetColor(255, 255, 255, 255)
		_GModText_Send(Owner, 303)
	end
	
	function onDrop( playerid )
		clearPreview();
		clearHudText();
		unColorOriginals();
		originalTable = nil;
		originalTable = {};
		firstPropAltitude = nil;
		firstPropPos = nil;
		copyBufferTable = nil;
		copyBufferTable = {};
		weldTable = {};
		spawnTable = {};
	    _EntRemove( MyIndex );
	end 
	

-- When the player presses left mouse button

	function onPrimaryAttack( )	
		_TraceLine(_PlayerGetShootPos(Owner),_PlayerGetShootAng(Owner), 4096, Owner);
		local iEnt = _TraceGetEnt();
		if(table.getn(copyBufferTable) < MAX_ENTITY_COPY or isAdmin(Owner) --[[or isVip(Owner)--]] or MAX_ENTITY_COPY == 0) then
			-- Old Traceline was 32768
			if(COPYGUN_USE_PROPPROTECTOR_SWEPWRAPPER == true and PLAYER_CAN_USE_COPYGUN_ON_ALL_PROPS == false) then
				_RunString("prop_protectionSWEPWrapper(".. Owner ..","..iEnt..",".. MyIndex ..",\"CopyGunisOwnerOfThisProp\")")
			else
				copygun_is_owner = true
			end
			if(copygun_is_owner == true) then
				if _TraceHitNonWorld() then
					local vHit = _TraceEndPos();
					--local vecpos = _PlayerGetShootPos( Owner );
					
					_EffectInit();
					_EffectSetEnt( Owner );
					_EffectSetOrigin( vHit );
					--_EffectSetStart( vecpos );
					_EffectSetScale( 200 );
					_EffectSetMagnitude( 500 );
					_EffectDispatch( "AR2Impact" );
					AddCopyItem (iEnt);
					if(isAdmin(Owner) == false --[[and isVip(Owner) == false--]] or MAX_ENTITY_COPY == 0) then
						updateHudText();
					else
						show_copygun_status()
					end
				end
				if(table.getn(copyBufferTable) <= PREVIEW_MAX_PROP_AMMOUNT+1 or PREVIEW_MAX_PROP_AMMOUNT == 0) then
					respawnPreview();
				end
			end
		else
			if(AlreadyCopied(iEnt) ~= false) then
				RemoveOutOfSpawnIndex(AlreadyCopied(iEnt));
				_EntFire(iEnt, "color", "255+255+255", 0);
				if(isAdmin(Owner) == false --[[and isVip(Owner) == false--]] or MAX_ENTITY_COPY == 0) then
					updateHudText();
				else
					show_copygun_status()
				end
			else
				_GModText_Start("CloseCaption_Bold");
				_GModText_SetPos(0.23, 0.40);
				_GModText_SetColor( 255, 255, 255, 255 );
				_GModText_SetTime( 2, 0, 0 );
				_GModText_SetText( "You can only select " .. MAX_ENTITY_COPY .. " props at one time for a copy!" );
				_GModText_SetDelay( 0 );
				_GModText_Send( Owner, 99 );
			end
		end
	end

	

-- When the player presses right mouse button

	function onSecondaryAttack( )
		if(last_spawn <= _CurTime() or isAdmin(Owner)) then
			last_spawn = SPAWN_INTERVAL + _CurTime();
			spawnTable = {};
			if (firstPropPos == nil) then return end;
			-- Old Traceline was 32768
			_TraceLine(_PlayerGetShootPos(Owner),_PlayerGetShootAng(Owner), 4096, Owner);
			local vSpawnPos = _TraceEndPos();
			vSpawnPos.z = vSpawnPos.z + firstPropAltitude
			if _TraceHit() then --again, I'd like to spawn on a non-world surface.
				for i = 1, table.getn(copyBufferTable) do
					SpawnCopyItem (i, vSpawnPos);
				end
				DOOR_TEMP_SAVE = {} -- Reset the Door/Button saver!
				for i = 1, table.getn(weldTable) do
					SpawnWeld(i);
					if(i == MAX_WELDS) then
						return;
					end
				end
			end
		else
			_GModText_Start("CloseCaption_Bold");
			_GModText_SetPos(0.23, 0.40);
			_GModText_SetColor( 255, 255, 255, 255 );
			_GModText_SetTime( 2, 0, 0 );
			_GModText_SetText( "You just can spawn props every " .. SPAWN_INTERVAL .. " seconds!" );
			_GModText_SetDelay( 0 );
			_GModText_Send( Owner, 99 );
		end
	end

	function Deploy( )
		IsDeployed = true;
		updateHudText()
		respawnPreview();
		think_start = true;
	end
	
	function Holster( )
		IsDeployed = false;
		clearHudText();
		clearPreview();
		think_start = true;
	end
	
-- When player presses reload. Returning false means DONT RELOAD. Although this will hitch on the client.

	function onReload( )
		if(isAdmin(Owner) == false --[[and isVip(Owner) == false--]]) then
			updateHudText();
		else
			show_copygun_status()
		end
		clearPreview();
		unColorOriginals();
		originalTable = nil;
		originalTable = {};
		firstPropAltitude = nil;
		firstPropPos = nil;
		copyBufferTable = nil;
		copyBufferTable = {};
		current_fileName = nil;
		DOOR_TEMP_SAVE = {} -- Reset the Door/Button saver!
		think_start = true;
		rotAng = 0; -- Reset angle
		DispMessage(0, "");
		weldTable = {};
		spawnTable = {};
		return true;
	end

-- These are only accessed once when setting up the weapon
	function getWeaponSwapHands()
		return false;	
	end
	function getWeaponFOV()
		return 70;	
	end
	function getWeaponSlot()
		return 5;	
	end
	function getWeaponSlotPos()
		return 4;	
	end
	function getFiresUnderwater()
		return true;
	end
	function getReloadsSingly()
		return false;
	end
	-- Primary Attack
	function getDamage()
		return 10;
	end
	function getPrimaryShotDelay()
		return 0.1;
	end
	function getPrimaryIsAutomatic()
		return true;
	end
	function getBulletSpread()
		return vector3( 0.0, 0.0, 0.0 );
	end
	function getViewKick()
		return vector3( 0.0, 0.0, 0.0);
	end
	function getViewKickRandom()
		return vector3( 0, 0, 0 );
	end
	function getNumShotsPrimary()
		return 1;
	end
	function getPrimaryAmmoType()
		return "pistol";
	end
	-- Secondary attack
	function getDamageSecondary()
		return 10;
	end
	function getSecondaryShotDelay()
		return 0.2;
	end
	function getSecondaryIsAutomatic()
		return false;
	end
	function getBulletSpreadSecondary()
		return vector3( 0.0, 0.0, 0.0 );
	end
	function getViewKickSecondary()
		return vector3( 0.0, 0.0, 0.0);
	end
	function getViewKickRandomSecondary()
		return vector3( 0, 0, 0 );
	end
	function getNumShotsSecondary()
		return 1;
	end
	function getSecondaryAmmoType()
		return "pistol";
	end
	function getViewModel( )
		return "models/weapons/v_crossbow.mdl";
	end
	function getWorldModel( )
		return "models/weapons/w_crossbow.mdl";
	end
	function getClassName() 
		return "tool_lua_groupcopy";
	end
	function getHUDMaterial( )
		return "gmod/SWEP/default";
	end
	function getMaxClipPrimary() -- return -1 if it doesn't use clips
		return 25;
	end
	function getMaxClipSecondary() -- return -1 if it doesn't use clips
		return -1;
	end
	function getDefClipPrimary() -- ammo in gun by default
		return 25;
	end
	function getDefClipSecondary()
		return 0;
	end
	function getAnimPrefix() -- How the player holds the weapon: pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade
		return "crossbow";
	end
	function getPrintName()
		return "~[Group Copy Tool]~";
	end
	-- 0 = Don't override, shoot bullets, make sound and flash
	-- 1 = Don't shoot bullets but do make flash/sounds
	-- 2 = Only play animations
	-- 3 = Don't do anything
	function getPrimaryScriptOverride()
		return 1;
	end
	function getSecondaryScriptOverride()
		return 1;
	end
