	_OpenScript("includes/player.lua")
	DEFAULT_CATEGORY = "Copy Gun Patterns"
	IDTable = {}
	CurGivePlayer = 1;
	
	function eventPlayerSay(PID, strText)
		local strCompare = string.lower(strText);
		local saveStart, saveEnd  = string.find(strCompare, "-cgsave ", 1, true);
		local loadStart, loadEnd  = string.find(strCompare, "-cgload ", 1, true);
		local rotStart, rotEnd  = string.find(strCompare, "-cgrot ", 1, true);
		local frozenStart, frozenEnd  = string.find(strCompare, "-cgfrozen ", 1, true);
		local previewStart, previewEnd  = string.find(strCompare, "-cgpreview ", 1, true);
		if (saveEnd ~= nil) and _PlayerHasWeapon(PID, "tool_lua_groupcopy") then
			local fileName = string.sub(strText, saveEnd + 1);
			_Msg("Saved As \""..fileName..".cgs\" by player ID "..PID.."\n");
			local runstring = "doFileSave(\""..fileName.."\")";
			_SWEPRunString(GetWeapByPlayer(PID), runstring);
			return "";
		elseif (loadEnd ~= nil) and _PlayerHasWeapon(PID, "tool_lua_groupcopy") then
			local fileName = string.sub(strText, loadEnd + 1);
			_Msg("Loading \""..fileName..".cgs\" for player ID "..PID.."\n");
			local runstring = "doFileLoad(\""..fileName.."\")";
			_SWEPRunString(GetWeapByPlayer(PID), runstring);
			return "";
		elseif (rotEnd ~= nil) and _PlayerHasWeapon(PID, "tool_lua_groupcopy") then
			local rotAng = string.sub(strText, rotEnd + 1);
			local runstring = "setRotAng("..rotAng..")";
			_SWEPRunString(GetWeapByPlayer(PID), runstring);
			return "";
		elseif (frozenEnd ~= nil) and _PlayerHasWeapon(PID, "tool_lua_groupcopy") then
			local IsFrozen = string.sub(strText, frozenEnd + 1);
			local runstring = "setFrozen("..IsFrozen..")";
			_SWEPRunString(GetWeapByPlayer(PID), runstring);
			return "";
		elseif (previewEnd ~= nil) and _PlayerHasWeapon(PID, "tool_lua_groupcopy") then
			local choice = string.sub(strText, previewEnd + 1);
			local runstring = "setPreview("..choice..")";
			_SWEPRunString(GetWeapByPlayer(PID), runstring);
			return "";
		else
			return strText;
		end
	end
	
	function CallAddWeld(ent1, ent2, PID)
		local runstring = "AddWeld(" .. ent1 .. ", " .. ent2 .. ")";
		_SWEPRunString(GetWeapByPlayer(PID), runstring);
	end
	
	function PollResponse(PID, WeapID) --called by SWEPs for polling
		IDTable[PID] = WeapID;
	end
	
	function ClearIDTable()
		IDTable = nil;
		IDTable = {};
		_Msg("ID Table Flushed! \n");
	end
	
	function GetWeapByPlayer(PID)
		if _EntExists(IDTable[PID]) == false then return 0 end;
		return IDTable[PID];
	end
	
	function cg_give_totarget()
		if IsPlayerOnline(CurGivePlayer) == false then return end;
		cggive(CurGivePlayer);
	end
	
	function cg_give_target(caller, PID)
		if caller ~= 1 then return end;
		if PID == nil then return end;
		local nPID = tonumber(PID);
		if IsPlayerOnline(nPID) == false then return false end;
		CurGivePlayer = nPID;
		return PID;
	end
	
	function cggive(PID)
		if IsPlayerOnline(PID) == false then return end;
		_PlayerGiveSWEP(PID,"weapons/CopyGun/CopyGunWelder.lua");
		_PlayerGiveSWEP(PID,"weapons/CopyGun/CopyGun.lua");
	end
	CONCOMMAND("cg_give_target", cg_give_target);
	CONCOMMAND("cg_clearidtable", ClearIDTable);

	FILTER_STRING = "([^%.%/%\%?%:%(%)%|]+)%.cgs"
	
	function RefreshSpawnMenu(PID)
		fileList = _file.Find("cg_saves/*")
		_spawnmenu.RemoveCategory(PID, DEFAULT_CATEGORY)
		_spawnmenu.SetCategory(PID, DEFAULT_CATEGORY)
		_spawnmenu.AddItem(PID, DEFAULT_CATEGORY, "@Server's Patterns", "title")
		for i = 3, table.getn(fileList) do
		local L, U, simpleName = string.find(fileList[i], FILTER_STRING)
			local runString = "say -cgload " .. simpleName
			_spawnmenu.AddItem(PID, DEFAULT_CATEGORY, "+"..simpleName, runString)
		end
	end
	
	function cc_refreshmenu()
		RefreshSpawnMenu(0);
	end
	
	CONCOMMAND("cg_refreshmenu", cc_refreshmenu)
	RefreshSpawnMenu(0);
	HookEvent("eventPlayerInitialSpawn", RefreshSpawnMenu)