--[[

Group Copy Gun v1r4b
by ZeroPoint

Requires Gmod 9.0.4 or greater
You must run 'CopyGunIO.lua' first.

Usage:

Primary Fire selects props for copy, the targets turn green as you select them.
Secondary Fire spawns a duplicate of the 'pattern' at the selected location.

Saying '-cgsave <name>' ingame will save the gun's current pattern to file(s) in the gmod/cg_saves.
The save will cancel if there is a file with a duplicate name. (This prevents clients from overwriting your stuff)

Saying '-cgload <name>' will load a pattern from file.

Saying '-cgrot <angle>' will set the amount of rotation for subsequent paste operations. Rotation is measured counterclockwise, in degrees. 
Positive angles less than 360 and negative angles greater than -360 are permitted.

Reload will clear any pattern from the gun and remove the green marking from previously selected elements.


Tips/Known Bugs:

Try to select a prop at the bottom of your structure first. In order to record the structure's 'altitude' correctly, the target prop must have a clear 'view' of the ground. Otherwise, part of the arrangement may spawn underground 
when you attempt to paste a copy.
As of this version, it's a bad idea to try and copy the duplicate of a structure. As far as I can tell, there's some strange problem with data corruption in _EntGetModel; in certain cases it returns either an incomplete string, 
or an invalid string which causes an error that shuts down the server. Until this issue is resolved, stick to copying arrangements of props that have been spawned from the menu.

]]


_OpenScript( "includes/vector3.lua" );
--_OpenScript( "includes/misc.lua" );

DEFAULT_SAVE_PARTIALDIR = "cg_saves/";
DEFAULT_SAVE_FOLDER = string.sub(DEFAULT_SAVE_PARTIALDIR, 1, -2);
POLL_INTERVAL = 0.1

-- These variables are passed by the engine



MyIndex			=	0; -- Weapon's entity index.

Owner			= 	0; -- The player that owns this weapon

CurrentTime		=	0; -- The current game time

rotAng = 0;
spawnWelds = 1;
spawnFrozen = 1;
showPreview = 1;

IsDeployed = false;
LastPoll = _CurTime();
firstPropAltitude = nil;
firstPropPos = nil;
copyBufferTable = {};
originalTable = {};
weldTable = {};
spawnTable = {};
previewTable = {};

	function setFrozen(iState)
		if (iState ~= 1) and (iState ~= 0) then
			if spawnFrozen == 1 then spawnFrozen = 0 end;
			if spawnFrozen == 0 then spawnFrozen = 1 end;
		else
			spawnFrozen = iState;
		end
		if spawnFrozen == 0 then
			DispMessage(8, "Unfrozen");
		end
		if spawnFrozen == 1 then
			DispMessage(8, "Frozen");
		end		
	end
	
	function indexByEnt(iEnt)
		for i = 1, table.getn(originalTable) do
			if originalTable[i] == iEnt then
				return i;
			end
		end
		return nil;
	end
	
	function AddWeld(iEnt1, iEnt2) --an external 'welder' SWEP will select the two ents for welding. All major scripting is handled in this SWEP for ease of processing.
		if iEnt1 == iEnt2 then return end;
		if (AlreadyCopied(iEnt1) == false) or (AlreadyCopied(iEnt2) == false) then return end;
		local newWeld = NCWeldEntities(iEnt1, iEnt2)
		local newWeldInfo = {};
		newWeldInfo[1] = "phys_constraint"
		newWeldInfo[2] = indexByEnt(iEnt1)
		newWeldInfo[3] = indexByEnt(iEnt2)
		table.insert(weldTable, newWeldInfo)
	end
	
	function SpawnWeld(iIndex)
		local origIndex1 = weldTable[iIndex][2]
		local origIndex2 = weldTable[iIndex][3]
		--_Msg("SpawnWeld: "..origIndex1.." "..origIndex2.."\n")
		local newWeld = NCWeldEntities(spawnTable[tonumber(origIndex1)], spawnTable[tonumber(origIndex2)])
	end
	
	function NCWeldEntities( enta, entb )		--Don't panic, it's just a modification of Garry's helper routine.

		local iConstraint = _EntCreate( "phys_constraint" );

		_EntSetPos( iConstraint, _EntGetPos( enta ) );
		_EntSetKeyValue( iConstraint, "attachpoint", _EntGetPos( entb ) );
		_EntSetKeyValue( iConstraint, "spawnflags", "1" );
		_PhysConstraintSetEnts( iConstraint, enta, entb );	
		
		_EntSpawn( iConstraint );
		_EntActivate( iConstraint );

		return iConstraint;

	end
	
	function DispMessage(iSel, msg1)
--[[		0: Reset
		1: Saved Successfully 		
		2: Save Cancelled due to Overwrite
		3: Loaded Successfuly
		4: Load file could not be found.
		5: Angle set successfully
		6: Angle was invalid
		7: Preview On/Off
		8: Freeze On/Off
]]		
		
		if iSel == 0 then
			_ScreenText ( Owner, "Pattern Cleared!", 0.3, -1, 255, 255, 255, 255, 0.1, 0.1, 3, 0, 2 )
		elseif iSel == 1 then
			_ScreenText ( Owner, "Pattern "..msg1.." saved successfully!", 0.3, -1, 255, 255, 255, 255, 0.1, 0.1, 3, 0, 2 )
		elseif iSel == 2 then
			_ScreenText ( Owner, "Pattern "..msg1.." already exists, try another name.", 0.3, -1, 255, 255, 255, 255, 0.1, 0.1, 3.5, 0, 2 )
		elseif iSel == 3 then
			_ScreenText ( Owner, msg1.." props loaded successfully!", 0.3, -1, 255, 255, 255, 255, 0.1, 0.1, 3, 0, 2 )
		elseif iSel == 4 then
			_ScreenText ( Owner, "Pattern "..msg1.." could not be found.", 0.3, -1, 255, 255, 255, 255, 0.1, 0.1, 3, 0, 2 )
		elseif iSel == 5 then
			_ScreenText ( Owner, "Angle set to "..msg1.." degrees.", 0.3, -1, 255, 255, 255, 255, 0.1, 0.1, 3, 0, 2 )
		elseif iSel == 6 then
			_ScreenText ( Owner, "Angle is invalid.", 0.3, -1, 255, 255, 255, 255, 0.1, 0.1, 3, 0, 2 )
		elseif iSel == 7 then
			_ScreenText ( Owner, "Ghost preview "..msg1, 0.3, -1, 255, 255, 255, 255, 0.1, 0.1, 2, 0, 2 )
		elseif iSel == 8 then
			_ScreenText ( Owner, "Patterns will spawn "..msg1, 0.3, -1, 255, 255, 255, 255, 0.1, 0.1, 2, 0, 2 )
		end
	end

	function setRotAng(ang)
		if (ang >= 0) and (ang < 360) then
			rotAng = ang;
			DispMessage(5, rotAng)
		elseif (ang < 0) and (ang > -360) then
			rotAng = 360 + ang;
			DispMessage(5, rotAng)
		else
			rotAng = 0;
			DispMessage(6)
		end
		respawnPreview();
	end
	
	function doRotPos(iIndex, intendedPos, localOrigin)
		local vRefVec = vecSub(intendedPos, localOrigin);
		local radius = math.sqrt(vRefVec.x^2 + vRefVec.y^2);
		local alpha_xy
		if (vRefVec.y == 0) and (vRefVec.x ~= 0) then
			alpha_xy = vRefVec.x         --this and the next two elseif statements prevent unnecessary trig functions and 'divide by zero' errors.
		elseif (vRefVec.y ~= 0) and (vRefVec.x == 0) then
			alpha_xy = vRefVec.y
		elseif (vRefVec.y == 0) and (vRefVec.x == 0) then
			return intendedPos
		elseif (vRefVec.y < 0) and (vRefVec.x < 0) then
			alpha_xy = math.deg(math.atan(vRefVec.y/vRefVec.x)) + 180 --corrects angle for lower left quadrant
		elseif (vRefVec.y > 0) and (vRefVec.x < 0) then
			alpha_xy = math.deg(math.atan(vRefVec.y/vRefVec.x)) + 180; --corrects angle for upper left quadrant
		else
			alpha_xy = math.deg(math.atan(vRefVec.y/vRefVec.x));
		end
		alpha_xy = alpha_xy + rotAng;
		if alpha_xy > 360 then
			alpha_xy = alpha_xy - 360
		elseif alpha_xy < 0 then
			alpha_xy = alpha_xy + 360
		end
		local vNewVec = vector3(0, 0 , intendedPos.z);
		vNewVec.y = math.sin(math.rad(alpha_xy));
		vNewVec.x = math.cos(math.rad(alpha_xy));
		vNewVec = vecMul(vNewVec, vector3(radius, radius , 1));
		localOrigin = vector3(localOrigin.x,localOrigin.y,0);
		vNewPos = vecAdd(localOrigin, vNewVec)
		return vNewPos;
	end
	
	function doRotAng(vOrigAng)
		return vector3(vOrigAng.x, (vOrigAng.y + rotAng), vOrigAng.z);
	end
	
	function AlreadyCopied(iEnt)
		for i = 1, table.getn(originalTable) do
			if originalTable[i] == iEnt then
				return true;
			end
		end
		return false;
	end
	
	function AddCopyItem(iEnt)
		local className = _EntGetType(iEnt);
		local modelName = _EntGetModel(iEnt);
		local vPos = _EntGetPos(iEnt);
		local vAng = _EntGetAng(iEnt);
		local vAngAngle = _EntGetAngAngle(iEnt);
		if AlreadyCopied(iEnt) then return end;
		if (className ~= "prop_physics") then return end;
		table.insert(originalTable, iEnt);
		_EntFire(iEnt, "color", "0+255+0", 0);
		_TraceLine(vPos, vector3(0, 0, -1), 32768, iEnt);
		local altitude = vecLength(vecSub(vPos, _TraceEndPos()));
		if (table.getn(copyBufferTable) <= 0) then
			firstPropAltitude = altitude;
			firstPropPos = vPos;
		end
		local iTableIndex = table.getn(copyBufferTable) + 1;
		local entData = {};
		entData[1] = className;
		entData[2] = modelName;
		entData[3] = vPos;
		entData[4] = vAngAngle;
		copyBufferTable[iTableIndex] = entData;
	end

	function SpawnCopyItem(iBufferIndex, vPos) --spawns prop from copyBufferTable[iBufferIndex] with relative arrangement pos 'vPos'
		if (firstPropAltitude == nil) or (firstPropPos == nil) then return end;
		local vOriginOffset = vecSub(vPos, firstPropPos);
		local newProp = _EntCreate(copyBufferTable[iBufferIndex][1]);
		spawnTable[table.getn(spawnTable) + 1] = newProp;
		local vNewPropPos = vecAdd(vOriginOffset, copyBufferTable[iBufferIndex][3])
		_EntPrecacheModel(copyBufferTable[iBufferIndex][2])
		_EntSetKeyValue(newProp, "model", copyBufferTable[iBufferIndex][2])
		--_EntSetModel(newProp, copyBufferTable[iBufferIndex][2]); --Maybe this line was the reason for string corruption?
		_EntSetPos(newProp, doRotPos(iBufferIndex, vNewPropPos, vPos));
		_EntSetAngAngle(newProp, doRotAng(copyBufferTable[iBufferIndex][4]));
		_EntSpawn(newProp);
		if spawnFrozen == 1 then
			_PhysEnableMotion(newProp, false);
		end
	end
	
	function unColorOriginals()
		for i = 1, table.getn(originalTable) do
			if _EntExists(originalTable[i]) then
				_EntFire(originalTable[i], "color", "255+255+255", 0); 
			end
		end
	end
	
	function colorOriginals()
		for i = 1, table.getn(originalTable) do
			if _EntExists(originalTable[i]) then
				_EntFire(originalTable[i], "color", "0+255+0", 0); 
			end
		end
	end
	
	function checkDefFolder()
		if _file.Exists(DEFAULT_SAVE_FOLDER) == false then
			_file.CreateDir(DEFAULT_SAVE_FOLDER);
		end
		return _file.Exists(DEFAULT_SAVE_FOLDER);
	end

	function doFileSave(fileName)
		if checkDefFolder() == false then 
			_Msg("Error: Could not create save folder!\n");
			return;
		end
		local saveDir = DEFAULT_SAVE_PARTIALDIR .. fileName .. ".cgs"; -- '.cgs' stands for Copy Gun Save. :p
		_Msg("Saving to: "..fileName.."\n")
		if _file.Exists(saveDir) then
			DispMessage(2, fileName);
			return;
		else 
			DispMessage(1, fileName);
		end
		SaveInfo(saveDir);
	end
	
	function doFileLoad(fileName)
		local loadDir
		if _file.Exists(DEFAULT_SAVE_FOLDER) == false then return end;
		if string.lower(string.sub(fileName, -4, -1)) ~= ".cgs" then
			loadDir = DEFAULT_SAVE_PARTIALDIR .. fileName .. ".cgs"
		else
			loadDir = DEFAULT_SAVE_PARTIALDIR .. fileName
		end
		if _file.Exists(loadDir) == false then 
			DispMessage(4 , fileName);
			return;
		end
		LoadInfo(loadDir);
	end
	
	function Poll()
		local parentNum = _EntGetParent(MyIndex)
		if parentNum == 0 then return end;
		--if _PlayerHasWeapon(parentNum, "tool_lua_groupcopy_welder") == false then
			--_PlayerGiveSWEP(parentNum, "weapons/CopyGun/CopyGunWelder.lua");
			--_PlayerSelectSWEP(1,"lua_tool_groupcopy");
		--end
		_RunString("PollResponse(" .. _EntGetParent(MyIndex) .. ", " .. MyIndex.. ")");
	end
	
	function onInit( )
		_Msg(("Copy Gun ID: " .. MyIndex) .. ", Player ID ".._EntGetParent(MyIndex).."\n"); --For debugging
		Poll();
		firstPropAltitude = nil;
		firstPropPos = nil;
		copyBufferTable = {};
		originalTable = {};
	end
	
	function SaveInfo(fileDir)
		if (fileDir == nil) then return end;
		local saveStr = "";
		local tempStr = "";
		
		for i = 1, table.getn(copyBufferTable) do
			tempStr = ""
			for j = 1, table.getn(copyBufferTable[i]) do
				if (j == 3) or (j == 4) then
					tempStr = tempStr .. "#" .. vecString(copyBufferTable[i][j]) .. "@" .. "\t";
					else
						tempStr = tempStr .. "#" .. copyBufferTable[i][j] .. "@" .. "\t";
				end
			end
			saveStr = saveStr .. "{" .. tempStr .. "}" .. "\n";
		end
		tempStr = ""
		for i = 1, table.getn(weldTable) do
			tempStr = tempStr .. "<#" .. weldTable[i][1] .. "@\t#" .. weldTable[i][2] .. "@\t#" .. weldTable[i][3] .. "@\t>\n"
		end
		saveStr = saveStr .. tempStr
		saveStr = saveStr .. "(" .. firstPropAltitude .. ")";
		_file.Write(fileDir, saveStr);
		_RunString("RefreshSpawnMenu(0)")
	end
	
	function spawnPreview()
		clearPreview();
		if showPreview == 0 then return end;
		vPos = vector3(0, 0, 0)
		for i = 1, table.getn(copyBufferTable) do
			local iBufferIndex = i
			if (firstPropAltitude == nil) or (firstPropPos == nil) then return end;
			local vOriginOffset = vecSub(vPos, firstPropPos);
			local newProp = _EntCreate("prop_dynamic_override");
			previewTable[table.getn(previewTable) + 1] = newProp;
			local vNewPropPos = vecAdd(vOriginOffset, copyBufferTable[iBufferIndex][3])
			_EntPrecacheModel(copyBufferTable[iBufferIndex][2])
			_EntSetKeyValue(newProp, "model", copyBufferTable[iBufferIndex][2])
			--_EntSetModel(newProp, copyBufferTable[iBufferIndex][2]);
			_EntSetPos(newProp, doRotPos(iBufferIndex, vNewPropPos, vPos));
			_EntSetAngAngle(newProp, doRotAng(copyBufferTable[iBufferIndex][4]));
			_EntSetSolid(newProp, 0);
			_EntSetMoveType(newProp, 0)
			_EntSetCollisionGroup(newProp, 0)
			_EntSetKeyValue(newProp, "targetname", "cg_preview");
			_EntSetKeyValue(newProp, "rendermode", "1");
			_EntSetKeyValue(newProp, "renderamt", "160");
			_EntSetKeyValue(newProp, "spawnflags", "527");
			_EntSpawn(newProp);
			
		end
	end
	
	function clearPreview()
		for i = 1, table.getn(previewTable) do
			_EntRemove(previewTable[i]);
		end
		previewTable = {};
	end
	
	function previewExists()
		if table.getn(previewTable) < 1 then
			return false;
		else
			return true;
		end
	end
	
	function movePreview(localOrigin2)
		if previewExists() == false then return end;
		local localOrigin1 = _EntGetPos(previewTable[1])
		if localOrigin1 == localOrigin2 then return end;
		local refVec = vecSub(localOrigin2, localOrigin1)
		for i = 1, table.getn(previewTable) do
			_EntSetPos(previewTable[i], vecAdd(_EntGetPos(previewTable[i]), refVec))
		end
	end
	
	function respawnPreview()
		clearPreview();
		spawnPreview();
	end
	
	function setPreview(iChoice)
		if (iChoice ~= 0) and (iChoice ~= 1) then
			if setPreview == 1 then setPreview = 0 end;
			if setPreview == 0 then setPreview = 1 end;
		else
			showPreview = iChoice
		end	
		if showPreview == 0 then
			DispMessage(7, "OFF")
			clearPreview();
		elseif showPreview == 1 then
			DispMessage(7, "ON")
			respawnPreview();
		end
	end
	
	function vecFromString(v1)
		local iCount = 0;
		local tempTable = {};
		for w in string.gfind(v1, "%-?%d+%.?%d*") do
			iCount = iCount + 1;
			tempTable[iCount] = w;
		end
		return vector3(tempTable[1], tempTable[2], tempTable[3]);
	end
	
	function LoadInfo(fileDir)
		local loadData = _file.Read(fileDir)
		_Msg("Load string length:" .. string.len(loadData) .. " chars\n")
		local tempTable = {};
		local iCount = 0;
		for w in string.gfind(loadData, "%b{}") do             
			iCount = iCount + 1;
			tempTable[iCount] = string.sub(w, 2, -2);
		end
		DispMessage(3, iCount);
		copyBufferTable = {};
		firstPropAltitude = 0;
		firstPropPos = vector3(0, 0, 0);
		
		for i = 1, table.getn(tempTable) do
			iCount = 0;
			copyBufferTable[i] = {};
			for w in string.gfind(tempTable[i], "%b#@") do
				iCount = iCount + 1;
				if (iCount == 3) or (iCount == 4) then
					copyBufferTable[i][iCount] = vecFromString(string.sub(w, 2, -2));
				else
					copyBufferTable[i][iCount] = string.sub(w, 2, -2);
				end
			end
		end
		
		tempTable = {};
		weldTable = nil;
		weldTable = {};
		
		iCount = 0;
		for w in string.gfind(loadData, "%b<>") do             
			iCount = iCount + 1;
			tempTable[iCount] = string.sub(w, 2, -2);
		end		
		_Msg(iCount .. " welds loaded \n")
		for i = 1, table.getn(tempTable) do
			iCount = 0;
			weldTable[i] = {};
			for w in string.gfind(tempTable[i], "%b#@") do
				iCount = iCount + 1;
				weldTable[i][iCount] = string.sub(w, 2, -2);
			end
		end		
		
		firstPropPos = copyBufferTable[1][3];
		for w in string.gfind(loadData, "%b()") do
			firstPropAltitude = string.sub(w, 2, -2);
		end
		
		if IsDeployed then respawnPreview() end;
		
		unColorOriginals();
	end
-- Called every frame

	function onThink( )
		if (LastPoll + POLL_INTERVAL) <= _CurTime() then 
			LastPoll = _CurTime()
			Poll();
		end
		
		_TraceLine(_PlayerGetShootPos(Owner),_PlayerGetShootAng(Owner), 32768, Owner);
		
		if _TraceHit() then --I think spawning in non-world hit locations would be nice...
			local previewPos = _TraceEndPos();
			previewPos.z = previewPos.z + firstPropAltitude
			movePreview(previewPos);
		end
	end

	

	

-- When the player presses left mouse button

	function onPrimaryAttack( )	
		_TraceLine(_PlayerGetShootPos(Owner),_PlayerGetShootAng(Owner), 32768, Owner);
		if _TraceHitNonWorld() then
			local iEnt = _TraceGetEnt();
			AddCopyItem (iEnt);
		end
		respawnPreview();
	end

	

-- When the player presses right mouse button

	function onSecondaryAttack( )
		spawnTable = {};
		if (firstPropPos == nil) then return end;
		_TraceLine(_PlayerGetShootPos(Owner),_PlayerGetShootAng(Owner), 32768, Owner);
		local vSpawnPos = _TraceEndPos();
		vSpawnPos.z = vSpawnPos.z + firstPropAltitude
		if _TraceHit() then --again, I'd like to spawn on a non-world surface.
			for i = 1, table.getn(copyBufferTable) do
				SpawnCopyItem (i, vSpawnPos);
			end
			for i = 1, table.getn(weldTable) do
				SpawnWeld(i);
			end
		end
	end

	function Deploy( )
		IsDeployed = true;
		respawnPreview();
	end
	
	function Holster( )
		IsDeployed = false;
		clearPreview();
	end
	
-- When player presses reload. Returning false means DONT RELOAD. Although this will hitch on the client.

	function onReload( )
		clearPreview();
		unColorOriginals();
		originalTable = nil;
		originalTable = {};
		firstPropAltitude = nil;
		firstPropPos = nil;
		copyBufferTable = nil;
		copyBufferTable = {};
		DispMessage(0, "");
		weldTable = {};
		spawnTable = {};
		return true;
	end

-- These are only accessed once when setting up the weapon
	function getWeaponSwapHands()
		return false;	
	end
	function getWeaponFOV()
		return 70;	
	end
	function getWeaponSlot()
		return 5;	
	end
	function getWeaponSlotPos()
		return 2;	
	end
	function getFiresUnderwater()
		return true;
	end
	function getReloadsSingly()
		return false;
	end
	-- Primary Attack
	function getDamage()
		return 10;
	end
	function getPrimaryShotDelay()
		return 0.2;
	end
	function getPrimaryIsAutomatic()
		return true;
	end
	function getBulletSpread()
		return vector3( 0.01, 0.01, 0.01 );
	end
	function getViewKick()
		return vector3( 0.0, 0.0, 0.0);
	end
	function getViewKickRandom()
		return vector3( 0, 0, 0 );
	end
	function getNumShotsPrimary()
		return 1;
	end
	function getPrimaryAmmoType()
		return "pistol";
	end
	-- Secondary attack
	function getDamageSecondary()
		return 10;
	end
	function getSecondaryShotDelay()
		return 0.2;
	end
	function getSecondaryIsAutomatic()
		return false;
	end
	function getBulletSpreadSecondary()
		return vector3( 0.0, 0.0, 0.0 );
	end
	function getViewKickSecondary()
		return vector3( 0.0, 0.0, 0.0);
	end
	function getViewKickRandomSecondary()
		return vector3( 0, 0, 0 );
	end
	function getNumShotsSecondary()
		return 1;
	end
	function getSecondaryAmmoType()
		return "pistol";
	end
	function getViewModel( )
		return "models/weapons/v_crossbow.mdl";
	end
	function getWorldModel( )
		return "models/weapons/w_crossbow.mdl";
	end
	function getClassName() 
		return "tool_lua_groupcopy";
	end
	function getHUDMaterial( )
		return "gmod/SWEP/default";
	end
	function getMaxClipPrimary() -- return -1 if it doesn't use clips
		return 25;
	end
	function getMaxClipSecondary() -- return -1 if it doesn't use clips
		return -1;
	end
	function getDefClipPrimary() -- ammo in gun by default
		return 25;
	end
	function getDefClipSecondary()
		return 0;
	end
	function getAnimPrefix() -- How the player holds the weapon: pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade
		return "crossbow";
	end
	function getPrintName()
		return "Group Copy Tool";
	end
	-- 0 = Don't override, shoot bullets, make sound and flash
	-- 1 = Don't shoot bullets but do make flash/sounds
	-- 2 = Only play animations
	-- 3 = Don't do anything
	function getPrimaryScriptOverride()
		return 2;
	end
	function getSecondaryScriptOverride()
		return 2;
	end



