--Extensively Moded by LuaPineapple (now uses ULX/ULib, IT IS REQUIRED UNLESS YOU EDIT LINE 149 AND FOLLOW DIRECTIONS IN THE COMMENT UNDER THAT LINE!)
--Version 6.5

--Was it precached?
cached = 0;
--============================================================================================================================--
-- Information on HoverBalls & Players

EntityInfo = {};
for i = 1, 2048 do --2048 possible hoverballs
	EntityInfo[i] = {};
	EntityInfo[i].Hight = 64.0;
	EntityInfo[i].Force = 200.0;
	EntityInfo[i].HoverEnabled = false;
	EntityInfo[i].AttachedObject = null;
	EntityInfo[i].OwnerID = 0;
end

-- Player Information
PlayerInfo = {};
for i = 1, _MaxPlayers( ) do
	PlayerInfo[i] = {};
	PlayerInfo[i].LastHight = 64.0;
	PlayerInfo[i].LastForce = 1000.0;
	PlayerInfo[i].PlayerID = 0;
	PlayerInfo[i].PowerChange = 0; --is he changing power?
end

--============================================================================================================================--
-- HoverBall handlers

function ProcessHoverBall( HoverBall )
	local vBallPos = _EntGetPos( HoverBall );
	_TraceSetMask( 131083 );
	_TraceLine( vBallPos, vector3(0,0,-1), 32768, HoverBall );
	local a = vecLength( vecSub( vBallPos, _TraceEndPos() ) );
	--one trace for water
	_TraceSetMask( MASK_WATER );
	_TraceLine( vBallPos, vector3(0,0,-1), 32768, HoverBall );
	local a2nd = vecLength( vecSub( vBallPos, _TraceEndPos() ) );

	if ( _TraceDidHitWater() > 0 ) then
		if ( _EntGetWaterLevel( EntityInfo[HoverBall].AttachedObject ) >= 1 ) then
			a = 1;
		else
			a = a2nd;
		end
	end
	local b = EntityInfo[HoverBall].Hight;
	local force = EntityInfo[HoverBall].Force;
	local c = b - a;
	--processes the balls
	if ( a < b ) then
		if ( c > 50 ) then
			force = EntityInfo[HoverBall].Force;
			_phys.ApplyForceCenter( HoverBall, vector3( 0, 0, force ) ); --push it up the z axis
			return;
		else
			force = (( c / 50 ) * EntityInfo[HoverBall].Force); --divid the hight by 50 and times it by the force of the ball
			_phys.ApplyForceCenter( HoverBall, vector3( 0, 0, force ) );
			return;
		end
	end
end

-- Thinks
function HoverBallsThink( )
	-- Find all Hoverballs
	local eHoverBalls = _EntitiesFindByClass( "prop_physics" ); --loads all prop_physics ents
	for _,entity in eHoverBalls do --processes every ent (how inefficient)
		-- Process HoverBalls
		if( EntityInfo[entity].HoverEnabled == true ) then --FLY MY MONKEYS! FLY!
			ProcessHoverBall( entity ); --slacks the work to another function
		end
	end
end
AddThinkFunction( HoverBallsThink ); -- "think, think, think." -? (guess who said this, you'll never figure it out XD)

--============================================================================================================================--
--Sets primary hover settings
function sethoverballhight( player, args ) --intuitive name
	PlayerInfo[player].LastHight = tonumber( args );
end
CONCOMMAND( "set_hoverballs_hight", sethoverballhight );

function sethoverballforce( player, args ) --same here
	PlayerInfo[player].LastForce = tonumber( args );
end
CONCOMMAND( "set_hoverballs_force", sethoverballforce );

--============================================================================================================================--
--functions related to the creation and deletion of hoverballs

function spawnHoverBall( player, args )
	if (cached == 0) then --was the model precached?
		_EntPrecacheModel( "models/LPine/hoverball.mdl" );
		cached = 1 --makes sure that it doesn't happen again.
	end
	if ( not _PlayerInfo( player, "alive" ) ) then return; end --is he dead?
	local vecpos = _PlayerGetShootPos( player );
	local plyang = _PlayerGetShootAng( player );
	_TraceLine( vecpos, plyang, 4096, player );

	if ( _TraceHitNonWorld() == false ) then return; end --We got something here

	local ent = _TraceGetEnt( ); --GET THE ENT ID  No.!

	local HoverBall = _EntCreate( "prop_physics" );
		_EntSetModel( HoverBall, "models/LPine/Hoverball.mdl" );
		_EntSetPos( HoverBall,  _TraceEndPos() ); --places it at the end of the trace
	_EntSpawn( HoverBall );
	--adds a nice spark effect to the hoverball spawn
	if ( not _PlayerInfo( player, "alive" ) ) then return; end --is he dead?
	local vecpos2 = _PlayerGetShootPos( player );
	local plyang2 = _PlayerGetShootAng( player );
	_TraceLine( vecpos2, plyang2, 4096, player );
	local entb = _TraceGetEnt( ); --all this to get the new hoverball's ent id
	local entbpos = _EntGetPos(entb) --gets the hoverball pos
	_EffectInit()
	_EffectSetEnt(entb)
	_EffectSetOrigin(entbpos)
	_EffectSetStart(entbpos)
	_EffectSetScale(30)
	_EffectSetMagnitude(100)
	_EffectSetRadius(40)
	_EffectDispatch("ManhackSparks")

	_PhysEnableCollisions( HoverBall, false); --does it fall through everything?
	WeldEntities( HoverBall, ent ); --if you dont get this then your IQ is <80

	local newhight = PlayerInfo[player].LastHight;
	local newforce = PlayerInfo[player].LastForce;

	EntityInfo[HoverBall].HoverEnabled = true; --set it aflot
	EntityInfo[HoverBall].Hight = newhight; --give hight
	EntityInfo[HoverBall].Force = newforce; --give force
	EntityInfo[HoverBall].AttachedObject = ent; --log ent number
	EntityInfo[HoverBall].OwnerID = player; --logs the owner
end
CONCOMMAND( "spawn_hoverball", spawnHoverBall );


function removeHoverBall( player, args ) --Moded to add a owner conditional (Stops minges :D), called by swep (Secondary Hoverball Sticker)
	local vecpos = _PlayerGetShootPos( player );--Common trace code
	local plyang = _PlayerGetShootAng( player );
	_TraceLine( vecpos, plyang, 4096, player );

	if ( _TraceHitNonWorld() == false ) then return; end --Did it hit something

	local entity = _TraceGetEnt();

	if (EntityInfo[entity].OwnerID == PlayerInfo[player].PlayerID) then -- is it his?
		if( EntityInfo[entity].HoverEnabled == true ) then
			EntityInfo[entity].HoverEnabled = false; --dehoverfy it
			_EntRemove( entity ); --he's dead jim
		end
	end
end


function removeAllHoverBalls( player, args ) --Comites Genocide agenst hoverballs (HITLER! >:D)
	for i = 1, 2048 do
		if( EntityInfo[i].HoverEnabled == true and hasAccess ( player, ACCESS_KICK ) == true) then --If its not an admin then his going no where (NEEDS ULX!!!!)
		--If you don't have ulx remove the line
		--if( EntityInfo[i].HoverEnabled == true and hasAccess ( player, ACCESS_KICK ) == true) then
		--and replace it with
		--if( EntityInfo[i].HoverEnabled == true) then
		--but be warned that ANYONE CAN REMOVE ALL HOVERBALLS if you do that! (or you can delete the function)
			EntityInfo[i].HoverEnabled = false;
			_EntRemove( i ); --he's dead Jim!
		end
	end
end
CONCOMMAND( "remove_all_hoverballs", removeAllHoverBalls );

function restetonbreak( breakerid, propid )
	EntityInfo[propid].HoverEnabled = false; --Oh noes! Someone removed it!
end
HookEvent("onPlayerRemove", restetonbreak );

--============================================================================================================================--
--other functions nessesary for proper functioning (no pun intended)

function giveHoverBallSticker( player, args )
	if( _PlayerHasWeapon( player, "HoverballSticker" ) ) then --Does he have it?
		_PlayerSelectWeapon( player, "HoverballSticker" );  --Can't even find his own gun :rolleyes:
	else
		_PlayerGiveSWEP( player, "weapons/tools/HoverballAlterer.lua" ); --the alterer is placed here so he has the Sticker out at the end
		_PlayerGiveSWEP( player, "weapons/tools/HoverballSticker.lua" ); --poor guy

	end
end
CONCOMMAND( "give_hoverball_sticker", giveHoverBallSticker );

function SetPlayerIDInfo( player, args ) --moded function, adds player ID to info; Plays the Do you need Help thing
	PlayerInfo[player].PlayerID = player; --Log his ID
	_Msg("Player occupying slot:"..player.."has been added to the player array\n");
end
HookEvent("eventPlayerSpawn", SetPlayerIDInfo);

--============================================================================================================================--
--the power up & down functions have 2 parts; part + which is executed while the player holds down the key and part - which does nothing (in this script)
--the think function actualy does the work of changing the hight

--powerup functions
function PowerUpHovers( player, args ) --code version 3 for incresse hight, sets PowerChange to  increase hight
PlayerInfo[player].PowerChange = 1;
end
CONCOMMAND( "+powerup", PowerUpHovers );

function PowerUpHoversEnder( player, args ) --is called when the key binded to +powerup is released.
PlayerInfo[player].PowerChange = 0;
end
CONCOMMAND( "-powerup", PowerUpHoversEnder );

--powerdown functions
function PowerDownHovers( player, args ) --code version 3 for incresse hight, sets PowerChange to decreasee the hight
PlayerInfo[player].PowerChange = 2;
end
CONCOMMAND( "+powerdown", PowerDownHovers );

function PowerDownHoversEnd( player, args ) --is called when the key binded to +powerdown is released.
PlayerInfo[player].PowerChange = 0;
end
CONCOMMAND( "-powerdown", PowerDownHoversEnd );

function PowerThink() --power alter function, think based.
	for i = 1, _MaxPlayers( ) do --loops through all the players
		--powerup
		if (PlayerInfo[i].PowerChange == 1) then --if he is upping then contiune
			for b = 1, 2048 do --loop through all the hovers
				if (EntityInfo[b].OwnerID == PlayerInfo[i].PlayerID) then --does it belong to the current player being processed?
					EntityInfo[b].Hight = EntityInfo[b].Hight + 2;
				end
			end
		end
		--powerdown
		if (PlayerInfo[i].PowerChange == 2) then --if he is downing then contiune
			for c = 1, 2048 do --loop through all the hovers
				if (EntityInfo[c].OwnerID == PlayerInfo[i].PlayerID) then --does it belong to the current player being processed?
					EntityInfo[c].Hight = EntityInfo[c].Hight - 2;
					end
			end
		end
	end
end;
AddThinkFunction( PowerThink );

--============================================================================================================================--
--following functions are called by the Hoverball Alterer SWEP

function SWEPPowerup( player, args ) --powers up a single hoverball (Is called by the Hoverball Alterer SWEP)
	local vecpos = _PlayerGetShootPos( player );--Common trace code
	local plyang = _PlayerGetShootAng( player );
	_TraceLine( vecpos, plyang, 4096, player );
	if ( _TraceHitNonWorld() == false ) then return; end --Did it hit something
	local entity = _TraceGetEnt(); -- got the ent that was hit!
	if (EntityInfo[entity].OwnerID == PlayerInfo[player].PlayerID) then -- is it his?
		EntityInfo[entity].Hight = EntityInfo[entity].Hight + 10; --incresse it by 10
	end
end

function SWEPPowerdown( player, args ) --powers down a single hoverball (Is called by the Hoverball Alterer SWEP)
	local vecpos = _PlayerGetShootPos( player );--Common trace code
	local plyang = _PlayerGetShootAng( player );
	_TraceLine( vecpos, plyang, 4096, player );
	if ( _TraceHitNonWorld() == false ) then return; end --Did it hit something
	local entity = _TraceGetEnt(); -- got the ent that was hit!
	if (EntityInfo[entity].OwnerID == PlayerInfo[player].PlayerID) then
		if EntityInfo[entity].Hight >= 10 then --stops negative values
			EntityInfo[entity].Hight = EntityInfo[entity].Hight - 10; --decresse it by 10
		end
	end
end

function SWEPStrengthen( player, args ) --Strengthens a single hoverball (Is called by the Hoverball Alterer SWEP)
	local vecpos = _PlayerGetShootPos( player );--Common trace code
	local plyang = _PlayerGetShootAng( player );
	_TraceLine( vecpos, plyang, 4096, player );
	if ( _TraceHitNonWorld() == false ) then return; end --Did it hit something
	local entity = _TraceGetEnt(); -- got the ent that was hit!
	if (EntityInfo[entity].OwnerID == PlayerInfo[player].PlayerID) then
		EntityInfo[entity].Force = EntityInfo[entity].Force + 100; --incresse it by 100
	end
end

function SWEPWeaken( player, args ) --Weakens a single hoverball (Is called by the Hoverball Alterer SWEP)
	local vecpos = _PlayerGetShootPos( player );--Common trace code
	local plyang = _PlayerGetShootAng( player );
	_TraceLine( vecpos, plyang, 4096, player );
	if ( _TraceHitNonWorld() == false ) then return; end --Did it hit something
	local entity = _TraceGetEnt(); -- got the ent that was hit!
	if (EntityInfo[entity].OwnerID == PlayerInfo[player].PlayerID) then
		if EntityInfo[entity].Force >= 100 then --I tryed it and strange things happen when the force is negative
			EntityInfo[entity].Force = EntityInfo[entity].Force - 100; --decrease it by 100
		end
	end
end
--end of script