--Sendmenu by Megiddo
--VERSION 1.2
--
--Installation:
-- Simply put this file in lua/init
-- Note that this requires ULib from ulyssesmod.net
--
--Changelog:
--v1.2 7/21/06
-- * Moved code over to ULib, should increase robustness, can now process multiple menus in one file.
--
--v1.1 5/22/06
-- * Fixed overflow problems ( Timer delays menus, you can change the delay with the increment variable )
--
--v1 02/22/06
-- * ulx_sv_sendmenuclearold now defaults to off
-- * Fixed cvar checks
-- * Added ulx_sv_sendmenudir
-- * Added some ULX checks
--
--v0.9 02/16/06
-- * Initial release
--
-- Thanks to:
-- TheDarkFactor for helping me track and kill the overflow problem as efficiently as possible.

assert( _file.Exists( "lua/ULib/init.lua" ), "sendmenu needs ULib to run!" )
_OpenScript( "ULib/init.lua" )
assert( ULib.VERSION >= 0.9, "sendmenu requires ULib version 0.9 or higher to run!" )

ULib.CONVAR( "ulx_sv_sendmenuenabled", "1", ACCESS_BAN, " - If enabled, clients will be sent the menus from the server" )
ULib.CONVAR( "ulx_sv_sendmenuclearold", "0", ACCESS_BAN, " - If enabled with sendmenuenabled, the client's original menu will be cleared" )
ULib.CONVAR( "ulx_sv_sendmenudir", "settings/menu_props", ACCESS_RCON, " - Where sendmenu will take it's menus from, USE '/' AND LEAVE OFF THE TRAILING '/'" )

ULib.print( "Send menu loaded." )
gMenus = {}

do -- Contain our local variables to this scope
	local files = ULib.filesInDir( ULib.getCvar( "ulx_sv_sendmenudir" ) )
	for i=1, table.getn( files ) do
		local file = _file.Read( ULib.getCvar( "ulx_sv_sendmenudir" ) .. "/" .. files[ i ] )
		local menus = ULib.parseKeyValues( file )
		for title, values in pairs( menus ) do -- Copy it to the main one
			gMenus[ title ] = values
		end
	end
end

local function sendMenu( userid, title )
	for k, v in pairs( gMenus[ title ] ) do
		_spawnmenu.AddItem( userid, title, k, v )
	end
end

local function sendMenus( userid )
	if ULib.getCvar( "ulx_sv_sendmenuenabled" ) == "0" then
		return
	end

	if ULib.getCvar( "ulx_sv_sendmenuclearold" ) ~= "0" then
		_spawnmenu.RemoveAll( userid )
	end

	local delay = 0
	local increment = 0.05

	for title in pairs( gMenus ) do
		AddTimer( delay, 1, sendMenu, userid, title )
		delay = delay + increment
	end
end

HookEvent( "eventPlayerInitialSpawn", sendMenus )
