-- This code is property of the Ulysses development team, ALL RIGHTS RESERVED

gUsers = {} -- Keeps track of long term admins that will stay across map changes
gSayCmds = {} -- Keeps track of said commands ( IE: a player says "freezeall" )
gCmdHelp = {} -- Keeps track of our help table
gCvarHelp = {} -- Keeps track of our help table
gMsgHooks = {} -- Message hooks
gCurTextKey = 500 -- The current text key, with this, we should never have a conflict
gCurRectKey = 500 -- The current rect key, with this, we should never have a conflict

-- One-time setup code
if _file.Exists( "lua/ulx/logs" ) == false then
	_file.CreateDir( "lua/ulx/logs" )
end
if _file.Exists( "lua/ulx/configs" ) == false then
	_file.CreateDir( "lua/ulx/configs" )
end

if _file.Exists( "lua/ulx/logs/log.txt" ) == false then
	_file.Write( "lua/ulx/logs/log.txt", "Sorry that there are no timestamps here, they'll be put in as soon as garry restores the date and time functions.\r\n" )
end
gForceDLComment = "//ULX-Dynamic res generator\r\n//Put files you wish to force the client to download in this file, seperated by newlines.\r\n//For example, you might put \"sound/supafly.mp3\" in here, make sure it has the quotes.\r\n\r\n"
gForceDLKeyBeg = "//ULX Dynamic res BEGIN"
gForceDLKeyEnd = "//ULX Dynamic res END"
if _file.Exists( "lua/ulx/configs/forcedownload.ini" ) == false then
	_file.Write( "lua/ulx/configs/forcedownload.ini", gForceDLComment )
end
-- End one-time setup code

if _GetCurrentMap() ~= "" then -- If the user isn't starting his listen client, then log the map change.
	ulx_log( "\r\n\r\nServer started/changelevel, current map: " .. _GetCurrentMap() .. ", ULX version: " .. ULX_VERSION ) -- Make a separation
end
	

-- Write a .res file for the forced downloads
if _GetCurrentMap() ~= "" and string.len( gForceDLComment ) < string.len( _file.Read( "lua/ulx/configs/forcedownload.ini" ) ) then
	generateRes()
end

-- Load our users
file = readFile( "lua/ulx/configs/users.ini", "//" )
for i=1, table.getn( file ) do
	local user = string.gsub( file[ i ], "^\"(.-)\"%s-\"(.-)\".*$", "%1" )
	local access = string.gsub( file[ i ], "^\"(.-)\"%s-\"(.-)\".*$", "%2" )
	--debug( "Adding user: " .. user .. " with access: " .. access )
	addUser( user, access )
end
file = nil -- To allow for garbage collection


-- eventPlayerSay - Called when someone says something, this will handle our say commands
function eventPlayerSay( userid, strText, bTeam )
		
	if userid == 0 then -- If this is the dedicated server, ignore it or we'll have problem 
		return strText 
	end

	local args = strText
	local argv = {}
	local argc
	args = string.sub( strText,string.len( _PlayerInfo( userid, "name" ) ) +3 )
	argv, argc = splitArgs( args )
	argc = argc - 1 -- Forget the command as counting

	argv[ 1 ] = string.lower( argv[ 1 ] ) -- Make it case insensitive
		
	if argv[ 1 ] == nil or argv[ 1 ] == "" or gSayCmds[ argv[ 1 ] ] == nil then -- If this isn't one of our commands
		local text
		for i=1, table.getn( gMsgHooks ) do -- See if any of our message hooks wants it
			text = gMsgHooks[ i ]( userid, strText, bTeam )
			if text ~= strText then
				return text
			end
		end
		
		return strText
	end
		
	local cmd_access = gSayCmds[ argv[ 1 ] ].access
	local fn_call = gSayCmds[ argv[ 1 ] ].fn
	local min_args = gSayCmds[ argv[ 1 ] ].minArgs
	local show_text = gSayCmds[ argv[ 1 ] ].show
	local command = gSayCmds[ argv[ 1 ] ].cmd
		
	if cmd_access ~= nil then
		if hasAccess( userid, cmd_access ) == false then
			ulx_tsay( userid, "You lack sufficient access to use this command!")
			return strText
		end
	end
	
	if min_args ~= nil then
		if argc < min_args then
			ulx_tsay( userid, "Insufficient parameters! Help is listed below :" )
			ulx_tsay( userid, command .. " " .. gCmdHelp[ command ].help )
			return strText
		end
	end
		
	args = string.sub( args, string.len( argv[ 1 ] ) + 1 ) -- This gets rid of the actual command from the text
	table.remove( argv, 1 )	
	fn_call( userid, args, argv, argc ) -- Give them the option of returning text they want shown
		
	if show_text == false then
		return ""
	else
		return strText
	end
end

function addMessageHook( callback )
	table.insert( gMsgHooks, callback )
end

-- getUser - This function will give you a userid from a partial match of name or steamid ( if it's given a valid userid it will return it ).
function getUser( userid, user, obey_immunity )
	if obey_immunity == nil then
		obey_immunity = true
	end
	
	if user == nil or userid == nil or type( userid ) ~= "number" or userid > 32 or userid < 0 then
		error_msg( "getUser() was passed invalid paramaters!" )
		return
	end
	
	local result = nil
	local temp
	
	temp = tonumber( user )
	if temp ~= nil and temp > 0 and temp <= 32 then -- Guess they mean the person's userid
		--if _util.PlayerByUserId( temp ) ~= nil and _util.PlayerByUserId( temp ) ~= 0 then -- If they're referring to an actual userid instead of a lua userid
		--	temp = _util.PlayerByUserId( temp )
		--end
		
		if _PlayerInfo( temp, "connected" ) then
			if obey_immunity == true and hasAccess( temp, ACCESS_IMMUNITY ) == true then
				ulx_console( userid, "That person has immunity!" )
				return nil
			end
			return temp -- And we're done!
		end
	end
	
	local user = string.lower( user ) -- We want to make this a case insensitive search	
	user = string.gsub( user, "([%[%]%(%)%%%+%-%*%?%^%$%.])", "%%%1" ) -- It'll have problems reading special characters otherwise		
	
	for i = 1, _MaxPlayers() do
		if _PlayerInfo( i, "connected" ) == true then
			temp = string.find( string.lower( _PlayerInfo( i, "name" ) ), user )
			if temp ~= nil then
				if obey_immunity == true and hasAccess( i, ACCESS_IMMUNITY ) == true then
					ulx_console( userid, "That person has immunity!" )
					return nil
				end	
				if result ~= nil then
					ulx_console( userid, "There is more than one person with that partial name!" )
					return nil
				end
				result = i 
			end
		end
	end
	
	if result ~= nil then -- If and only if we have one result from partial names, return it!
		return result
	end
	
	 --No results in partial names? Let's get desperate and test steam ID's!
	for i = 1, _MaxPlayers() do
		if _PlayerInfo( i, "connected" ) == true then
			temp = string.find( string.lower( _PlayerInfo( i, "networkid" ) ), user )
			if temp ~= nil then
				if obey_immunity == true and hasAccess( i, ACCESS_IMMUNITY ) == true then
					ulx_console( userid, "That person has immunity!" )
					return nil
				end				
				if result ~= nil then
					ulx_console( userid, "There is more than one person with that partial name!" )
					return nil
				end
				result = i 
			end
		end
	end
	
	if result ~= nil then -- If and only if we have one result from steam IDs, return it!
		return result
	end	
	
	ulx_console( userid, "Sorry, I couldn't find the user you wanted to perform that action on!" )
	return nil
end

-- getAccess - returns the user's full access
function getAccess( userid )
	local steamid = _PlayerInfo( userid, "networkid" )
	if userid == 1 and _IsDedicatedServer() == false then
		return LISTEN_ADMIN_ACCESS
	elseif gUsers[ steamid ] ~= nil then
		return gUsers[ steamid ]
	else
		return nil
	end
end

-- hasAccess - If the user has the specified access, return true, otherwise false.
function hasAccess( userid, access )
	if userid == 0 or access == nil then -- nil access means it's open for everyone!
		return true
	end
	
	local steamid = _PlayerInfo( userid, "networkid" )
	if userid == 1 and _IsDedicatedServer() == false and string.find( LISTEN_ADMIN_ACCESS, access ) ~= nil then -- Guess they're the admin
		return true
	elseif gUsers[ steamid ] and string.find( gUsers[ steamid ], access ) ~= nil then
		return true
	else
		return false
	end
end

function hasAccessSteamid( steamid, access )
	if steamid == 0 or access == nil then -- nil access means it's open for everyone!
		return true
	end
	
	steamid = string.upper( steamid ) -- Incase they're an idiot.
	
	if gUsers[ steamid ] and string.find( gUsers[ steamid ], access ) ~= nil then
		return true
	elseif userid == 1 and _IsDedicatedServer() == false and string.find( LISTEN_ADMIN_ACCESS, access ) ~= nil then -- Gues they're the admin
		return true
	else
		return false
	end
end

-- ULX_CONVAR - Adds a convar with only the specified access allowed ( if left nil it will allow everyone )
function ULX_CONVAR( cvar_name, default, cmd_access, cmd_help )
	_G[ cvar_name ] = default
	
	local fn_name = commandToFnName( cvar_name )
	_G[ fn_name ] = function ( userid, args ) -- This function will handle the cvar ( command ) callback
		if cmd_access ~= nil then
			if hasAccess( userid, cmd_access ) == false then
				ulx_console( userid, "You lack sufficient access to use this cvar!" )
				return
			end
		end

		args = stripQuotes( args )		
		if args == "" then
			if cmd_help ~= nil then
				ulx_console( userid, "\"" .. cvar_name .. "\" = \"" .. _G[ cvar_name ] .. "\"\n  " ) ulx_console(  userid, cmd_help .. "\n  CVAR generated by ULX" )
				return
			else
				ulx_console( userid, "\"" .. cvar_name .. "\" = \"" .. _G[ cvar_name ] .. "\"\n" ) ulx_console( userid, "  CVAR generated by ULX" )
				return
			end
		end
		_G[ cvar_name ] = args
	end
	
	local temp = loadstring( "return " .. fn_name ) -- We use this to convert a string to a function call
	CONCOMMAND( cvar_name, temp() )
	
	-- Now let's add to your help database!
	temp = cmd_help or " - No help available"
	gCvarHelp[ cvar_name ] = { access=cmd_access, help=temp, cmd=cvar_name }
	table.insert( gCvarHelp, gCvarHelp[ cvar_name ] ) -- This is so we can sort the help with ulx_help. Don't worry, this doesn't take much extra memory ( pointer )			
end

function ULX_CLIENTVAR( cvar_name, dflt, cmd_access, cmd_help )
	_G[ cvar_name ] = { default=dflt }
	
	local fn_name = commandToFnName( cvar_name )
	_G[ fn_name ] = function ( userid, args ) -- This function will handle the cvar ( command ) callback
		if cmd_access ~= nil then
			if hasAccess( userid, cmd_access ) == false then
				ulx_console( userid, "You lack sufficient access to use this cvar!" )
				return
			end
		end
		
		args = stripQuotes( args )		
		local steamid = _PlayerInfo( userid, "networkid" ) -- Track them by steamid

		if _G[ cvar_name ][ steamid ] == nil then
			_G[ cvar_name ][ steamid ] = _G[ cvar_name ].default
		end
		
		if args == "" then
			if cmd_help ~= nil then
				ulx_console( userid, "\"" .. cvar_name .. "\" = \"" .. _G[ cvar_name ][ steamid ] .. "\"\n  " ) ulx_console(  userid, cmd_help .. "\n  Client variable generated by ULX" )
				return
			else
				ulx_console( userid, "\"" .. cvar_name .. "\" = \"" .. _G[ cvar_name ][ steamid ] .. "\"\n" ) ulx_console( userid, "  Client variable generated by ULX" )
				return
			end
		end
		
		_G[ cvar_name ][ steamid ] = args
	end
	
	local temp = loadstring( "return " .. fn_name ) -- We use this to convert a string to a function call
	CONCOMMAND( cvar_name, temp() )
	
	-- Now let's add to your help database!
	temp = cmd_help or "- No help available"
	gCvarHelp[ cvar_name ] = { access=cmd_access, help=temp, cmd=cvar_name }
	table.insert( gCvarHelp, gCvarHelp[ cvar_name ] ) -- This is so we can sort the help with ulx_help. Don't worry, this doesn't take much extra memory ( pointer )	
end

-- ULX_CONCOMMAND - Adds a command with only the specified access allowed ( if left nil it will allow everyone )
function ULX_CONCOMMAND( command, fn_call, cmd_access, cmd_help, min_args, say_cmd, show_text )
	-- Let's do some quick error checking, so we won't have reoccuring problems later
	local error_flag = false
	if show_text == nil then
		show_text = true
	end		
	
	if command == nil or command == "" or type( command ) ~= "string" then
		error_msg( "ULX_CONCOMMAND did not recieve a valid string for the command argument!" )
		error_flag = true
	end
	
	if fn_call == nil or type( fn_call ) ~= "function" then
		error_msg( "ULX_CONCOMMAND did not recieve a valid function for the fn_call argument!" )
	end
	
	if cmd_access ~= nil then
		if cmd_access == "" then
			cmd_access = nil
		elseif	type( cmd_access ) ~= "string" then
			error_msg( "ULX_CONCOMMAND did not recieve a valid string for the access argument! ( This is an optional arg )" )
			error_flag = true			
		end
	end
	
	if cmd_help ~= nil then
		if cmd_help == "" then
			cmd_help = nil
		elseif	type( cmd_help ) ~= "string" then
			error_msg( "ULX_CONCOMMAND did not recieve a valid string for the help argument! ( This is an optional arg )" )
			error_flag = true			
		end
	end
	
	if min_args ~= nil then
		if	type( min_args ) ~= "number" or min_args < 0 then
			error_msg( "ULX_CONCOMMAND did not recieve a valid number for the min_args argument! ( This is an optional arg )" )
			error_flag = true			
		end
	end
	
	if say_cmd ~= nil then
		if type( say_cmd ) ~= "string" or say_cmd == "" then
			error_msg( "ULX_CONCOMMAND did not recieve a valid string for the say_cmd argument! ( This is an optional arg )" )
			error_flag = true
		end
		
		if type( show_text ) ~= "boolean" then
			error_msg( "ULX_CONCOMMAND did not recieve a valid boolean for the show_text argument! ( This is an optional arg )" )
			error_flag = true			
		end
	end				
	
	if error_flag then -- Help them out a bit by showing the function call
		error_msg( "The function call to ULX_CONCOMMAND was: "  )
		print_functioncall( ULX_CONCOMMAND, command, fn_call, cmd_access, cmd_help, min_args, say_cmd, show_text )
	end
	
	---------------------
	--Error checking done
	---------------------
	local fn_name = commandToFnName( command )
	
	_G[ fn_name ] = function ( userid, args ) -- This function will handle the command callback, and call the user specified call back after an access check
		if cmd_access ~= nil then
			if hasAccess( userid, cmd_access ) == false then
				ulx_console( userid, "You lack sufficient access to use this command!" )
				return
			end
		end
		
		local argv = {}
		local argc
		argv, argc = splitArgs( args )
	
		if min_args ~= nil then
			if argc < min_args then
				ulx_console( userid, "Insufficient parameters! Help is listed below :" )
				ulx_console( userid, command .. " " .. gCmdHelp[ command ].help )
				return
			end
		end
		
		fn_call( userid, args, argv, argc )
	end
	
	local temp = loadstring( "return " .. fn_name ) -- We use this to convert a string to a function call
	CONCOMMAND( command, temp() )
	
	-- Now let's add to our help database!	
	if cmd_help ~= nil then
		if say_cmd ~= nil then
			temp = cmd_help .. " ( say: " .. say_cmd .. " )"
		else
			temp = cmd_help
		end
	else
		temp = "- No help available"
	end
	gCmdHelp[ command ]= { access=cmd_access, help=temp, cmd=command }
	table.insert( gCmdHelp, gCmdHelp[ command ] ) -- This is so we can sort the help with ulx_help. Don't worry, this doesn't take much extra memory ( pointer )	
	
	-- If they want it to be a say command, add it
	if say_cmd ~= nil then
		say_cmd = string.lower( say_cmd ) -- Case insensitive
		gSayCmds[ say_cmd ] = { fn=fn_call, access=cmd_access, minArgs=min_args, show=show_text, cmd=command }
	end
end

function addCsayAdvert( msg, r, g, b, repeat_time, length )
	AddTimer( repeat_time, 0, ulx_csay_all_parse, msg, r, g, b, length )
end

function cc_csayAdvert( userid, args, argv, argc )
	if userid ~= 0 then
		ulx_console( userid, "You are not allowed to use this command!" )
	end
	
	addCsayAdvert( argv[ 1 ], argv[ 2 ], argv[ 3 ], argv[ 4 ], argv[ 5 ], argv[ 6 ] )
end

ULX_CONCOMMAND( "addCsayAdvert", cc_csayAdvert, ACCESS_NONE )

function addAdvert( msg, repeat_time )	
	AddTimer( repeat_time, 0, ulx_tsay_all_parse, msg )
end

function cc_advert( userid, args, argv, argc )
	if userid ~= 0 then
		ulx_console( userid, "You are not allowed to use this command!" )
	end
	
	addAdvert( argv[ 1 ], argv[ 2 ] )
end

ULX_CONCOMMAND( "addAdvert", cc_advert, ACCESS_NONE )

function newTextKey()
	gCurTextKey = gCurTextKey + 1
	if gCurTextKey > 2500 then
		gCurTextKey = 500
	end
	return gCurTextKey
end

function newRectKey()
	gCurRectKey = gCurRectKey + 1
	if gCurRectKey > 2500 then
		gCurRectKey = 500
	end
	return gCurRectKey
end

-- TODO: Move these vars somewhere more appropriate

ULX_CONVAR( "ulx_sv_showvotes", "1", ACCESS_CVAR, "- If set to 1, players will see who's voting for what option" )

ULX_CONVAR( "ulx_sv_antispamenabled", "0", ACCESS_CVAR, "- If set to 1, antispam will be enabled ( read on )" )
ULX_CONVAR( "ulx_sv_antispamtime", "5", ACCESS_CVAR, "- If players spawn more than the number of props in this time, they'll be blocked" )
ULX_CONVAR( "ulx_sv_antispamprops", "5", ACCESS_CVAR, "- If players spawn more than this number of props in the given time, they'll be blocked" )
ULX_CONVAR( "ulx_sv_antispamblocktime", "30", ACCESS_CVAR, "- This is how long players will be blocked ( in seconds ) after spamming" )

ULX_CONVAR( "ulx_sv_mingekick", "0", ACCESS_KICK, "- If set to 1, players with the name mingebag will be kicked" )

ULX_CONVAR( "ulx_sv_reservedslots", "2", ACCESS_KICK, "- How many slots are reserved for admins" )
ULX_CONVAR( "ulx_sv_reservedslotmode", "0", ACCESS_KICK, "- Reserved slot mode, read server.ini" )
-- Slot modes:
-- 0 - reserved slots disabled
-- 1 - ULX will never kick someone to free up a slot, which means that if admins join all the reserved slots, the server will be full
-- 2 - ULX will kick the player with the highest ping to keep 1 reserved slot open ( won't kick admins )
-- 3 - ULX will kick the player with the shortest connection time to keep 1 reserved slot open ( won't kick admins )

-- This is what the players will see when they join
-- You can use %player%, %hostname%, %curmap%, and %nextmap% in your text and have it automaticly parsed for you
ULX_CONVAR( "ulx_sv_welcomemessage", "Welcome to %hostname%, %playername%! We're currently playing %curmap%.", ACCESS_CHAT, "- This message will be shown to players joining your server." )
