-- cc_ulxWho - responds to ulx_who, shows the admin list ( admins currently in server )
function cc_ulxWho( userid, args, argv, argc )
	ulx_console( userid, "userid   name   access" )
	
	for i = 1, _MaxPlayers() do
		if _PlayerInfo( i, "connected" ) then
			local access = getAccess( i )
			if access ~= nil then -- If this player has access, show it!
				ulx_console( userid, i .. "   " .. _PlayerInfo( i, "name" ) .. "   " .. access )
			end
		end
	end
	
	ulx_console( userid, "End of admin list" )
end

ULX_CONCOMMAND( "ulx_who", cc_ulxWho, _, "- If there are admins currently in the server, shows their access" )

-- cc_ulxHelp - responds to ulx_help, shows the help for registered commands, only shows commands the user has access to
function cc_ulxHelp( userid, args, argv, argc )
	ulx_console( userid, "Command help:" )
    
	for _, v in ipairs( gCmdHelp ) do 
		if hasAccess( userid, v.access ) then
			ulx_console( userid, v.cmd .. " " .. v.help )
		end
	end
	
	ulx_console( userid, "\nCvar help:" )
	for _, v in ipairs( gCvarHelp ) do 
		if hasAccess( userid, v.access ) then
			ulx_console( userid, v.cmd .. " " .. v.help )
		end
	end
	
	ulx_console( userid, "-End of help\nULX version: " .. ULX_VERSION .. "\n" )
end

ULX_CONCOMMAND( "ulx_help", cc_ulxHelp, _, "- Shows the list you currently see" )

-- cc_ulxKick - responds to ulx_kick <user>, kicks the specified player
function cc_ulxKick( userid, args, argv, argc )
	local target = getUser( userid, argv[ 1 ] )
	if target == nil then
		return
	end
	
	if _PlayerInfo( target, "connected" ) then
		if argv[ 2 ] == nil or argv[ 2 ] == "" then
			_ServerCommand( "kickid " .. _PlayerInfo( target, "networkid" ) .. "\n" )
		else
			_ServerCommand( "kickid " .. _PlayerInfo( target, "networkid" ) .. " \"" .. argv[ 2 ] .. "\"\n" )
		end
		ulx_log( "Admin " .. ulx_playerString( userid ) .. " kicked player " .. ulx_playerString( target ) )
	end
end

ULX_CONCOMMAND( "ulx_kick", cc_ulxKick, ACCESS_KICK, "<user> - Kicks the specified player", 1, "!kick" )

-- cc_ulxBan - responds to ulx_ban <user> [<minutes>], bans the specified player
function cc_ulxBan( userid, args, argv, argc )	
	local target = getUser( userid, argv[ 1 ] )
	if target == nil then
		return
	end
	
	local time = 0
	
	if _PlayerInfo( target, "connected" ) then
		if argv[ 2 ] ~= nil then
			local num = tonumber( argv[ 2 ] )
			if num ~= nil then
				time = num
			end
		end
		
		_ServerCommand( "banid " .. time .. " " .. _PlayerInfo( target, "networkid" ) .. ";writeid\n" )
		ulx_log( "Admin " .. ulx_playerString( userid ) .. " banned player " .. ulx_playerString( target ) .. " for " .. time .. " minutes." )
	end
end

ULX_CONCOMMAND( "ulx_ban", cc_ulxBan, ACCESS_BAN, "<user> [<minutes>] - bans the specified player for the specified minutes ( perm ban if nil )", 1, "!ban" )

-- cc_ulxBan - responds to ulx_ban <user> [<minutes>], kicks & bans the specified player
function cc_ulxKickban( userid, args, argv, argc )
	local target = getUser( userid, argv[ 1 ] )
	if target == nil then
		return
	end
	
	local time = 0	
	
	if _PlayerInfo( target, "connected" ) then
		if argv[ 2 ] ~= nil then
			local num = tonumber( argv[ 2 ] )
			if num ~= nil then
				time = num
			end
		end
		
		_ServerCommand( "banid " .. time .. " " .. _PlayerInfo( target, "networkid" ) .. " kick;writeid\n" )
		ulx_log( "Admin " .. ulx_playerString( userid ) .. " kick banned player " .. ulx_playerString( target ) .. " for " .. time .. " minutes." )
	end
end

ULX_CONCOMMAND( "ulx_kickban", cc_ulxKickban, ACCESS_BAN, "<user> [<minutes>] - kicks & bans the player for the specified minutes ( perm ban if nil )", 1, "!kickban" )

-- cc_ulxMap - responds to ulx_map
function cc_ulxMap( userid, args, argv, argc )
	if string.find( argv[ 1 ], ";" ) then
		ulx_log( "Admin " .. ulx_playerString( userid ) .. " attempted to use an exploit to run console commands!" )
		_Msg( "Admin " .. ulx_playerString( userid ) .. " attempted to use an exploit to run console commands!" )
		return
	end
	_ServerCommand( "changelevel " .. argv[ 1 ] .. "\n" )
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " changed the map to " ..  argv[ 1 ] )	
end

ULX_CONCOMMAND( "ulx_map", cc_ulxMap, ACCESS_MAP, "<map> - changes to the specified map", 1, "!map" )

-- cc_ulxRcon - responds to ulx_rcon
function cc_ulxRcon( userid, args, argv, argc )
	_ServerCommand( args .. "\n" )
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " executed \"" .. args .. "\" on server console" )	
end

ULX_CONCOMMAND( "ulx_rcon", cc_ulxRcon, ACCESS_RCON, "<command> - Send the specified command to the server console", 1, "!rcon", false )

-- cc_ulxCsay - responds to ulx_csay <message>, prints the message in the center of everyone's screen
function cc_ulxCsay( userid, args, argv, argc )	
	local s = stripQuotes( args ) -- We don't want just the first argument, let's take the full thing
	ulx_csay_all( s )
end

ULX_CONCOMMAND( "ulx_csay", cc_ulxCsay, ACCESS_CHAT, "<message> - prints the message in the center of everyone's screen", 1, "@@@", false )

-- cc_ulxChat - responds to ulx_chat <message>, prints the message in the talk portion of everyone's screen
function cc_ulxChat( userid, args, argv, argc )	
	local s = stripQuotes( args )
	ulx_tsay_all( s )
end

ULX_CONCOMMAND( "ulx_say", cc_ulxChat, ACCESS_CHAT, "<message> - prints the message in the chat portion of everyone's screen", 1, "@@", false )

-- cc_ulxAchat - responds to ulx_achat
function cc_ulxAchat( userid, args, argv, argc )
	local name = _PlayerInfo( userid, "name" )
	for i = 1, _MaxPlayers() do
		if getAccess( i ) ~= nil then -- If this player has access, show it!
			ulx_tsay( i, name .. " to admins: " .. args )
		end
	end
	
	if getAccess( userid ) == nil then
		ulx_tsay( userid, name .. " to admins: " .. args ) -- If they weren't included in the loop, still let them know they said it.
	end
end

ULX_CONCOMMAND( "ulx_asay", cc_ulxAchat, _, "<message> - Sends message to all currently connected admins", 1, "@", false )

-- cc_ulxPsay - responds to ulx_psay
function cc_ulxPsay( userid, args, argv, argc )
	local target = getUser( userid, argv[ 1 ] )
	if target == nil then
		return
	end
	
	if target == userid then
		ulx_tsay( userid, "Why are you trying to talk to yourself?" )
		return
	end

	local name = _PlayerInfo( userid, "name" )
	
	if _PlayerInfo( target, "connected" ) and argv[ 2 ] ~= nil then
		args = string.sub( args, string.len( argv[ 1 ] ) + 2 ) -- Cut off the name
		ulx_tsay( target, name .. " to " .. _PlayerInfo( target, "name" ) .. ": " .. args )
		ulx_tsay( userid, name .. " to " .. _PlayerInfo( target, "name" ) .. ": " .. args )
	end
end

ULX_CONCOMMAND( "ulx_psay", cc_ulxPsay, _, "<user> <message> - Sends message to specified user", 2, "/p", false )

-- cc_ulxTeam - responds to ulx_chat <user> <team>
function cc_ulxTeam( userid, args, argv, argc )
	local target = getUser( userid, argv[ 1 ] )
	if target == nil then
		return
	end
	
	local team = tonumber( argv[ 2 ] )
	if team ~= nil and team >= 0 and team <= 5 then
		_PlayerChangeTeam( target, team )
		return
	end
	
	team = string.lower( argv[ 2 ] )
	if team == "unassigned" then
		_PlayerChangeTeam( target, TEAM_UNASSIGNED )
	elseif team == "spectator" then
		_PlayerChangeTeam( target, TEAM_SPECTATOR )
	elseif team == "blue" then
		_PlayerChangeTeam( target, TEAM_BLUE )		
	elseif team == "yellow" then
		_PlayerChangeTeam( target, TEAM_YELLOW )		
	elseif team == "green" then
		_PlayerChangeTeam( target, TEAM_GREEN )		
	elseif team == "red" then
		_PlayerChangeTeam( target, TEAM_RED )
	else
		ulx_console( userid, "You entered an invalid team!\n" )
		return
	end
	
	_PlayerRespawn( target ) -- This is so they'll respawn in their correct team area
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " changed player " .. ulx_playerString( target ) .. "'s team to " .. team )
end

ULX_CONCOMMAND( "ulx_team", cc_ulxTeam, ACCESS_SLAY, "<user> <team> - forces the user to join the team ( unassigned, spectator, blue, yellow, green, red )", 2, "team" )

function cc_ulxVote( userid, args, argv, argc )
	local title = argv[ 1 ]
	table.remove( argv, 1 ) -- Get rid of the title
	menu_sendVoteTable( ulx_voteCallback, _, title, argv, argv )
end

function ulx_voteCallback( id, num, name )
	ulx_tsay_all( "Option \"" .. tostring( name ) .. "\" won!" )
end
ULX_CONCOMMAND( "ulx_vote", cc_ulxVote, ACCESS_VOTE, "<question> <option 1> <option 2> ... - Takes up a vote with the specified options", 3, "!vote" )

-- cc_ulxVotemap
function cc_ulxVotemap( userid, args, argv, argc )
	for i,v in pairs( argv ) do -- Loop through the arguments
		if _file.Exists( "maps/" .. v .. ".bsp" ) == false then
			ulx_console( userid, "Invalid map!" )
			return
		end
	end
	
	if argc == 1 then
		menu_sendVote( ulx_votemapCallback, _, "Change map to " .. argv[ 1 ] .. "?", "Yes", argv[ 1 ], "No", false )
	else
		menu_sendVoteTable( ulx_votemapCallback, _, "Change level to:", argv, argv )
	end
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " started a votemap" )	
end

function ulx_votemapCallback( id )
	if id == nil or id == ID_NONE or id == false then
		ulx_tsay_all( "Votemap unsuccessful." )
		return
	end
	
	ulx_tsay_all( "Map \"" .. id .. "\" won! Changing levels now." )
	AddTimer( 5, 1, _ServerCommand, "changelevel " .. id .. "\n" )
end

ULX_CONCOMMAND( "ulx_votemap", cc_ulxVotemap, ACCESS_VOTE, "map [map2] .. - Gives the users a vote on the chosen maps ( Yes/No question if only one specified )", 1, "!votemap" )

-- cc_ulxVotekick
function cc_ulxVotekick( userid, args, argv, argc )
	local target = getUser( userid, argv[ 1 ] )
	if target == nil then
		return
	end
	
	menu_sendVote( ulx_votekickCallback, _, "Kick " .. _PlayerInfo( target, "name" ) .. "?", "Yes", _PlayerInfo( target, "networkid" ), "No", false )
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " started a votekick on player" .. ulx_playerString( userid ) )	
end

function ulx_votekickCallback( id )
	if id == nil or id == ID_NONE or id == false then
		ulx_tsay_all( "Votekick unsuccessful." )
		return
	end
	
	ulx_tsay_all( "Player kicked" )
	_ServerCommand( "kickid " .. id .. " \"votekick\"\n" )
end

ULX_CONCOMMAND( "ulx_votekick", cc_ulxVotekick, ACCESS_VOTE, "<user> - Gives the users a vote to kick the specified player", 1, "!votekick" )

-- cc_ulxVotekickban
function cc_ulxVotekickban( userid, args, argv, argc )
	local target = getUser( userid, argv[ 1 ] )
	if target == nil then
		return
	end
	
	menu_sendVote( ulx_votekickbanCallback, _, "Kickban " .. _PlayerInfo( target, "name" ) .. "?", "Yes", _PlayerInfo( target, "networkid" ), "No", false )
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " started a votekickban on player" .. ulx_playerString( userid ) )	
end

function ulx_votekickbanCallback( id )
	if id == nil or id == ID_NONE or id == false then
		ulx_tsay_all( "Votekickban unsuccessful." )
		return
	end
	
	ulx_tsay_all( "Player kickbanned" )
	_ServerCommand( "banid 0 " .. id .. " kick\n" )
end

ULX_CONCOMMAND( "ulx_votekickban", cc_ulxVotekickban, ACCESS_VOTE, "<user> - Gives the users a vote to kickban the specified player", 1, "!votekickban" )


function cc_ulxRemoveflames( userid, args, argv, argc )
	local flames = _EntitiesFindByClass( "entityflame" )
	
	for i=0, table.getn( flames ) do -- Loop through them
		_EntRemove( flames[ i ] )
	end
	
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " removed flames" )	
end

ULX_CONCOMMAND( "ulx_removeflames", cc_ulxRemoveflames, ACCESS_SLAY, "- Removes all flames", 0, "removeflames" )

function cc_ulxEnt( userid, args, argv, argc )
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " created an ent, using these arguments: " .. args ) -- Log first incase it crashes
	local class = argv[ 1 ]
	table.remove( argv, 1 ) -- We already have the first now
	newEnt = _EntCreate( class )

	local pos = _PlayerGetShootPos( userid )
	local ang = _PlayerGetShootAng( userid )
	_TraceLine( pos, ang, 4096, userid )
	local vector = _TraceEndPos()
	vector.z = vector.z + 20
	debug( tostring( vector ) )
	_EntSetKeyValue( newEnt, "origin", vector.x .. " " .. vector.y .. " " .. vector.z ) -- Note that the position can be overridden by the users's flags

	for i,v in ipairs( argv ) do -- Loop through them
		local key = string.sub( v, 1, string.find( v, ":" ) - 1 )
		local value = string.sub( v, string.find( v, ":" ) + 1 )
		_EntSetKeyValue( newEnt, key, value )
	end

	_EntSpawn( newEnt )
end

ULX_CONCOMMAND( "ulx_ent", cc_ulxEnt, ACCESS_ENT, "<classname> <flag> .. - spawn an ent, separate flag and value with : ( IE: ulx_ent prop_ragdoll model:models/alyx.mdl )", 1 )

function cc_ulxAdduser( userid, args, argv, argc )
	local target = getUser( userid, argv[ 1 ] )
	if target == nil then
		return
	end
	
	local steamid = _PlayerInfo( target, "networkid" ) -- Little bit of error checking
	if steamid == "UNKNOWN" then
		ulx_console( userid, "Sorry, you can't add users that have a steamid of UNKNOWN" )
		return
	end
	
	argv[ 2 ] = stripQuotes( argv[ 2 ] )
	_file.Write( "lua/ulx/configs/users.ini", _file.Read( "lua/ulx/configs/users.ini" ) .. "\"" .. steamid .. "\" \"" .. argv[ 2 ] .. "\"\r\n" )
	addUser( steamid, argv[ 2 ] )
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " made user " .. ulx_playerString( target ) .. " an admin with access " .. argv[ 2 ] )
end

ULX_CONCOMMAND( "ulx_adduser", cc_ulxAdduser, ACCESS_RCON, "<user> <access> - Adds a user with the specified access to the permanent access list", 2 )

function cc_ulxLua( userid, args, argv, argc )
	_ServerCommand( "lua " .. args .. "\n" )
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " executed lua command: " .. args )
end

ULX_CONCOMMAND( "ulx_lua", cc_ulxLua, ACCESS_RCON, "<command> - Feeds the server a lua command", 1 )

function cc_ulxExec( userid, args, argv, argc )
	execFile( argv[ 1 ] )
	ulx_log( "Admin " .. ulx_playerString( userid ) .. " executed file " .. argv[ 1 ] )
end

ULX_CONCOMMAND( "ulx_exec", cc_ulxExec, ACCESS_CFG, "<file> - executes a file ( will run lua commands properly )", 1 )













function mingecheck( name, userid, steamid )
	if ulx_sv_mingekick ~= "1" then
		return
	end
	
	if string.sub( string.lower( name ), -8 ) == "mingebag" then
		_ServerCommand( "kickid " .. steamid .. " \"ULX Auto-Minge kick\"\n" )
		ulx_log( "Mingebag kicked by ULX ( steamid unknown )" )
	end
	return
end

HookEvent( "eventPlayerConnect", mingecheck )

function welcomeMessage( name, userid, steamid )
	ulx_tsay_parse( userid, ulx_sv_welcomemessage )
end

HookEvent( "eventPlayerActive", welcomeMessage )

gUserConnectionTime = {}

function reserveSlotCheck( name, userid, steamid )
	gUserConnectionTime[ userid ] = _CurTime()
	
	local mode = tonumber( ulx_sv_reservedslotmode )
	if mode == nil or mode == 0 then -- disabled
		return
	end
	
	local curPlayers = 0
	for i=1, _MaxPlayers() do
		if _PlayerInfo( i, "connected" ) == true then
			curPlayers = curPlayers + 1
		end
	end
	
	local reserved = 1
	if mode == 1 then
		reserved = tonumber( ulx_sv_reservedslots )
		if reserved == nil then
			return
		end	
	end
	
	if hasAccess( userid, ACCESS_RESERVATION ) == false then -- Don't run checks on those with reservation
		--debug( "reserved = " .. reserved )	
		--debug( "curPlayers = " .. curPlayers )
	
		if curPlayers + reserved > _MaxPlayers() then
			_ServerCommand( "kickid " .. steamid .. " \"ULX-Slot reserved\"\n" )
			return
		end
	end
	
	if curPlayers + reserved > _MaxPlayers() and mode ~= 1 then -- We need to kick someone
		if mode == 2 then
			local highest = nil
			for i=1, _MaxPlayers() do
				if _PlayerInfo( i, "connected" ) and hasAccess( i, ACCESS_IMMUNITY ) == false then
					if highest == nil or _PlayerInfo( i, "ping" ) > _PlayerInfo( highest, "ping" ) then
						highest = i
					end
				end
			end
			
			if highest == nil then
				return -- ERROR
			end
			
			_ServerCommand( "kickid " .. _PlayerInfo( highest, "networkid" ) .. " \"ULX-Freeing slot\"\n" )
		elseif mode == 3 then
			local shortest = nil
			for i=1, _MaxPlayers() do
				if _PlayerInfo( i, "connected" ) and hasAccess( i, ACCESS_IMMUNITY ) == false and hasAccess( i, ACCESS_RESERVATION ) == false and gUserConnectionTime[ i ] ~= nil then
					if shortest == nil or gUserConnectionTime[ i ] > gUserConnectionTime[ shortest ] then
						shortest = i
					end
				end
			end
			
			if shortest == nil then
				return -- ERROR
			end
			
			_ServerCommand( "kickid " .. _PlayerInfo( shortest, "networkid" ) .. " \"ULX-Freeing slot\"\n" )			
		end
	end
	
	return
end

HookEvent( "eventPlayerActive", reserveSlotCheck )
