--[[
	Title: ulx init

	Opens everything needed by ulx. It handles multiple loadings itself,
	so you do not need to worry about it.
]]

assert( _file.Exists( "lua/ULib/init.lua" ), "ULX needs ULib to run!" )
_OpenScript( "ULib/init.lua" )
assert( ULib.ULIB_VERSION >= 1.2, "ULX requires ULib version 1.2 or higher to run!" )


--- If we haven't already loaded ULib, load it!
if not ulx then
--[[
	Table: ulx

	Contains ulx. Everything in ulx is within this table, and should be used with "ulx." infront of it.
    ]]
	ulx = {}

	_Msg( "///////////////////////////////\n" )
	_Msg( "//            ULX            //\n" )
	_Msg( "///////////////////////////////\n" )
	_Msg( "// Loading...                //\n" )

	_Msg( "//  base.lua                 //\n" )
	_OpenScript( "ulx/base.lua" )
	_Msg( "//  util.lua                 //\n" )
	_OpenScript( "ulx/util.lua" )
	_Msg( "//  fun.lua                  //\n" )
	_OpenScript( "ulx/fun.lua" )
	_Msg( "//  cleanup.lua              //\n" )
	_OpenScript( "ulx/cleanup.lua" )
	_Msg( "//  menu_skin.lua            //\n" )
	_OpenScript( "ulx/menu_skin.lua" )
	_Msg( "//  menus.lua                //\n" )
	_OpenScript( "ulx/menus.lua" )
	_Msg( "//  vote.lua                 //\n" )
	_OpenScript( "ulx/vote.lua" )
	_Msg( "//  ulib_plugin.lua          //\n" )
	_OpenScript( "ulx/ulib_plugin.lua" )
	_Msg( "//  timed.lua                //\n" )
	_OpenScript( "ulx/timed.lua" )
	_Msg( "//  log.lua                  //\n" )
	_OpenScript( "ulx/log.lua" )
	_Msg( "//  end.lua                  //\n" )
	_OpenScript( "ulx/end.lua" )

	_Msg( "// Load Complete!            //\n" )
	_Msg( "///////////////////////////////\n" )
end