--[[
	Title: Base

	Sets up some things for ulx.
]]

--[[
	Variable: ucl
	
	This is what holds the ucl we'll use.
]]
ulx.ucl = ULib.mainUcl

ulx.LOW_ARGS = "You did not specify enough arguments for this command. Type 'ulx help' in console for help."

ulx.version = 2.21

ulx.help = {}
ulx.convarhelp = {}

function ulx.cc_ulx( userid, args )
	if ULib.trim( args ) == "" then
		ULib.console( userid, "No command entered. If you need help, please type \"ulx help\" in your console." )
	else
		ULib.console( userid, "Invalid command entered. If you need help, please type \"ulx help\" in your console." )
	end
end
ULib.BEGIN_SUBCONCOMMAND( "ulx", ulx.cc_ulx )

--[[
	Function: CONCOMMAND
	
	This is what will set up ULX's commands, it makes them under the command "ulx"

	Parameters:
		
		command - The console command. IE, "kick".
		fn_call - The function to call when the command's called.
		help - *(Optional)* A help string for using the command.
		access - *(Optional, defaults to ACCESS_ALL)* Restricted access.
		say_cmd - *(Optional)* A say command to use.
		hide_say - *(Optional, defaults to false)* If true, say command will be hid.
		
	Returns:
	
		True on success, nil and error otherwise.
]]
function ulx.CONCOMMAND( command, fn_call, help, access, say_cmd, hide_say )
	if not ULib.checkParams( { command, fn_call }, { "string", "function" } ) then return nil, ULib.ERR_ARGS end
	if say_cmd and ULib.trim( say_cmd ) == "" then say_cmd = nil end

	if say_cmd and type( say_cmd ) == "string" then
		ULib.addSayCommand( say_cmd, fn_call, help, hide_say, access, ulx.ucl )
	end

	table.insert( ulx.help, { cmd=command, help=help, say_cmd=say_cmd } )
	return ULib.ADD_SUBCONCOMMAND( "ulx", command, fn_call, help, access, ulx.ucl )
end

--[[
	Function: CONVAR

	This is what will set up ULX's convars, it makes them under the command "ulx"

	Parameters:
		
		command - The console command. IE, "sv_kickminge".
		value - The value to start off at.
		help - *(Optional)* A help string for using the command.
		access - *(Optional, defaults to ACCESS_ALL)* Restricted access.

	Returns:
	
		True on success, nil and error otherwise.
]]
function ulx.CONVAR( command, value, help, access )
	value = value or ""
	if not ULib.checkParam( command, "string" ) then return nil, ULib.ERR_ARGS end

	table.insert( ulx.convarhelp, { cmd=command, access=access, help=help } )
	return ULib.ADD_SUBCONVAR( "ulx", command, value, help, access, ulx.ucl )
end

function ulx.cc_help( userid )
	ULib.console( userid, "ULX Help:" )
	ULib.console( userid, "If a command can take multiple targets, it will usually let you use the keywords <ALL>, <BLUE>, <YELLOW>, <GREEN>, and <RED>." )
	ULib.console( userid, "These keywords are self explanitory." )
	ULib.console( userid, "All commands must be preceded by \"ulx \", ie \"ulx slap\"" )
	ULib.console( userid, "\nCommand Help:" )
	for k, v in pairs( ulx.help ) do
		local t = ULib.GET_SUBCONCOMMAND( "ulx " .. v.cmd )
		if ulx.ucl:query( userid, t.access ) then
			if v.say_cmd then
				ULib.console( userid, " o " .. v.cmd .. " " .. v.help .. " (say:" .. v.say_cmd .. ")" )
			else
				ULib.console( userid, " o " .. v.cmd .. " " .. v.help )
			end
		end
	end

	ULib.console( userid, "\nCvar Help:" )
	for k, v in pairs( ulx.convarhelp ) do
		if ulx.ucl:query( userid, v.access ) then
			ULib.console( userid, " o " .. v.cmd .. " " .. v.help )
		end
	end
	ULib.console( userid, "-End of help\nULX version: " .. ulx.version .. "\n" )
end
ulx.CONCOMMAND( "help", ulx.cc_help, "- Shows this help.", ACCESS_ALL )


local oldFn = onUnknownConsoleCommand
function onUnknownConsoleCommand ( playerid, incommand, args )
	if oldFn( playerid, incommand, args ) then return true end -- Only bother if it's unhandled

	if string.sub( incommand, 1, 4 ) == "ulx_" then
		ULib.tsay( playerid, "ULX v2+ now uses the prefix \"ulx \" before commands instead of \"ulx_\", please try your command again." )
	end

	return false
end
