ulx.menu_skin = {}
ulx.menu_skin.prev = "Previous Page"
ulx.menu_skin.next = "Next Page"
ulx.menu_skin.exit = "Exit"
ulx.menu_skin.max_options = 10
ULib.default_skin.bind_options = true

local menuColor = { r=75, g=180, b=255, a=220 }
local textColor = { r=255, g=255, b=255, a=255 }
local disabledTextColor = { r=175, g=175, b=175, a=255 }
local titleColor = { r=255, g=255, b=255, a=220 }

local menuPos = { x=0.025, y=0.35, w=0.2, h=0.305 }
local textPos = { x=0.045, y=0.39, spacing=0.02, titlespace=0.02 }
local titlePos = { x=0.06, y=0.325, w=0.07, h=0.045 }

local rectKey = 588 -- Uses 2
local textKey = 590 -- This is where to start, this skin will take (max_options+1) keys

function ulx.menu_skin.showMenu( userid, title, page_options, timeout, page, menu )
	ULib.sendRect( userid, rectKey + 1, titlePos.x, titlePos.y, titlePos.w, titlePos.h, timeout, titleColor.r, titleColor.g, titleColor.b, titleColor.a, "ulx/title" )
	ULib.sendRect( userid, rectKey, menuPos.x, menuPos.y, menuPos.w, menuPos.h, timeout, menuColor.r, menuColor.g, menuColor.b, menuColor.a, "ULib/menu" )

	ULib.sendText( userid, textKey, textPos.x, textPos.y, "  " .. title, timeout, textColor.r, textColor.g, textColor.b, textColor.a )
	for k, v in pairs( page_options ) do
		if v.disabled then
			ULib.sendText( userid, textKey + k, textPos.x, textPos.y + k * textPos.spacing + textPos.titlespace, math.mod( k, 10 ) .. ". " .. v.text, timeout, disabledTextColor.r, disabledTextColor.g, disabledTextColor.b, disabledTextColor.a ) -- Mod so 10 shows up as 0
		else
			ULib.sendText( userid, textKey + k, textPos.x, textPos.y + k * textPos.spacing + textPos.titlespace, math.mod( k, 10 ) .. ". " .. v.text, timeout, textColor.r, textColor.g, textColor.b, textColor.a ) -- Mod so 10 shows up as 0
		end
	end
end

function ulx.menu_skin.hideMenu( userid, page_options, page, menu )
	for i=textKey, textKey + ulx.menu_skin.max_options + 1 do
		_GModText_Hide( userid, i )
	end
	_GModRect_Hide( userid, rectKey )
	_GModRect_Hide( userid, rectKey + 1 )
	--_GModRect_Hide( userid, titleKey )
end

function ulx.menu_skin.startVote( userid, time, voteMenu )
end

function ulx.menu_skin.updateVote( userid, optionid, time, text, voteMenu )
end

function ulx.menu_skin.endVote( winning_id, winning_text, total_votes, total_voters, voteMenu )
end