--[[
	Title: Utilities

	Some tools to help admins do what they do best.
]]

function ulx.cc_who( userid, args, argv, argc )
	ULib.console( userid, "userid   name   access" )
	
	for i=1, _MaxPlayers() do
		if _PlayerInfo( i, "connected" ) then
			local access = ulx.ucl:getAccess( i )
			if access then -- If this player has access, show it!
				ULib.console( userid, i .. "   " .. _PlayerInfo( i, "name" ) .. "   " .. access )
			else
				ULib.console( userid, i .. "   " .. _PlayerInfo( i, "name" ) .. "   GUEST" )
			end
		end
	end

	ULib.console( userid, "End of admin list" )
end
ulx.CONCOMMAND( "who", ulx.cc_who, "- Shows all connected players ids and access." )

function ulx.cc_rcon( userid, args, argv, argc )
	ulx.logServAct( userid, "#A ran rcon command \""..args.."\"", true )
	_ServerCommand( args .. "\n" )
end
ulx.CONCOMMAND( "rcon", ulx.cc_rcon, "<command> - Send the specified command to the server console", ACCESS_RCON, "!rcon", true )

function ulx.cc_team( userid, args, argv, argc )
	if argc < 2 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local target, err = ULib.getUser( argv[ 1 ], _, ulx.ucl, userid )
	if not target then
		ULib.tsay( userid, err )
		return
	end
	
	local team = tonumber( argv[ 2 ] )
	if team ~= nil and team >= 0 and team <= 5 then -- Easy number
		_PlayerChangeTeam( target, team )
		_PlayerRespawn( target ) -- This is so they'll respawn in their correct team area
		return
	end
	
	team = string.lower( argv[ 2 ] )
	if team == "unassigned" then
		_PlayerChangeTeam( target, TEAM_UNASSIGNED )
	elseif team == "spectator" then
		_PlayerChangeTeam( target, TEAM_SPECTATOR )
	elseif team == "blue" then
		_PlayerChangeTeam( target, TEAM_BLUE )		
	elseif team == "yellow" then
		_PlayerChangeTeam( target, TEAM_YELLOW )
	elseif team == "green" then
		_PlayerChangeTeam( target, TEAM_GREEN )		
	elseif team == "red" then
		_PlayerChangeTeam( target, TEAM_RED )
	else
		ULib.tsay( userid, "You entered an invalid team!\n" )
		return
	end
	
	_PlayerRespawn( target ) -- This is so they'll respawn in their correct team area
	ulx.logUserAct(userid, target, "#A swaped #T to team "..team)
end
ulx.CONCOMMAND( "team", ulx.cc_team, "<user> <team> - forces the user to join the team (unassigned, spectator, blue, yellow, green, red)", ACCESS_PLAYER, "!team" )

function ulx.cc_lua( userid, args, argv, argc )
	ulx.logServAct(userid, "#A ran lua command \""..args.."\"")
	_ServerCommand( "lua " .. args .. "\n" )
end
ulx.CONCOMMAND( "lua", ulx.cc_lua, "<command> - Feeds the server a lua command", ACCESS_RCON )

function ulx.cc_exec( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	if _file.Exists( argv[ 1 ] ) then
		ULib.execFile( argv[ 1 ] )
		ulx.logServAct(userid, "#A executed config file \""..argv[1].."\"")
	elseif _file.Exists( "cfg/" .. argv[ 1 ] ) then
		ULib.execFile( "cfg/" .. argv[ 1 ] )
		ulx.logServAct(userid, "#A executed config file \"cfg/"..argv[1].."\"")
	else
		ULib.tsay(userid,"Invalid config file.")
	end
end
ulx.CONCOMMAND( "exec", ulx.cc_exec, "<file> - executes a file (will run lua commands properly)", ACCESS_CVAR )

function ulx.cc_kick( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local target, err = ULib.getUser( argv[ 1 ], _, ulx.ucl, userid )
	if not target then
		ULib.tsay( userid, err )
		return
	end
	if argv[ 2 ] then
		ulx.logUserAct( userid, target, "#A kicked #T (" .. argv[ 2 ] .. ")" )
	else
		ulx.logUserAct( userid, target, "#A kicked #T" )
	end
	
	ULib.kick( target, argv[ 2 ] )
end
ulx.CONCOMMAND( "kick", ulx.cc_kick, "<user> [<reason>] - Kicks a user with the given reason", ACCESS_KICK, "!kick" )

function ulx.cc_ban( userid, args, argv, argc )
	if argc < 2 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local target, err = ULib.getUser( argv[ 1 ], _, ulx.ucl, userid )
	if not target then
		ULib.tsay( userid, err )
		return
	end
	
	local bantime = tonumber( argv[ 2 ] )
	if not bantime then ULib.tsay( useird, "Invalid ban time!" ) return end

	local time = "for " .. argv[ 2 ] .. " minute(s)"
	if tonumber(argv[ 2 ]) == 0 then time = "permanently" end
	ulx.logUserAct(userid, target, "#A banned #T "..time)

	ULib.ban( target, bantime )
end
ulx.CONCOMMAND( "ban", ulx.cc_ban, "<user> <time> - Bans a user for time, use 0 time for permaban", ACCESS_BAN, "!ban" )

function ulx.cc_kickban( userid, args, argv, argc )
	if argc < 2 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local target, err = ULib.getUser( argv[ 1 ], _, ulx.ucl, userid )
	if not target then
		ULib.tsay( userid, err )
		return
	end

	local bantime = tonumber( argv[ 2 ] )
	if not bantime then ULib.tsay( useird, "Invalid ban time!" ) return end

	local time = "for " .. argv[ 2 ] .. " minute(s)"
	if tonumber(argv[ 2 ]) == 0 then time = "permanently" end
	ulx.logUserAct(userid, target, "#A kicked #T and banned him/her "..time)

	ULib.kickban( target, bantime )
end
ulx.CONCOMMAND( "kickban", ulx.cc_kickban, "<user> <time> - Bans a user for time, use 0 time for permaban", ACCESS_BAN, "!kickban" )

function ulx.cc_asay( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local message = _PlayerInfo( userid, "name" ) .. " to admins: " .. args
	for i=1, _MaxPlayers() do
		if _PlayerInfo( i, "connected" ) and ulx.ucl:query( i, ACCESS_CHAT ) then
			ULib.tsay( i, message )
		end
	end
end
ulx.CONCOMMAND( "asay", ulx.cc_asay, "<message> - Sends a message to all currently connected admins.", ACCESS_CHAT, "@", true )

function ulx.cc_tsay( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	ULib.tsay( 0, args )
end
ulx.CONCOMMAND( "tsay", ulx.cc_tsay, "<message> - Sends a message to everyone.", ACCESS_CHAT, "@@", true )

function ulx.cc_csay( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	ULib.csay( 0, args )
end
ulx.CONCOMMAND( "csay", ulx.cc_csay, "<message> - Sends a message to everyone in the middle of the screen", ACCESS_CHAT, "@@@", true )

function ulx.cc_psay( userid, args, argv, argc )
	if argc < 2 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end
	
	local targets, err = ULib.getUsers( argv[ 1 ], true, true, ulx.ucl, userid ) -- Enable keywords, ignore immunity
	if not targets then
		ULib.tsay( userid, err )
		return
	end

	local target = argv[ 1 ] -- Let's establish a string for "to:"
	if table.getn( targets ) == 1 then
		target = _PlayerInfo( targets[ 1 ], "name" )
	end

	local str = string.gsub( args, argv[ 1 ], "" ) -- Take the target out of the string.
	local message = _PlayerInfo( userid, "name" ) .. " to " .. target .. ":" .. str

	for _, v in ipairs( targets ) do
		if v ~= userid then
			ULib.tsay( v, message )
		end
	end
	ULib.tsay( userid, message )
end
ulx.CONCOMMAND( "psay", ulx.cc_psay, "<user> <message> - Sends a private message to target(s)", ACCESS_ALL, "!p", true )

function ulx.cc_map( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local map = argv[ 1 ]
	if string.sub( map, -4 ) == ".bsp" then
		map = string.sub( map, 1, -5 ) -- Take off the .bsp
	end

	if not _file.Exists( "maps/" .. map .. ".bsp" ) then
		ULib.tsay( userid, map .. " is not a valid map!" )
		return
	end
	ulx.logServAct(userid, "#A changed map to "..map)
	_ServerCommand( "changelevel " .. map .. "\n" )
end
ulx.CONCOMMAND( "map", ulx.cc_map, "<map> - Changes to the specified map", ACCESS_MAP, "!map" )

function ulx.cc_ent( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local class = argv[ 1 ]
	table.remove( argv, 1 ) -- We already have the first now
	newEnt = _EntCreate( class )

	local pos = _PlayerGetShootPos( userid )
	local ang = _PlayerGetShootAng( userid )
	_TraceLine( pos, ang, 4096, userid )
	local vector = _TraceEndPos()
	vector.z = vector.z + 20

	_EntSetKeyValue( newEnt, "origin", vector.x .. " " .. vector.y .. " " .. vector.z ) -- Note that the position can be overridden by the users's flags

	for i,v in ipairs( argv ) do -- Loop through them
		local key = string.sub( v, 1, string.find( v, ":" ) - 1 )
		local value = string.sub( v, string.find( v, ":" ) + 1 )
		_EntSetKeyValue( newEnt, key, value )
	end

	_EntSpawn( newEnt )
	ulx.logServAct(userid, "#A created entity " .. args)
end
ulx.CONCOMMAND( "ent", ulx.cc_ent, "<classname> <flag> .. - spawn an ent, separate flag and value with : (IE: ulx ent prop_ragdoll model:models/alyx.mdl)", ACCESS_ENT )


function ulx.cc_changeAccess( userid, args, argv, argc )
	if argc < 2 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end
	
	if argc > 2 then
		ULib.tsay( userid, "You specified too many arguments. Perhaps you forgot to use quotes around the command?" )
		return
	end

	local command = argv[ 1 ]
	local newaccess = argv[ 2 ]
	if string.len( newaccess ) > 1 then string.upper( newaccess ) end -- If they're using a define, make sure it's all caps.
	newaccess = ULib.reverseAccess[ newaccess ] or newaccess -- Pick up defines.

	if not ULib.commands[ command ] and not ULib.GET_SUBCONCOMMAND( command ) then
		ULib.tsay( userid, "The commmand \"" .. command .. "\" does not exist or is not under ULib control!" )
	end

	local oldaccess
	if ULib.commands[ command ] then
		oldaccess = ULib.commands[ command ].access
	else
		oldaccess = ULib.GET_SUBCONCOMMAND( command ).access
	end
	oldaccess = ULib.reverseAccess[ oldaccess ] or oldaccess -- Pick up defines.
	if oldaccess == nil then oldaccess = "ACCESS_ALL" end -- Needs special attention

	local data = ULib.parseKeyValues( ULib.stripComments( _file.Read( ULib.ACCESS_FILE ), "//" ) )
	table.remove( data[ oldaccess ], ULib.findInTable( data[ oldaccess ], command ) )
	table.insert( data[ newaccess ], command )
	_file.Write( ULib.ACCESS_FILE, ULib.makeKeyValues( data ) )
	ULib.parseAccess() -- Let it sort out the file properly and apply changes.
end
ulx.CONCOMMAND( "changeaccess", ulx.cc_changeAccess, "<command> <newAccess> - Change command access. IE, changeaccess \"ulx help\" \"b\". Can use access defines too.", ACCESS_RCON )


---------------
--   Hooks   --
---------------
local function checkMinge( name, userid )
	if ULib.getCvar( "ulx sv_mingekick" ) == "1" then
		if name == "MingeBag" or string.sub( name, 4 ) == "MingeBag" then -- Catches it with numbers in front as well
			AddTimer( 0.1, 1, ULib.kick, userid, "[ULX] Auto-minge kick" )
		end
	end
end
HookEvent( "eventPlayerActive", checkMinge )
ulx.CONVAR( "sv_mingekick", "0", "<0/1> - Turns off/on auto-minge bag kick", ACCESS_KICK )

local function showWelcome( name, userid )
	local message = ULib.getCvar( "ulx sv_welcomemessage" )
	if not message or message == "" then return end

	message = string.gsub( message, "%%curmap%%", _GetCurrentMap() )
	message = string.gsub( message, "%%hostname%%", _GetConVar_String( "hostname" ) )

	ULib.tsay( userid, message )
end
HookEvent( "eventPlayerActive", showWelcome )
ulx.CONVAR( "sv_welcomemessage", "", "<msg> - This is shown to players on join", ACCESS_CHAT )

local gUserConnectionTime = {}

local function reserveSlotCheck( name, userid, steamid )
	gUserConnectionTime[ userid ] = _CurTime()
	
	local mode = tonumber( ULib.getCvar( "ulx sv_reservedslotmode" ) )
	if not mode or mode == 0 then -- disabled
		return
	end
	
	local curPlayers = 0
	for i=1, _MaxPlayers() do
		if _PlayerInfo( i, "connected" ) == true then
			curPlayers = curPlayers + 1
		end
	end
	
	local reserved = 1
	if mode == 1 then
		reserved = tonumber( ULib.getCvar( "ulx sv_reservedslots" ) )
		if not reserved then -- Error
			return
		end	
	end
	
	if not ulx.ucl:query( userid, ACCESS_RESERVATION ) then -- Don't run checks on those with reservation
		if curPlayers + reserved > _MaxPlayers() then
			ULib.kick( userid, "[ULX] Slot reserved" )
			return
		end
	end
	
	if curPlayers + reserved > _MaxPlayers() and mode ~= 1 then -- We need to kick someone
		if mode == 2 then -- Kick highest ping
			local highest
			local ping
			for i=1, _MaxPlayers() do
				if _PlayerInfo( i, "connected" ) and not ulx.ucl:query( i, ACCESS_IMMUNITY ) then
					local newping = _PlayerInfo( i, "ping" )
					if not highest or newping > ping then
						highest = i
						ping = newping
					end
				end
			end
			
			if not highest then
				return -- ERROR
			end
			
			ULib.kick( highest, "[ULX] Freeing slot" )
		elseif mode == 3 then
			local shortest
			for i=1, _MaxPlayers() do
				if _PlayerInfo( i, "connected" ) and not ulx.ucl:query( i, ACCESS_IMMUNITY ) and not ulx.ucl:query( i, ACCESS_RESERVATION ) and gUserConnectionTime[ i ] then
					if not shortest or gUserConnectionTime[ i ] > gUserConnectionTime[ shortest ] then
						shortest = i
					end
				end
			end
			
			if not shortest then
				return -- ERROR
			end

			ULib.kick( shortest, "[ULX] Freeing slot" )
		end
	end
	
	return
end
HookEvent( "eventPlayerActive", reserveSlotCheck )
ulx.CONVAR( "sv_reservedslots", "2", "- How many slots are reserved for admins", ACCESS_KICK )
ulx.CONVAR( "sv_reservedslotmode", "0", "- Reserved slot mode, read server.ini", ACCESS_KICK )

function ulx.cc_addAdvert( userid, args, argv, argc )
	if userid ~= 0 then -- Not called from a config
		return
	end
	
	if argc < 2 then return end -- Invalid

	local message = argv[ 1 ]
	local rpt = tonumber( argv[ 2 ] )
	if not ULib.checkParams( { message, rpt }, { "string", "number" } ) then return end -- Dodge invalids
	
	message = string.gsub( message, "%%curmap%%", _GetCurrentMap() )
	message = string.gsub( message, "%%hostname%%", _GetConVar_String( "hostname" ) )
	message = string.gsub( message, "%%ulx_version%%", ulx.version )
	AddTimer( rpt, 0, ULib.tsay, 0, message )
end
ulx.CONCOMMAND( "addAdvert", ulx.cc_addAdvert, "", ACCESS_NONE ) -- Can only add from configs

function ulx.cc_addCsayAdvert( userid, args, argv, argc )
	if userid ~= 0 then -- Not called from a config
		return
	end
	
	if argc < 6 then return end -- Invalid

	local message = argv[ 1 ]
	local r = tonumber( argv[ 2 ] )
	local g = tonumber( argv[ 3 ] )
	local b = tonumber( argv[ 4 ] )
	local rpt = tonumber( argv[ 5 ] )
	local len = tonumber( argv[ 6 ] )
	if not ULib.checkParams( { message, r, g, b, rpt, len }, { "string", "number", "number", "number", "number", "number" } ) then return end -- Dodge invalids
	
	message = string.gsub( message, "%%curmap%%", _GetCurrentMap() )
	message = string.gsub( message, "%%hostname%%", _GetConVar_String( "hostname" ) )
	message = string.gsub( message, "%%ulx_version%%", ulx.version )	
	AddTimer( rpt, 0, ULib.csay, 0, message, r, g, b, _, len )
end
ulx.CONCOMMAND( "addCsayAdvert", ulx.cc_addCsayAdvert, "", ACCESS_NONE ) -- Can only add from configs

function ulx.cc_entfire( userid, args, argv, argc )
	if argc < 2 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local targets
	if tonumber( argv[ 1 ] ) then
		targets = { tonumber( argv[ 1 ] ) }
	elseif argv[ 1 ] == "!picker" then
		PlayerLookTrace( userid, 4096 )
		targets = { _TraceGetEnt() }
	else
		local name = _EntitiesFindByName( argv[ 1 ] )
		local class = _EntitiesFindByClass( argv[ 1 ] )
		name = name or {}
		class = class or {} -- To avoid errors in merging.
		targets = ULib.mergeTable( name, class )
	end

	if not targets or targets[ 1 ] == -1 then -- Nothing found
		ULib.tsay( userid, "No such entity found!" )
		return
	end
	
	local delay = tonumber( argv[ 4 ] )

	for _, id in ipairs( targets ) do
		_EntFire( id, argv[ 2 ], argv[ 3 ], delay )
	end
	ulx.logServAct(userid, "#A used entfire command \"" .. args .. "\"")
end
ulx.CONCOMMAND( "entfire", ulx.cc_entfire, "- Like ent_fire <target> <action> [<value>] [<delay>]", ACCESS_ENT, "!entfire" )

function ulx.cc_adduser( userid, args, argv, argc )
	if argc < 2 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end
	
	local target, err = ULib.getUser( argv[ 1 ], _, ulx.ucl, userid )
	if not target then
		ULib.tsay( userid, err )
		return
	end
	
	if ulx.ucl ~= ULib.mainUcl then
		ULib.tsay( userid, "Sorry, this server is using a custom UCL, adduser cannot be used with custom UCLs." )
		return
	end

	local pass = argv[ 3 ] or ""
	local passreq = ULib.isStringTrue( argv[ 4 ] )

	local login = ULib.getSteamLogin( target )
	local success, msg = ulx.ucl:addUser_steamlogin( login, pass, argv[ 2 ], passreq )

	if not success then
		ULib.tsay( userid, "[UCL] adduser had an error, message is: \"" .. msg .. "\"" )
		return
	end

	-- Format of admin account:
	-- "<steamlogin>" "<password>" "<access flags>" "e[f]"
	local line = "\"" .. login .. "\" \"" .. pass .. "\" \"" .. argv[ 2 ] .. "\" \"e"
	if passreq then line = line .. "f" end
	line = line .. "\" // Added via ulx adduser by " .. ULib.playerString( userid )
	_file.Write( ULib.DEFAULT_UCL_FILE, ULib.trim( _file.Read( ULib.DEFAULT_UCL_FILE ) ) .. ULib.NEWLINE .. line )
	ulx.logUserAct(userid, target, "#A added user #T with access " .. argv[ 2 ])
end
ulx.CONCOMMAND( "adduser", ulx.cc_adduser, "<user> <access> [<password>] [<passreq>] - Gives access forever, with optional pass.", ACCESS_RCON, "!adduser" )

function ulx.cc_addtempuser( userid, args, argv, argc )
	if argc < 3 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end
	
	local target, err = ULib.getUser( argv[ 1 ], _, ulx.ucl, userid )
	if not target then
		ULib.tsay( userid, err )
		return
	end

	local timeout = tonumber( argv[ 3 ] )
	if string.lower( argv[ 3 ] ) == "map" then timeout = -1 end
	if not timeout then
		ULib.tsay( userid, "addtempuser was not given a valid value for access time." )
		return
	end
	
	local login = ULib.getSteamLogin( target )
	local success, msg = ulx.ucl:addUser_steamlogin( login, "", argv[ 2 ], false )

	if not success then
		ULib.tsay( userid, "[UCL] addtempuser had an error, message is: \"" .. msg .. "\"" )
		return
	end

	if timeout > 0 then
		timeout = timeout * 60 -- We need this to be in seconds! (Was given to us in minutes)
		AddTimer( timeout, 1, ulx.ucl.removeUser, ulx.ucl, login, ACCOUNT_STEAMLOGIN ) -- First arg is "self"

		ULib.db.tempaccess = ULib.db.tempaccess or {}
		ULib.db.tempaccess[ login ] = { stop=ULib.db.uptime+timeout, access=argv[ 2 ] }
		ULib.saveDb() -- Save the database now.		
	end
	ulx.logUserAct(userid, target, "#A temporarily added user #T with access " .. argv[ 2 ])
end
ulx.CONCOMMAND( "addtempuser", ulx.cc_addtempuser, "<user> <access> <time> - Gives access temp. Time is server mins, use \"map\" to give till mapchange.", ACCESS_RCON, "!addtempuser" )

-- Handle adding users again on map changes
local function addTempUsers()
	if not ULib.db.tempaccess then return end -- Nothing to do
	
	-- Clean up our database
	local db = ULib.db.tempaccess

	for k, v in pairs( db ) do
		if ULib.db.uptime > v.stop then
			db[ k ] = nil
		else
			ulx.ucl:addUser_steamlogin( k, "", v.access, false )
			local timeout = v.stop - ULib.db.uptime
			AddTimer( timeout, 1, ulx.ucl.removeUser, ulx.ucl, k, ACCOUNT_STEAMLOGIN ) -- First arg is "self"
		end
	end
	
	if ULib.numValues( db ) <= 0 then -- Remove if not necessary.
		ULib.db.tempacess = nil
	end
end
addTempUsers()
