ulx.cleanup = {}
ulx.cleanup.help = {}

function ulx.cleanup.cc_ulx_cleanup( userid, args )
	if ULib.trim( args ) ~= "" then
		ULib.console( userid, "Invalid command entered." )
	end

       	ULib.console( userid, "Cleanup Command Help:" )
       	for k, v in pairs( ulx.cleanup.help ) do
		local t = ULib.GET_SUBCONCOMMAND( "ulx clean " .. v.cmd )
		if ulx.ucl:query( userid, t.access ) then
			if v.say_cmd then
				ULib.console( userid, " o " .. v.cmd .. " " .. v.help .. " (say:" .. v.say_cmd .. ")" )
			else
				ULib.console( userid, " o " .. v.cmd .. " " .. v.help )
			end
		end
	end
end
ULib.BEGIN_SUBCONCOMMAND( "ulx clean", ulx.cleanup.cc_ulx_cleanup, _, ACCESS_ENT, ulx.ucl )
table.insert( ulx.help, { cmd="clean", help="- Offers various cleanups." } ) -- Put ourselves in ulx help.

function ulx.cleanup.CONCOMMAND( command, fn_call, help, access, say_cmd, hide_say )
	if not ULib.checkParams( { command, fn_call }, { "string", "function" } ) then return nil, ULib.ERR_ARGS end
	if say_cmd and ULib.trim( say_cmd ) == "" then say_cmd = nil end

	if say_cmd and type( say_cmd ) == "string" then
		ULib.addSayCommand( say_cmd, fn_call, help, hide_say, access, ulx.ucl )
	end

	table.insert( ulx.cleanup.help, { cmd=command, help=help, say_cmd=say_cmd } )
	return ULib.ADD_SUBCONCOMMAND( "ulx clean", command, fn_call, help, access, ulx.ucl )
end

local ragdolls = {
"prop_ragdoll",
"env_smoketrail",
}

local flames = {
"entityflame",
"env_smoketrail",
}

local props = {
"prop_physics",
"helicopter_chunk",
"gib",
"physics_cannister",
"prop_flashlight",
"physics_cannister",
"physics_thruster",
"prop_wheel",
"env_smoketrail",
}

local sprites = {
"prop_placement",
}

local vehicles = {
"prop_vehicle_jeep",
"prop_vehicle_airboat",
"prop_vehicle_prisoner_pod",
}

local npcs = {
"combine_bouncemine",
"npc_breen",
"npc_crow",
"npc_cscanner",
"npc_dog",
"npc_eli",
"npc_gman",
"npc_kleiner",
"npc_mossman",
"npc_pigeon",
"npc_seagull",
"npc_alyx",
"npc_antlion",
"npc_antlionguard",
"npc_barney",
"npc_citizen",
"npc_combine",
"npc_combinedropship",
"npc_combinegunship",
"npc_fastzombie",
"npc_headcrab",
"npc_headcrab_fast",
"npc_headcrab_poison",
"npc_helicopter",
"npc_manhack",
"npc_monk",
"npc_metropolice",
"npc_poisonzombie",
"npc_rollermine",
"npc_sniper",
"npc_stalker",
"npc_strider",
"npc_turret_floor",
"npc_vortigaunt",
"npc_zombie",
"npc_zombie_torso",
"prop_thumper",
"env_smoketrail",
}

function ulx.cc_cleanRagdolls( userid, args )
	for _, class in ipairs( ragdolls ) do
		ULib.removeAllEnts( class )
	end
	ulx.logServAct(userid, "#A cleaned all ragdolls")
end
ulx.cleanup.CONCOMMAND( "ragdolls", ulx.cc_cleanRagdolls, "- Removes all ragdolls", ACCESS_ENT, "!cleanragdolls" )

function ulx.cc_cleanFlames( userid, args )
	for _, class in ipairs( flames ) do
		ULib.removeAllEnts( class )
	end
	ulx.logServAct(userid, "#A cleaned all flames")
end
ulx.cleanup.CONCOMMAND( "flames", ulx.cc_cleanFlames, "- Removes all flames", ACCESS_ENT, "!cleanflames" )

function ulx.cc_cleanProps( userid, args )
	for _, class in ipairs( props ) do
		ULib.removeAllEnts( class )
	end
	ulx.logServAct(userid, "#A cleaned all props")
end
ulx.cleanup.CONCOMMAND( "props", ulx.cc_cleanProps, "- Removes all props", ACCESS_ENT, "!cleanprops" )

function ulx.cc_cleanSprites( userid, args )
	for _, class in ipairs( sprites ) do
		ULib.removeAllEnts( class )
	end
	ulx.logServAct(userid, "#A cleaned all sprites")
end
ulx.cleanup.CONCOMMAND( "sprites", ulx.cc_cleanSprites, "- Removes all sprites and effects", ACCESS_ENT, "!cleansprites" )

function ulx.cc_cleanVehicles( userid, args )
	for _, class in ipairs( vehicles ) do
		ULib.removeAllEnts( class )
	end
	ulx.logServAct(userid, "#A cleaned all vehicles")
end
ulx.cleanup.CONCOMMAND( "vehicles", ulx.cc_cleanVehicles, "- Removes all vehicles", ACCESS_ENT, "!cleanvehicles" )

function ulx.cc_cleanNpcs( userid, args )
	for _, class in ipairs( npcs ) do
		ULib.removeAllEnts( class )
	end
	ulx.logServAct(userid, "#A cleaned all npcs")
end
ulx.cleanup.CONCOMMAND( "npcs", ulx.cc_cleanNpcs, "- Removes all NPCs", ACCESS_ENT, "!cleannpcs" )

function ulx.cc_cleanAll( userid, args )
	for _, class in ipairs( ragdolls ) do
		ULib.removeAllEnts( class )
	end

	for _, class in ipairs( flames ) do
		ULib.removeAllEnts( class )
	end

	for _, class in ipairs( props ) do
		ULib.removeAllEnts( class )
	end

	for _, class in ipairs( sprites ) do
		ULib.removeAllEnts( class )
	end

	for _, class in ipairs( vehicles ) do
		ULib.removeAllEnts( class )
	end

	for _, class in ipairs( npcs ) do
		ULib.removeAllEnts( class )
	end
	ulx.logServAct(userid, "#A cleaned up everything")
end
ulx.cleanup.CONCOMMAND( "all", ulx.cc_cleanAll, "- Removes everything", ACCESS_ENT, "!cleanall" )