table.sort( ulx.help, function (a,b) -- Sort our help
	return (a.cmd < b.cmd)
end )

table.sort( ulx.convarhelp, function (a,b) -- Sort our help
	return (a.cmd < b.cmd)
end )

-- This takes care of the things in the configs directory.

if not _file.Exists( "lua/ulx/configs/forcedownload.ini" ) then
	ULib.print( "[ULX] ERROR: The forcedownload.ini file is missing!" )
else
	local file = ULib.stripComments( _file.Read( "lua/ulx/configs/forcedownload.ini" ), "//" )
	local lines = ULib.explode( file, "\n+" )
	for _, line in pairs( lines ) do
		local data = ULib.stripQuotes( string.gsub( line, "^.*(%b\"\").*$", "%1" ) )
		if data and data ~= "" then
			ULib.forceDownload( data )
		end
	end
end

-- Load our configs
if not _file.Exists( "lua/ulx/configs/server.ini" ) then
	ULib.print( "[ULX] ERROR: The server.ini file is missing!" )
else
	AddTimer( 2, 1, ULib.execFile, "lua/ulx/configs/server.ini" ) -- This will make it load after server.cfg
end

if _file.Exists( "lua/ulx/configs/maps/" .. _GetCurrentMap() .. ".ini" ) then
	AddTimer( 2, 1, ULib.execFile, "lua/ulx/configs/maps/" .. _GetCurrentMap() .. ".ini" ) -- This will make it load after server.cfg
end

-- Load our banned users
if _file.Exists( "cfg/banned_user.cfg" ) then
	ULib.execFile( "cfg/banned_user.cfg" )
end

-- Create log if logging is on
if ULib.isStringTrue(ULib.getCvar("ulx log")) and _GetCurrentMap() ~= "" then
	ulx.log = ULib.Log:new("ulx",ULib.getCvar("ulx logDir"))
	ulx.log:writeln("Started logging on ".._GetCurrentMap())
end

-- Download menus to client
ULib.forceDownload( "materials/ULib/menu.vtf" )
ULib.forceDownload( "materials/ULib/menu.vmt" )
ULib.forceDownload( "materials/ulx/title.vtf" )
ULib.forceDownload( "materials/ulx/title.vmt" )