--[[
	Title: Fun

	Some fun things for admins
]]

function ulx.cc_slap( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local targets, err = ULib.getUsers( argv[ 1 ], _, true, ulx.ucl, userid ) -- Enable keywords
	if not targets then
		ULib.tsay( userid, err )
		return
	end

	for _, v in ipairs( targets ) do
		ulx.logUserAct(userid, v, "#A slapped #T with "..tostring(argv[2] or 0).." damage")
		ULib.slap( v, argv[ 2 ], argv[ 3 ] )
	end
end
ulx.CONCOMMAND( "slap", ulx.cc_slap, "<user(s)> [<damage>] [<power>] - Slaps target(s) with given damage and power", ACCESS_SLAY, "!slap" )

function ulx.cc_slay( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local targets, err = ULib.getUsers( argv[ 1 ], _, true, ulx.ucl, userid ) -- Enable keywords
	if not targets then
		ULib.tsay( userid, err )
		return
	end

	for _, v in ipairs( targets ) do
		ulx.logUserAct(userid, v, "#A slayed #T")
		_PlayerKill( v )
	end
end

ulx.CONCOMMAND( "slay", ulx.cc_slay, "<user(s)> - slays the specified user", ACCESS_SLAY, "!slay" )

function ulx.cc_sslay( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local targets, err = ULib.getUsers( argv[ 1 ], _, true, ulx.ucl, userid ) -- Enable keywords
	if not targets then
		ULib.tsay( userid, err )
		return
	end

	local respawn_time = 3
	local dissolve = true
	
	if argv[ 2 ] ~= nil then -- if they specified respawn time
		local num = tonumber( argv[ 2 ] )
		if num ~= nil then
			respawn_time = num
		end
	end
	
	if argv[ 3 ] ~= nil then -- if they specified dissolve
		dissolve = ULib.isStringTrue( argv[ 3 ] )
	end

	for _, v in ipairs( targets ) do
		ulx.logUserAct(userid, v, "#A sslayed #T")
		_PlayerSilentKill( v, respawn_time, dissolve )
	end
end
ulx.CONCOMMAND( "sslay", ulx.cc_sslay, "<user> [<respawn time> [<bool disolve>]] - silently slays the specified user", ACCESS_SLAY, "!sslay" )

function ulx.cc_ignite( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local targets, err = ULib.getUsers( argv[ 1 ], _, true, ulx.ucl, userid ) -- Enable keywords
	if not targets then
		ULib.tsay( userid, err )
		return
	end

	for _, v in ipairs( targets ) do
		ulx.logUserAct(userid, v, "#A ignited #T")
		_PlayerSetHealth( v, 139 ) -- This is so the person doesn't keep dying in the next spawn
		_EntFire( v, "ignite", 1, 0 )
	end
end
ulx.CONCOMMAND( "ignite", ulx.cc_ignite, "<user> - ignites the specified user ( death by fire )", ACCESS_SLAY, "!ignite" )

function ulx.cc_playsound( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	if _file.Exists( "sound/" .. argv[ 1 ] ) == false then
		ULib.tsay( userid, "That sound doesn't exist on the server!" )
		return
	end
	ulx.logServAct(userid, "#A played sound "..argv[1])
	_PlaySound( argv[ 1 ] )
end
ulx.CONCOMMAND( "playsound", ulx.cc_playsound, "<sound file> - Plays a sound ( relative to 'sound' dir )", ACCESS_CHAT )

function ulx.cc_freeze( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local targets, err = ULib.getUsers( argv[ 1 ], _, true, ulx.ucl, userid ) -- Enable keywords
	if not targets then
		ULib.tsay( userid, err )
		return
	end

	for _, v in ipairs( targets ) do
		ulx.logUserAct(userid, v, "#A froze #T")
		ULib.freezePlayer( v )
	end
end
ulx.CONCOMMAND( "freeze", ulx.cc_freeze, "<user(s)> - Freezes target(s)", ACCESS_KICK, "!freeze" )

function ulx.cc_unfreeze( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local targets, err = ULib.getUsers( argv[ 1 ], _, true, ulx.ucl, userid ) -- Enable keywords
	if not targets then
		ULib.tsay( userid, err )
		return
	end

	for _, v in ipairs( targets ) do
		ulx.logUserAct(userid, v, "#A unfroze #T")
		ULib.unfreezePlayer( v )
	end
end
ulx.CONCOMMAND( "unfreeze", ulx.cc_unfreeze, "<user(s)> - Unfreezes target(s)", ACCESS_KICK, "!unfreeze" )

function ulx.cc_god( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local targets, err = ULib.getUsers( argv[ 1 ], true, true, ulx.ucl, userid ) -- Enable keywords, ignore immunity
	if not targets then
		ULib.tsay( userid, err )
		return
	end

	for _, v in ipairs( targets ) do
		ulx.logUserAct(userid, v, "#A set godmode on #T")
		_PlayerGod( v, true )
	end
end
ulx.CONCOMMAND( "god", ulx.cc_god, "<user(s)> - Makes player invincible", ACCESS_SLAY, "!god" )


function ulx.cc_ungod( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local targets, err = ULib.getUsers( argv[ 1 ], true, true, ulx.ucl, userid ) -- Enable keywords, ignore immunity
	if not targets then
		ULib.tsay( userid, err )
		return
	end

	for _, v in ipairs( targets ) do
		ulx.logUserAct(userid, v, "#A removed godmode from #T")
		_PlayerGod( v, false )
	end
end
ulx.CONCOMMAND( "ungod", ulx.cc_ungod, "<user(s)> - Revokes invincible", ACCESS_SLAY, "!ungod" )

function ulx.cc_hp( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local hp = tonumber( argv[ 2 ] )
	if not hp then 
		ULib.tsay( userid, "\"" .. argv[ 2 ] .. "\" is an invalid health!" )
		return
	end

	local targets, err = ULib.getUsers( argv[ 1 ], _, true, ulx.ucl, userid ) -- Enable keywords
	if not targets then
		ULib.tsay( userid, err )
		return
	end

	for _, v in ipairs( targets ) do
		ulx.logUserAct(userid, v, "#A set #T's health to "..hp)
		_PlayerSetHealth( v, hp )
	end
end
ulx.CONCOMMAND( "hp", ulx.cc_hp, "<user(s)> <hp> - Set's user(s) hp", ACCESS_SLAY, "!hp" )

function ulx.cc_blind( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local amt
	if not argv[ 2 ] then
		amt = 255
	else
		amt = tonumber( argv[ 2 ] )
	end

	if not amt then 
		ULib.tsay( userid, "\"" .. argv[ 2 ] .. "\" is an invalid amount!" )
		return
	end

	local targets, err = ULib.getUsers( argv[ 1 ], _, true, ulx.ucl, userid ) -- Enable keywords
	if not targets then
		ULib.tsay( userid, err )
		return
	end

	for _, v in ipairs( targets ) do
		ulx.logUserAct(userid, v, "#A blinded #T "..math.floor(100*(amt/255)).."%")
		ULib.sendRect( v, 187, 0, 0, 1, 1, 3000, 255, 255, 255, amt )
	end
end
ulx.CONCOMMAND( "blind", ulx.cc_blind, "<user(s)> [<amt>]- Blinds user(s) by amount, 255 = full", ACCESS_KICK, "!blind" )

function ulx.cc_unblind( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local amt
	if not argv[ 2 ] then
		amt = 255
	else
		amt = tonumber( argv[ 2 ] )
	end

	if not amt then 
		ULib.tsay( userid, "\"" .. argv[ 2 ] .. "\" is an invalid amount!" )
		return
	end

	local targets, err = ULib.getUsers( argv[ 1 ], _, true, ulx.ucl, userid ) -- Enable keywords
	if not targets then
		ULib.tsay( userid, err )
		return
	end

	for _, v in ipairs( targets ) do
		ulx.logUserAct(userid, v, "#A unblinded #T")
		_GModRect_Hide( v, 187, 0.5 )
	end
end
ulx.CONCOMMAND( "unblind", ulx.cc_unblind, "<user(s)> - Unblinds user(s)", ACCESS_KICK, "!unblind" )

function ulx.cc_noclip( userid, args, argv, argc )
	local targets, err
	if argc < 1 then
		targets = { userid }
	else
		targets, err = ULib.getUsers( argv[ 1 ], true, true, ulx.ucl, userid ) -- Enable keywords, ignore immunity
		if not targets then
			ULib.tsay( userid, err )
			return
		end
	end

	for _, v in ipairs( targets ) do
		if _EntGetMoveType( v ) == MOVETYPE_WALK then
			_EntSetMoveType( v, MOVETYPE_NOCLIP )
		else
			_EntSetMoveType( v, MOVETYPE_WALK )
		end
	end
end
ulx.CONCOMMAND( "noclip", ulx.cc_noclip, "[<user(s)>] - Toggles noclip for user(s) (yourself if no one specified).", ACCESS_KICK, "!noclip" )

local gimps = {} -- Holds gimp info
local gimpSays = {} -- Holds gimp says

function ulx.cc_gimp( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local targets, err = ULib.getUsers( argv[ 1 ], _, true, ulx.ucl, userid ) -- Enable keywords
	if not targets then
		ULib.tsay( userid, err )
		return
	end

	for _, v in ipairs( targets ) do
		ulx.logUserAct(userid, v, "#A gimped #T")
		gimps[ _PlayerInfo( v, "networkid" ) ] = true
	end
end
ulx.CONCOMMAND( "gimp", ulx.cc_gimp, "<user> - Gimps a player (can't talk normally)", ACCESS_SLAY, "!gimp" )

function ulx.cc_ungimp( userid, args, argv, argc )
	if argc < 1 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local targets, err = ULib.getUsers( argv[ 1 ], _, true, ulx.ucl, userid ) -- Enable keywords
	if not targets then
		ULib.tsay( userid, err )
		return
	end

	for _, v in ipairs( targets ) do
		ulx.logUserAct(userid, v, "#A ungimped #T")
		gimps[ _PlayerInfo( v, "networkid" ) ] = nil
	end
end
ulx.CONCOMMAND( "ungimp", ulx.cc_ungimp, "<user> - Ungimps a player", ACCESS_SLAY, "!ungimp" )

function ulx.cc_addGimpSay( userid, args )
	if userid ~= 0 then -- Not called from a config
		return
	end

	local say = ULib.stripQuotes( args )
	table.insert( gimpSays, say )
end
ulx.CONCOMMAND( "addGimpSay", ulx.cc_addGimpSay, "", ACCESS_NONE ) -- Can only add from configs


local function gimpCheck( userid, strText )
	local steamid = _PlayerInfo( userid, "networkid" )
	if not gimps[ steamid ] or table.getn( gimpSays ) < 1 then return strText end

	return _PlayerInfo( userid, "name" ) .. ": " .. gimpSays[ math.random( table.getn( gimpSays ) ) ]
end
ULib.hookSay( gimpCheck, 3 )